#include	"defs.h"
/*	$Modname: pppmd5c.c$  $version: 1.6$      $date: 03/10/95$   */
/*
* 	$lgb$
1.0 08/24/94 ross
1.1 08/24/94 ross cleanup for release
1.2 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.3 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.4 12/13/94 ross connected to NT RAS with Netbios
1.5 01/26/95 ross changes for rwutils
1.6 03/10/95 ross chap working with nt 3.5.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
/* MD5C.C - RSA Data Security, Inc., MD5 message-digest algorithm */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All rights reserved.

License to copy and use this software is granted provided that it	is identified as the "RSA Data Security, Inc. MD5 
Message-Digest	Algorithm" in all material mentioning or referencing this software or this function.

License is also granted to make and use derivative works provided that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"	without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this documentation and/or software. */
/****************************************************************************/
#include <stdio.h>
#include <string.h>

#include "ppp.h"
#include "kpppmd5.h"
#include "vpmd5str.h"
#include "vpppmd5.h"
/****************************************************************************/
static void MD5Init (MD5_CONTEXT *sptr_context);
static void MD5Update (MD5_CONTEXT *sptr_context, BYTE *input, ULONG inputLen);
static void MD5Final (BYTE digest[16], MD5_CONTEXT *sptr_context);
static void MD5Transform (ULONG state[4], BYTE block[64]);
static void Encode (BYTE *bptr_output, ULONG *ulptr_input, ULONG length);
static void Decode (ULONG *ulptr_output, BYTE *bptr_input, ULONG length);
/****************************************************************************/
/* Digests a string and prints the result. */
/****************************************************************************/
void MDString (BYTE id,BYTE *bptr_secret,BYTE secret_length,BYTE *bptr_challenge_value,BYTE challenge_length,
	BYTE *bptr_response_value)
{
	MD5_CONTEXT sptr_context;
	ULONG length;
	BYTE chap_string_to_encode[128];

	chap_string_to_encode[0] = id;

	memcpy (&chap_string_to_encode[1],bptr_secret,secret_length);
	memcpy ((void *) (&chap_string_to_encode[1] + secret_length),bptr_challenge_value,challenge_length);

	length = sizeof (id) + secret_length + challenge_length;
	
	MD5Init (&sptr_context);
	MD5Update (&sptr_context,(BYTE *) chap_string_to_encode, length);
	MD5Final (bptr_response_value, &sptr_context);
}
/****************************************************************************/
/* MD5 initialization. Begins an MD5 operation, writing a new sptr_context. */
/****************************************************************************/
void MD5Init (MD5_CONTEXT *sptr_context)
{
	sptr_context->count[0] = 0x00000000L;
	sptr_context->count[1] = 0x00000000L;

	/* Load magic initialization constants.*/
	sptr_context->state[0] = 0x67452301L;
	sptr_context->state[1] = 0xefcdab89L;
	sptr_context->state[2] = 0x98badcfeL;
	sptr_context->state[3] = 0x10325476L;
}
/****************************************************************************/
/* MD5 block update operation. Continues an MD5 message-digest operation, processing another message block, and updating the
  sptr_context. */
/****************************************************************************/
void MD5Update (MD5_CONTEXT *sptr_context, BYTE *bptr_input, ULONG input_length)
	/* sptr_context, input block and length of input block */
{
	ULONG i,
			index,
			part_length;

	/* Compute number of bytes mod 64 */
	index = (ULONG)((sptr_context->count[0] >> 3) & 0x3F);

	/* Update number of bits */
	if ((sptr_context->count[0] += ((ULONG)input_length << 3)) < ((ULONG)input_length << 3))
		{
		sptr_context->count[1]++;
		}

	sptr_context->count[1] += ((ULONG)input_length >> 29);

	part_length = 64 - index;

	/* Transform as many times as possible.*/
	if (input_length >= part_length)
		{
		memcpy ((BYTE *)&sptr_context->buffer[index], (BYTE *)bptr_input, part_length);
		MD5Transform (sptr_context->state, sptr_context->buffer);

		for (i = part_length; i + 63 < input_length; i += 64)
			{
			MD5Transform (sptr_context->state, &bptr_input[i]);
			}

		index = 0x00000000L;
		}
	else
		{
		i = 0x00000000L;
		}

/* Buffer remaining input */
	memcpy ((BYTE *)&sptr_context->buffer[index],(BYTE *)&bptr_input[i],input_length-i);
}

/****************************************************************************/
/* MD5 finalization. Ends an MD5 message-digest operation, writing the message digest and zeroizing the sptr_context. */
/****************************************************************************/
void MD5Final (BYTE digest[16],MD5_CONTEXT *sptr_context)
{
	BYTE bits[8];
	ULONG index,
			padding_length;

	/* Save number of bits */
	Encode (bits, sptr_context->count, 8);

	/* Pad out to 56 mod 64.*/
	index = (ULONG)((sptr_context->count[0] >> 3) & 0x3f);
	padding_length = (index < 56) ? (56 - index) : (120 - index);
	MD5Update (sptr_context, PADDING, padding_length);

	/* Append length (before padding) */
	MD5Update (sptr_context, bits, 8);
	
	/* Store state in digest */
	Encode (digest, sptr_context->state, 16);

	/* Zeroize sensitive information.*/
	memset ((BYTE *)sptr_context,(int)  0, sizeof (*sptr_context));
}
/****************************************************************************/
/* MD5 basic transformation. Transforms state based on block. */
/****************************************************************************/
static void MD5Transform (ULONG state[4],BYTE block[64])
{
	ULONG a = state[0],
			b = state[1],
			c = state[2],
			d = state[3],
			x[16];

	Decode (x, block, 64);

	/* Round 1 */
	FF (a, b, c, d, x[ 0], S11, 0xd76aa478L); /* 1 */
	FF (d, a, b, c, x[ 1], S12, 0xe8c7b756L); /* 2 */
	FF (c, d, a, b, x[ 2], S13, 0x242070dbL); /* 3 */
	FF (b, c, d, a, x[ 3], S14, 0xc1bdceeeL); /* 4 */
	FF (a, b, c, d, x[ 4], S11, 0xf57c0fafL); /* 5 */
	FF (d, a, b, c, x[ 5], S12, 0x4787c62aL); /* 6 */
	FF (c, d, a, b, x[ 6], S13, 0xa8304613L); /* 7 */
	FF (b, c, d, a, x[ 7], S14, 0xfd469501L); /* 8 */
	FF (a, b, c, d, x[ 8], S11, 0x698098d8L); /* 9 */
	FF (d, a, b, c, x[ 9], S12, 0x8b44f7afL); /* 10 */
	FF (c, d, a, b, x[10], S13, 0xffff5bb1L); /* 11 */
	FF (b, c, d, a, x[11], S14, 0x895cd7beL); /* 12 */
	FF (a, b, c, d, x[12], S11, 0x6b901122L); /* 13 */
	FF (d, a, b, c, x[13], S12, 0xfd987193L); /* 14 */
	FF (c, d, a, b, x[14], S13, 0xa679438eL); /* 15 */
	FF (b, c, d, a, x[15], S14, 0x49b40821L); /* 16 */

	/* Round 2 */
	GG (a, b, c, d, x[ 1], S21, 0xf61e2562L); /* 17 */
	GG (d, a, b, c, x[ 6], S22, 0xc040b340L); /* 18 */
	GG (c, d, a, b, x[11], S23, 0x265e5a51L); /* 19 */
	GG (b, c, d, a, x[ 0], S24, 0xe9b6c7aaL); /* 20 */
	GG (a, b, c, d, x[ 5], S21, 0xd62f105dL); /* 21 */
	GG (d, a, b, c, x[10], S22,  0x2441453L); /* 22 */
	GG (c, d, a, b, x[15], S23, 0xd8a1e681L); /* 23 */
	GG (b, c, d, a, x[ 4], S24, 0xe7d3fbc8L); /* 24 */
	GG (a, b, c, d, x[ 9], S21, 0x21e1cde6L); /* 25 */
	GG (d, a, b, c, x[14], S22, 0xc33707d6L); /* 26 */
	GG (c, d, a, b, x[ 3], S23, 0xf4d50d87L); /* 27 */
	GG (b, c, d, a, x[ 8], S24, 0x455a14edL); /* 28 */
	GG (a, b, c, d, x[13], S21, 0xa9e3e905L); /* 29 */
	GG (d, a, b, c, x[ 2], S22, 0xfcefa3f8L); /* 30 */
	GG (c, d, a, b, x[ 7], S23, 0x676f02d9L); /* 31 */
	GG (b, c, d, a, x[12], S24, 0x8d2a4c8aL); /* 32 */

	/* Round 3 */
	HH (a, b, c, d, x[ 5], S31, 0xfffa3942L); /* 33 */
	HH (d, a, b, c, x[ 8], S32, 0x8771f681L); /* 34 */
	HH (c, d, a, b, x[11], S33, 0x6d9d6122L); /* 35 */
	HH (b, c, d, a, x[14], S34, 0xfde5380cL); /* 36 */
	HH (a, b, c, d, x[ 1], S31, 0xa4beea44L); /* 37 */
	HH (d, a, b, c, x[ 4], S32, 0x4bdecfa9L); /* 38 */
	HH (c, d, a, b, x[ 7], S33, 0xf6bb4b60L); /* 39 */
	HH (b, c, d, a, x[10], S34, 0xbebfbc70L); /* 40 */
	HH (a, b, c, d, x[13], S31, 0x289b7ec6L); /* 41 */
	HH (d, a, b, c, x[ 0], S32, 0xeaa127faL); /* 42 */
	HH (c, d, a, b, x[ 3], S33, 0xd4ef3085L); /* 43 */
	HH (b, c, d, a, x[ 6], S34,  0x4881d05L); /* 44 */
	HH (a, b, c, d, x[ 9], S31, 0xd9d4d039L); /* 45 */
	HH (d, a, b, c, x[12], S32, 0xe6db99e5L); /* 46 */
	HH (c, d, a, b, x[15], S33, 0x1fa27cf8L); /* 47 */
	HH (b, c, d, a, x[ 2], S34, 0xc4ac5665L); /* 48 */

	/* Round 4 */
	II (a, b, c, d, x[ 0], S41, 0xf4292244L); /* 49 */
	II (d, a, b, c, x[ 7], S42, 0x432aff97L); /* 50 */
	II (c, d, a, b, x[14], S43, 0xab9423a7L); /* 51 */
	II (b, c, d, a, x[ 5], S44, 0xfc93a039L); /* 52 */
	II (a, b, c, d, x[12], S41, 0x655b59c3L); /* 53 */
	II (d, a, b, c, x[ 3], S42, 0x8f0ccc92L); /* 54 */
	II (c, d, a, b, x[10], S43, 0xffeff47dL); /* 55 */
	II (b, c, d, a, x[ 1], S44, 0x85845dd1L); /* 56 */
	II (a, b, c, d, x[ 8], S41, 0x6fa87e4fL); /* 57 */
	II (d, a, b, c, x[15], S42, 0xfe2ce6e0L); /* 58 */
	II (c, d, a, b, x[ 6], S43, 0xa3014314L); /* 59 */
	II (b, c, d, a, x[13], S44, 0x4e0811a1L); /* 60 */
	II (a, b, c, d, x[ 4], S41, 0xf7537e82L); /* 61 */
	II (d, a, b, c, x[11], S42, 0xbd3af235L); /* 62 */
	II (c, d, a, b, x[ 2], S43, 0x2ad7d2bbL); /* 63 */
	II (b, c, d, a, x[ 9], S44, 0xeb86d391L); /* 64 */

	state[0] += a;
	state[1] += b;
	state[2] += c;
	state[3] += d;

	/* Zeroize sensitive information.*/
	memset ((BYTE *)x, 0,(int)  sizeof (x));
}
/****************************************************************************/
/* Encodes input (ULONG) into output (BYTE). Assumes length is a multiple of 4. */
/****************************************************************************/
static void Encode (BYTE *bptr_output, ULONG *ulptr_input, ULONG length)
{
 	ULONG i, j;

 	for (i = 0x00000000L, j = 0x00000000L; j < length; i++, j += 0x00000004L)
		{
		bptr_output[j] = (BYTE)(ulptr_input[i] & 0xff);
		bptr_output[j+1] = (BYTE)((ulptr_input[i] >> 8) & 0xff);
		bptr_output[j+2] = (BYTE)((ulptr_input[i] >> 16) & 0xff);
		bptr_output[j+3] = (BYTE)((ulptr_input[i] >> 24) & 0xff);
 		}
}
/****************************************************************************/
/* Decodes input (BYTE) into output (ULONG). Assumes length is a multiple of 4. */
/****************************************************************************/
static void Decode (ULONG *ulptr_output, BYTE *bptr_input, ULONG length)
{
	ULONG i, j;

	for (i = 0x00000000L, j = 0x00000000L; j < length; i++, j += 0x00000004L)
		{
		ulptr_output[i] = ((ULONG)bptr_input[j]) | (((ULONG)bptr_input[j+1]) << 8) | (((ULONG)bptr_input[j+2]) << 16) |
			(((ULONG)bptr_input[j+3]) << 24);
		}
}
