#include	"defs.h"

#include <string.h>
#include <stdlib.h>
#include "ppp.h"

#include "pppmux.h"

/****************************************************************************/
static BYTE *build_mux_ppp_header (BYTE *sptr_tx_packet);

/****************************************************************************/
enum TEST send_mux_ppp_packet (USHORT mux_port_number,
	BYTE *sptr_tx_packet,
	USHORT number_of_bytes,
	void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	USHORT	real_port_number;
	void 		*vptr_free_buffer;

	real_port_number = 0;
	vptr_free_buffer = sptr_tx_packet;

	if (ppp.port[real_port_number].enabled == FALSE )
	{
ret_buf:
		if (fptr_tx_completion != NULL)
		{
			(fptr_tx_completion) (mux_port_number,sptr_tx_packet);
		}
#if 0
		printf ("PPP: Port %d is not enabled\r\n", real_port_number);
#endif
		return (FAIL);
	}

	if (ppp.port[real_port_number].connect_state != LINK_UP)
	{
#if 0
		printf ("PPP: Link is not up on Port %d\r\n", real_port_number);
#endif
		goto ret_buf;
	}
			
	number_of_bytes = (USHORT) (number_of_bytes + sizeof (PPP_HEADER));

	sptr_tx_packet = build_mux_ppp_header (sptr_tx_packet);

	if ((*ppp.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,
			mux_port_number,
			sptr_tx_packet,
			number_of_bytes,
			FALSE,
			FALSE,
			fptr_tx_completion,
			vptr_free_buffer) == PASS)
	{
		return (PASS);
	}

	return (FAIL);
}

/****************************************************************************/
static BYTE *build_mux_ppp_header (BYTE *sptr_tx_packet)
{
	PPP_HEADER		*sptr_header;

	sptr_header = (PPP_HEADER *)(ULONG)((ULONG)sptr_tx_packet - (ULONG)sizeof(PPP_HEADER));

	sptr_header->hdlc_address = HDLC_ADDRESS;
	sptr_header->hdlc_control = UNNUMBERED_INFORMATION;
	sptr_header->protocol_type = (USHORT_ENUM (PPP_PROTOCOL_TYPE)) APSM_MUX_PROTOCOL;

	return ((BYTE *)sptr_header);
}

