#include	"defs.h"
/*	$Modname: pppnbsrx.c$  $version: 1.10$      $date: 01/26/95$   */
/*
* 	$lgb$
1.0 08/11/94 ross
1.1 08/24/94 ross
1.2 08/24/94 ross cleanup for release
1.3 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.4 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.5 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.6 12/02/94 ross testing NT3.5 RAS
1.7 12/03/94 ross testing Windows 95 RAS
1.8 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.9 12/13/94 ross connected to NT RAS with Netbios
1.10 01/26/95 ross changes for rwutils
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "ppp.h"
/****************************************************************************/
static void build_netbios_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp);
/****************************************************************************/
void initialize_netbios_ncp (USHORT real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;

#ifdef __MLPPP__
	sptr_ncp = &mlppp.port[real_port_number].ncp[PPP_NETBIOS_NCP_STACK_INDEX];
#else
	sptr_ncp = &ppp.port[real_port_number].ncp[PPP_NETBIOS_NCP_STACK_INDEX];
#endif

	strcpy (sptr_ncp->name,"Netbios Gateway");

	sptr_ncp->type = NETBIOS_PROTOCOL_STACK;
	sptr_ncp->ppp_protocol_stack_type = NETBIOS_PROTOCOL;
	sptr_ncp->ncp_protocol_type = NBFCP_PROTOCOL;
	sptr_ncp->state = PPP_INITIAL_STATE;
	sptr_ncp->old_state = PPP_INITIAL_STATE;
	sptr_ncp->protocol_stack_id = ILLEGAL_STACK_ID;
	sptr_ncp->real_port_number = real_port_number;

	sptr_ncp->receive.fptr_process_receive_options[NAME_PROJECTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[PEER_INFORMATION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[MULTICAST_FILTERING] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;
	sptr_ncp->receive.fptr_process_receive_options[IEEE_MAC_ADDRESS_REQUIRED] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_request_option_processor;

	sptr_ncp->receive_nak.fptr_process_receive_options[NAME_PROJECTION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[PEER_INFORMATION] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[MULTICAST_FILTERING] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;
	sptr_ncp->receive_nak.fptr_process_receive_options[IEEE_MAC_ADDRESS_REQUIRED] = 
		(enum TEST (*) (OPTION_LIST_ENTRY *sptr_option,void *vptr_class)) ppp_ncp_configure_nak_option_processor;

	sptr_ncp->fptr_protocol_stack_up = build_netbios_ppp_accepted_parameters;

	sptr_ncp->real_port_number = real_port_number;

	copy_configuration_options_to_tx_accepted_options (&sptr_ncp->option_lists);
}
/****************************************************************************/
static void build_netbios_ppp_accepted_parameters (USHORT virtual_port_number,PPP_NCP_CLASS *sptr_ncp)
{
	PARAMETER_NOT_USED (virtual_port_number);
	PARAMETER_NOT_USED (sptr_ncp);
}

