#include	"defs.h"
/*	$Modname: pppncprx.c$  $version: 1.19$      $date: 06/26/95$   */
/*
* 	$lgb$
1.0 01/05/94 keyur Initial Release.
1.1 01/05/94 keyur Added version control support.
1.2 01/20/94 keyur Added feature of sending code reject at NCP level and some statistics.
1.3 01/28/94 keyur Added code to support all the NCP options.
1.4 02/02/94 keyur Added code to tell if ack was transmitted or not for NCP.
1.5 03/23/94 keyur Obsoleting because it's split into three files.
1.6 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.7 05/02/94 keyur took out memcheck header file.
1.8 06/15/94 keyur cosmetic changes.
1.9 08/11/94 ross adding rfc1570 lcp support
1.10 08/24/94 ross adding new ncps.
1.11 08/30/94 ross fixed problem with new ncps.  Courtesy of Danny.
1.12 09/06/94 ross enum sizing bug.  Courtesy of Danny.
1.13 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.14 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.15 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.16 12/13/94 ross connected to NT RAS with Netbios
1.17 03/10/95 ross general fixes.  see change.doc
1.18 05/15/95 ross added termination request elimination code.
1.19 06/26/95 ross initial version of BCP
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include "ppp.h"
#include	<logif.h>

/****************************************************************************/
static enum TEST process_ncp_configuration_options (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,USHORT number_of_bytes_processed,PPP_NCP_CLASS *sptr_ncp);
static void ncp_configure_request_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,PPP_NCP_CLASS *sptr_ncp);
static void	process_ncp_configuration_nak_options (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,USHORT number_of_bytes_processed,PPP_NCP_CLASS *sptr_ncp);
static void ncp_configure_ack_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp);
static void ncp_configure_reject_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,PPP_NCP_CLASS *sptr_ncp);
static void ncp_termination_request_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,PPP_NCP_CLASS *sptr_ncp);
static void ncp_termination_ack_received (USHORT real_port_number, UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,PPP_NCP_CLASS *sptr_ncp);
static void ncp_code_reject_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp);
static void ncp_configure_nak_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp);
static void illegal_ncp_code_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp);
/****************************************************************************/
void initialize_ncp (USHORT real_port_number)
{
	PPP_NCP_CLASS *sptr_ncp;
	BYTE protocol_stack_index;

	for (protocol_stack_index = 0x00; protocol_stack_index < NUMBER_OF_NCP_STACKS;
		protocol_stack_index = (BYTE) (protocol_stack_index + 1))
		{
#ifdef __MLPPP__
		sptr_ncp = &mlppp.port[real_port_number].ncp[protocol_stack_index];
#else
		sptr_ncp = &ppp.port[real_port_number].ncp[protocol_stack_index];
#endif

		sptr_ncp->protocol_stack_id = ILLEGAL_STACK_ID;
		}

	initialize_ip_ncp (real_port_number);
	initialize_ipx_ncp (real_port_number);
	initialize_appletalk_ncp (real_port_number);
	initialize_netbios_ncp (real_port_number);
	initialize_spanning_tree_ncp (real_port_number);

	ppp.fptr_ncp_packet_rxed[0x00] = illegal_ncp_code_received;
	ppp.fptr_ncp_packet_rxed[CONFIGURE_REQUEST] = ncp_configure_request_received;
	ppp.fptr_ncp_packet_rxed[CONFIGURE_NAK] = ncp_configure_nak_received;
	ppp.fptr_ncp_packet_rxed[CONFIGURE_ACK] = ncp_configure_ack_received;
	ppp.fptr_ncp_packet_rxed[CONFIGURE_REJECT] = ncp_configure_reject_received;
	ppp.fptr_ncp_packet_rxed[TERMINATION_REQUEST] = ncp_termination_request_received;
	ppp.fptr_ncp_packet_rxed[TERMINATION_ACK] = ncp_termination_ack_received;
	ppp.fptr_ncp_packet_rxed[CODE_REJECT] = ncp_code_reject_received;

	ppp.fptr_ncp_packet_rxed[PROTOCOL_REJECT] = illegal_ncp_code_received;
	ppp.fptr_ncp_packet_rxed[PPP_ECHO_REQUEST] = illegal_ncp_code_received;
	ppp.fptr_ncp_packet_rxed[PPP_ECHO_REPLY] = illegal_ncp_code_received;
	ppp.fptr_ncp_packet_rxed[DISCARD_REQUEST] = illegal_ncp_code_received;
}
/****************************************************************************/
enum TEST ncp_packet_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp)
{
	if ((sptr_ncp->protocol_stack_id == ILLEGAL_STACK_ID) || (sptr_ncp->enabled == FALSE))
		{
#ifndef __MLPPP__
		send_lcp_protocol_reject (real_port_number,(LCP_PACKET *) sptr_ncp_rx_packet,number_of_bytes_rxed);
#else
		send_lcp_protocol_reject (mlppp.port[real_port_number].LinkInfo[0].port->port_number,
						(LCP_PACKET *) sptr_ncp_rx_packet,number_of_bytes_rxed);
#endif
		return (FAIL);
		}

	/* Srikar, Mar 23, 1997. Added the following to support disabling IP through SNMP manager. If the */
	/* AdminStatus has been set to disabled then we will reject the protocol. This support is available */
	/* only for the IP protocol right now. THIS IS NOT A PROPER FIX. The proper fix would be to disable all the */
	/* IP related options once the protocol is disabled. Otherwise the client gets a IP related option like IP */
	/* address and keeps the link open even though no protocol could be negotiated. Hence we are constrained to */
	/* send a protocol reject here. */

	if (sptr_ncp->ppp_protocol_stack_type == IP_PROTOCOL && sptr_ncp->mib.ipcp.pppIpConfigAdminStatus == SNMP_PPP_IP_LINK_NOT_OPENED)
		{
#ifndef __MLPPP__
		send_lcp_protocol_reject (real_port_number,(LCP_PACKET *) sptr_ncp_rx_packet,number_of_bytes_rxed);
#else
		send_lcp_protocol_reject (mlppp.port[real_port_number].LinkInfo[0].port->port_number,
						(LCP_PACKET *) sptr_ncp_rx_packet,number_of_bytes_rxed);
#endif
		return (FAIL);
		}


	if (sptr_ncp_rx_packet->ip.generic.code >= NUMBER_OF_PPP_CONTROL_CODES)
		{
		sptr_ncp_rx_packet->ip.generic.code = (BYTE_ENUM (PPP_CONTROL_CODE)) 0x00; /* force it the illegal_ncp_code_received function */
		}

	(*ppp.fptr_ncp_packet_rxed[sptr_ncp_rx_packet->ip.generic.code]) (real_port_number,sptr_ncp_rx_packet,
		number_of_bytes_rxed,sptr_ncp);

	++sptr_ncp->statistics.number_of_rx_control_packets[sptr_ncp_rx_packet->ip.generic.code];

	++sptr_ncp->statistics.number_of_rx_packets;

	sptr_ncp->statistics.number_of_rx_bytes += number_of_bytes_rxed;

	return (PASS);
}
/****************************************************************************/
static void ncp_configure_request_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,PPP_NCP_CLASS *sptr_ncp)
{
	USHORT number_of_bytes_without_options;

	ppp_printf (PPP_NCP_PRINTF,"PPP: NCP %s Configure Packet Received on port: %04x\r\n",sptr_ncp->name,real_port_number);

	number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (NCP_HEADER);

	if (number_of_bytes_rxed > number_of_bytes_without_options)
		{
		if (process_ncp_configuration_options (real_port_number,sptr_ncp_rx_packet,number_of_bytes_rxed,
			number_of_bytes_without_options,sptr_ncp) == FAIL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP %s:ERROR in receiving NCP Options Received on port: %04x\r\n",
				sptr_ncp->name,real_port_number);

			return;
			}
		}

	execute_ncp_state_machine (PPP_RECEIVE_CONFIGURE_REQUEST_GOOD_EVENT,sptr_ncp,real_port_number,
		sptr_ncp_rx_packet,number_of_bytes_rxed);
}
/****************************************************************************/
static enum TEST process_ncp_configuration_options (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,USHORT number_of_bytes_processed,PPP_NCP_CLASS *sptr_ncp)
{
	enum OPTION_PARSE_RESULT parse_result;
	USHORT length_of_options_to_be_processed;

	length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_processed);

	parse_result = parse_ppp_options_from_configure_request (&sptr_ncp->option_lists,
		(PPP_OPTION *) &sptr_ncp_rx_packet->generic.packet_with_options.options,length_of_options_to_be_processed,
		&sptr_ncp->receive,sptr_ncp);

	if (parse_result == SOME_OPTIONS_ARE_REJECTED)
		{
		execute_ncp_state_machine (PPP_RECEIVE_CONFIG_REQUEST_BAD_OPTION_EVENT,sptr_ncp,real_port_number,
			sptr_ncp_rx_packet,number_of_bytes_rxed);

		return (FAIL);
		}
	else if (parse_result == SOME_OPTIONS_ARE_NACKED)
		{
		execute_ncp_state_machine (PPP_RECEIVE_CONFIGURE_REQUEST_BAD_EVENT,sptr_ncp,real_port_number,
			sptr_ncp_rx_packet,number_of_bytes_rxed);

		return (FAIL);
		}
	else
	{
		return (PASS);
	}
}
/****************************************************************************/
static void ncp_configure_ack_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp)
{
	ppp_printf (PPP_NCP_PRINTF,"PPP: NCP %s ACK Packet Received on port: %04x\r\n",sptr_ncp->name,real_port_number);

	sptr_ncp->statistics.number_of_rx_bytes += number_of_bytes_rxed;

	if (number_of_bytes_rxed != sptr_ncp->length_of_last_txed_request)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP:NCP %s configuration ACK received with wrong length of packet on port: %04x\r\n",
			sptr_ncp->name,real_port_number);

		return;
		}

	sptr_ncp_rx_packet->generic.configure_ack.ncp_header.code = CONFIGURE_REQUEST;
	
	if (memcmp (sptr_ncp_rx_packet,&sptr_ncp->last_txed_configuration_request_packet[0],
		sptr_ncp->length_of_last_txed_request) != 0x00)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP NCP: configuration ACK received with wrong order of options on port: %04x\r\n",
			real_port_number);

		return;
		}

	 execute_ncp_state_machine (PPP_RECEIVE_CONFIGURE_ACK_EVENT,sptr_ncp,real_port_number,sptr_ncp_rx_packet,
		number_of_bytes_rxed);
}
/****************************************************************************/
static void ncp_configure_reject_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,PPP_NCP_CLASS *sptr_ncp)
{
	USHORT length_of_options_to_be_processed;
	USHORT number_of_bytes_without_options;

	ppp_printf (PPP_NCP_PRINTF,"PPP: NCP %s CONFIGURE REJECT Packet Received on port: %04x\r\n",sptr_ncp->name,real_port_number);

	if (sptr_ncp_rx_packet->generic.configure_reject.ncp_header.id == sptr_ncp->last_request_id)
		{
		number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (NCP_HEADER);

		length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_without_options);

		if (length_of_options_to_be_processed > 0x0000)
			{
			parse_ppp_options_from_reject_configure (&sptr_ncp->option_lists,
				(PPP_OPTION *) &sptr_ncp_rx_packet->generic.configure_request.options,length_of_options_to_be_processed);
			}

		execute_ncp_state_machine (PPP_RECEIVE_CONFIGURE_REJECT_EVENT,sptr_ncp,real_port_number,
			sptr_ncp_rx_packet,number_of_bytes_rxed);
		}
}
/****************************************************************************/
static void ncp_termination_request_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,PPP_NCP_CLASS *sptr_ncp)
{
	ppp_printf (PPP_NCP_PRINTF,"PPP NCP: TERMINATION REQUEST Packet Received on port: %04x\r\n",real_port_number);

	execute_ncp_state_machine (PPP_RECEIVE_TERMINATE_REQUEST_EVENT,sptr_ncp,real_port_number,
		sptr_ncp_rx_packet,number_of_bytes_rxed);

	/* wait 1 cycle for other side to terminate the link before trying to reset so we can come back up. rfc 1661 sect. 3.7*/

	sptr_ncp->number_of_termination_requests = (USHORT) ppp.maximum_number_of_termination_requests;

	sptr_ncp->termination_request_send_interval = 0x00000000L;
}
/****************************************************************************/
static void ncp_termination_ack_received (USHORT real_port_number, UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,PPP_NCP_CLASS *sptr_ncp)
{
	ppp_printf (PPP_NCP_PRINTF,"PPP NCP: TERMINATION ACK Packet Received on port: %04x\r\n",real_port_number);

	execute_ncp_state_machine (PPP_RECEIVE_TERMINATE_ACK_EVENT,sptr_ncp,real_port_number,sptr_ncp_rx_packet,number_of_bytes_rxed);
}
/****************************************************************************/
static void ncp_code_reject_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp)
{
	ppp_printf (PPP_NCP_PRINTF,"PPP NCP: CODE REJECT Packet Received on port: %04x\r\n",real_port_number);

	execute_ncp_state_machine (PPP_RECEIVE_CODE_REJECT_PERMITTED_EVENT,sptr_ncp,real_port_number,
		sptr_ncp_rx_packet,number_of_bytes_rxed);
}
/****************************************************************************/
static void illegal_ncp_code_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp)
{
	ppp_printf (PPP_NCP_PRINTF,"PPP NCP:Illegal NCP Received on port: %04x\r\n",real_port_number);

	++ppp.port[real_port_number].link_quality_counters.ifInErrors;

	ppp.port[real_port_number].link_quality_counters.InGoodOctets -= number_of_bytes_rxed;

	execute_ncp_state_machine (PPP_RECEIVE_UNKNOWN_CODE_EVENT,sptr_ncp,real_port_number,sptr_ncp_rx_packet,number_of_bytes_rxed);
}
/****************************************************************************/
static void ncp_configure_nak_received (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,USHORT number_of_bytes_rxed,
	PPP_NCP_CLASS *sptr_ncp)
{
	USHORT number_of_bytes_without_options;

	number_of_bytes_without_options = sizeof (PPP_HEADER) + sizeof (NCP_HEADER);

	if (number_of_bytes_rxed > number_of_bytes_without_options)
		{
		process_ncp_configuration_nak_options (real_port_number,sptr_ncp_rx_packet,number_of_bytes_rxed,
			number_of_bytes_without_options,sptr_ncp);
		}
	else
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP:IPCP Configuration NAK Received with no NAK options in it on port: %04x\r\n",
			real_port_number);
		}

	execute_ncp_state_machine (PPP_RECEIVE_CONFIGURE_NAK_EVENT,sptr_ncp,real_port_number,NULL,
		number_of_bytes_rxed);
}
/****************************************************************************/
static void	process_ncp_configuration_nak_options (USHORT real_port_number,UNION_NCP_PACKET *sptr_ncp_rx_packet,
	USHORT number_of_bytes_rxed,USHORT number_of_bytes_processed,PPP_NCP_CLASS *sptr_ncp)
{
	USHORT length_of_options_to_be_processed;

	PARAMETER_NOT_USED (real_port_number);

	length_of_options_to_be_processed = (USHORT) (number_of_bytes_rxed - number_of_bytes_processed);

	parse_ppp_options_from_nak_configure (&sptr_ncp->option_lists,
		(PPP_OPTION *) &sptr_ncp_rx_packet->generic.packet_with_options.options,length_of_options_to_be_processed,
		&sptr_ncp->receive_nak,sptr_ncp);
}
void initialize_ncp_tx_accepted_option_list (USHORT real_port_number)
{
	reset_ip_ncp_state_machine(real_port_number);
	initialize_ip_ncp_tx_accepted_option_list (real_port_number);
	reset_ipx_ncp_state_machine(real_port_number);
	initialize_ipx_ncp_tx_accepted_option_list (real_port_number);
/* Remaining NCPS to be added later */

}


