#include	"defs.h"
/*	$Modname: pppoptn.c$  $version: 1.14$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 08/10/94 ross initial version.
1.1 08/11/94 ross
1.2 08/24/94 ross
1.3 08/24/94 ross cleanup for release
1.4 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.5 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.6 11/04/94 ross Testing against net manage ppp.  VJC testing.
1.7 12/02/94 ross testing NT3.5 RAS
1.8 12/03/94 ross testing Windows 95 RAS
1.9 12/05/94 ross dynamic option support.  Portions courtesy of Dan.
1.10 01/26/95 ross changes for rwutils
1.11 01/30/95 ross removing duplicate configuration options
1.12 02/27/95 ross dynamic load changes including lsl_control.
1.13 03/10/95 ross general fixes.  see change.doc
1.14 10/19/95 biao got rid of Microsoft Visual C++ 2.2 level 4 warnings.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include "ppp.h"
/*************************************************************************************************/
enum TEST parse_ppp_options_from_packet (OPTION_LIST *sptr_option_list,PPP_OPTION *sptr_source_option,
	USHORT length_of_options);
static enum OPTION_PARSE_RESULT set_missing_required_options_in_nak (OPTION_LIST *sptr_configured_option_list,
	OPTION_LIST *sptr_rxed_option_list,OPTION_LIST *sptr_nak_option_list);
/*************************************************************************************************/
enum TEST add_new_ppp_option_to_list (OPTION_LIST *sptr_option_list,enum OPTION_STATE state,BYTE option_type,BYTE length,
	void *vptr_option_data,enum BOOLEAN negotiation_required,enum BOOLEAN negotiable,enum BOOLEAN automatic_nak_processing)
{
	OPTION_LIST_ENTRY *sptr_option;
	UNION_OPTION_TYPES type;

	type.generic = option_type;

	sptr_option = (OPTION_LIST_ENTRY *) table_malloc (sizeof (OPTION_LIST_ENTRY),1);

	if (sptr_option == NULL)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for New Option \r\n");

		return (FAIL);
		}

	if (length > 0x00)
		{
		sptr_option->uptr_data = (UNION_OPTION_DATA_TYPES *) table_malloc (length,1);

		if (sptr_option->uptr_data == NULL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for New Option \r\n");

			return (FAIL);
			}
		}

	sptr_option->state = (BYTE_ENUM (PPP_STATE)) state;
	sptr_option->type = type;
	sptr_option->length = length;
	sptr_option->negotiation_required = (BYTE_ENUM (BOOLEAN)) negotiation_required;
	sptr_option->negotiable = (BYTE_ENUM (BOOLEAN)) negotiable;
	sptr_option->automatic_nak_processing = (BYTE_ENUM (BOOLEAN)) automatic_nak_processing;

	/* Srikar, Mar 23, 1997. Added the following for the administrative enabling/disabling of certain */
	/* PPP options like IP protocol, VJ compression. Later on this can be used for any other option. By */
	/* default we enable all the options here. Later if necessary they are disabled/enabled in the */
	/* corresponding SNMP access functions. */

	sptr_option->admin_status = SNMP_PPP_OPTION_ADMIN_ENABLED;

	if (length > 0x00)
		{
		memcpy (sptr_option->uptr_data,vptr_option_data,length);
		}

	add_entry_to_list ((LINK *) &sptr_option_list->sptr_forward_link,(LINK *) &sptr_option->sptr_forward_link);

	return (PASS);
}
/*************************************************************************************************/
USHORT get_size_of_ppp_options (OPTION_LIST *sptr_option_list)
{
	USHORT number_of_option_bytes;
	OPTION_LIST_ENTRY *sptr_option;

	number_of_option_bytes = 0x0000;

	for (sptr_option = sptr_option_list->sptr_forward_link; sptr_option != NULL; sptr_option = sptr_option->sptr_forward_link)
		{
		/* Srikar, Mar 23, 1997. The following line added to support administratively disabled options. */
		/* Skip the administratively disabled options. */

		if (sptr_option->admin_status != SNMP_PPP_OPTION_ADMIN_ENABLED) {
			continue;
		}
		number_of_option_bytes += (USHORT) (sizeof (sptr_option->type) + sizeof (sptr_option->length));

		number_of_option_bytes = (USHORT) (number_of_option_bytes + sptr_option->length);
		}

	return (number_of_option_bytes);
}
/****************************************************************************/
void store_ppp_options_in_packet (OPTION_LIST *sptr_option_list,PPP_OPTION *sptr_destination_option)
{
	OPTION_LIST_ENTRY *sptr_source_option;

	for (sptr_source_option = sptr_option_list->sptr_forward_link; sptr_source_option != NULL;
		sptr_source_option = sptr_source_option->sptr_forward_link)
		{
		/* Srikar, Mar 23, 1997. The following line added to support administratively disabled options. */
		/* Skip the administratively disabled options. */

		if (sptr_source_option->admin_status != SNMP_PPP_OPTION_ADMIN_ENABLED) {
			continue;
		}
		sptr_destination_option->type = sptr_source_option->type;
		sptr_destination_option->length = (BYTE) (sptr_source_option->length + sizeof (sptr_destination_option->type) +
			sizeof (sptr_destination_option->length));

		memcpy (&sptr_destination_option->data,sptr_source_option->uptr_data,sptr_source_option->length);

		sptr_destination_option = (PPP_OPTION *) ((ULONG) sptr_destination_option +	sptr_destination_option->length);
		}
}
/****************************************************************************/
enum OPTION_PARSE_RESULT parse_ppp_options_from_configure_request (OPTION_LISTS *sptr_option_lists,
	PPP_OPTION *sptr_received_option, USHORT length_of_options,RECEIVE_OPTION_FUNCTIONS *sptr_receive_functions,void *vptr_class)
{
	OPTION_LIST_ENTRY *sptr_configured_option;
	OPTION_LIST_ENTRY *sptr_receive_list_option;
	enum TEST option_value_ok;
	enum OPTION_PARSE_RESULT return_code;

	free_ppp_option_list (&sptr_option_lists->received);
	free_ppp_option_list (&sptr_option_lists->tx_nak);
	free_ppp_option_list (&sptr_option_lists->tx_reject);
	free_ppp_option_list (&sptr_option_lists->rx_accepted);

	if (parse_ppp_options_from_packet (&sptr_option_lists->received,sptr_received_option,length_of_options) == FAIL)
		{
		return (OPTION_PARSING_ERROR);
		}

	return_code = set_missing_required_options_in_nak (&sptr_option_lists->remote_configured,&sptr_option_lists->received,
		&sptr_option_lists->tx_nak);

	sptr_receive_list_option = (OPTION_LIST_ENTRY *) get_entry_from_list ((LINK *) &sptr_option_lists->received);

	while (sptr_receive_list_option != NULL)
		{
		sptr_configured_option = find_matching_option (&sptr_option_lists->remote_configured,
			sptr_receive_list_option->type.generic);

#ifndef CBCP
		if (sptr_receive_list_option->type.generic == LCP_CALLBACK)
		{
			if (sptr_receive_list_option->uptr_data->byte_array[0] == 0x06)
				sptr_configured_option = NULL ;
		}
#endif

/* sudha 26 July 1999.This is required because, what was happening was, if any
NT client is acting as a RAS client to our ProxyServer, NT client requests DNS 
primary as well as secondary (option number 129, 131 ) address from RASServer 
(i.e.,) our ProxyServer during NCP IPCP negotiations.But Proxy sends configure 
nak to those DNS primary as well as secondary, only if some ip address has been 
configured.Otherwise, if not configured, Proxy sends ack for those options of 
NT client with 0.0.0.0 as their address itself instead of rejecting those 
options.Due to this, NT client, is not willing to accept 0.0.0.0 as the DNS 
primary & secondary address & keeps on sending configure request to Proxy 
thinking that, if Proxy has some DNS options address configured, it should 
nak or if not configured, it should reject.Due to this problem, NT client 
never comes up, even after getting IP address from Proxy.After some time, it 
times out & the connection is down.Now, we are checking whether the received 
options from ras client contain dns primary or secondary or both.If it has & 
if we don't have a proper address to nak them other than 0.0.0.0, then we 
are rejecting those options. */

		if ((sptr_configured_option != NULL) &&
			((sptr_receive_list_option->type.generic == IP_PRIMARY_DNS_OPTION_TYPE)
			|| (sptr_receive_list_option->type.generic == IP_SECONDARY_DNS_OPTION_TYPE)))
		{
printf("\n\r\PPPOPTN : %d",sptr_receive_list_option->type.generic);
/* printf("\n\r\PPPOPTN : data value is %lX",sptr_configured_option->uptr_data->_ulong); */
			if (sptr_configured_option->uptr_data->_ulong == 0x00000000L)
				sptr_configured_option = NULL ;
		}
/* sudha 26 July 1999 */

		if (sptr_configured_option == NULL)
			{
			add_entry_to_list ((LINK *) &sptr_option_lists->tx_reject,(LINK *) sptr_receive_list_option);

			return_code = SOME_OPTIONS_ARE_REJECTED;
			}
		else
			{
			/* Srikar, Mar 23, 1997. Added support to reject adiministratively disabled options. If the option */
			/* is administratively disabled we add the option to the reject list; otherwise we call the */
			/* ppp_ncp_configure_request_option_processor to handle the option. If the same is checked inside */
			/* the ppp_ncp_configure_request_option_processor, the FAIL return code would only send a NAK for this */
			/* option. */

			if (sptr_configured_option->admin_status == SNMP_PPP_OPTION_ADMIN_DISABLED)
				{
				add_entry_to_list ((LINK *) &sptr_option_lists->tx_reject,(LINK *) sptr_receive_list_option);
				return_code = SOME_OPTIONS_ARE_REJECTED;
				}
			else
				{
				option_value_ok = (*sptr_receive_functions->fptr_process_receive_options[sptr_receive_list_option->type.generic])
					(sptr_receive_list_option,vptr_class);

				if (option_value_ok == PASS)
					{
					add_entry_to_list ((LINK *) &sptr_option_lists->rx_accepted,(LINK *) sptr_receive_list_option);
					}
				else
					{
					if (return_code == OPTIONS_RECEIVED_ARE_OK)
						{
						return_code = SOME_OPTIONS_ARE_NACKED;
						}

					add_entry_to_list ((LINK *) &sptr_option_lists->tx_nak,(LINK *) sptr_receive_list_option);
					}
				}
			}

		sptr_receive_list_option = (OPTION_LIST_ENTRY *) get_entry_from_list ((LINK *) &sptr_option_lists->received);
		}

	return (return_code);
}
/****************************************************************************/
static enum OPTION_PARSE_RESULT set_missing_required_options_in_nak (OPTION_LIST *sptr_configured_option_list,
	OPTION_LIST *sptr_rxed_option_list,OPTION_LIST *sptr_nak_option_list)
{
	OPTION_LIST_ENTRY *sptr_configured_option;
	OPTION_LIST_ENTRY *sptr_rxed_option;
	OPTION_LIST_ENTRY *sptr_nak_option;
	enum OPTION_PARSE_RESULT return_code;

	return_code	= OPTIONS_RECEIVED_ARE_OK;

	for (sptr_configured_option = sptr_configured_option_list->sptr_forward_link; sptr_configured_option != NULL;
		sptr_configured_option = sptr_configured_option->sptr_forward_link)
		{
		for (sptr_rxed_option = sptr_rxed_option_list->sptr_forward_link; sptr_rxed_option != NULL;
			sptr_rxed_option = sptr_rxed_option->sptr_forward_link)
			{
			if (sptr_configured_option->type.generic == sptr_rxed_option->type.generic)
				{
				break;
				}
			}

		if (sptr_configured_option->negotiation_required == TRUE)
			{
			if (sptr_rxed_option == NULL)
				{
				sptr_nak_option = duplicate_option (sptr_configured_option);

				if (sptr_nak_option != NULL)
					{
					add_entry_to_list ((LINK *) sptr_nak_option_list,(LINK *) sptr_nak_option);

					return_code = SOME_OPTIONS_ARE_NACKED;
					}
				}
			}
		}

	return (return_code);
}
/****************************************************************************/
enum OPTION_PARSE_RESULT parse_ppp_options_from_nak_configure (OPTION_LISTS *sptr_option_lists,PPP_OPTION *sptr_received_option,
	USHORT length_of_options,RECEIVE_OPTION_FUNCTIONS *sptr_receive_functions,void *vptr_class)
{
	OPTION_LIST_ENTRY *sptr_configured_option;
	OPTION_LIST_ENTRY *sptr_receive_list_option;
	enum TEST option_value_ok;
	enum OPTION_PARSE_RESULT return_code;
	BYTE type_value;

	return_code = OPTIONS_RECEIVED_ARE_OK;

	free_ppp_option_list (&sptr_option_lists->received);
	free_ppp_option_list (&sptr_option_lists->rx_nak);
	free_ppp_option_list (&sptr_option_lists->tx_reject);

	if (parse_ppp_options_from_packet (&sptr_option_lists->received,sptr_received_option,length_of_options) == FAIL)
		{
		return (OPTION_PARSING_ERROR);
		}

	for (sptr_receive_list_option = sptr_option_lists->received.sptr_forward_link;
                sptr_receive_list_option != NULL; sptr_receive_list_option = sptr_receive_list_option->sptr_forward_link)
		{
		sptr_configured_option = find_matching_option (&sptr_option_lists->configured,sptr_receive_list_option->type.generic);

		if (sptr_configured_option == NULL)
			{
			free_ppp_option_list (&sptr_option_lists->received);
			return (OPTION_PARSING_ERROR);
			}
		else
			{
#if 0	/* need to check with satish */
			type_value = sptr_receive_list_option->type.generic;

			if (type_value == IP_DNS_PRIMARY)
				type_value = IP_PRIMARY_DNS_ADDR_OPTION_TYPE;
			else if (type_value == IP_DNS_SECONDARY)
				type_value = IP_SECONDARY_DNS_ADDR_OPTION_TYPE;

			option_value_ok = (*sptr_receive_functions->fptr_process_receive_options[type_value])
				(sptr_receive_list_option,vptr_class);
#else
			option_value_ok = (*sptr_receive_functions->fptr_process_receive_options[sptr_receive_list_option->type.generic])
				(sptr_receive_list_option,vptr_class);
#endif

			if (option_value_ok == FAIL)
				{
				free_ppp_option_list (&sptr_option_lists->received);
				return (OPTION_PARSING_ERROR);
				}
			}
		}
	free_ppp_option_list (&sptr_option_lists->received);

	return (return_code);
}
/****************************************************************************/
OPTION_LIST_ENTRY *find_matching_option (OPTION_LIST *sptr_option_list,BYTE type)
{
	OPTION_LIST_ENTRY *sptr_matching_option = NULL;

	for (sptr_matching_option = sptr_option_list->sptr_forward_link; sptr_matching_option != NULL;
		sptr_matching_option = sptr_matching_option->sptr_forward_link)
		{
		if (sptr_matching_option->type.generic == type)
			{
			break;
			}
		}

	return (sptr_matching_option);
}
/****************************************************************************/
enum TEST parse_ppp_options_from_packet (OPTION_LIST *sptr_option_list,PPP_OPTION *sptr_source_option,
	USHORT length_of_options)
{
	while ((length_of_options != 0x0000) && (sptr_source_option->length <= length_of_options))
		{
		if (sptr_source_option->length == 0x00)
			{
			break;
			}

		if (add_new_ppp_option_to_list (sptr_option_list,OPTION_PARSED_STATE,sptr_source_option->type.generic,
			(BYTE) (sptr_source_option->length - sizeof (sptr_source_option->type) - sizeof (sptr_source_option->length)),
			&sptr_source_option->data,FALSE,TRUE,TRUE) == FAIL)
			{
			return (FAIL);
			}

		length_of_options = (USHORT) (length_of_options - sptr_source_option->length);

		sptr_source_option = (PPP_OPTION *) ((ULONG) sptr_source_option +	sptr_source_option->length);
		}

	if ((length_of_options != 0x0000) && (sptr_source_option->length > length_of_options))
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Illegal Option Length \r\n");

		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
void free_ppp_option_list (OPTION_LIST *sptr_option_list)
{
	OPTION_LIST_ENTRY *sptr_source_option;
	OPTION_LIST_ENTRY *sptr_next_source_option;
	ALTERNATE_OPTION *sptr_alternate_option;
	ALTERNATE_OPTION *sptr_next_alternate_option;

	for (sptr_source_option = sptr_option_list->sptr_forward_link; sptr_source_option != NULL; )
		{
		sptr_next_source_option = sptr_source_option->sptr_forward_link;

		delete_entry_from_list ((LINK *) sptr_option_list,(LINK *) sptr_source_option);

		if (sptr_source_option->length > 0x00)
			{
			table_free (sptr_source_option->uptr_data);
			}

		if (sptr_source_option->uptr_lowest_value != NULL)
			{
			table_free (sptr_source_option->uptr_lowest_value);
			table_free (sptr_source_option->uptr_highest_value);
			table_free (sptr_source_option->uptr_step);
			}

		for (sptr_alternate_option = sptr_source_option->alternate_option_list.sptr_forward_link;
			sptr_alternate_option != NULL; )
			{
			sptr_next_alternate_option = sptr_alternate_option->links.sptr_forward_link;

			if (sptr_alternate_option->uptr_data != NULL)
				{
				table_free (sptr_alternate_option->uptr_data);
				}

			table_free (sptr_alternate_option);

			sptr_alternate_option = sptr_next_alternate_option;
			}

		table_free (sptr_source_option);

		sptr_source_option = sptr_next_source_option;
		}
}
/****************************************************************************/
enum BOOLEAN is_option_present (OPTION_LIST *sptr_option_list,BYTE option_type)
{
	OPTION_LIST_ENTRY *sptr_matching_option;

	for (sptr_matching_option = sptr_option_list->sptr_forward_link; sptr_matching_option != NULL;
		sptr_matching_option = sptr_matching_option->sptr_forward_link)
		{
		if (sptr_matching_option->type.generic == option_type)
			{
			return (TRUE);
			}
		}

	return (FALSE);
}
/****************************************************************************/
enum TEST copy_option (OPTION_LIST *sptr_option_list,BYTE option_type,void *vptr_destination,USHORT maximum_size)
{
	OPTION_LIST_ENTRY *sptr_matching_option;

	sptr_matching_option = find_matching_option (sptr_option_list,option_type);

	if (sptr_matching_option != NULL)
		{
		if (maximum_size >= sptr_matching_option->length)
			{
			memcpy (vptr_destination,sptr_matching_option->uptr_data,sptr_matching_option->length);

			return (PASS);
			}
		else
			{
 			ppp_printf (PPP_ALARM_PRINTF,"PPP: Copy Option Length too small\r\n");
			}
		}

 	ppp_printf (PPP_DATA_PRINTF,"PPP: Copy Option Does Not Exist\r\n");

	return (FAIL);
}
/****************************************************************************/
enum TEST copy_option_from_entry (OPTION_LIST_ENTRY *sptr_matching_option,void *vptr_destination,USHORT maximum_size)
{
	if (maximum_size >= sptr_matching_option->length)
		{
		memcpy (vptr_destination,sptr_matching_option->uptr_data,sptr_matching_option->length);

		return (PASS);
		}
	else
		{
 		ppp_printf (PPP_ALARM_PRINTF,"PPP: Copy Option Length too small\r\n");

		return (FAIL);
		}
}
/****************************************************************************/
enum TEST copy_data_to_option (OPTION_LIST_ENTRY *sptr_matching_option,void *vptr_source,USHORT size)
{
	if (size <= sptr_matching_option->length)
		{
		memcpy (sptr_matching_option->uptr_data,vptr_source,size);

		return (PASS);
		}
	else
		{
 		ppp_printf (PPP_ALARM_PRINTF,"PPP: Copy Option Length too small\r\n");

		return (FAIL);
		}
}
/*************************************************************************************************/
enum OPTION_PARSE_RESULT parse_ppp_options_from_reject_configure (OPTION_LISTS *sptr_option_lists,
	PPP_OPTION *sptr_received_option,USHORT length_of_options)
{
	OPTION_LIST_ENTRY *sptr_tx_accepted_option;
	OPTION_LIST_ENTRY *sptr_receive_list_option;

	free_ppp_option_list (&sptr_option_lists->received);
	free_ppp_option_list (&sptr_option_lists->rx_reject);

	if (parse_ppp_options_from_packet (&sptr_option_lists->received,sptr_received_option,length_of_options) == FAIL)
		{
		return (OPTION_PARSING_ERROR);
		}

	sptr_receive_list_option = (OPTION_LIST_ENTRY *) get_entry_from_list ((LINK *) &sptr_option_lists->received);

	while (sptr_receive_list_option != NULL)
		{
		sptr_tx_accepted_option = find_matching_option (&sptr_option_lists->tx_accepted,sptr_receive_list_option->type.generic);

		if (sptr_tx_accepted_option == NULL)
			{
			free_ppp_option_list (&sptr_option_lists->received);

			return (OPTION_PARSING_ERROR);
			}
		else
			{
			add_entry_to_list ((LINK *) &sptr_option_lists->rx_reject,(LINK *) sptr_receive_list_option);

			delete_entry_from_option_list (&sptr_option_lists->tx_accepted,sptr_tx_accepted_option);
			}

		sptr_receive_list_option = (OPTION_LIST_ENTRY *) get_entry_from_list ((LINK *) &sptr_option_lists->received);
		}

	return (OPTIONS_RECEIVED_ARE_OK);
}
/*************************************************************************************************/
void delete_entry_from_option_list (OPTION_LIST *sptr_option_list,OPTION_LIST_ENTRY *sptr_option_to_delete)
{
	delete_entry_from_list ((LINK *) sptr_option_list,(LINK *) sptr_option_to_delete);

	if (sptr_option_to_delete->length > 0x00)
		{
		table_free (sptr_option_to_delete->uptr_data);
		}

	table_free (sptr_option_to_delete);
}
/*************************************************************************************************/
enum OPTION_PARSE_RESULT parse_ppp_lcp_options_from_reject_configure (USHORT real_port_number,OPTION_LISTS *sptr_option_lists,
	PPP_OPTION *sptr_received_option,USHORT length_of_options)
{
	OPTION_LIST_ENTRY *sptr_tx_accepted_option;
	OPTION_LIST_ENTRY *sptr_receive_list_option;

	free_ppp_option_list (&sptr_option_lists->received);
	free_ppp_option_list (&sptr_option_lists->rx_reject);

	if (parse_ppp_options_from_packet (&sptr_option_lists->received,sptr_received_option,length_of_options) == FAIL)
	{
		return (OPTION_PARSING_ERROR);
	}

	sptr_receive_list_option = (OPTION_LIST_ENTRY *) get_entry_from_list ((LINK *) &sptr_option_lists->received);

	while (sptr_receive_list_option != NULL)
	{
		/* check if it is AUTHENTICATION if so then send terminate request and 
			close down the connection if authentication is enabled */

		if (sptr_receive_list_option->type.generic == LCP_AUTHENTICATION_PROTOCOL)
		{
			if ((ppp.port[real_port_number].authentication.remote_user_name[0] != '\0'))
			{ 
				/* Authentication is enabled so terminate */
				free_ppp_option_list (&sptr_option_lists->received);
				return (OPTION_PARSING_FATAL);
			}
		}
		sptr_tx_accepted_option = find_matching_option (&sptr_option_lists->tx_accepted,sptr_receive_list_option->type.generic);

		if (sptr_tx_accepted_option == NULL)
		{
			free_ppp_option_list (&sptr_option_lists->received);

			return (OPTION_PARSING_ERROR);
		}
		else
		{
			add_entry_to_list ((LINK *) &sptr_option_lists->rx_reject,(LINK *) sptr_receive_list_option);

			delete_entry_from_option_list (&sptr_option_lists->tx_accepted,sptr_tx_accepted_option);
		}
		sptr_receive_list_option = (OPTION_LIST_ENTRY *) get_entry_from_list ((LINK *) &sptr_option_lists->received);
	}
	return (OPTIONS_RECEIVED_ARE_OK);
}

