#include	"defs.h"
/*	$Modname: pppoptna.c$  $version: 1.2$      $date: 02/27/95$   */
/*
* 	$lgb$
1.0 12/05/94 ross
1.1 12/13/94 ross added copyrights in some files
1.2 02/27/95 ross fixed problem with duplicate_options.  Courtesy of Dan.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993 - 1994 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "ppp.h"
/*************************************************************************************************/
static enum TEST add_option_to_alternate_list (OPTION_LIST *sptr_option_list,BYTE option_type,BYTE length,
	void *vptr_option_data);
static enum TEST add_range_to_configuration_option (OPTION_LIST *sptr_option_list,BYTE option_type,BYTE length,
	void *vptr_option_data);
/*************************************************************************************************/
void add_configuration_option (OPTION_LIST *sptr_option_list,enum OPTION_STATE state,
	BYTE option_type,BYTE length,void *vptr_option_data,char *cptr_option_name,char *cptr_ncp_name,enum BOOLEAN swap_value,
	enum BOOLEAN negotiation_required,enum BOOLEAN negotiable,enum BOOLEAN automatic_nak_processing)
{
	ULONG ulong_swap_value;
	USHORT ushort_swap_value;

	if (swap_value == TRUE)
		{
		if (length == sizeof (ULONG))
			{
			ulong_swap_value = swap_long (*((ULONG *)vptr_option_data));

			vptr_option_data = &ulong_swap_value;
			}
		else if (length == sizeof (USHORT))
			{
			ushort_swap_value = swap (*((USHORT *)vptr_option_data));

			vptr_option_data = &ushort_swap_value;
			}
		else
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP:Adding %s option to %s failed\r\n",cptr_option_name,cptr_ncp_name);
			}
		}

	if (add_new_ppp_option_to_list (sptr_option_list,state,option_type,length,vptr_option_data,
		negotiation_required,negotiable,automatic_nak_processing) == FAIL)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP:Adding %s option to %s failed\r\n",cptr_option_name,cptr_ncp_name);
		}
}
/*************************************************************************************************/
void add_alternate_to_configuration_option (OPTION_LIST *sptr_option_list,BYTE option_type,BYTE length,void *vptr_option_data,
	char *cptr_option_name,char *cptr_ncp_name,enum BOOLEAN swap_value)
{
	ULONG ulong_swap_value;
	USHORT ushort_swap_value;

	if (swap_value == TRUE)
		{
		if (length == sizeof (ULONG))
			{
			ulong_swap_value = swap_long (*((ULONG *)vptr_option_data));

			vptr_option_data = &ulong_swap_value;
			}
		else if (length == sizeof (USHORT))
			{
			ushort_swap_value = swap (*((USHORT *)vptr_option_data));

			vptr_option_data = &ushort_swap_value;
			}
		else
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP:Adding %s option to %s failed\r\n",cptr_option_name,cptr_ncp_name);
			}
		}

	if (add_option_to_alternate_list (sptr_option_list,option_type,length,vptr_option_data) == FAIL)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP:Adding %s option to %s failed\r\n",cptr_option_name,cptr_ncp_name);
		}
}
/*************************************************************************************************/
static enum TEST add_option_to_alternate_list (OPTION_LIST *sptr_option_list,BYTE option_type,BYTE length,
	void *vptr_option_data)
{
	ALTERNATE_OPTION *sptr_alternate_option;
	OPTION_LIST_ENTRY *sptr_option_entry;

	sptr_alternate_option = (ALTERNATE_OPTION *) table_malloc (sizeof (ALTERNATE_OPTION),1);

	if (sptr_alternate_option == NULL)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for New Option \r\n");

		return (FAIL);
		}

	if (length > 0x00)
		{
		sptr_alternate_option->uptr_data = (UNION_OPTION_DATA_TYPES *) table_malloc (length,1);

		if (sptr_alternate_option->uptr_data == NULL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for New Option \r\n");

			return (FAIL);
			}
		}

	sptr_alternate_option->length = length;

	if (length > 0x00)
		{
		memcpy (sptr_alternate_option->uptr_data,vptr_option_data,length);
		}

	sptr_option_entry = find_matching_option (sptr_option_list,option_type);

	if (sptr_option_entry != NULL)
		{
		sptr_option_entry->alternate_checking_enabled = TRUE;

		add_entry_to_list ((LINK *) &sptr_option_entry->alternate_option_list,
			(LINK *) &sptr_alternate_option->links.sptr_forward_link);

		return (PASS);
		}
	else
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for Alternate Option \r\n");

		return (FAIL);
		}
}
/*************************************************************************************************/
void add_configuration_option_range (OPTION_LIST *sptr_option_list,BYTE option_type,BYTE length,void *vptr_option_data,
	char *cptr_option_name,char *cptr_ncp_name,enum BOOLEAN swap_value)
{
	ULONG ulong_swap_value;
	USHORT ushort_swap_value;

	if (swap_value == TRUE)
		{
		if (length == sizeof (ULONG))
			{
			ulong_swap_value = swap_long (*((ULONG *)vptr_option_data));

			vptr_option_data = &ulong_swap_value;
			}
		else if (length == sizeof (USHORT))
			{
			ushort_swap_value = swap (*((USHORT *)vptr_option_data));

			vptr_option_data = &ushort_swap_value;
			}
		else
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP:Adding %s option to %s failed\r\n",cptr_option_name,cptr_ncp_name);
			}
		}

	if (add_range_to_configuration_option (sptr_option_list,option_type,length,vptr_option_data) == FAIL)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP:Adding %s option to %s failed\r\n",cptr_option_name,cptr_ncp_name);
		}
}
/*************************************************************************************************/
static enum TEST add_range_to_configuration_option (OPTION_LIST *sptr_option_list,BYTE option_type,BYTE length,
	void *vptr_option_data)
{
	OPTION_LIST_ENTRY *sptr_option_entry;

	sptr_option_entry = find_matching_option (sptr_option_list,option_type);

	if (sptr_option_entry == NULL)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for Alternate Option \r\n");

		return (FAIL);
		}

	if (length > 0x00)
		{
		sptr_option_entry->uptr_lowest_value = (UNION_OPTION_DATA_TYPES *) table_malloc (length/3,1);

		if (sptr_option_entry->uptr_lowest_value == NULL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for New Option \r\n");

			return (FAIL);
			}

		sptr_option_entry->uptr_highest_value = (UNION_OPTION_DATA_TYPES *) table_malloc (length/3,1);

		if (sptr_option_entry->uptr_highest_value == NULL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for New Option \r\n");

			return (FAIL);
			}

		sptr_option_entry->uptr_step = (UNION_OPTION_DATA_TYPES *) table_malloc (length/3,1);

		if (sptr_option_entry->uptr_step == NULL)
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for New Option \r\n");

			return (FAIL);
			}
		}

	memcpy (sptr_option_entry->uptr_lowest_value,vptr_option_data,length/3);
	memcpy (sptr_option_entry->uptr_highest_value,(void *) ((ULONG) vptr_option_data + (length/3)),length/3);
	memcpy (sptr_option_entry->uptr_step,(void *) ((ULONG) vptr_option_data + ((2 * length)/3)),length/3);

	sptr_option_entry->range_checking_enabled = TRUE;

	return (PASS);
}
/*************************************************************************************************/
void remove_configuration_option (OPTION_LIST *sptr_option_list,BYTE option_type)
{
	OPTION_LIST_ENTRY *sptr_option;

	for (sptr_option = sptr_option_list->sptr_forward_link; sptr_option != NULL; sptr_option = sptr_option->sptr_forward_link)
		{
		if (sptr_option->type.generic == option_type)
			{
			delete_entry_from_option_list (sptr_option_list,sptr_option);

			break;
			}
		}

	if (sptr_option == NULL)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Tried to delete option not present \r\n");
		}
}
/*************************************************************************************************/
void replace_configuration_option (OPTION_LIST *sptr_option_list,OPTION_LIST_ENTRY *sptr_option_to_replace,
	enum OPTION_STATE state)
{
	enum BOOLEAN negotiation_required;
	enum BOOLEAN negotiable;
	enum BOOLEAN automatic_nak_processing;

	negotiation_required = sptr_option_to_replace->negotiation_required;
	negotiable = sptr_option_to_replace->negotiable;
	automatic_nak_processing = sptr_option_to_replace->automatic_nak_processing;

	remove_configuration_option (sptr_option_list,sptr_option_to_replace->type.generic);

	add_new_ppp_option_to_list (sptr_option_list,state,sptr_option_to_replace->type.generic,sptr_option_to_replace->length,
		sptr_option_to_replace->uptr_data,negotiation_required,negotiable,automatic_nak_processing);
}
/*************************************************************************************************/
void free_ppp_option_lists (OPTION_LISTS *sptr_option_lists)
{
	/* free_ppp_option_list (&sptr_option_lists->configured); */
	/* free_ppp_option_list (&sptr_option_lists->remote_configured); */
	free_ppp_option_list (&sptr_option_lists->received);
	free_ppp_option_list (&sptr_option_lists->tx_nak);
	free_ppp_option_list (&sptr_option_lists->rx_nak);
	free_ppp_option_list (&sptr_option_lists->tx_reject);
	free_ppp_option_list (&sptr_option_lists->rx_reject);
	free_ppp_option_list (&sptr_option_lists->tx_accepted);
	free_ppp_option_list (&sptr_option_lists->rx_accepted);
}
/****************************************************************************/
OPTION_LIST_ENTRY *duplicate_option (OPTION_LIST_ENTRY *sptr_to_option_to_copy)
{
	OPTION_LIST_ENTRY *sptr_duplicate_option;
	UNION_OPTION_DATA_TYPES	*uptr_matching_option_data;

	sptr_duplicate_option = (OPTION_LIST_ENTRY *) table_malloc (sizeof (OPTION_LIST_ENTRY),1);

	if (sptr_duplicate_option != NULL)
		{
		if (sptr_to_option_to_copy->length != 0x00)
			{
			uptr_matching_option_data = (UNION_OPTION_DATA_TYPES *) table_malloc (sptr_to_option_to_copy->length,1);

			if (uptr_matching_option_data != NULL)
				{
				memcpy (sptr_duplicate_option,sptr_to_option_to_copy,sizeof (OPTION_LIST_ENTRY));

				sptr_duplicate_option->uptr_data = uptr_matching_option_data;

				memcpy (sptr_duplicate_option->uptr_data,sptr_to_option_to_copy->uptr_data,sptr_to_option_to_copy->length);

				return (sptr_duplicate_option);
				}
			else
				{
				table_free (sptr_duplicate_option);
				}
			}
		else
			{
			memcpy (sptr_duplicate_option,sptr_to_option_to_copy,sizeof (OPTION_LIST_ENTRY));

			return (sptr_duplicate_option);
			}
		}

	ppp_printf (PPP_ALARM_PRINTF,"PPP: Out of Memory for Copy Option \r\n");

	return (NULL);
}
/****************************************************************************/
void replace_data_field_in_option (OPTION_LIST_ENTRY *sptr_option,UNION_OPTION_DATA_TYPES *uptr_new_data,BYTE new_length)
{
	void *vptr_allocated_data;

	if (sptr_option->length > 0x00)
		{
		if (sptr_option->uptr_data != NULL)
			{
			table_free (sptr_option->uptr_data);
			}
		else
			{
			ppp_printf (PPP_ALARM_PRINTF,"PPP: Illegal Option \r\n");
			}
		}

	vptr_allocated_data = (OPTION_LIST_ENTRY *) table_malloc (new_length,1);

	if (vptr_allocated_data != NULL)
		{
		memcpy (vptr_allocated_data,uptr_new_data,new_length);

		sptr_option->uptr_data = vptr_allocated_data;
		sptr_option->length = new_length;
		}
}
/****************************************************************************/
void copy_configuration_options_to_tx_accepted_options (OPTION_LISTS *sptr_option_lists)
{
	OPTION_LIST_ENTRY *sptr_option_to_copy;
	OPTION_LIST_ENTRY *sptr_option_to_add;

	for (sptr_option_to_copy = sptr_option_lists->configured.sptr_forward_link; sptr_option_to_copy != NULL;
		sptr_option_to_copy = sptr_option_to_copy->sptr_forward_link)
		{
		/* Srikar, Mar 23, 1997. The following line added to support administratively disabled options. */
		/* Skip the administratively disabled options. */

		if (sptr_option_to_copy->admin_status == SNMP_PPP_OPTION_ADMIN_DISABLED) 
		{
			continue;
		}

		sptr_option_to_add = duplicate_option (sptr_option_to_copy);

		if (sptr_option_to_add != NULL)
			{
			add_entry_to_list ((LINK *) &sptr_option_lists->tx_accepted.sptr_forward_link,
				(LINK *) &sptr_option_to_add->sptr_forward_link);
			}
		else 
			{
			break;
			}
		}
}


void copy_remote_configuration_options_to_tx_accepted_list (OPTION_LISTS *sptr_option_lists)
{
	OPTION_LIST_ENTRY *sptr_option_to_copy;
	OPTION_LIST_ENTRY *sptr_option_to_add;

	for (sptr_option_to_copy = sptr_option_lists->remote_configured.sptr_forward_link; sptr_option_to_copy != NULL;
		sptr_option_to_copy = sptr_option_to_copy->sptr_forward_link)
		{
			if (sptr_option_to_copy->type.generic != LCP_AUTHENTICATION_PROTOCOL)
				continue;

			sptr_option_to_add = duplicate_option (sptr_option_to_copy);

			if (sptr_option_to_add != NULL)
				{
				add_entry_to_list ((LINK *) &sptr_option_lists->tx_accepted.sptr_forward_link,
					(LINK *) &sptr_option_to_add->sptr_forward_link);
				}
			else 
				{
				break;
				}
		}
}


void	add_new_lcp_option_to_list (OPTION_LIST *sptr_option_list,
		OPTION_LIST_ENTRY *sptr_new_option)
{
	BYTE length, option_type;
	void *option_data_ptr;
	enum BOOLEAN negotiation_required, negotiable, automatic_nak_processing;
	enum OPTION_STATE state;
	
	if (sptr_new_option == NULL)
	{
		printf ("PPP: Wrong Option passed to list\n");
		return;
	}

	option_type = *((BYTE *)(&(sptr_new_option->type)));
	length = sptr_new_option->length;
	negotiation_required = sptr_new_option->negotiation_required;
	automatic_nak_processing = sptr_new_option->automatic_nak_processing;	
	negotiable = sptr_new_option->negotiable;
	state = sptr_new_option->state;
	option_data_ptr = sptr_new_option->uptr_data;

	add_new_ppp_option_to_list (sptr_option_list, state,sptr_new_option->type.generic,length,
		option_data_ptr, negotiation_required, negotiable, automatic_nak_processing);
}


