#include	"defs.h"
/*	$Modname: ppprx.c$  $version: 1.33$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 12/10/93 ross Initial Release.
1.1 01/05/94 ross Split file into ppplcprx.c,pppncprx.c and ppprx.c.
1.2 01/05/94 keyur Added support for version control.
1.3 01/20/94 keyur Added some statistics.
1.4 01/28/94 keyur Added code for checking packet authenticity.
1.5 02/22/94 keyur There is no change from previous release.
1.6 03/09/94 keyur Deleted semicolon.
1.7 03/23/94 keyur Cosmetic Changes.
1.8 03/26/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Ad
1.9 04/06/94 keyur Cleared source routing bit out of source address of protocol packet.
1.10 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.11 04/13/94 keyur Added support for NCP state machine
1.12 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.13 04/19/94 keyur Cosmetic Changes
1.14 05/02/94 keyur
1.15 05/02/94 keyur took out memcheck header file.
1.16 06/15/94 keyur cosmetic changes.
1.17 06/23/94 ross moved van jacobsen constants to call ip.
1.18 07/18/94 ross general cleanup with options, added header compression, accm features.
1.19 08/11/94 ross adding rfc1570 lcp support
1.20 08/24/94 ross adding new ncps.
1.21 08/30/94 ross cleaned up ip receive routine for vj.
1.22 09/06/94 ross adding cipx.
1.23 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.24 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.25 12/02/94 ross testing NT3.5 RAS
1.26 12/03/94 ross testing Windows 95	RAS
1.27 12/13/94 ross connected to NT RAS with Netbios
1.28 02/27/95 ross dynamic load changes including lsl_control.
1.29 03/03/95 ross added up calls.
1.30 03/10/95 ross general fixes.  see change.doc
1.31 05/15/95 ross removed WAN_CRC and added printf's in verify_packet.
1.32 06/26/95 ross initial version of BCP
1.33 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include "ppp.h"
#ifdef CBCP
#include "vpppcb.h"
#endif
#include <softquot.h>
/****************************************************************************/
static enum TEST determine_packet_type (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed);
static enum TEST verify_packet (USHORT real_port_number,UNION_PPP_PACKET *sptr_lcp_rx_packet,
	USHORT *usptr_number_of_bytes_rxed);
enum TEST ip_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed);
enum TEST ipx_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed);
enum TEST appletalk_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed);
enum TEST bridge_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed);
enum TEST netbios_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed);
enum TEST check_id (USHORT real_port_number,enum PPP_CONTROL_CODE code,BYTE received_id,BYTE expected_id,
	char *cptr_ncp_name);
enum TEST verify_ncp (USHORT real_port_number,UNION_PPP_PACKET *sptr_rx_packet);
static void print_out_packet_type (USHORT real_port_number,enum PPP_PROTOCOL_TYPE protocol_type);

#ifdef CBCP
extern void cbcp_packet_received (USHORT real_port_number, CBCP_PACKET *sptr_cbcp_rx_packet, USHORT number_of_bytes_rxed) ;
#endif

#if defined (CCP)
	UNION_PPP_PACKET	*ccp_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *sptr_rxed_packet, 
		USHORT *usptr_number_of_bytes_rxed);
    enum BOOLEAN decompressed_by_ppp_rx = FALSE;    /* Sudha from Chris 27 Jan 1999 */

#endif
/****************************************************************************/
enum BOOLEAN ppp_receive (USHORT real_port_number,UNION_PPP_PACKET **sptr_return_packet,USHORT *usptr_number_of_bytes_rxed)
{
	UNION_PPP_PACKET *sptr_rxed_packet;
	USHORT number_of_bytes_rxed;

#ifdef DEBUG
	check_for_ppp_runtime_breakpoint ();
#endif

#ifndef __MLPPP__
	real_port_number = (USHORT) (real_port_number - ppp.number_of_lan_ports);
#endif /* __MLPPP__ */

	if (ppp.port[real_port_number].enabled == FALSE)
		{
		return (FALSE);
		}

/* Kamalnath 05\02\1997 */
   if (ppp.port[real_port_number].slip_on == TRUE)
	{
		BYTE *usptr_rx_packet;

		if (!ppp.port[real_port_number].serial_driver.fptr_rx_routine) 
			return (FALSE);

		if ((*ppp.port[real_port_number].serial_driver.fptr_rx_routine) (real_port_number,(void **) &usptr_rx_packet,
				&number_of_bytes_rxed) == FALSE)
		{
			return (FALSE);
		}

		*sptr_return_packet = usptr_rx_packet;
		
		if (receive_slip_packet (real_port_number, &usptr_rx_packet,&number_of_bytes_rxed) == FAIL)
		{
			ppp_return_buffer_to_device_driver ((USHORT) (real_port_number + ppp.number_of_lan_ports),*sptr_return_packet);

			return (FALSE);
		}
		*usptr_number_of_bytes_rxed = number_of_bytes_rxed;
		*sptr_return_packet = usptr_rx_packet;
		return (TRUE);
	}
/* Kamalnath 05\02\1997 */

	if (!ppp.port[real_port_number].serial_driver.fptr_rx_routine) 
		return (FALSE);

	if ((*ppp.port[real_port_number].serial_driver.fptr_rx_routine) (real_port_number,(void **) &sptr_rxed_packet,
		&number_of_bytes_rxed) == FALSE)
		{
		return (FALSE);
		}

#ifdef SOFTWARE_QUOTING
	if (ppp.port[real_port_number].async.enabled == TRUE)
		{
		*sptr_return_packet = sptr_rxed_packet;

		sptr_rxed_packet = (UNION_PPP_PACKET *) asynchronous_packet_received (real_port_number,
			(PPP_PACKET *) sptr_rxed_packet,&number_of_bytes_rxed);

		if (sptr_rxed_packet == NULL)
			{
			ppp_return_buffer_to_device_driver ((USHORT) (real_port_number + ppp.number_of_lan_ports),*sptr_return_packet);

			return (FALSE);
			}
		}
#endif

#if defined (CCP)
	if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
		{
		sptr_rxed_packet = ccp_decompress_ppp (real_port_number, sptr_rxed_packet, &number_of_bytes_rxed);

      decompressed_by_ppp_rx = TRUE;      /* Sudha from Chris 27 Jan 1999 */

		if (sptr_rxed_packet == NULL)
			{
			return (FALSE);
			}
		}
#endif

	++ppp.port[real_port_number].link_quality_counters.ifInUniPackets;

	ppp.port[real_port_number].link_quality_counters.ifInOctets += number_of_bytes_rxed;
	ppp.port[real_port_number].link_quality_counters.InGoodOctets += number_of_bytes_rxed;

	ppp.port[real_port_number].lcp_mibs.pppLqrInGoodOctets += number_of_bytes_rxed;

	if (verify_packet (real_port_number,sptr_rxed_packet,&number_of_bytes_rxed) == FAIL)
		{
		ppp_return_buffer_to_device_driver ((USHORT) (real_port_number + ppp.number_of_lan_ports),sptr_rxed_packet);

		return (FALSE);
		}
#if 0
	ppp_printf (PPP_DATA_PRINTF,"PPP:Packet Received: %04x, size %04x\r\n",real_port_number,number_of_bytes_rxed);
#endif

	if (determine_packet_type (real_port_number,sptr_rxed_packet,(void **) &sptr_rxed_packet,&number_of_bytes_rxed) == FAIL)
		{
		ppp_return_buffer_to_device_driver ((USHORT) (real_port_number + ppp.number_of_lan_ports),sptr_rxed_packet);

		return (FALSE);
		}


#ifdef DEBUG
	ppp_printf (PPP_DATA_PRINTF,"PPP:Protocol Packet Received: %04x, size %04x, %p\r\n",real_port_number,number_of_bytes_rxed,
		sptr_rxed_packet);
	display_packet ((BYTE *) sptr_rxed_packet, number_of_bytes_rxed);
#endif

	*usptr_number_of_bytes_rxed = number_of_bytes_rxed;
	*sptr_return_packet = sptr_rxed_packet;

	return (TRUE);
}
#if defined (CCP)
/****************************************************************************/
UNION_PPP_PACKET	*ccp_decompress_ppp (USHORT real_port_number, UNION_PPP_PACKET *sptr_rxed_packet, 
	USHORT *usptr_number_of_bytes_rxed)
{
	UNION_PPP_PACKET *uptr_compressed_ppp_packet;
	enum PPP_STATE ccp_state;
	
	ccp_state = (*ppp.ccp.fptr_get_ccp_state_function) (real_port_number);

	if (ccp_state == PPP_OPENED_STATE)
		{
		uptr_compressed_ppp_packet = sptr_rxed_packet;
		
		if ((*ppp.ccp.fptr_get_receiver_compression_database_initialization_status_function) (real_port_number) == TRUE)
			{
			ppp_return_buffer_to_device_driver ((USHORT) (real_port_number + ppp.number_of_lan_ports), uptr_compressed_ppp_packet);
			
			return (NULL);
			}

		sptr_rxed_packet = (*((*ppp.ccp.fptr_get_receiver_decompression_function_function) (real_port_number)))
			(real_port_number, sptr_rxed_packet, usptr_number_of_bytes_rxed);
		
		if (sptr_rxed_packet == NULL)
			{
			ppp_return_buffer_to_device_driver ((USHORT) (real_port_number + ppp.number_of_lan_ports), uptr_compressed_ppp_packet);
			
			return (NULL);
			}
		}
	
	return (sptr_rxed_packet);
}
#endif
/****************************************************************************/
static enum TEST determine_packet_type (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed)
{
	PPP_NCP_CLASS *sptr_ncp;
	enum TEST return_code;

#ifdef DEBUG
	display_packet ((BYTE *) sptr_rxed_packet, *usptr_number_of_bytes_rxed);
#endif

	if ((sptr_rxed_packet->generic.header.protocol_type) != LCP_PROTOCOL &&
		(ppp.port[real_port_number].state != PPP_OPENED_STATE))
		{
		return (FAIL);
		}

#ifdef DEBUG
	print_out_packet_type (real_port_number,sptr_rxed_packet->generic.header.protocol_type);
#endif

	switch (sptr_rxed_packet->generic.header.protocol_type)
		{
#ifdef __MLPPP__
		case IP_PROTOCOL:
		case VAN_JACOBSON_COMPRESSED_PROTOCOL:
		case VAN_JACOBSON_UNCOMPRESSED_PROTOCOL:
		case IPX_PROTOCOL:
		case APPLETALK_PROTOCOL:
		case BRIDGING_PROTOCOL:
		case MULTILINK_PROTOCOL:
		case NETBIOS_PROTOCOL:
		case IPCP_PROTOCOL:
		case IPXCP_PROTOCOL:
		case ATCP_PROTOCOL:
		case NBFCP_PROTOCOL:
		case BCP_PROTOCOL:
			return (PASS);

#else	/* __MLPPP__ */
		case IP_PROTOCOL:
		case VAN_JACOBSON_COMPRESSED_PROTOCOL:
		case VAN_JACOBSON_UNCOMPRESSED_PROTOCOL:
			return_code = ip_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,usptr_number_of_bytes_rxed);

			return (return_code);
		case IPX_PROTOCOL:
			return_code = ipx_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,usptr_number_of_bytes_rxed);

			return (return_code);
		case APPLETALK_PROTOCOL:
			return_code = appletalk_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,
				usptr_number_of_bytes_rxed);

			return (return_code);
		case BRIDGING_PROTOCOL:
			return_code = bridge_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,
				usptr_number_of_bytes_rxed);

			return (return_code);
		case NETBIOS_PROTOCOL:
			return_code = netbios_packet_received (real_port_number,sptr_rxed_packet,sptr_return_rxed_packet,
				usptr_number_of_bytes_rxed);

			return (return_code);
		case IPCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,IP_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case IPXCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,IPX_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }
         
			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case ATCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,APPLETALK_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case NBFCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,NETBIOS_PROTOCOL_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
		case BCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,SPANNING_TREE_STACK);
         if (sptr_ncp == NULL)
         {
            return(FAIL);
         }

			ncp_packet_received (real_port_number,(UNION_NCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed,sptr_ncp);

			break;
#endif /* __MLPPP__ */

		case LCP_PROTOCOL:
			lcp_packet_received (real_port_number,(LCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed);

			break;
#if defined (CCP)
#ifdef __MLPPP__
/* Sudha from Chris 27 Jan 1999 */
		case CCP_PROTOCOL:
			if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
			{
				BYTE last_id_of_ccp_packet_sent;

				last_id_of_ccp_packet_sent = (*ppp.ccp.fptr_get_last_id_of_ccp_packet_sent_function) (real_port_number);

				if (check_id (real_port_number,sptr_rxed_packet->generic.code,sptr_rxed_packet->generic.id,
					last_id_of_ccp_packet_sent,"CCP") == FAIL)
				{
					return (FAIL);
				}
				(*ppp.ccp.fptr_ccp_packet_received_function) (real_port_number,(void *) sptr_rxed_packet,
					*usptr_number_of_bytes_rxed);
			}
			break;
/* Sudha from Chris 27 Jan 1999 */

		case LINK_CCP_PROTOCOL:
#else	/* __MLPPP__ */
		case CCP_PROTOCOL:
#endif /* __MLPPP__ */
			if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
				{
				(*ppp.ccp.fptr_ccp_packet_received_function) (real_port_number,(void *) sptr_rxed_packet,
					*usptr_number_of_bytes_rxed);
				}
			
			break;
#endif
		case PAP_PROTOCOL:
			pap_packet_received (real_port_number,(PAP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed);

			break;
		case CHAP_PROTOCOL:
			chap_packet_received (real_port_number,(CHAP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed);

			break;
		case LINK_QUALITY_PROTOCOL:
			link_quality_report_received (real_port_number,(LINK_QUALITY_REPORT *) sptr_rxed_packet,*usptr_number_of_bytes_rxed);

			break;

/*stupid fix */
		case CBCP_PROTOCOL :
			cbcp_packet_received (real_port_number,
			                     (CBCP_PACKET *) sptr_rxed_packet,
										*usptr_number_of_bytes_rxed) ;
			break;
		default:
			if (ppp.port[real_port_number].state == PPP_OPENED_STATE)
				{
				send_lcp_protocol_reject (real_port_number,(LCP_PACKET *) sptr_rxed_packet,*usptr_number_of_bytes_rxed);
				}

			return (FAIL);
		}

	return (FAIL);
}
/****************************************************************************/
static void print_out_packet_type (USHORT real_port_number,enum PPP_PROTOCOL_TYPE protocol_type)
{
	switch (protocol_type)
		{
		case IPX_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:IPX Protocol Packet Received: %04x\r\n",real_port_number);
			break;
		case IP_PROTOCOL:
		case VAN_JACOBSON_COMPRESSED_PROTOCOL:
		case VAN_JACOBSON_UNCOMPRESSED_PROTOCOL:
		case APPLETALK_PROTOCOL:
		case BRIDGING_PROTOCOL:
		case NETBIOS_PROTOCOL:
		case IPCP_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:IPCP Protocol Packet Received: %04x\r\n",real_port_number);
			break;
		case IPXCP_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:IPXCP Protocol Packet Received: %04x\r\n",real_port_number);
			break;
		case ATCP_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:ATCP Protocol Packet Received: %04x\r\n",real_port_number);
			break;
		case LCP_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:LCP Protocol Packet Received: %04x\r\n",real_port_number);
			break;
#if defined (CCP)
		case CCP_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:CCP Protocol Packet Received: %04x\r\n",real_port_number);
			break;
#endif
		case PAP_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:PAP Protocol Packet Received: %04x\r\n",real_port_number);
			break;
		case CHAP_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:CHAP Protocol Packet Received: %04x\r\n",real_port_number);
			break;
		case LINK_QUALITY_PROTOCOL:
			ppp_printf (PPP_DATA_PRINTF,"PPP:LINK_QUALITY_PROTOCOL Packet Received: %04x\r\n",real_port_number);
			break;
		default:
			ppp_printf (PPP_ALARM_PRINTF,"PPP:Bad Protocol Packet Received: %04x\r\n",real_port_number);
			break;
		}
}
/****************************************************************************/
enum TEST ip_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed)
{
	PPP_NCP_CLASS *sptr_ncp;
	enum VAN_JACOBSON_COMPRESSION_TYPE compression_type;

#ifdef DEBUG
	ppp_printf (PPP_DATA_PRINTF,"PPP:IP Protocol Packet Received: %04x\r\n",real_port_number);
#endif

	sptr_ncp = find_ppp_ncp (real_port_number,IP_PROTOCOL_STACK);
   if (sptr_ncp == NULL)
   {
      return(FAIL);
   }

	if (sptr_ncp->state != PPP_OPENED_STATE)
		{
		return (FAIL);
		}

#ifdef __LSL__
	*usptr_number_of_bytes_rxed = (USHORT) (*usptr_number_of_bytes_rxed + sizeof (UNION_MAC_HEADER) - sizeof (PPP_HEADER));
	*sptr_return_rxed_packet = (LCP_PACKET *) ((ULONG) sptr_rxed_packet - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));
#endif

	switch (sptr_rxed_packet->generic.header.protocol_type)
		{
		case IP_PROTOCOL:
			compression_type = VJ_IP_TYPE;
			break;
		case VAN_JACOBSON_COMPRESSED_PROTOCOL:
			compression_type = VJ_COMPRESSED_TCP_TYPE;
			break;
		case VAN_JACOBSON_UNCOMPRESSED_PROTOCOL:
			compression_type = VJ_UNCOMPRESSED_TCP_TYPE;
			break;
		default:
			return (FAIL);
		}

#ifdef __MLPPP__
	if (mlppp.port[real_port_number].vjc.fptr_uncompress_tcp_header != NULL)
		{
		(*mlppp.port[real_port_number].vjc.fptr_uncompress_tcp_header) (real_port_number,sptr_return_rxed_packet,
			usptr_number_of_bytes_rxed,(BYTE) compression_type);
		}
#else	/*__MLPPP__*/
	if (ppp.port[real_port_number].vjc.fptr_uncompress_tcp_header != NULL)
		{
		(*ppp.port[real_port_number].vjc.fptr_uncompress_tcp_header) (real_port_number,sptr_return_rxed_packet,
			usptr_number_of_bytes_rxed,(BYTE) compression_type);
		}
#endif	/*__MLPPP__*/

#ifdef __LSL__
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->length_or_type.type = SNAP_IP_PACKET;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->destination_address._ushort = 0xffff;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->destination_address._ulong = 0xffffffffL;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->source_address._ushort = 0x0000;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->source_address._ulong = 0x00000000L;
#endif

	++sptr_ncp->statistics.number_of_rx_packets;

	sptr_ncp->statistics.number_of_rx_bytes += *usptr_number_of_bytes_rxed;

	return (PASS);
}
/****************************************************************************/
enum TEST ipx_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed)
{
	PPP_NCP_CLASS *sptr_ncp;
	enum TEST return_code;

#ifdef DEBUG
	ppp_printf (PPP_DATA_PRINTF,"PPP:i.p.r.:IPX Protocol Packet Received: %04x\r\n",real_port_number);
#endif

	sptr_ncp = find_ppp_ncp (real_port_number,IPX_PROTOCOL_STACK);
   if (sptr_ncp == NULL)
   {
      return(FAIL);
   }
   
	if (sptr_ncp->state != PPP_OPENED_STATE)
		{
		return (FAIL);
		}

#ifdef __LSL__
	*usptr_number_of_bytes_rxed = (USHORT) (*usptr_number_of_bytes_rxed + sizeof (UNION_MAC_HEADER) - sizeof (PPP_HEADER));
	*sptr_return_rxed_packet = (LCP_PACKET *) ((ULONG) sptr_rxed_packet - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));
#endif

#ifdef __MLPPP__
	if (is_option_present (&mlppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX].option_lists.rx_accepted,
		(BYTE) IPX_COMPRESSION_PROTOCOL) == TRUE)
		{
		if (mlppp.port[real_port_number].cipx.fptr_uncompress_ipx_header != NULL)
			{
			return_code = (*mlppp.port[real_port_number].cipx.fptr_uncompress_ipx_header) (real_port_number,sptr_return_rxed_packet,
				usptr_number_of_bytes_rxed);
#else	/*__MLPPP__*/
	if (is_option_present (&ppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX].option_lists.rx_accepted,
		(BYTE) IPX_COMPRESSION_PROTOCOL) == TRUE)
		{
		if (ppp.port[real_port_number].cipx.fptr_uncompress_ipx_header != NULL)
			{
			return_code = (*ppp.port[real_port_number].cipx.fptr_uncompress_ipx_header) (real_port_number,sptr_return_rxed_packet,
				usptr_number_of_bytes_rxed);
#endif	/*__MLPPP__*/

			if (return_code == FAIL)
				{
				return (FAIL);
				}
			}
		}

#ifdef __LSL__
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->length_or_type.type = SNAP_IPX_PROTOCOL_ID;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->destination_address._ushort = 0xffff;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->destination_address._ulong = 0xffffffffL;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->source_address._ushort = 0x0000;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->source_address._ulong = 0x00000000L;
#endif

	++sptr_ncp->statistics.number_of_rx_packets;

	sptr_ncp->statistics.number_of_rx_bytes += *usptr_number_of_bytes_rxed;

	return (PASS);
}
/****************************************************************************/
enum TEST appletalk_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed)
{
	PPP_NCP_CLASS *sptr_ncp;

	sptr_ncp = find_ppp_ncp (real_port_number,APPLETALK_PROTOCOL_STACK);
   if (sptr_ncp == NULL)
   {
      return(FAIL);
   }

	if (sptr_ncp->state != PPP_OPENED_STATE)
		{
		return (FAIL);
		}

#ifdef DEBUG
	ppp_printf (PPP_DATA_PRINTF,"PPP:APPLETALK Protocol Packet Received: %04x\r\n",real_port_number);
#endif

#ifdef __LSL__
	*usptr_number_of_bytes_rxed = (USHORT) (*usptr_number_of_bytes_rxed + sizeof (UNION_MAC_HEADER) - sizeof (PPP_HEADER));
	*sptr_return_rxed_packet = (LCP_PACKET *) ((ULONG) sptr_rxed_packet - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));

	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->length_or_type.type = SNAP_APPLETALK_PROTOCOL_ID;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->destination_address._ushort = 0xffff;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->destination_address._ulong = 0xffffffffL;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->source_address._ushort = 0x0000;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->source_address._ulong = 0x00000000L;
#endif

	++sptr_ncp->statistics.number_of_rx_packets;

	sptr_ncp->statistics.number_of_rx_bytes += *usptr_number_of_bytes_rxed;

	return (PASS);
}
/****************************************************************************/
enum TEST bridge_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed)
{
	PPP_NCP_CLASS *sptr_ncp;

	sptr_ncp = find_ppp_ncp (real_port_number,SPANNING_TREE_STACK);
   if (sptr_ncp == NULL)
   {
      return(FAIL);
   }

	if (sptr_ncp->state != PPP_OPENED_STATE)
		{
		return (FAIL);
		}

#ifdef DEBUG
	ppp_printf (PPP_DATA_PRINTF,"PPP:BRIDGE Protocol Packet Received: %04x\r\n",real_port_number);
#endif

	*sptr_return_rxed_packet = extract_bcp_lan_id (sptr_rxed_packet,usptr_number_of_bytes_rxed);

	++sptr_ncp->statistics.number_of_rx_packets;

	sptr_ncp->statistics.number_of_rx_bytes += *usptr_number_of_bytes_rxed;

	return (PASS);
}
/****************************************************************************/
enum TEST netbios_packet_received (USHORT real_port_number,UNION_PPP_PACKET *sptr_rxed_packet,
	void **sptr_return_rxed_packet,USHORT *usptr_number_of_bytes_rxed)
{
	PPP_NCP_CLASS *sptr_ncp;

	sptr_ncp = find_ppp_ncp (real_port_number,NETBIOS_PROTOCOL_STACK);
   if (sptr_ncp == NULL)
   {
      return(FAIL);
   }

	if (sptr_ncp->state != PPP_OPENED_STATE)
		{
		return (FAIL);
		}

#ifdef DEBUG
	ppp_printf (PPP_DATA_PRINTF,"PPP:APPLETALK Protocol Packet Received: %04x\r\n",real_port_number);
#endif

#ifdef __LSL__
	*usptr_number_of_bytes_rxed = (USHORT) (*usptr_number_of_bytes_rxed + sizeof (UNION_MAC_HEADER) - sizeof (PPP_HEADER));
	*sptr_return_rxed_packet = (LCP_PACKET *) ((ULONG) sptr_rxed_packet - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));

	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->length_or_type.type = swap (*usptr_number_of_bytes_rxed);
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->destination_address._ushort = 0xffff;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->destination_address._ulong = 0xffffffffL;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->source_address._ushort = 0x0000;
	((ETHERNET_MAC_HEADER *) *sptr_return_rxed_packet)->source_address._ulong = 0x00000000L;
#endif

	++sptr_ncp->statistics.number_of_rx_packets;

	sptr_ncp->statistics.number_of_rx_bytes += *usptr_number_of_bytes_rxed;

	return (PASS);
}

void 	my_debug_function ()
{
}

/****************************************************************************/
static enum TEST verify_packet (USHORT real_port_number,UNION_PPP_PACKET *sptr_rx_packet,
	USHORT *usptr_number_of_bytes_rxed)
{																															/* check for padding */
	BYTE	expected_id;

	if (sptr_rx_packet->generic.header.hdlc_address != HDLC_ADDRESS)
		{
			my_debug_function ();
		ppp_printf (PPP_ALARM_PRINTF,"PPP: HDLC Address Error: %04x\r\n",real_port_number);

		++ppp.port[real_port_number].lcp_mibs.pppLinkStatusBadAddresses;

		return (FAIL);
		}

	if (sptr_rx_packet->generic.header.hdlc_control != UNNUMBERED_INFORMATION)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: HDLC Control Error: %04x\r\n",real_port_number);

		++ppp.port[real_port_number].lcp_mibs.pppLinkStatusBadControls;

		return (FAIL);
		}

	if ((swap (sptr_rx_packet->generic.header.protocol_type) & 0xff00) != 0x0000)
		{
		if (*usptr_number_of_bytes_rxed > (swap (sptr_rx_packet->lcp.lcp_header.length) + sizeof (PPP_HEADER))) 
			{																													/* ignore padding bytes */
			*usptr_number_of_bytes_rxed = (USHORT) (swap (sptr_rx_packet->lcp.lcp_header.length) + sizeof (PPP_HEADER));  
			}
		}

	if ((*usptr_number_of_bytes_rxed - sizeof (PPP_HEADER)) > ppp.port[real_port_number].lcp_mibs.pppLinkStatusLocalMRU)
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP: Length Too Large Error: %04x\r\n",real_port_number);

		++ppp.port[real_port_number].lcp_mibs.pppLinkStatusPacketTooLongs;

		return (FAIL);
		}

#ifndef __MLPPP__
	switch (sptr_rx_packet->generic.header.protocol_type)
		{
		case IP_PROTOCOL:
		case IPX_PROTOCOL:
		case APPLETALK_PROTOCOL:
		case BRIDGING_PROTOCOL:
		case NETBIOS_PROTOCOL:
			break;
		case VAN_JACOBSON_COMPRESSED_PROTOCOL:
			break;
		case VAN_JACOBSON_UNCOMPRESSED_PROTOCOL:
			break;
		case IPCP_PROTOCOL:
		
/* Kamalnath 18/08/1996 */

			if (ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].enabled) 
			{
				if (is_dhcp_client_enabled (real_port_number + ppp.number_of_lan_ports))
				{
					if (ppp.port[real_port_number].dhcp_status != DHCP_STATUS_IP_ADDRESS_OBTAINED)
					{
						printf ("IP ADDRESS not obtained, silently dropping IPCP packet\n") ;
						return (FAIL) ;
					}
				}
			}
			else
			{
				printf ("IP disabled for port %d\n", real_port_number + ppp.number_of_lan_ports) ;
			}
			
/* Kamalnath 18/08/1996 */

		case IPXCP_PROTOCOL:
		case ATCP_PROTOCOL:
		case NBFCP_PROTOCOL:
		case BCP_PROTOCOL:
			if (verify_ncp (real_port_number,sptr_rx_packet) == FAIL)
				{
				return (FAIL);
				}

			break;
		case LCP_PROTOCOL:
			if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,
				ppp.port[real_port_number].last_id_of_lcp_packet_sent,"LCP") == FAIL)
				{
				return (FAIL);
				}

			break;
#if defined (CCP)
		case CCP_PROTOCOL :
			if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
				{
				BYTE last_id_of_ccp_packet_sent;

				last_id_of_ccp_packet_sent = (*ppp.ccp.fptr_get_last_id_of_ccp_packet_sent_function) (real_port_number);

				if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,
					last_id_of_ccp_packet_sent,"CCP") == FAIL)
					{
					return (FAIL);
					}
				}
			break;
#endif

		case PAP_PROTOCOL:

			if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,
				ppp.port[real_port_number].last_id_of_pap_packet_sent,"PAP") == FAIL)
				{
				return (FAIL);
				}

			break;
		case CHAP_PROTOCOL:
			if (sptr_rx_packet->generic.code == CHAP_RESPONSE)
				expected_id = ppp.port[real_port_number].last_id_of_chap_challenge_packet_sent;
			else
				expected_id = ppp.port[real_port_number].last_id_of_chap_response_packet_sent;

			if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,
				expected_id,"CHAP") == FAIL)
				{
				return (FAIL);
				}

			break;

/* sudhir  stupid fix */
		case CBCP_PROTOCOL :
			break ;

		case LINK_QUALITY_PROTOCOL:
			break;


		default:
			if (sptr_rx_packet->generic.header.protocol_type & NCP_MASK)
				{
				send_lcp_protocol_reject (real_port_number,(LCP_PACKET *) sptr_rx_packet,*usptr_number_of_bytes_rxed);
				}
			return (FAIL);
		}
#endif

	return (PASS);
}
/****************************************************************************/
enum TEST verify_ncp (USHORT real_port_number,UNION_PPP_PACKET *sptr_rx_packet)
{
	PPP_NCP_CLASS *sptr_ncp;

	switch (sptr_rx_packet->generic.header.protocol_type)
		{
		case IPCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,IP_PROTOCOL_STACK);

			if (sptr_ncp != NULL)
				{
				if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,sptr_ncp->last_request_id,
					"IPCP") == FAIL)
					{
					return (FAIL);
					}
				}

			break;
		case IPXCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,IPX_PROTOCOL_STACK);

			if (sptr_ncp != NULL)
				{
				if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,sptr_ncp->last_request_id,
					"IPXCP") == FAIL)
					{
					return (FAIL);
					}
				}

			break;
		case ATCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,APPLETALK_PROTOCOL_STACK);

			if (sptr_ncp != NULL)
				{
				if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,sptr_ncp->last_request_id,
					"ATCP") == FAIL)
					{
					return (FAIL);
					}
				}

			break;
		case NBFCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,NETBIOS_PROTOCOL_STACK);

			if (sptr_ncp != NULL)
				{
				if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,sptr_ncp->last_request_id,
					"NBFCP") == FAIL)
					{
					return (FAIL);
					}
				}

			break;
		case BCP_PROTOCOL:
			sptr_ncp = find_ppp_ncp (real_port_number,SPANNING_TREE_STACK);

			if (sptr_ncp != NULL)
				{
				if (check_id (real_port_number,sptr_rx_packet->generic.code,sptr_rx_packet->generic.id,sptr_ncp->last_request_id,
					"BCP") == FAIL)
					{
					return (FAIL);
					}
				}

			break;
		}

	return (PASS);
}
/****************************************************************************/
enum TEST check_id (USHORT real_port_number,enum PPP_CONTROL_CODE code,BYTE received_id,BYTE expected_id,
	char *cptr_ncp_name)
{
	switch (code)
		{
		case CONFIGURE_REQUEST:
		case TERMINATION_REQUEST:
		case CODE_REJECT:
		case PROTOCOL_REJECT:
		case PPP_ECHO_REQUEST:
		case DISCARD_REQUEST:
		case IDENTIFICATION:
		case TIME_REMAINING:
#if defined (CCP)
		case RESET_REQUEST:
		case RESET_ACK:
#endif
			break;
		case CONFIGURE_ACK:
		case CONFIGURE_NAK:
		case CONFIGURE_REJECT:
		case TERMINATION_ACK:
		case PPP_ECHO_REPLY:
			if (received_id != expected_id)
				{
				ppp_printf (PPP_ALARM_PRINTF,
					"PPP:%s configuration ACK received with wrong id on port: %04x, expected %02x, received %02x\r\n",
					cptr_ncp_name,real_port_number,expected_id,received_id);

				return (FAIL);
				}

			break;
		default:
			return (FAIL);
		}

	return (PASS);
}

