#include	"defs.h"
/*	$Modname: ppptx.c$  $version: 1.37$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 12/10/93 ross Initial release.
1.1 01/05/94 ross Split the file into ppplcptx.c,pppncptx.c and ppptx.c
1.2 01/05/94 keyur Added support for version control.
1.3 01/20/94 keyur Fixed bug of not freeing the packet.
1.4 01/28/94 keyur Added one more bug of not freeing the packet.
1.5 03/09/94 keyur Added code to pass onto virtual port number to protocol stack.
1.6 03/09/94 keyur Some cosmetic changes were made.
1.7 03/23/94 keyur Added some functions for async PPP.
1.8 03/24/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John. Ch
1.9 03/26/94 keyur Added and tested Async Support and ATCP for Appletalk Support and split it.
1.10 03/26/94 keyur Changed ppp_packet_transmitted according to new driver registration.
1.11 04/12/94 keyur Added State Machine support for LCP according to RFC1548
1.12 04/13/94 keyur Added support for NCP state machine
1.13 04/19/94 keyur Added ordering of options for LCP and NCP, courtesy of John
1.14 04/19/94 keyur Cosmetic Changes
1.15 05/02/94 keyur
1.16 05/02/94 keyur took out memcheck header file.
1.17 06/15/94 keyur cosmetic changes.
1.18 07/18/94 ross general cleanup with options, added header compression, accm features.
1.19 08/15/94 ross partial compression implementation.
1.20 08/24/94 ross adding new ncps.
1.21 08/24/94 ross cleanup for release
1.22 08/30/94 ross
1.23 08/30/94 ross added cipx conditional in the compress routine.
1.24 09/06/94 ross check for protocol type in compress routine.
1.25 09/06/94 ross bug in compression callback.
1.26 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP and Netbios.
1.27 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.28 11/04/94 ross Testing against net manage ppp.	VJC testing.
1.29 12/13/94 ross connected to NT RAS with Netbios
1.30 01/26/95 ross changes for rwutils
1.31 01/30/95 ross removing duplicate configuration options
1.32 02/27/95 ross bug with checking for compression options.
1.33 03/03/95 ross added up calls.
1.34 03/10/95 ross general fixes.  see change.doc
1.35 05/15/95 ross cipx fixes.
1.36 06/26/95 ross initial version of BCP
1.37 10/19/95 biao added Compression Control Protocol (CCP) support. Please refer to change.doc for details.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include "ppp.h"
#include <wanmgr.h> /* Kamalnath 21\03\1997 SLIP added this header file */
#include <softquot.h>
/****************************************************************************/
enum TEST build_ppp_header (USHORT real_port_number,ULONG protocol_stack_id,PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet);
USHORT compress_protocol_packet (USHORT real_port_number,PPP_PACKET_WITH_MAC_HEADER **sptr_tx_packet,
	USHORT number_of_bytes,USHORT *usptr_protocol_virtual_port_number,enum BOOLEAN *eptr_device_driver_buffer,
	void (**fptr_tx_completion) (USHORT port_number,void *vptr_buffer));
static void *copy_compressed_packet (void *vptr_packet,USHORT number_of_bytes);
static void ppp_compression_packet_transmitted (USHORT port_number,void *vptr_txed_packet);
#if defined (CCP)
	PPP_PACKET_WITH_MAC_HEADER *ccp_compress_ppp (USHORT real_port_number, USHORT protocol_virtual_port_number, 
		enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet, USHORT *usptr_number_of_bytes,
		void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer));
#endif
/****************************************************************************/
enum TEST send_ppp_packet (ULONG protocol_stack_id,USHORT real_port_number,USHORT protocol_virtual_port_number,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_crc,
	enum BOOLEAN device_driver_buffer,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	enum TEST header_ok;
	USHORT number_of_ppp_bytes;
	void *vptr_async_buffer;
/* Sachin 04/04/1997 */
	USHORT number_of_ppp_bytes_without_headers;
/* Sachin 04/04/1997 */

	real_port_number = (USHORT) (real_port_number - ppp.number_of_lan_ports);

/* Kamalnath 17\03\1997 SLIP */
	if (ppp.port[real_port_number].slip_on == TRUE)
	{
		void *vptr_slip_buffer;
		
		if (get_wan_port_owner(real_port_number) != OWNED_BY_SLIP)
			return (FAIL);

		number_of_bytes = send_slip_packet (real_port_number, (void**)&sptr_tx_packet,number_of_bytes,
				protocol_virtual_port_number,device_driver_buffer,fptr_tx_completion,&vptr_slip_buffer);
		
		if (number_of_bytes == 0x0000)
		{
			return (FAIL);
		}
		
		protocol_virtual_port_number = real_port_number;
		fptr_tx_completion = slip_packet_transmitted;
		device_driver_buffer = FALSE;
#if 0	/* KVSP */
      vptr_slip_buffer = sptr_tx_packet ;
#endif

		if ((*ppp.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,protocol_virtual_port_number,
			sptr_tx_packet,number_of_bytes,do_not_calculate_crc,device_driver_buffer,fptr_tx_completion,
			vptr_slip_buffer) == PASS)
		{
#if 0	/* KVSP */
#endif
			return (PASS);
		}
		else
		{
			return (FAIL);
		}
	}
/* Kamalnath 17\03\1997 SLIP */

#ifdef __DOD__

	if (ppp.port[real_port_number].enabled == FALSE )
	{
ret_buf:
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion);
		return (FAIL);
	}
	else if (ppp.port[real_port_number].state != PPP_OPENED_STATE)
	{
/* sudhir 3/3/98 */
		if ((ppp.port[real_port_number].connect_state == LINK_DOWN_BY_DEMAND) 
			&& (ppp.port[real_port_number].callback_on == FALSE))
/* sudhir 3/3/98 */

		{
#ifdef DOD_DEBUG
		printf("PPP1:Reactivating port %04x\r\n", real_port_number);
#endif
			ppp_link_active(real_port_number);
		}
			
		goto ret_buf;
	}
			
#else /* __DOD__ */
	if (ppp.port[real_port_number].enabled == FALSE || ppp.port[real_port_number].state != PPP_OPENED_STATE)
		{
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion);

		return (FAIL);
		}
#endif /* __DOD__ */

#ifdef __MLPPP__
	if (protocol_stack_id == mlppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].protocol_stack_id)
#else	/*__MLPPP__*/
	if (protocol_stack_id == ppp.port[real_port_number].ncp[PPP_BRIDGING_NCP_STACK_INDEX].protocol_stack_id)
#endif	/*__MLPPP__*/
		{
		sptr_tx_packet = add_bcp_lan_id (real_port_number,protocol_virtual_port_number,sptr_tx_packet,&number_of_bytes,
			do_not_calculate_crc,fptr_tx_completion);

		if (sptr_tx_packet == NULL)
			{
			return (FAIL);
			}

		if (fptr_tx_completion != NULL)
			{
			fptr_tx_completion = ppp_free_a_bridge_send_packet;
			}
		}

	number_of_ppp_bytes = (USHORT) (number_of_bytes - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));

/* Sachin 04/04/1997 */
	number_of_ppp_bytes_without_headers = (USHORT) (number_of_bytes - sizeof (UNION_MAC_HEADER));
/* Sachin 04/04/1997 */

	header_ok = build_ppp_header (real_port_number,protocol_stack_id,sptr_tx_packet);

/* Sachin 04/04/1997 */
	/* if ((header_ok == FAIL) || (number_of_ppp_bytes > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU)) */
	if ((header_ok == FAIL) || (number_of_ppp_bytes_without_headers > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU))
/* Sachin 04/04/1997 */
		{
		return_buffer (real_port_number,protocol_virtual_port_number,device_driver_buffer,sptr_tx_packet,fptr_tx_completion);
		return (FAIL);
		}

	number_of_bytes = compress_protocol_packet (real_port_number,&sptr_tx_packet,number_of_bytes,
		&protocol_virtual_port_number,&device_driver_buffer,&fptr_tx_completion);

	number_of_bytes = (USHORT) (number_of_bytes - sizeof (UNION_MAC_HEADER) + sizeof (PPP_HEADER));

#if defined (CCP)
	if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
		{
		sptr_tx_packet = ccp_compress_ppp (real_port_number, protocol_virtual_port_number, &device_driver_buffer, sptr_tx_packet, 
			&number_of_bytes,	&fptr_tx_completion);

		if (sptr_tx_packet == NULL)
			{
			return (FAIL);
			}
		}
#endif

#ifdef SOFTWARE_QUOTING
	if (ppp.port[real_port_number].async.enabled == TRUE)
		{
		number_of_bytes = async_protocol_packet_tx (real_port_number,&sptr_tx_packet,number_of_bytes,
			protocol_virtual_port_number,device_driver_buffer,fptr_tx_completion,&vptr_async_buffer);

		if (number_of_bytes == 0x0000)
			{
			return (FAIL);
			}

		protocol_virtual_port_number = real_port_number;
		fptr_tx_completion = ppp_async_packet_transmitted;
		device_driver_buffer = FALSE;
		}
#if 1	/* MUX */
	else
		{
		vptr_async_buffer = sptr_tx_packet;
		}
#endif
#endif

	if (number_of_bytes == 0x0000)
		{
		return (FAIL);
		}

#if 1	/* MUX */
	vptr_async_buffer = sptr_tx_packet;
#endif

#ifdef DEBUG
	ppp_printf (PPP_DATA_PRINTF,"PPP:Protocol Packet sent out port %04x\r\n",real_port_number);

	display_packet ((BYTE *) sptr_tx_packet, number_of_bytes);
#endif

	if ((*ppp.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,protocol_virtual_port_number,
		&sptr_tx_packet->header,number_of_bytes,do_not_calculate_crc,device_driver_buffer,fptr_tx_completion,
		vptr_async_buffer) == PASS)
		{
#ifdef DEBUG
		++ppp.port[real_port_number].statistics.number_of_tx_packets;

		ppp.port[real_port_number].statistics.number_of_tx_bytes += (ULONG) number_of_bytes;
#endif
	
#ifdef __DOD__
		reset_ppp_idle_timer (real_port_number);
#endif /* __DOD__ */

		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}
#if defined (CCP)
/****************************************************************************/
PPP_PACKET_WITH_MAC_HEADER *ccp_compress_ppp (USHORT real_port_number, USHORT protocol_virtual_port_number, 
	enum BOOLEAN *eptr_device_driver_buffer, PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet, USHORT *usptr_number_of_bytes,
	void (**ptr_fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	enum PPP_STATE ccp_state;
	
	ccp_state = (*ppp.ccp.fptr_get_ccp_state_function) (real_port_number);

	if (ccp_state == PPP_OPENED_STATE )
		{ 
		if ((*ppp.ccp.fptr_get_sender_compression_database_initialization_status_function) (real_port_number) == TRUE)
			{
			return_buffer (real_port_number,protocol_virtual_port_number,*eptr_device_driver_buffer,sptr_tx_packet,*ptr_fptr_tx_completion);

			return (NULL);
			}
 		
 		sptr_tx_packet = (*((*ppp.ccp.fptr_get_sender_compression_function_function) (real_port_number)))
 			(real_port_number, protocol_virtual_port_number, eptr_device_driver_buffer, sptr_tx_packet, 
 			usptr_number_of_bytes, ptr_fptr_tx_completion);
		
		if (sptr_tx_packet == NULL)
			{
			return_buffer (real_port_number,protocol_virtual_port_number,*eptr_device_driver_buffer,sptr_tx_packet,*ptr_fptr_tx_completion);

			return (NULL);
			}
		}
	
/* Sachin 04/04/1997 */	
	/* if (*usptr_number_of_bytes > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU) */
	if ((*usptr_number_of_bytes - sizeof (PPP_HEADER)) > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU)
/* Sachin 04/04/1997 */	
		{
		return_buffer (real_port_number,protocol_virtual_port_number,*eptr_device_driver_buffer,sptr_tx_packet,*ptr_fptr_tx_completion);

		return (NULL);
		}

	return (sptr_tx_packet);
}
#endif
/****************************************************************************/
void return_buffer (USHORT real_port_number,USHORT protocol_virtual_port_number,enum BOOLEAN device_driver_buffer,
	PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,void (*fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	if (device_driver_buffer == TRUE)
		{
		packet_forward_device_driver_free (real_port_number,ppp.port[real_port_number].device_driver_id,
			(void *) ((ULONG) sptr_tx_packet));
		}

	if (fptr_tx_completion != NULL)
		{
		(fptr_tx_completion) (protocol_virtual_port_number,sptr_tx_packet);
		}
}
/****************************************************************************/
enum TEST send_native_ppp_packet (USHORT real_port_number,PPP_PACKET *sptr_tx_packet,USHORT number_of_bytes,
	void (*fptr_tx_completion) (USHORT protocol_virtual_port_number,void *sptr_buffer))
{
	void *vptr_async_buffer;

#ifdef __DOD__

	/* Reset idle timer for those packets which are sent before PPP goes into
	OPENED_STATE and for NCP packets after PPP is in OPENED_STATE. 
	Basically eliminating periodic Echo Req/Rpy, Authentication, LQR pkts... */

	if (	(ppp.port[real_port_number].state != PPP_OPENED_STATE) ||
			(	(ppp.port[real_port_number].state == PPP_OPENED_STATE) && 
		  		(sptr_tx_packet->header.protocol_type < BIG_ENDIAN_CONSTANT(0xC000))	&&
				(sptr_tx_packet->header.protocol_type >= BIG_ENDIAN_CONSTANT(0x8000))
			)
		)
	{
		reset_ppp_idle_timer (real_port_number);
	}
				
#endif /* __DOD__ */

	sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
	sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

	if (ppp.port[real_port_number].enabled == FALSE ||
		(number_of_bytes > ppp.port[real_port_number].lcp_mibs.pppLinkStatusRemoteMRU))
		{
		ppp_printf (PPP_ALARM_PRINTF,"PPP:LCP Port Disabled or Packet too Large %04x\r\n",real_port_number);

		if (fptr_tx_completion != NULL)
			{
			sptr_tx_packet = (PPP_PACKET *) ((ULONG) sptr_tx_packet - sizeof (MAC_HEADER) + sizeof (PPP_HEADER)); 

			(fptr_tx_completion) (real_port_number,sptr_tx_packet);
			}

		return (FAIL);
		}

	if (ppp.port[real_port_number].async.enabled == TRUE)
		{
		number_of_bytes = async_native_packet_tx (real_port_number,(PPP_PACKET **)&sptr_tx_packet,number_of_bytes,
			fptr_tx_completion,&vptr_async_buffer);

		if (number_of_bytes == 0x0000)
			{
			return (FAIL);
			}

		fptr_tx_completion = ppp_async_packet_transmitted;
		}
#if 1	/* MUX */
	else
		{
		vptr_async_buffer = (void *) ((ULONG) sptr_tx_packet - sizeof (MAC_HEADER) + sizeof (PPP_HEADER)); 
		}
#endif

#ifdef DEBUG
	ppp_printf (PPP_DATA_PRINTF,"PPP:LCP Packet sent out port %04x\r\n",real_port_number);
	display_packet ((BYTE *) sptr_tx_packet, number_of_bytes);
#endif

	if ((*ppp.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,real_port_number,sptr_tx_packet,
		number_of_bytes,FALSE,FALSE,fptr_tx_completion,vptr_async_buffer) ==	PASS)
		{
		++ppp.port[real_port_number].statistics.number_of_tx_packets; 
		++ppp.port[real_port_number].link_quality_counters.ifOutUniPackets;

		ppp.port[real_port_number].statistics.number_of_tx_bytes += (ULONG) number_of_bytes;
		ppp.port[real_port_number].link_quality_counters.ifOutOctets += number_of_bytes;
		
		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}
/****************************************************************************/
enum TEST build_ppp_header (USHORT real_port_number,ULONG protocol_stack_id,PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet)
{
	USHORT protocol_stack_index;
	PPP_NCP_CLASS *sptr_ncp;

	sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
	sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;

	for (protocol_stack_index = 0x0000; protocol_stack_index < NUMBER_OF_NCP_STACKS; ++protocol_stack_index)
	{
#ifdef __MLPPP__
		sptr_ncp = &mlppp.port[real_port_number].ncp[protocol_stack_index];
#else	/*__MLPPP__*/
		sptr_ncp = &ppp.port[real_port_number].ncp[protocol_stack_index];
#endif	/*__MLPPP__*/

		if (protocol_stack_id == sptr_ncp->protocol_stack_id)
		{
			if (sptr_ncp->state == PPP_OPENED_STATE)
			{
				sptr_tx_packet->header.protocol_type =	(USHORT_ENUM (PPP_PROTOCOL_TYPE)) (sptr_ncp->ppp_protocol_stack_type);

				return (PASS);
			}

			break;
		}
	}

	ppp_printf (PPP_ALARM_PRINTF,"PPP: Protocol Packet To Transmit Dumped, Connection Down on Port %04x\r\n",real_port_number);

	return (FAIL);
}
/****************************************************************************/
void ppp_packet_transmitted (USHORT real_port_number)
{
	real_port_number = (USHORT) (real_port_number - ppp.number_of_lan_ports);

/* THIS CHECK IS ADDED NOW */
	if(ppp.port[real_port_number].serial_driver.fptr_tx_complete != NULL)
	(*ppp.port[real_port_number].serial_driver.fptr_tx_complete) (real_port_number);
}
/****************************************************************************/
USHORT compress_protocol_packet (USHORT real_port_number,PPP_PACKET_WITH_MAC_HEADER **sptr_tx_packet,
	USHORT number_of_bytes,USHORT *usptr_protocol_virtual_port_number,enum BOOLEAN *eptr_device_driver_buffer,
	void (**fptr_tx_completion) (USHORT port_number,void *vptr_buffer))
{
	PPP_PACKET_WITH_MAC_HEADER *sptr_original_tx_packet;
	enum VAN_JACOBSON_COMPRESSION_TYPE vj_return_code;
	enum BOOLEAN compression_option_is_present;
	/* Srikar, Mar 23, 1997. Added the following to check if compression is enabled and operational. */
	OPTION_LIST_ENTRY *sptr_option_entry;

	sptr_original_tx_packet = *sptr_tx_packet;

	if (((*sptr_tx_packet)->header.protocol_type) == IP_PROTOCOL)
		{
		/* Srikar, Mar 23, 1997. Modified the following to check if compression is enabled and operational. */
#ifdef __MLPPP__
		sptr_option_entry = find_matching_option(&mlppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted, (BYTE) IP_COMPRESSION_OPTION_TYPE);
#else
		sptr_option_entry = find_matching_option(&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted, (BYTE) IP_COMPRESSION_OPTION_TYPE);
#endif
		if (sptr_option_entry != NULL && sptr_option_entry->admin_status == SNMP_PPP_OPTION_ADMIN_ENABLED)
			{
				compression_option_is_present = TRUE;
			}
		else
			{
				compression_option_is_present = FALSE;
			}
/*
		compression_option_is_present = is_option_present (
			&ppp.port[real_port_number].ncp[PPP_IP_NCP_STACK_INDEX].option_lists.tx_accepted,(BYTE) IP_COMPRESSION_OPTION_TYPE);
*/

#ifdef __MLPPP__
		if ((mlppp.port[real_port_number].vjc.fptr_compress_tcp_header != NULL) && (compression_option_is_present == TRUE))
			{
			vj_return_code = (enum VAN_JACOBSON_COMPRESSION_TYPE) (*mlppp.port[real_port_number].vjc.fptr_compress_tcp_header)
				(real_port_number,(void **) sptr_tx_packet,&number_of_bytes);
#else	/*__MLPPP__*/
		if ((ppp.port[real_port_number].vjc.fptr_compress_tcp_header != NULL) && (compression_option_is_present == TRUE))
			{
			vj_return_code = (enum VAN_JACOBSON_COMPRESSION_TYPE) (*ppp.port[real_port_number].vjc.fptr_compress_tcp_header)
				(real_port_number,(void **) sptr_tx_packet,&number_of_bytes);
#endif	/*__MLPPP__*/

			switch (vj_return_code)
				{
				case VJ_IP_TYPE:
					(*sptr_tx_packet)->header.protocol_type = IP_PROTOCOL;
					break;
				case VJ_UNCOMPRESSED_TCP_TYPE:
					(*sptr_tx_packet)->header.protocol_type = VAN_JACOBSON_UNCOMPRESSED_PROTOCOL;
					break;
				case VJ_COMPRESSED_TCP_TYPE:
					(*sptr_tx_packet)->header.protocol_type = VAN_JACOBSON_COMPRESSED_PROTOCOL;
					break;
				case VJ_TYPE_ERROR:
					ppp_printf (PPP_ALARM_PRINTF,"PPP:VJ Error sent out port uncompressed %04x\r\n",real_port_number);
					return (0x0000);
				default:
					ppp_printf (PPP_ALARM_PRINTF,"PPP:VJ Packet sent out port uncompressed %04x\r\n",real_port_number);
					return (0x0000);
				}

			*sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) copy_compressed_packet (*sptr_tx_packet,number_of_bytes);

			(*sptr_tx_packet)->header.hdlc_address = HDLC_ADDRESS;
			(*sptr_tx_packet)->header.hdlc_control = UNNUMBERED_INFORMATION;

			if (*fptr_tx_completion != NULL)
				{
				(*fptr_tx_completion) (*usptr_protocol_virtual_port_number,sptr_original_tx_packet);
				}

			if (*eptr_device_driver_buffer == TRUE)
				{
				packet_forward_device_driver_free (real_port_number,ppp.port[real_port_number].device_driver_id,
					(void *) sptr_original_tx_packet);
				}

			if (*sptr_tx_packet == NULL)
				{
#ifdef DEBUG
 				ppp_printf (PPP_ALARM_PRINTF,"PPP:VJ Packet sent out port uncompressed %04x\r\n",real_port_number);
#endif

				return (0x0000);
				}

			*usptr_protocol_virtual_port_number = real_port_number;
			*fptr_tx_completion = ppp_compression_packet_transmitted;
			*eptr_device_driver_buffer = FALSE;
			}
		}
	else if (((*sptr_tx_packet)->header.protocol_type) == IPX_PROTOCOL)
		{
#ifdef __MLPPP__
		if (is_option_present (&mlppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX].option_lists.tx_accepted,
			(BYTE) IPX_COMPRESSION_PROTOCOL) == TRUE)
			{
			if (mlppp.port[real_port_number].cipx.fptr_compress_ipx_header != NULL)
				{
				(*mlppp.port[real_port_number].cipx.fptr_compress_ipx_header) (real_port_number,
					(void **) sptr_tx_packet,&number_of_bytes);
#else	/*__MLPPP__*/
		if (is_option_present (&ppp.port[real_port_number].ncp[PPP_IPX_NCP_STACK_INDEX].option_lists.tx_accepted,
			(BYTE) IPX_COMPRESSION_PROTOCOL) == TRUE)
			{
			if (ppp.port[real_port_number].cipx.fptr_compress_ipx_header != NULL)
				{
				(*ppp.port[real_port_number].cipx.fptr_compress_ipx_header) (real_port_number,
					(void **) sptr_tx_packet,&number_of_bytes);
#endif	/*__MLPPP__*/

				*sptr_tx_packet = (PPP_PACKET_WITH_MAC_HEADER *) copy_compressed_packet (*sptr_tx_packet,number_of_bytes);

				(*sptr_tx_packet)->header.hdlc_address = HDLC_ADDRESS;
				(*sptr_tx_packet)->header.hdlc_control = UNNUMBERED_INFORMATION;
				(*sptr_tx_packet)->header.protocol_type = IPX_PROTOCOL;

				if (*fptr_tx_completion != NULL)
					{
					(*fptr_tx_completion) (*usptr_protocol_virtual_port_number,sptr_original_tx_packet);
					}

				if (*eptr_device_driver_buffer == TRUE)
					{
					packet_forward_device_driver_free (real_port_number,ppp.port[real_port_number].device_driver_id,
						(void *) sptr_original_tx_packet);
					}

				if (*sptr_tx_packet == NULL)
					{
#ifdef DEBUG
 					ppp_printf (PPP_ALARM_PRINTF,"PPP:CIPX Packet sent out port uncompressed %04x\r\n",real_port_number);
#endif

					return (0x0000);
					}

				*usptr_protocol_virtual_port_number = real_port_number;
				*fptr_tx_completion = ppp_compression_packet_transmitted;
				*eptr_device_driver_buffer = FALSE;
				}
			}
		}

	return (number_of_bytes);
}
/****************************************************************************/
static void *copy_compressed_packet (void *vptr_packet,USHORT number_of_bytes)
{
	void *vptr_allocated_packet;

	vptr_allocated_packet = buffer_malloc (number_of_bytes);

#ifdef DEBUG
	ppp_printf (PPP_MEMORY_PRINTF,"PPP:VJ Packet Allocated %08lx\r\n",vptr_allocated_packet);
#endif

	if (vptr_allocated_packet != NULL)
		{
		memcpy (vptr_allocated_packet,vptr_packet,number_of_bytes);
		}

	return (vptr_allocated_packet);
}
/****************************************************************************/
static void ppp_compression_packet_transmitted (USHORT port_number,void *vptr_txed_packet)
{
	PARAMETER_NOT_USED (port_number);

	ppp_printf (PPP_MEMORY_PRINTF,"PPP:VJ Packet Freed %08lx\r\n",vptr_txed_packet);

	buffer_free (vptr_txed_packet);
}
/****************************************************************************/
enum TEST send_cipx_packet (USHORT real_port_number,PPP_PACKET_WITH_MAC_HEADER *sptr_tx_packet,USHORT number_of_bytes,
	void (*fptr_tx_completion) (USHORT protocol_virtual_port_number,void *sptr_buffer))
{

	void *vptr_async_buffer;
	enum BOOLEAN device_driver_buffer = FALSE;

	sptr_tx_packet->header.hdlc_address = HDLC_ADDRESS;
	sptr_tx_packet->header.hdlc_control = UNNUMBERED_INFORMATION;
 	sptr_tx_packet->header.protocol_type =	IPX_PROTOCOL;

	number_of_bytes = (USHORT) (sizeof (PPP_HEADER) + number_of_bytes);

#if defined (CCP)
	if ((ppp.ccp.enabled == TRUE) && ((*ppp.ccp.fptr_get_ccp_port_status_function) (real_port_number) == TRUE))
		{
		sptr_tx_packet = ccp_compress_ppp (real_port_number, real_port_number, &device_driver_buffer, sptr_tx_packet, 
			&number_of_bytes,	&fptr_tx_completion);

		if (sptr_tx_packet == NULL)
			{
			return (FAIL);
			}
		}
#endif

	if (ppp.port[real_port_number].async.enabled == TRUE)
		{
		number_of_bytes = async_protocol_packet_tx (real_port_number,&sptr_tx_packet,number_of_bytes,
			real_port_number,FALSE,fptr_tx_completion,&vptr_async_buffer);

		if (number_of_bytes == 0x0000)
			{
			return (FAIL);
			}

		fptr_tx_completion = ppp_async_packet_transmitted;
		}
#if 1	/* MUX */
	else
		{
		vptr_async_buffer = sptr_tx_packet;
		}
#endif

	if ((*ppp.port[real_port_number].serial_driver.fptr_tx_routine) (real_port_number,real_port_number,
		&sptr_tx_packet->header,number_of_bytes,FALSE,FALSE,fptr_tx_completion,vptr_async_buffer) == PASS)
		{
		++ppp.port[real_port_number].statistics.number_of_tx_packets;

		ppp.port[real_port_number].statistics.number_of_tx_bytes += (ULONG) number_of_bytes;

		return (PASS);					  
		}
	else
		{
	 	return (FAIL);
		}
}

