/* --------------------------------------------------------------------------
Module: SLIP (CSLIP)
Author: Kamalnath
Duration: Feb 1997 - April 1997
 --------------------------------------------------------------------------*/
#include "defs.h"
#include <stdarg.h>
#include <stdlib.h>
#include "ppp.h"

/* Slip Tx Buffer list */
void build_slip_buffer_list (USHORT real_port_number)
{
	SLIP_TX_BUFFER_LIST_ENTRY *sptr_slip_tx_buffer_list_entry;
	USHORT number_of_buffers;

	ppp.port[real_port_number].slip_port.actual_size_of_tx_buffer =  (USHORT) (SLIP_MAXIMUM_TX_ENCODED_PACKET_MULTIPLIER *
		(ppp.port[real_port_number].slip_port.maximum_transmit_bufsize) + sizeof(LINK) + SIZE_OF_SLIP_FRM_HEADER);

	slip_printf (SLIP_MEMORY_PRINTF,"SLIP: Malloc size for tx packet = %d for port %d\r\n",
		ppp.port[real_port_number].slip_port.actual_size_of_tx_buffer, real_port_number);
	
	for (number_of_buffers = 0x0000;	number_of_buffers < ppp.port[real_port_number].slip_port.number_of_buffers;
		++number_of_buffers)
	{
	 	sptr_slip_tx_buffer_list_entry = (SLIP_TX_BUFFER_LIST_ENTRY *)
			buffer_malloc (ppp.port[real_port_number].slip_port.actual_size_of_tx_buffer);

		if (sptr_slip_tx_buffer_list_entry == NULL)
		{
			if (number_of_buffers != 0x0000)
			{
				ppp.port[real_port_number].slip_port.number_of_buffers = (USHORT) number_of_buffers;
			}
			else
			{
				ppp.port[real_port_number].slip_port.number_of_buffers = 0x0000;
			}

			break;
		}

		add_entry_to_list ((LINK *) &ppp.port[real_port_number].slip_port.buffer_free_list,&sptr_slip_tx_buffer_list_entry->links);
	}
#if 0	/* KVSP */
	printf ("SLIP: Buffer start = 0x%x\r\n", &ppp.port[real_port_number].slip_port.buffer_free_list);
#endif
}
/****************************************************************************/
void free_slip_tx_buffer_list (USHORT real_port_number)
{
	SLIP_TX_BUFFER_LIST_ENTRY *sptr_slip_tx_buffer_list_entry;
	USHORT index_number_of_buffers;

	for (index_number_of_buffers = 0x0000;	index_number_of_buffers < ppp.port[real_port_number].slip_port.number_of_buffers;
		++index_number_of_buffers)
	{
		sptr_slip_tx_buffer_list_entry = get_entry_from_list ((LINK *) &ppp.port[real_port_number].slip_port.buffer_free_list);

		if (sptr_slip_tx_buffer_list_entry == NULL)
		{
			break;
		}

		buffer_free (sptr_slip_tx_buffer_list_entry);
	}
}
/* Slip Tx Buffer list */

void slip_printf (enum SLIP_PRINTF_GROUPS printf_group,const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format);

	if (ppp.slip_printing_enabled == FALSE)
	{
		va_end (argptr);

		return;
	}

	print_string = FALSE;

	switch (printf_group)
	{
		case SLIP_MEMORY_PRINTF:
			print_string = ppp.slip_memory_printing_enabled;
			break;
		case SLIP_ALARM_PRINTF:
			print_string = ppp.slip_alarm_printing_enabled;
			break;
		case SLIP_DATA_PRINTF:
			print_string = ppp.slip_data_printing_enabled;
			break;
		case SLIP_EVENT_PRINTF:
			print_string = ppp.slip_event_printing_enabled;
			break;
		default:
			break;
	}

	if (print_string == TRUE)
	{
		vprintf (cptr_format,argptr);
	}

	va_end (argptr);
}
