/*	$Modname: vnatstr.h$  $version: 1.8$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 04/19/94 keyur
1.1 04/19/94 keyur Added support for version control.
1.2 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.3 07/18/94 ross general cleanup with options, added header compression, accm features.
1.4 08/08/94 ross working on adding version 2
1.5 08/11/94 ross adding rfc1570 lcp support
1.6 08/24/94 ross adding new ncps.
1.7 12/13/94 ross connected to NT RAS with Netbios
1.8 10/19/95 biao replaced enum declarations with RouterWare ENUM declaration macros.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
typedef	struct	AT_OPTIONS_BOOLEAN
{
	BYTE_ENUM (BOOLEAN)	address;
	BYTE_ENUM (BOOLEAN)	routing_protocol;
	BYTE_ENUM (BOOLEAN)	suppress_broadcast;
	BYTE_ENUM (BOOLEAN)	compression;
	BYTE_ENUM (BOOLEAN)	server_information;
	BYTE_ENUM (BOOLEAN)	zone_information;
	BYTE_ENUM (BOOLEAN)	default_router_address;
} AT_OPTIONS_BOOLEAN;

typedef	struct	PPP_APPLETALK_CONFIGURATION
{
	AT_OPTIONS_BOOLEAN						enabled;

	USHORT										local_at_network_number;
	BYTE											local_at_node_id;

	USHORT_ENUM (AT_ROUTING_PROTOCOL)	routing_protocol;

	BYTE											ddp_type[128];

	BYTE_ENUM (AT_COMPRESSION_PROTOCOL)	at_compression_protocol;
	USHORT_ENUM (AT_SERVER_CLASS)			server_class;
	ULONG											server_implementation_id;

	BYTE											server_name[128];

	BYTE											zone[128];

	USHORT										default_at_network_number;
	BYTE											default_at_node_id;
} PPP_APPLETALK_CONFIGURATION;

typedef	struct	APPLETALK_ADDRESS_OPTION
{
	BYTE_ENUM (ATCP_OPTION_TYPE)	type;
	BYTE							length;
	BYTE							reserved;
	USHORT						local_at_network_number;
	BYTE							local_at_node_id;
} APPLETALK_ADDRESS_OPTION;

typedef	struct	ATCP_ROUTING_PROTOCOL_OPTION
{
	BYTE_ENUM (ATCP_OPTION_TYPE)			type;
	BYTE									length;
	USHORT_ENUM (AT_ROUTING_PROTOCOL)		routing_protocol;
}	ATCP_ROUTING_PROTOCOL_OPTION;

typedef	struct	SUPPRESS_BROADCAST_OPTION
{
	BYTE_ENUM (ATCP_OPTION_TYPE)	type;
	BYTE							length;
	BYTE							ddp_type[VARIABLE_NUMBER];
} SUPPRESS_BROADCAST_OPTION;

typedef	struct	AT_COMPRESSION_OPTION
{
	BYTE_ENUM (ATCP_OPTION_TYPE)			type;
	BYTE									length;
	BYTE_ENUM (AT_COMPRESSION_PROTOCOL)	at_compression_protocol;
} AT_COMPRESSION_OPTION;

typedef	struct	SERVER_INFORMATION_OPTION
{
	BYTE_ENUM (ATCP_OPTION_TYPE)	type;
	BYTE							length;
	USHORT_ENUM (AT_SERVER_CLASS)		server_class;
	ULONG							server_implementation_id;
	BYTE							server_name[VARIABLE_NUMBER];
} SERVER_INFORMATION_OPTION;

typedef	struct	ZONE_INFORMATION_OPTION
{
	BYTE_ENUM (ATCP_OPTION_TYPE)	type;
	BYTE							length;
	BYTE							zone[VARIABLE_NUMBER];
} ZONE_INFORMATION_OPTION;

typedef	struct	DEFAULT_ROUTER_ADDRESS_OPTION
{
	BYTE_ENUM (ATCP_OPTION_TYPE)	type;
	BYTE							length;
	BYTE							reserved;
	USHORT						default_at_network_number;
	BYTE							default_at_node_id;
} DEFAULT_ROUTER_ADDRESS_OPTION;

typedef	union	UNION_ATCP_OPTIONS
{
	APPLETALK_ADDRESS_OPTION		address;
	ATCP_ROUTING_PROTOCOL_OPTION	routing_protocol;
	SUPPRESS_BROADCAST_OPTION		suppress_broadcast;
	AT_COMPRESSION_OPTION			compression;
	SERVER_INFORMATION_OPTION		server_information;
	ZONE_INFORMATION_OPTION			zone_information;
	DEFAULT_ROUTER_ADDRESS_OPTION	default_router_address;
} UNION_ATCP_OPTIONS;

typedef	struct	ATCP_OPTIONS
{
	APPLETALK_ADDRESS_OPTION		address;
	ATCP_ROUTING_PROTOCOL_OPTION	routing_protocol;
	SUPPRESS_BROADCAST_OPTION		suppress_broadcast;
	AT_COMPRESSION_OPTION			compression;
	SERVER_INFORMATION_OPTION		server_information;
	ZONE_INFORMATION_OPTION			zone_information;
	DEFAULT_ROUTER_ADDRESS_OPTION	default_router_address;
} ATCP_OPTIONS;

typedef	struct	ATCP_CONFIGURE_REQUEST
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;

	UNION_ATCP_OPTIONS		union_atcp_options[VARIABLE_NUMBER];
} ATCP_CONFIGURE_REQUEST;

typedef	struct	ATCP_CONFIGURE_ACK
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)				code;
	BYTE							id;
	USHORT 						length;

	UNION_ATCP_OPTIONS		union_atcp_options[VARIABLE_NUMBER];
} ATCP_CONFIGURE_ACK;

typedef	struct	ATCP_CONFIGURE_NAK
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;

	UNION_ATCP_OPTIONS		union_atcp_options[VARIABLE_NUMBER];
} ATCP_CONFIGURE_NAK;

typedef	struct	ATCP_CONFIGURATION_REJECT
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;

	UNION_ATCP_OPTIONS		union_atcp_options[VARIABLE_NUMBER];
} ATCP_CONFIGURATION_REJECT;

typedef	struct	ATCP_TERMINATE_REQUEST
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
} ATCP_TERMINATE_REQUEST;

typedef	struct	ATCP_TERMINATE_ACK
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
} ATCP_TERMINATE_ACK;

typedef	struct	ATCP_CODE_REJECT_PACKET
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;
	BYTE  						rejected_packet[VARIABLE_NUMBER_OF_BYTES];

} ATCP_CODE_REJECT_PACKET;

typedef	struct	ATCP_PACKET
{
	PPP_HEADER					header;

	BYTE_ENUM (PPP_CONTROL_CODE)	code;
	BYTE							id;
	USHORT 						length;

	UNION_ATCP_OPTIONS 		options;
} ATCP_PACKET;

typedef	union	UNION_ATCP_PACKET
{
	ATCP_PACKET						generic;
	ATCP_CONFIGURE_REQUEST		configure_request;
	ATCP_CONFIGURE_ACK			configuration_ack;
	ATCP_CONFIGURE_NAK			configuration_nak;
	ATCP_CONFIGURATION_REJECT	configuration_reject;
	ATCP_TERMINATE_REQUEST		terminate_request;
	ATCP_TERMINATE_ACK			terminate_ack;
	ATCP_CODE_REJECT_PACKET		reject;
} UNION_ATCP_PACKET;

/* pppatrx.c */

void initialize_appletalk_ncp (USHORT real_port_number);
