/*	$Modname: vncpstat.h$  $version: 1.4$      $date: 05/15/95$   */
/*
* 	$lgb$
1.0 05/02/94 keyur initial check-in.
1.1 05/02/94 keyur added ncp generic files and changed CLOSE/OPEN to UP/DOWN.  Courtesy of John.
1.2 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.3 12/13/94 ross connected to NT RAS with Netbios
1.4 05/15/95 ross wrong state in the ncp state machine down and stopping.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
/*
      | State																		 State
      |    0         1         2         3         4         5		    6         7         8           9
Events| Initial   Starting  Closed    Stopped   Closing   Stopping Req-Sent  Ack-Rcvd  Ack-Sent    Opened
------+----------------------------------------------------------------------------------------------------
 Up   |    2     irc,scr/6     -         -         -         -		    -         -         -           -
 Down |    -         -         0       tls/1       0         1		    1         1         1         tld/1
 Open |  tls/1       1     irc,scr/6     3r        5r        5r	    6         7         8           9r
 Close|    0         0         2         2         4         4		irc,str/4 irc,str/4 irc,str/4 tld,irc,str/4
      |
  TO+ |    -         -         -         -       str/4     str/5	  scr/6     scr/6     scr/8         -
  TO- |    -         -         -         -       tlf/2     tlf/3	  tlf/3p    tlf/3p    tlf/3p        -
      |
 RCR+ |    -         -       sta/2 irc,scr,sca/8   4         5		  sca/8   sca,tlu/9   sca/8   tld,scr,sca/8
 RCR- |    -         -       sta/2 irc,scr,scn/6   4         5		  scn/6     scn/7     scn/6   tld,scr,scn/6
 RCA  |    -         -       sta/2     sta/3       4         5		  irc/7     scr/6x  irc,tlu/9   tld,scr/6x
 RCN  |    -         -       sta/2     sta/3       4         5		irc,scr/6   scr/6x  irc,scr/8   tld,scr/6x
      |
 RTR  |    -         -       sta/2     sta/3     sta/4     sta/5	  sta/6     sta/6     sta/6   tld,zrc,sta/5
 RTA  |    -         -         2         3       tlf/2     tlf/3	    6         6         8       tld,scr/6
      |
 RUC  |    -         -       scj/2     scj/3     scj/4     scj/5	  scj/6     scj/7     scj/8       scj/9
 RXJ+ |    -         -         2         3         4         5		    6         6         8           9
 RXJ- |    -         -       tlf/2     tlf/3     tlf/2     tlf/3	  tlf/3     tlf/3     tlf/3   tld,irc,str/5
      |
 RXR  |    -         -         2         3         4         5		    6         7         8         ser/9

*/

NCP_STATE_MACHINE_TABLE	ncp_state_machine_table[NUMBER_OF_PPP_STATES][NUMBER_OF_PPP_EVENTS] = 
{
/* ------------------------------------------------------------------------ */
/*										     INITIAL   0                     			 */		 
/* ------------------------------------------------------------------------ */
{
/* UP	 								  	*/		{set_ncp_state,PPP_CLOSED_STATE},
/* DOWN								  	*/		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* OPEN								  	*/		{ncp_this_layer_start,PPP_STARTING_STATE},
/* CLOSE								   */		{set_ncp_state,PPP_INITIAL_STATE},
/* 									   */																		
/* TIMEOUT_WITH_COUNTER_GREATER  */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* TIMEOUT_WITH_COUNTER_EXPIRED  */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* 									   */																		
/* RX									   */																		
/* 									   */																		
/* CONFIGURE_REQUEST_GOOD		   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_REQUEST_BAD		   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_REQUEST_BAD_OPTION  */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_ACK					   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_NAK					   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_REJECT				   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* TERMINATE_REQUEST				   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* TERMINATE_ACK					   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* UNKNOWN_CODE					   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* CODE_REJECT_PERMITTED		   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* PROTOCOL_REJECT				   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* CODE_REJECT_CATASTROPHIC	   */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  STARTING	 1										 */			 
/* ------------------------------------------------------------------------ */
{																												 
/* UP										*/		{ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,								 
(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/* DOWN									*/		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* OPEN								   */		{set_ncp_state,PPP_STARTING_STATE},
/* CLOSE								   */		{set_ncp_state,PPP_INITIAL_STATE},
/* 									   */																			
/* TIMEOUT_WITH_COUNTER_GREATER  */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* TIMEOUT_WITH_COUNTER_EXPIRED  */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* 									   */		
/* RX									   */		
/* 									   */		
/* CONFIGURE_REQUEST_GOOD		   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* CONFIGURE_REQUEST_BAD		   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* CONFIGURE_REQUEST_BAD_OPTION  */		{ncp_null_state,ILLEGAL_PPP_STATE},												 
/* CONFIGURE_ACK					   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* CONFIGURE_NAK					   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* CONFIGURE_REJECT				   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* TERMINATE_REQUEST				   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* TERMINATE_ACK					   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* UNKNOWN_CODE					   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* CODE_REJECT_PERMITTED		   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* PROTOCOL_REJECT				   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* CODE_REJECT_CATASTROPHIC	   */		{ncp_null_state,ILLEGAL_PPP_STATE},													 
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  CLOSED		 2										 */
/* ------------------------------------------------------------------------ */
{
/* UP										*/	  	{ncp_null_state,ILLEGAL_PPP_STATE},        
/* 										*/		
/* DOWN									*/	  	{set_ncp_state,PPP_INITIAL_STATE},
/* OPEN									*/	  	{ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))	  	send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/* 										*/
/* CLOSE									*/	  	{set_ncp_state,PPP_CLOSED_STATE},
/* 										*/																		 
/* TIMEOUT_WITH_COUNTER_GREATER	*/	  	{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{ncp_null_state,ILLEGAL_PPP_STATE},													 
/* 										*/																		 
/* RX										*/																		 
/* 										*/																		 
/* CONFIGURE_REQUEST_GOOD			*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_REQUEST_BAD			*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_REQUEST_BAD_OPTION	*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_ACK						*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_NAK						*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_CLOSED_STATE},
/* CONFIGURE_REJECT					*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_CLOSED_STATE},
/* TERMINATE_REQUEST					*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_CLOSED_STATE},
/* TERMINATE_ACK						*/	  	{set_ncp_state,PPP_CLOSED_STATE},
/* UNKNOWN_CODE						*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_code_reject,PPP_CLOSED_STATE},
/* CODE_REJECT_PERMITTED			*/	  	{set_ncp_state,PPP_CLOSED_STATE},
/* PROTOCOL_REJECT					*/	  	{set_ncp_state,PPP_CLOSED_STATE},
/* CODE_REJECT_CATASTROPHIC		*/	  	{ncp_this_layer_finished,PPP_CLOSED_STATE},
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  STOPPED	 3										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{ncp_null_state,ILLEGAL_PPP_STATE},
/*											*/	
/*	DOWN									*/	  	{ncp_this_layer_start,PPP_STARTING_STATE},
/* OPEN									*/	  	{set_ncp_state,PPP_STOPPED_STATE},
/*	CLOSE									*/	  	{set_ncp_state,PPP_CLOSED_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{ncp_null_state,ILLEGAL_PPP_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{ncp_null_state,ILLEGAL_PPP_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_ack,PPP_ACK_SENT_STATE},
/*											*/
/*	CONFIGURE_REQUEST_BAD			*/	  	{ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_nak,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/   	(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_nak,PPP_ACK_SENT_STATE},
/*											*/
/*	CONFIGURE_ACK						*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_STOPPED_STATE},
/*	CONFIGURE_NAK						*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_STOPPED_STATE},
/*	CONFIGURE_REJECT					*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_STOPPED_STATE},
/*	TERMINATE_REQUEST					*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_STOPPED_STATE},
/*	TERMINATE_ACK						*/	  	{set_ncp_state,PPP_STOPPED_STATE},
/*	UNKNOWN_CODE						*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_code_reject,PPP_STOPPED_STATE},
/*	CODE_REJECT_PERMITTED			*/	  	{set_ncp_state,PPP_STOPPED_STATE},
/*	PROTOCOL_REJECT					*/	  	{set_ncp_state,PPP_STOPPED_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  	{ncp_this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*								 CLOSING					 4										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{ncp_null_state,ILLEGAL_PPP_STATE},
/*											*/		
/*	DOWN									*/	  	{set_ncp_state,PPP_INITIAL_STATE},
/* OPEN									*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	CLOSE									*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_request,PPP_CLOSING_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{ncp_this_layer_finished,PPP_CLOSED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_ACK						*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_NAK						*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*	CONFIGURE_REJECT					*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*	TERMINATE_REQUEST					*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_CLOSING_STATE},
/*	TERMINATE_ACK						*/	  	{ncp_this_layer_finished,PPP_CLOSED_STATE},
/*	UNKNOWN_CODE						*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_code_reject,PPP_CLOSING_STATE},
/*	CODE_REJECT_PERMITTED			*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*	PROTOCOL_REJECT					*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  	{ncp_this_layer_finished,PPP_CLOSED_STATE},
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*								STOPPING					 5										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  	{ncp_null_state,ILLEGAL_PPP_STATE},
/*											*/			
/*	DOWN									*/	  	{set_ncp_state,PPP_STARTING_STATE},
/* OPEN									*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	CLOSE									*/	  	{set_ncp_state,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_request,PPP_STOPPING_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  	{ncp_this_layer_finished,PPP_STOPPED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_ACK						*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_NAK						*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	CONFIGURE_REJECT					*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	TERMINATE_REQUEST					*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_STOPPING_STATE},
/*	TERMINATE_ACK						*/	  	{ncp_this_layer_finished,PPP_STOPPED_STATE},
/*	UNKNOWN_CODE						*/	  	{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_code_reject,PPP_STOPPING_STATE},
/*	CODE_REJECT_PERMITTED			*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	PROTOCOL_REJECT					*/	  	{set_ncp_state,PPP_STOPPING_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  	{ncp_this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*										REQUEST_SENT	  6										 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {ncp_null_state,ILLEGAL_PPP_STATE}, 
/*											*/				
/*	DOWN									*/	  {set_ncp_state,PPP_STARTING_STATE},
/*	OPEN									*/	  {set_ncp_state,PPP_REQUEST_SENT_STATE},
/*	CLOSE									*/	  {ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_request,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {ncp_this_layer_finished,PPP_STOPPED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_ack,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_nak,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_reject,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_ACK						*/	  {ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  set_ncp_state,PPP_ACK_RECEIVED_STATE},
/*											*/
/*	CONFIGURE_NAK                 */   {ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REJECT					*/	  {ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE, 
/*											*/	  (void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*											*/
/*	TERMINATE_REQUEST					*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_REQUEST_SENT_STATE},
/*	TERMINATE_ACK						*/	  {set_ncp_state,PPP_REQUEST_SENT_STATE},
/*	UNKNOWN_CODE						*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_code_reject,PPP_REQUEST_SENT_STATE},
/*	CODE_REJECT_PERMITTED			*/	  {set_ncp_state,PPP_REQUEST_SENT_STATE},
/*	PROTOCOL_REJECT					*/	  {set_ncp_state,PPP_REQUEST_SENT_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  {ncp_this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*									 	 ACK_RECEIVED		7									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {ncp_null_state,ILLEGAL_PPP_STATE}, 
/*											*/				
/*	DOWN									*/	  {set_ncp_state,PPP_STARTING_STATE},
/*	OPEN									*/	  {set_ncp_state,PPP_ACK_RECEIVED_STATE},
/*	CLOSE									*/	  {ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_request,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {ncp_this_layer_finished,PPP_STOPPED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_ack,NO_CHANGE_TO_PPP_STATE,
/*											*/	  ncp_this_layer_up,PPP_OPENED_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_nak,PPP_ACK_RECEIVED_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_reject,PPP_ACK_RECEIVED_STATE},
/*	CONFIGURE_ACK						*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_NAK                 */   {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REJECT					*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	TERMINATE_REQUEST					*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_REQUEST_SENT_STATE},
/*	TERMINATE_ACK						*/	  {set_ncp_state,PPP_REQUEST_SENT_STATE},
/*	UNKNOWN_CODE						*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_code_reject,PPP_ACK_RECEIVED_STATE},
/*	CODE_REJECT_PERMITTED			*/	  {set_ncp_state,PPP_REQUEST_SENT_STATE},
/*	PROTOCOL_REJECT					*/	  {set_ncp_state,PPP_REQUEST_SENT_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  {ncp_this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											  ACK_SENT		 8									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/	  {ncp_null_state,ILLEGAL_PPP_STATE}, 
/*											*/				
/*	DOWN									*/	  {set_ncp_state,PPP_STARTING_STATE},
/*	OPEN									*/	  {set_ncp_state,PPP_ACK_SENT_STATE},
/*	CLOSE									*/	  {ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_request,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_ACK_SENT_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/	  {ncp_this_layer_finished,PPP_STOPPED_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_ack,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD			*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_nak,PPP_ACK_RECEIVED_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_reject,PPP_ACK_RECEIVED_STATE},
/*	CONFIGURE_ACK						*/	  {ncp_initialize_restart_counter,PPP_OPENED_STATE,
/*											*/	  ncp_this_layer_up,PPP_OPENED_STATE},
/*	CONFIGURE_NAK                 */   {ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REJECT					*/	  {ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/	  (void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_ACK_SENT_STATE},
/*	TERMINATE_REQUEST					*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_REQUEST_SENT_STATE},
/*	TERMINATE_ACK						*/	  {set_ncp_state,PPP_ACK_SENT_STATE},
/*	UNKNOWN_CODE						*/	  {(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_code_reject,PPP_ACK_SENT_STATE},
/*	CODE_REJECT_PERMITTED			*/	  {set_ncp_state,PPP_ACK_SENT_STATE},
/*	PROTOCOL_REJECT					*/	  {set_ncp_state,PPP_ACK_SENT_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/	  {ncp_this_layer_finished,PPP_STOPPED_STATE},
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
},
/* ------------------------------------------------------------------------ */
/*											OPENED			 9									 */
/* ------------------------------------------------------------------------ */
{
/*	UP										*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*											*/
/*	DOWN									*/		{ncp_this_layer_down,PPP_STARTING_STATE},
/*	OPEN									*/		{set_ncp_state,PPP_OPENED_STATE},
/*	CLOSE									*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_request,PPP_CLOSING_STATE},
/*											*/
/*	TIMEOUT_WITH_COUNTER_GREATER	*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	TIMEOUT_WITH_COUNTER_EXPIRED	*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*											*/
/*	RX										*/
/*											*/
/*	CONFIGURE_REQUEST_GOOD			*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_ack,PPP_ACK_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD			*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_nak,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REQUEST_BAD_OPTION	*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_reject,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_ACK						*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*											*/
/*	CONFIGURE_NAK						*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*	CONFIGURE_REJECT					*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*											*/
/*	TERMINATE_REQUEST					*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		ncp_zero_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_ack,PPP_STOPPING_STATE},
/*											*/
/*	TERMINATE_ACK						*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_configuration_request,PPP_REQUEST_SENT_STATE},
/*											*/
/*	UNKNOWN_CODE						*/		{(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_code_reject,PPP_OPENED_STATE},
/*	CODE_REJECT_PERMITTED			*/		{set_ncp_state,PPP_OPENED_STATE},
/*	PROTOCOL_REJECT					*/		{set_ncp_state,PPP_OPENED_STATE},
/*	CODE_REJECT_CATASTROPHIC		*/		{ncp_this_layer_down,NO_CHANGE_TO_PPP_STATE,
/*											*/		ncp_initialize_restart_counter,NO_CHANGE_TO_PPP_STATE,
/*											*/		(void (*) (PPP_NCP_CLASS *,USHORT,void *,USHORT,enum PPP_STATE))send_ncp_termination_request,PPP_STOPPING_STATE},
/*											*/
/*	ECHO_REQUEST						*/		{ncp_null_state,ILLEGAL_PPP_STATE},			
/*	ECHO_REPLY							*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	DISCARD_REQUEST					*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_TIMEOUT		*/		{ncp_null_state,ILLEGAL_PPP_STATE},
/*	PPP_ECHO_RESPONSE_FAILURE		*/		{ncp_null_state,ILLEGAL_PPP_STATE}
}
};

