/*	$Modname: vnstpstr.h$  $version: 1.4$      $date: 10/19/95$   */
/*
* 	$lgb$
1.0 08/24/94 ross
1.1 08/24/94 ross cleanup for release
1.2 09/29/94 ross fixes for Chap, courtesy of Danny.  Added STP	and Netbios.
1.3 06/26/95 ross initial version of BCP
1.4 10/19/95 biao replaced enum declarations with RouterWare ENUM declaration macros.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
typedef	struct	BRIDGING_OPTIONS_BOOLEAN
{
	BYTE_ENUM (BOOLEAN)	bridge_identification;
	BYTE_ENUM (BOOLEAN) 	line_identification;
	BYTE_ENUM (BOOLEAN) 	mac_support_type;
	BYTE_ENUM (BOOLEAN) 	tinygram_compression;
	BYTE_ENUM (BOOLEAN) 	lan_identification;
	BYTE_ENUM (BOOLEAN) 	mac_address;
	BYTE_ENUM (BOOLEAN) 	spanning_tree_protocol;
}	BRIDGING_OPTIONS_BOOLEAN;

typedef	struct	BRIDGE_ID
{
#ifndef BIG_ENDIAN
	unsigned int						lan_segment_number:12;
	unsigned int						bridge_number:4;
#else
	unsigned int						bridge_number:4;
	unsigned int						lan_segment_number:12;
#endif
} BRIDGE_ID;

typedef	union	UNION_BRIDGE_ID
{
	BRIDGE_ID	_bit;
	USHORT		_ushort;
} UNION_BRIDGE_ID;

typedef	struct	PPP_BRIDGING_CONFIGURATION
{
	BRIDGING_OPTIONS_BOOLEAN		enabled;

	UNION_BRIDGE_ID					bridge_id;

	UNION_BRIDGE_ID					line_id;

	BYTE_ENUM (BOOLEAN)			 	mac_type[NUMBER_OF_BRIDGE_MAC_TYPES];

	BYTE_ENUM (BOOLEAN)			 	tinygram_enable;

	BYTE_ENUM (BOOLEAN)			 	lan_id_enable;

	ULONG									lan_id;

	MAC_ADDRESS							mac_address;
	MAC_ADDRESS							remote_mac_address;

	BYTE_ENUM (BOOLEAN)			 	bridge_type[NUMBER_OF_BRIDGE_PROTOCOL_TYPES];

	BYTE									number_of_bridge_types_supported;
} PPP_BRIDGING_CONFIGURATION;

typedef	struct BRIDGING_OR_LINE_IDENTIFICATION_OPTION
{
	BYTE_ENUM (BRIDGING_NCP_OPTION)	type;
	BYTE										length;

#ifndef BIG_ENDIAN
	unsigned int							lan_segment_number:12;
	unsigned int							bridge_number:4;
#else
	unsigned int							bridge_number:4;
	unsigned int							lan_segment_number:12;
#endif
} BRIDGING_OR_LINE_IDENTIFICATION_OPTION;

typedef	struct BRIDGING_MAC_SUPPORT
{
	BYTE_ENUM (BRIDGING_NCP_OPTION) 	type;
	BYTE										length;
	BYTE_ENUM (BRIDGE_MAC_TYPE) 		mac_type;
} BRIDGING_MAC_SUPPORT;

typedef	struct	TINYGRAM_COMPRESSION_OR_LAN_ID_OPTION
{
	BYTE_ENUM (BRIDGING_NCP_OPTION) 	type;
	BYTE										length;
	BYTE_ENUM (BOOLEAN) 					enable;
} TINYGRAM_COMPRESSION_OR_LAN_ID_OPTION;

typedef	struct	BRIDGING_MAC_ADDRESS_OPTION
{
	BYTE_ENUM (BRIDGING_NCP_OPTION) 	type;
	BYTE			  							length;
	MAC_ADDRESS	  							mac_address;
} BRIDGING_MAC_ADDRESS_OPTION;

typedef	struct	BRIDGING_PROTOCOL_OPTION
{
	BYTE_ENUM (BRIDGING_NCP_OPTION) 	type;
	BYTE			  						  	length;
	BYTE_ENUM (BRIDGE_PROTOCOL_TYPE) bridge_type[NUMBER_OF_BRIDGE_PROTOCOL_TYPES];
} BRIDGING_PROTOCOL_OPTION;

typedef	struct	BRIDGE_FLAGS
{
#ifdef BIG_ENDIAN
	unsigned int	crc:1;
	unsigned int	lan_id:1;
	unsigned int	_8023_zero_filled:1;
	unsigned int	reserved:1;
	unsigned int	number_of_pads:4;
#else
	unsigned int	number_of_pads:4;
	unsigned int	reserved:1;
	unsigned int	_8023_zero_filled:1;
	unsigned int	lan_id:1;
	unsigned int	crc:1;
#endif
} BRIDGE_FLAGS;

typedef	union	UNION_BRIDGE_FLAGS
{
	BRIDGE_FLAGS	_bit;
	BYTE				_byte;
} UNION_BRIDGE_FLAGS;

typedef	struct	COPIED_PPP_BRIDGE_PACKET
{
	UNION_MAC_HEADER					dummy_mac_header;

	UNION_BRIDGE_FLAGS				flags;

	BYTE_ENUM (BRIDGE_MAC_TYPE)	mac_type;

	ULONG									lan_id;

	UNION_MAC_HEADER					mac_header;

	BYTE									data[VARIABLE_NUMBER_OF_BYTES];
} COPIED_PPP_BRIDGE_PACKET;

typedef	struct	PPP_BRIDGE_PACKET_HEADER
{
	UNION_MAC_HEADER					mac_header;

	UNION_BRIDGE_FLAGS				flags;

	BYTE_ENUM (BRIDGE_MAC_TYPE)	mac_type;

	ULONG									lan_id;
} PPP_BRIDGE_PACKET_HEADER;

typedef	struct	PPP_BRIDGE_PACKET
{
	PPP_HEADER							ppp_header;

	UNION_BRIDGE_FLAGS				flags;

	BYTE_ENUM (BRIDGE_MAC_TYPE)	mac_type;

	ULONG									lan_id;

	UNION_MAC_HEADER					mac_header;

	BYTE									data[VARIABLE_NUMBER_OF_BYTES];
} PPP_BRIDGE_PACKET;

typedef	struct	BRIDGE_MAC_PACKET
{
	ULONG									lan_id;

	BYTE_ENUM (BRIDGE_MAC_TYPE)	mac_type;

	UNION_MAC_HEADER					mac_header;

	BYTE									data[VARIABLE_NUMBER_OF_BYTES];

} BRIDGE_MAC_PACKET;


void initialize_spanning_tree_ncp (USHORT real_port_number);

