/*
	Author   : Sachin (Courtesy, Bala)
	Date     : 30th June, 1996
	Synopsis : Header file for all call back related stuff
*/

#ifndef _VPPPCB_H_

#define _VPPPCB_H_


enum CBCP_CALLBACK_TYPE
{
	CBCP_TYPE_NO_CALLBACK = 1,
	CBCP_TYPE_USER_SPECIFIED = 2,
	CBCP_TYPE_ADMINISTRATOR_SPECIFIED = 3
} ;


typedef struct LCP_EXTENSION_CALLBACK
{
	BYTE_ENUM (CALLBACK_OPERATION) operation ;
	BYTE message[1] ;
} LCP_EXTENSION_CALLBACK ;


typedef struct	CALLBACK_ADDRESS
{
	BYTE	address_type;
	BYTE	address[128];
} CALLBACK_ADDRESS;


typedef	struct	CALLBACK_OPTION_NO_CALLBACK
{
	BYTE	callback_type;
	BYTE	length;
	BYTE	delay;
} CALLBACK_OPTION_NO_CALLBACK;

typedef	struct	CALLBACK_OPTION_CALL_BACK_USER_SPECIFIED_NO
{
	BYTE	callback_type;
	BYTE	length;
	BYTE	delay;
	BYTE	address_type;
	BYTE	address[1];
} CALLBACK_OPTION_CALL_BACK_USER_SPECIFIED_NO;

typedef	struct	CALLBACK_OPTION_CALL_BACK_PRE_SPECIFIED_NO
{
	BYTE	callback_type;
	BYTE	length;
	BYTE	delay;
} CALLBACK_OPTION_CALL_BACK_PRE_SPECIFIED_NO;

typedef	union	UNION_CALLBACK_OPTIONS
{
	CALLBACK_OPTION_NO_CALLBACK	no_callback;
	CALLBACK_OPTION_CALL_BACK_USER_SPECIFIED_NO	user_specified_no;
	CALLBACK_OPTION_CALL_BACK_PRE_SPECIFIED_NO	pre_specified_no;
} UNION_CALLBACK_OPTIONS;

typedef	struct	CBCP_REQUEST_DATA
{
	BYTE	data[sizeof(CALLBACK_OPTION_NO_CALLBACK) + sizeof(CALLBACK_OPTION_CALL_BACK_USER_SPECIFIED_NO) +
						sizeof(CALLBACK_OPTION_CALL_BACK_PRE_SPECIFIED_NO)];
} CBCP_REQUEST_DATA;

typedef	struct	CBCP_RESPONSE_DATA
{
	BYTE	callback_type;
	BYTE	length;
	BYTE	delay;
	CALLBACK_ADDRESS	callback_address;
} CBCP_RESPONSE_DATA;

typedef	union	UNION_CBCP_DATA
{
	CBCP_REQUEST_DATA	request;
	CBCP_RESPONSE_DATA	response;
} UNION_CBCP_DATA;

typedef	struct	CBCP_PACKET
{
	PPP_HEADER			ppp_header;

	LCP_HEADER			lcp_header;

	UNION_CBCP_DATA	data;

} CBCP_PACKET;


typedef	struct	CBCP_REQUEST_PACKET
{
	PPP_HEADER			ppp_header;

	LCP_HEADER			lcp_header;

	CBCP_REQUEST_DATA	request;

} CBCP_REQUEST_PACKET;

typedef	struct	CBCP_RESPONSE_PACKET
{
	PPP_HEADER			ppp_header;

	LCP_HEADER			lcp_header;

	CBCP_RESPONSE_DATA	response;

} CBCP_RESPONSE_PACKET;

typedef	struct	CBCP_ACK_PACKET
{
	PPP_HEADER			ppp_header;

	LCP_HEADER			lcp_header;

	CBCP_RESPONSE_DATA response ;

} CBCP_ACK_PACKET;


extern void cbcp_packet_received (USHORT port_number, CBCP_PACKET *sptr_cbcp_rx_packet, USHORT no_of_bytes_rxed) ;
extern void send_cbcp_ack (USHORT real_port_number, CBCP_PACKET *sptr_cbcp_packet) ;
extern void send_cbcp_request (USHORT real_port_number) ;

#endif
