#include <stdlib.h>
#include <stdio.h>
#include	<kstart.h>
#include <stdarg.h>

#include "scrttype.h"
#include "scrtcons.h"
#include "scrtfuns.h"
#include "scrtdata.h"
#include "scrtvnv.h"
#include "scrtenum.h"
#include "scrtasm.h"

ScriptPortClassType ScriptPortClass[MAX_NO_OF_PORTS] ;
USHORT MaxIDLs[MAX_NO_OF_PORTS] ;

int ExecuteScriptFile (BYTE PortNum)
{
	/* If the script is OK then this means that it was 
		initialized before and hence no need of
		reinitializing it again */
	if (ScriptPortClass[PortNum].ScriptOK)
		return 0 ;

	/* Allocate memory for the address table */
	if (!ScriptPortClass[PortNum].AddrTable)
		ScriptPortClass[PortNum].AddrTable = 
			(WORD *) malloc ((WORD) (ADDR_TABLE_SIZE / 16)) ;
	if (!ScriptPortClass[PortNum].AddrTable) 
	{
		script_printf (ALARM_SCRIPT_PRINTF,
			"Not enough memory to execute script for port %d\n\r", PortNum) ;
		goto error_exit ;
	}

	/* Buffer for the script code */
	if (!ScriptPortClass[PortNum].CodeBuffer)
		ScriptPortClass[PortNum].CodeBuffer =
			(BYTE *) malloc ((WORD) (CODE_BUFFER_SIZE / 16)) ;
	if (!ScriptPortClass[PortNum].CodeBuffer) 
	{
		script_printf (ALARM_SCRIPT_PRINTF,
				"Not enough Memory to execute script for port %d\n\r", PortNum) ;
		goto error_exit ;
	}

	/* Add Well known commands */
	if (AddBuiltInCommands (PortNum) < 0) 
	{
		script_printf (ALARM_SCRIPT_PRINTF, 
				"Script execution internal error 02 for port %d\n\r", PortNum) ;
		goto error_exit ;
	}

	/* Read the script and decode it */
	if (ReadAndDecode (PortNum) < 0) 
	{
		script_printf (ALARM_SCRIPT_PRINTF, 
				"Error in decoding script for port %d\n\r", PortNum) ;
		goto error_exit ;
	} 
	script_printf (NON_CRITICAL_SCRIPT_PRINTF,
					"Script decoded succesfully for port %d\n\r", PortNum) ;

	/*	Initialize stack upper boundary.	*/
	ScriptPortClass[PortNum].StackUpperBoundary = (ArgType *) ScriptPortClass[PortNum].CodeBuffer +
								CODE_BUFFER_SIZE - 2 * sizeof (ArgType) ;

	/* First call to execute code after reinitializing
		script code */
	if (!InitializeScriptExe (PortNum))
		goto error_exit ; 
	return 0 ;

error_exit :
	if (ScriptPortClass[PortNum].Display[0]) 
	{
		PurgeSymbols (ScriptPortClass[PortNum].Display[0]) ; 
		ScriptPortClass[PortNum].Display[0] = 0 ;
	}
	if (ScriptPortClass[PortNum].AddrTable) 
	{
		free ((WORD *) ScriptPortClass[PortNum].AddrTable) ;
		ScriptPortClass[PortNum].AddrTable = 0 ;
	}
	if (ScriptPortClass[PortNum].CodeBuffer) 
	{
		free ((BYTE *) ScriptPortClass[PortNum].CodeBuffer) ;
		ScriptPortClass[PortNum].CodeBuffer = 0 ;
	}

	ScriptPortClass[PortNum].ScriptOver = 1 ;
	return -1 ;
}


/*----------------------------------------------------------------------------
	Name		:	InitializeScriptExe											
	Input		:	None													
	Output	:	None													
	Synopsis	:	Handles the initialization of script execution.			
----------------------------------------------------------------------------*/
int InitializeScriptExe (BYTE PortNum)
{
	SymType *sym_ptr ;
		
	sym_ptr = FindSymbol ("MAIN", PortNum) ;
	if (!sym_ptr) 
	{	
		script_printf (ALARM_SCRIPT_PRINTF,
				"Script execution internal error 03 for port %d\n\r", PortNum) ;
		goto Err_xit ;
	}
	ScriptPortClass[PortNum].Scope = 0 ;

	/*	Initialize stack to where code ends.	*/
	ScriptPortClass[PortNum].StackTop = 
		(ArgType *) &(ScriptPortClass[PortNum].CodeBuffer[(WORD) (ScriptPortClass[PortNum].AddrTable[ScriptPortClass[PortNum].CodeIdx])]) ;

	ScriptPortClass[PortNum].StackBottom  =  
		(ArgType *) &(ScriptPortClass[PortNum].CodeBuffer[(WORD) (ScriptPortClass[PortNum].AddrTable[ScriptPortClass[PortNum].CodeIdx])]);

	ScriptPortClass[PortNum].FramePtr = ScriptPortClass[PortNum].StackTop ;
	ScriptPortClass[PortNum].EntryCount = 0 ;	/*	No. of procedure nesting is 0 for main.	*/

	/*	Initialize the stack to call main.	*/
	ScriptPortClass[PortNum].StackTop->ArgType = E_INT_CONST ;
	ScriptPortClass[PortNum].StackTop->StorageClass = Q_PARAM ;
	ScriptPortClass[PortNum].StackTop->IntVal = 0 ;

	ScriptPortClass[PortNum].StackTop ++ ;	  /*	Adjust the stack top.	*/

	ScriptPortClass[PortNum].StackTop ++ ;	 /*	Leave a hole for the return address.	*/

	/*	Start execution at main body.	*/
	ScriptPortClass[PortNum].CodeIdx = (WORD) sym_ptr->IntVal ;
	ScriptPortClass[PortNum].ScriptOver = 0 ;
	ScriptPortClass[PortNum].ScriptOK = 1 ;

	/* This is necessary b'cos if MAX_IDL is 0
		then the buffers will not be closed
		unless MRBLR number of characters have been received.
		Hence trying to read looking for the "E" bit
		in the RxBD would make it to just wait and
		not receive anything
		So set MAX_IDL to some value and before exiting script
		reset it to 0
	*/

	MaxIDLs[PortNum] = GetMaxIDL ((USHORT) PortNum) ;
	SetMaxIDL ((USHORT) PortNum, 20) ;

	script_printf (NON_CRITICAL_SCRIPT_PRINTF,
		"Started executing the script for port %d\n\r", PortNum) ;

	if (ExecuteScript (PortNum) < 0)
	{
	 	printf (ALARM_SCRIPT_PRINTF, 
				"Error in script execution for port %d\n\r", PortNum) ;
		SetMaxIDL ((USHORT) PortNum, MaxIDLs[PortNum]) ; 
		ResetScriptVariables (PortNum) ;
		goto Err_xit ;
	}
	return 1 ;

Err_xit:
	ScriptPortClass[PortNum].ScriptOK = 0 ;
	ScriptPortClass[PortNum].ScriptOver = 1 ;
	return 0 ;
}


/*----------------------------------------------------------------------------
	Name		:	ExecuteScript											
	Input		:	None													
	Output	:	None													
	Synopsis	:	Handles the script execution.							
----------------------------------------------------------------------------*/
int ExecuteScript (BYTE PortNum)
{
	BYTE operator ;
	int result ;
	int (*handler) (BYTE) ;

	if (!ScriptPortClass[PortNum].ScriptOK)
		return 0 ;

	/* To make the script execution faster continue reading
		the script code until a CALL is encountered and
		yield control to the wan timer */
	do
	{
		ScriptPortClass[PortNum].CodeAddr = *((WORD *) (ScriptPortClass[PortNum].AddrTable + ScriptPortClass[PortNum].CodeIdx)) ;
		operator = ScriptPortClass[PortNum].CodeBuffer[ScriptPortClass[PortNum].CodeAddr] ;

		if (operator > Q_KILL)
			goto error_exit ;		/*	Invalid operator.	*/

		handler = CmdHdlrs[operator] ;

		if (handler)
		{
			ScriptPortClass[PortNum].CmdErr = 0 ;
			result = (*handler) (PortNum) ;
			if (ScriptPortClass[PortNum].CmdErr & 0x80)
			{
				script_printf (ALARM_SCRIPT_PRINTF, 
					"Error in handling script for port %d\n\r", PortNum) ;
			}
			if (result < 0 || ScriptPortClass[PortNum].CmdErr == 1)
				return result ;	/*	Execution aborted in some command/end script.	*/
		}
		else
			ScriptPortClass[PortNum].CodeIdx ++ ;	/*	Move on to next instruction.	*/
	} while (operator != Q_CALL) ;

	return 0 ;

error_exit :
	ScriptPortClass[PortNum].ScriptOK = 0 ;
	ScriptPortClass[PortNum].CmdErr = 1 ;

	script_printf (ALARM_SCRIPT_PRINTF, 
			"Invalid operator in script for port %d\n\r", PortNum) ;
	return -2 ;
}

void ScriptTimer (BYTE PortNum)
{
	int Result ;

	if (!ScriptPortClass[PortNum].ScriptOver
							&& ScriptPortClass[PortNum].ScriptOK)
	{
		Result = ExecuteScript (PortNum) ; 

		if (Result < 0 || ScriptPortClass[PortNum].CmdErr)
		{
			SetMaxIDL ((USHORT) PortNum, MaxIDLs[PortNum]) ; 

			if (Result == RESET_SCRIPT_VARIABLES 
							|| ScriptPortClass[PortNum].CmdErr)
			{
				ExitHdlr (PortNum) ;
			}
			ResetScriptVariables (PortNum) ;
	   }
	}
}


void ResetScriptVariables (BYTE PortNum)
{
	PurgeNamesAndLabels (PortNum) ;
	if (ScriptPortClass[PortNum].Display[0]) 
	{
		PurgeSymbols (ScriptPortClass[PortNum].Display[0]) ;
		ScriptPortClass[PortNum].Display[0] = 0 ;
	}

	if (ScriptPortClass[PortNum].AddrTable) 
	{
		free (ScriptPortClass[PortNum].AddrTable) ;
		ScriptPortClass[PortNum].AddrTable = 0 ;
	}

	if (ScriptPortClass[PortNum].CodeBuffer) 
	{
		free (ScriptPortClass[PortNum].CodeBuffer) ;
		ScriptPortClass[PortNum].CodeBuffer = 0 ;
	}

	if (ScriptPortClass[PortNum].RecvStr)
	{
		free (ScriptPortClass[PortNum].RecvStr) ;
		ScriptPortClass[PortNum].RecvStr = 0 ;
	}	

	ScriptPortClass[PortNum].RecvCharCount = 0 ;
	ScriptPortClass[PortNum].RecvStr = 0 ;
	ScriptPortClass[PortNum].CodeIdx = 0 ;
	ScriptPortClass[PortNum].LastCodeIdx = 0 ;
	ScriptPortClass[PortNum].CodeAddr = 0 ;
	ScriptPortClass[PortNum].EntryCount = 0 ;
	ScriptPortClass[PortNum].StackUpperBoundary = 0 ;
	ScriptPortClass[PortNum].StackBottom = 0 ;
	ScriptPortClass[PortNum].StackTop = 0 ;
	ScriptPortClass[PortNum].FramePtr = 0 ;
	ScriptPortClass[PortNum].TempsPtr = 0 ;

	ScriptPortClass[PortNum].Scope = 0 ;
	ScriptPortClass[PortNum].CurLineNo = 0 ;
	ScriptPortClass[PortNum].ScriptOK = 0 ;
	ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;
	ScriptPortClass[PortNum].ScriptOnWait = 0 ;
	ScriptPortClass[PortNum].CmdErr = 0 ;
	ScriptPortClass[PortNum].ScriptOver = 1 ;
}

int ScriptRunning (BYTE PortNum)
{
	return (!ScriptPortClass[PortNum].ScriptOver 
							&& ScriptPortClass[PortNum].ScriptOK) ;
}

void script_dec_ticks (void)
{
	int PortNum ;

	for (PortNum = 0 ; PortNum < MAX_NO_OF_PORTS ; PortNum ++)
	{
		if (!ScriptPortClass[PortNum].ScriptOver)
		{
			if (ScriptPortClass[PortNum].ScriptOnWait)
			{
				ScriptPortClass[PortNum].ScriptWaitTimer -- ;
				if (ScriptPortClass[PortNum].ScriptWaitTimer < 0)
				{
					ScriptPortClass[PortNum].ScriptWaitTimer = 0 ;			
				}
			}
		}
	}
}

void ResetScriptOverVar (BYTE PortNum)
{
	ScriptPortClass[PortNum].ScriptOver = 0 ;
}

void script_printf (enum SCRIPT_PRINTF_GROUPS printf_group, char *printf_format, ...)
{
 	enum BOOLEAN print_string = FALSE ;
	va_list argptr ;

	va_start (argptr, printf_format) ;

	switch (printf_group)
	{
		case ALARM_SCRIPT_PRINTF :
			print_string = ScriptPrintf.alarm_print_enabled ;
			break ;

		case NON_CRITICAL_SCRIPT_PRINTF :
			print_string = ScriptPrintf.non_critical_print_enabled ;
			break ;
	}

	if (print_string)
		vprintf (printf_format, argptr) ;
	va_end (argptr) ;
}
