#ifndef __SCRTTYPE__

#define __SCRTTYPE__

#include <kstart.h>
#include "scrtcons.h"

#define BYTEPtr BYTE*

typedef union 
{
	long IntValue ;
	BYTE *StrValue ;
	struct sym_info_t	*SymPtr ; 
	int (*Hdlr) (BYTE) ;				/* Build in function handler.	*/
	struct arg_type_t *ArgPtr ; 
	long *IntPointer ;				/*	Used for accessing parameters.	*/
	BYTEPtr *StrPointer ;			/*	Used for accessing parameters.	*/
} ValType ;

typedef struct	sym_info_t
{
	BYTE SymClass ;	/*	intger / real / string / proc.	*/
	BYTE SymType ;	   /*	Global / parameter /local variable.	*/
	int Status ;		/*	Symbol status.	*/
	BYTE *Name ;	   /*	Pointer to symbol name.	*/
	ValType Val ;	   /*	Argument info.	*/
	struct sym_info_t	*Llink ;	/*	Ptr to lexically less nodes.	*/
	struct sym_info_t *Rlink ;	/*	Ptr to lexically greater nodes.	*/
} SymType ;

#define	IntVal	Val.IntValue
#define	StrVal	Val.StrValue
#define	SymVal	Val.SymPtr
#define	ArgVal	Val.ArgPtr
#define	Handler	Val.Hdlr
#define	IntPtr	Val.IntPointer
#define	StrPtr	Val.StrPointer

typedef struct arg_type_t	
{
	BYTE ArgType ;	  		/*	integer / real / string.	*/
	BYTE StorageClass ;	/*	global / parameter / local / temporary. */
	ValType Val ;			/*	Argument value.	*/
} ArgType ;

typedef struct	
{
	char *Name ;				/*	Command name.	*/
	int (*Hdlr) (BYTE) ;		/*	Command handler ptr.	*/
} BuiltInType ;

typedef struct	
{
	BYTE *VarName ;	/*	Name of the variable.	*/
	BYTE VarType ;	   /*	Type of the variable.	*/
} PreDefVarType ;


typedef struct ScriptPortClassTag
{
	/* Thes variables are used by the */
	/* script file 						*/
	WORD *AddrTable ;
	BYTE *CodeBuffer ;
	SymType *Display[MAX_LEVELS] ;

	WORD CodeAddr ;		/*	Beginning offset of instn in code buffer.	*/
								/* to be initialize to 0 		*/
	WORD CodeIdx ;
	WORD LastCodeIdx ;	/*	Last instruction seq no. to be initialize to 0 */

	WORD EntryCount ;	/*	Indicates no. of proc nesting.	*/

	WORD RecvCharCount ;			/* NoOfChars in the RecvStr buffer * /

/*	BYTE LANToLAN ;				 If the LAL to LAN routing enabled */
/*	BYTE DialStr[60] ; */
	BYTE ScriptOK ;
	long ScriptWaitTimer ;
	BYTE ScriptOnWait ;			/* Used to check script is waiting for */
		  								/* some strings or to expire timer		*/
	BYTE *RecvStr ;
	ArgType *StackUpperBoundary ;		/*	Stack top limit.	*/
	ArgType *StackBottom ;	/*	Stack bottom.	*/
	ArgType *StackTop ;		/*	Stack top.	*/
	ArgType *FramePtr ;		/*	Stack frame pointer.	*/
	ArgType *TempsPtr ;		/*	Pointer to beginning of temporaries.	*/
	int Scope ;
	WORD CurLineNo ;		/* current line being processed in script file */
	BYTE ScriptOver ; 		/* indicates that Script is over */
	BYTE CmdErr ;			/* Indicates that error occured during execution */


} ScriptPortClassType ;


#endif
