/* VSERSTR.H -- Has the core structure definition and related structures 
**				used in interface to the SCC serial programming.
*/

#ifndef _VSERSTR_H_
#define _VSERSTR_H_

/* #define DEBUG */

#ifdef DEBUG
#define STATIC
#else
#define STATIC static
#endif

#define sudha 0 /* 15-Sep-1999 */

/* NOTE: Take care of constant below if number of ports changes. */
#define MAX_WAN_PORTS				3

#define MAX_SERIAL_TX_DESCRIPTORS	16
#define MAX_SERIAL_RX_DESCRIPTORS	32

/* First few bytes of a receive buffer will hold a pointer. So the
** sizeof(void *) amount of space is reserved.
*/
#define RX_BUFFER_HEADER_SPACE		(256 + sizeof(void *))
#define MAX_SERIAL_RX_BUFFER_SIZE	(1536 - RX_BUFFER_HEADER_SPACE)

typedef struct SERIAL_RXTX_DESCRIPTOR {
	LINK				links;
	USHORT				length;
	BYTE 				*sptr_buffer;
	enum TX_BUFFER_OWNER tx_buffer_owner; /* self buffers are free-d locally */
} SERIAL_RXTX_DESCRIPTOR;

typedef struct SERIAL_STATISTICS_CLASS {
	ULONG				tx_pending_bytes;	/* Bytes on current_tx_list */
} SERIAL_STATISTICS_CLASS;

typedef struct SERIAL_CLASS {
	/* If below flag is TRUE, the serial port is in use for dialout. */
	enum BOOLEAN			activity_enabled[MAX_WAN_PORTS];

	/* Settings */
	ULONG					baud_rate[MAX_WAN_PORTS];
	USHORT					mode_bits[MAX_WAN_PORTS];

	void 					(*fptr_tx_complete[MAX_WAN_PORTS])(USHORT, void *, BYTE *);
	void 					(*fptr_rx_callback[MAX_WAN_PORTS])(USHORT, void *, BYTE *, USHORT);
	void					*user_parameter[MAX_WAN_PORTS];

	/* Fields below are related to TRANSMIT. For each port there is an array
	** of TX descriptors that point to the buffer to TX. The actual buffer
	** is passed on from layer above for TX purposes. 'free_tx_list' has 
	** unused descriptors. 'current_tx_list' is the one from which buffers
	** are scheduled for TX. 'tx_complete_list' contains pointers to
	** descriptors that refer buffers freed, but not yet put on the free list.
	*/
	SERIAL_RXTX_DESCRIPTOR	tx_descriptor[MAX_WAN_PORTS][MAX_SERIAL_TX_DESCRIPTORS];
	SERIAL_RXTX_DESCRIPTOR	*sptr_current_tx_descriptor[MAX_WAN_PORTS];
	LINK					free_tx_list[MAX_WAN_PORTS];
	LINK					current_tx_list[MAX_WAN_PORTS];
	LINK					tx_complete_list[MAX_WAN_PORTS];

	/* Fields below are related to RECEIVE. RX buffers are allocated for a
	** standard size when the port is used for dialout. 'free_rx_list' has
	** unused buffers, 'current_rx_list ' has buffers into which data has 
	** been received, 'scheduled_for_rx' has buffers that are currently
	** being used for reception.
	*/
	SERIAL_RXTX_DESCRIPTOR	rx_descriptor[MAX_WAN_PORTS][MAX_SERIAL_RX_DESCRIPTORS];
	LINK					free_rx_list[MAX_WAN_PORTS];
	LINK					current_rx_list[MAX_WAN_PORTS];
	LINK					scheduled_for_rx[MAX_WAN_PORTS];
	int						num_free_rx_buf[MAX_WAN_PORTS]; /* To keep track of flow control */
	int						num_scheduled_for_rx[MAX_WAN_PORTS];

	SERIAL_STATISTICS_CLASS	statistics[MAX_WAN_PORTS];
} SERIAL_CLASS;

#endif /* _VSERSTR_H_ */
