#include <defs.h>

#define 	GLOBAL_FILE

#include	"uim.h"
#include	"\rtrware\stdlib\stdlib.h"
#include	"chat\kchat.h"
#include	"chat\vchatstr.h"

extern   int   GetBaudDivisor(int BaudRate);

int	ChatOnPort = 0;	/* non-zero means SMC-WAN chat is on this port */

/****************************************************************************
* Routine	: initialize_uim_controller
* Input		: none
* Summary	: Programs the SMC and initializes the tx descriptors and the
* free_tx_list and scheduled_tx_lists.
****************************************************************************/	
int	initialize_uim_controller(void)
{
	InitSMC(GetBaudDivisor(UIM_SPEED));
	InitTimer();
	return (initialize_uim_rxtx_descriptors());
}

/****************************************************************************/
int initialize_uim_rxtx_descriptors (void)
{
	USHORT number_of_tx_descriptors;

	for (number_of_tx_descriptors = 0; number_of_tx_descriptors < NUMBER_OF_TX_DESCRIPTORS; ++number_of_tx_descriptors)
	{
		if ((uim.tx_descriptor[number_of_tx_descriptors].sptr_tx_packet =
											(BYTE *)malloc (MAX_CONFIG_PKT)) != NULL) {
			uim.tx_descriptor[number_of_tx_descriptors].length = 0;
			add_entry_to_list (&uim.free_tx_list, &uim.tx_descriptor[number_of_tx_descriptors].links);
		} else
			return(-1);
	}
	/* Receive init */
	uim.write_index = 0;
	uim.enabled = FALSE;
	return(1);
}
/****************************************************************************/
int reinitialize_uim_rxtx_descriptors_for_chat (void)
{
   BYTE *buf_ptr;
	USHORT number_of_tx_descriptors;

	/* stop SMC for now */

	/* first make free_tx_list NULL, we are going to remake this list */
	uim.free_tx_list.sptr_forward_link = NULL;
	uim.free_tx_list.sptr_backward_link = NULL;

	for (number_of_tx_descriptors = 0; number_of_tx_descriptors < NUMBER_OF_TX_DESCRIPTORS; ++number_of_tx_descriptors)
	{
		/* free up the small buffer(size only MAX_CONFIG_PKT) first. */
      buf_ptr = uim.tx_descriptor[number_of_tx_descriptors].sptr_tx_packet;
		
		/* now allocate big buffers(size SIZE_RX_CHAT_BUFFER) for tx */
		if ((uim.tx_descriptor[number_of_tx_descriptors].sptr_tx_packet =
									(BYTE *)malloc (SIZE_RX_CHAT_BUFFER)) != NULL) {
			uim.tx_descriptor[number_of_tx_descriptors].length = 0;
			add_entry_to_list (&uim.free_tx_list, &uim.tx_descriptor[number_of_tx_descriptors].links);
         /* free up the small buffer(size only MAX_CONFIG_PKT) */
         free (buf_ptr);
		} else {
         uim.tx_descriptor[number_of_tx_descriptors].sptr_tx_packet = buf_ptr;
			return(0);
		}
	}
	/* Receive init */
	uim.write_index = 0;
	uim.enabled = FALSE;
	return(1);
}

	





	
