/*	                                                          				
* $lgb$
1.0 04/05/94 ross
1.1 04/05/94 ross initial release
1.2 09/22/94 ross
* $lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/*	$Modname: kasync.h$  $version: 1.2$      $date: 09/22/94$   */
/************************************************************************/
/* async.c */

#define KWAN_H

#define NUMBER_OF_SYSTEM_BUFFERS_TO_LEAVE_FREE 4
#define FRAME_DELIMITER 0x7e

/* Vidy 25/06/99 added for VoIP priority issue */
#define	SMALL_PACKETS_FIRST 1
#define	MAXIMUM_SMALL_PACKET_SIZE	150

#define NUMBER_OF_TX_BUFFERS 128
/* #define NUMBER_OF_RX_BUFFERS 256 */
#define NUMBER_OF_RX_BUFFERS 64
#define NUMBER_OF_SERIAL_PORTS 3

#define INVALID_DEVICE_ID 0xffff
#define DIS_CONNECTED 0
#define CONNECTED 1

#define MAX_NUMBER_OF_WAN_PORTS 3 /* sudha 27 Nov 1998 */

#define ANALYSIS_WAIT_SECONDS	5000	/* 5 seconds to analyse first packet */

/* Kamalnath SLIP 14\03\1997 */
#define	ASYNC_PPP_OR_SLIP_MODE  0
#define	ASYNC_PPP_MODE				1
#define	SLIP_MODE					2
/* Kamalnath SLIP 14\03\1997 */

/* sudha 23 April 1999 */
#define PORT_PROXY_ENABLE 1
#define PORT_AG_ENABLE 2
#define PORT_PROXY_AG_ENABLE 3
#define PORT_RAS_ENABLE 4
#define PORT_PROXY_RAS_ENABLE 5
#define PORT_AG_RAS_ENABLE 6
#define PORT_PROXY_AG_RAS_ENABLE 7

#define DIAL_OUT_PORT 0
#define DIAL_IN_PORT 1
#define DIAL_OUT_IN_PORT 2

enum WAN_COMMAND_TYPE
{
	NOP_WAN_COMMAND,

	TX_RESET = 1,
	TX_ENABLE,
	TX_DISABLE,
	TX_CRC_INITIALIZATION,
	TX_CRC_DISABLE,
	WAN_END_OF_MESSAGE,
	ABORT_TX,
	MP_BIT_ON,
	TX_BUFFER_CLEAR,

	RX_RESET = 17,
	RX_ENABLE,
	RX_DISABLE,
	RX_CRC_INITIALIZATION,
	RX_MESSAGE_REJECT,
	SEARCH_MP_BIT,
	RX_CRC_DISABLE,
	RX_CRC_ENABLE,

	CHANNEL_RESET = 0x21,
	ENTER_SEARCH_MODE = 0x31
};

enum WAN_PROTOCOL_MODE
{
	__WAN,
	MONOSYNC,
	BISYNC,
	EXTERNAL_SYNC,
	HDLC,
	LOOP_MODE
};

enum WAN_LOOPBACK_MODE
{
	NORMAL,
	AUTO_ECHO,
	LOCAL_LOOPBACK = 0x3
};

enum ADPLL_CLOCK_RATE_MODE
{
	TIMES_8,
	TIMES_16,
	TIMES_32
};

enum TRANSMISSION_CODE_TYPE
{
	NRZ_TX,
	NRZI_TX
};

enum HDLC_ADDRESS_CHECK_MODE
{
	NO_ADDRESS_CHECK
};

enum DMA_COMMAND_TYPE
{
	SOFTWARE_ABORT = 0x01,
	FRAME_END_INTERRUPT_COUNTER_CLEARED
};

enum TX_OR_RX_CONVERION
{
	TX_POINTER_CONVERSION,
	RX_POINTER_CONVERSION
};

enum CLOCK_MODE
{
	INTERNAL_CLOCK,
	EXTERNAL_CLOCK
};

#define ESC 27

enum USHORT_LENGTH
{
	_5_BITS,
	_6_BITS,
	_7_BITS,
	_8_BITS
};

enum WAN_PRINTF_GROUPS
{
	WAN_INITIALIZATION_PRINTF,
	WAN_RX_PRINTF,
	WAN_TX_PRINTF
};

/* sudhir 28/2/97 */
#define SHELL_MENU_MAX_RESPONSE_LENGTH 20
#define SHELL_MENU_MAX_IDLE_TIME 20
enum SHELL_MENU_STATE
{
   SHELL_MENU_OFF = 0,
   SHELL_MENU_SENT = 1,
   SHELL_MENU_LOGIN_PROMPT_SENT = 2,
   SHELL_MENU_USER_NAME_RECEIVED = 3,
   SHELL_MENU_PASSWORD_PROMPT_SENT = 4,
   SHELL_MENU_PASSWORD_RECEIVED = 5,
	SHELL_MENU_ANALYSIS = 6
} ;
/* sudhir 28/2/97 */

/* sudhir 21/6/97 */
enum SHELL_MENU_RESPONSE
{
   INVALID_OPTION=0,
   PPP_SHELL_OPTION=1,
   SLIP_SHELL_OPTION=2,
   AG_SHELL_OPTION=3,
   TELNET_OPTION=4,
	SHELL_LOGOFF=5
};

/* sudha 23 April 1999 */
enum PORT_FUNCTION_TYPE
{
	PROXY_ENABLE = 0,
	AG_ENABLE,
	RAS_ENABLE,
	PROXY_AG_ENABLE,
	PROXY_RAS_ENABLE,
	AG_RAS_ENABLE,
	PROXY_AG_RAS_ENABLE
};

enum DIAL_IN_OUT_TYPE 
{
	DIAL_OUT = 0,
	DIAL_IN,
	DIAL_OUT_IN
};

#ifdef FRAME_RELAY
enum HLDD_TYPE
{
	HLDD_TYPE_PPP = 0,
	HLDD_TYPE_SLIP,
	HLDD_TYPE_FRAME_RELAY,
	HLDD_TYPE_UNKNOWN
} ;
#endif



