/***************************************************************************
File	:	modem.c
Synop	:	Mainly contains the modem state machine.
modification	:	03/10/96 Vidy added "SOFTWARE_QUOTING" conditional for
						RF200 problem wih microcode
						sudha 21-Oct-1999. changed the enum BOOLEAN var
						need_to_proceed_with_modem_dial_state_and_not_idle_state
						as a BOOLEAN array var whose length is MAX_NUMBER_OF_WAN_PORTS.
						In MdmStateCmdA() as well as in set_modem_to_dialing_mode()
						functions, changes for the same.
						Changes in MdmStateOffline() function, to try to dial for
						the first time, even in	modem reported error condition, only 
						if initial_need_to_dial_out is enabled.
***************************************************************************/

#include "defs.h"
#include <stdio.h>
#include <string.h>
#include "wan.h"
#include	"modemsup.h"
#include <wanmgr.h>
#include <udb.h>
#include <softquot.h>
#include "\rtrware\store\boot.h"		/* for model numbers */

#ifdef EVENT_LOG		/* vidy 11/02/98 */
#include	<logif.h>
#endif

/* sudha 27 June 1999.This var is used whether to proceed with dial string
of modem to dial or just reinit of modem state machine & so not to proceed
with dial string but has to go to idle state */

/* sudha 21-Oct-1999. Changed this var to an array var */
enum BOOLEAN need_to_proceed_with_modem_dial_state_and_not_idle_state[MAX_NUMBER_OF_WAN_PORTS] = {TRUE, TRUE, TRUE};

extern void flush_rx_buffers_sticking_around (USHORT port_number) ;
extern void callback_attempt_failed (USHORT) ;
extern void DLBK_Initialize_Port (USHORT wan_port_number);

extern void StartScript (USHORT port_number) ;
extern int ScriptRunning (BYTE PortNum) ;

extern enum BOOLEAN check_if_slip_is_enabled(USHORT port_num);

extern void check_for_user_name_and_send_prompt (USHORT port_number);

extern USHORT is_DCD_present(USHORT);
void append_cr_if_necessary (BYTE *string) ;
extern char *process_back_slash (char *) ;

void	reinitiaize_SYNC_port(port_number);
extern	void enable_wan_tx_rx (USHORT port_number);

extern enum BOOLEAN is_remote_access_enabled_on_port (USHORT port_number);
void set_modem_to_answering_mode (USHORT port_number);
void set_modem_to_dialing_mode (USHORT port_number);

void	(* MdmStateHandlers[])(USHORT) = {
	MdmStateIdle,
	MdmStateOffLine,
	MdmStateOnLine,
	MdmStateCmdA,
	ModemStateCmdT,
	MdmStateCmdRest,
	MdmStateWaitOK,
	MdmStateDialA,
	MdmStateWaitConn,
	MdmStateWaitRing,
	MdmStateHupDTRDown,
	MdmStateHupCheckCD,
	MdmStateHupStr,
	MdmStateBreak,
	MdmStateDelayOnline,
	MdmStateDTRDialLinkDn,
	MdmStateDTRDialDTRDn,
	MdmStateDTRDialDTRUp,
	MdmStateDTRDialChkOnline,
	MdmStateCallBack,
	MdmStateReinit,
	MdmStateResetISDN,
	MdmStateISDNAtfs1
};


void construct_dial_string (USHORT port_number, char *dial_number)
{
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;
	
	strcpy (modem_str_ptr->dial_string, modem_str_ptr->modem_dial_prefix) ;
	strcat (modem_str_ptr->dial_string, dial_number) ;
	strcat (modem_str_ptr->dial_string, modem_str_ptr->modem_dial_suffix) ;

	/* printf ("Dial number : %s, New dial string : %s\n", dial_number, modem_str_ptr->dial_string) ; */
}

/* Converts lower case to higher case */
BYTE  *strupr( BYTE *ptr)
{
	BYTE	*p = ptr;
	while (*ptr) {
		if (*ptr <= 'z' && *ptr >= 'a')
			*ptr = *ptr - 32;
		ptr ++;
	}
	 return(p);
}

void	SetModemDefInfo(USHORT	port_number)
{
	USHORT modem_string_index ;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;
	ISDN_STRINGS *isdn_str_ptr = &wan.port[port_number].isdn_info.strings;


	if (!modem_str_ptr->modem_ring_mesg[0])
		ConvertControls((modem_str_ptr->modem_ring_mesg), DEF_MDM_RING_MESG);
	process_back_slash (modem_str_ptr->modem_ring_mesg) ;

	if (!modem_str_ptr->modem_hangup_string[0])
			ConvertControls((modem_str_ptr->modem_hangup_string), DEF_MDM_HANUP_STR);
	process_back_slash (modem_str_ptr->modem_hangup_string) ;

	if (!modem_str_ptr->modem_ok_mesg[0])
			ConvertControls((modem_str_ptr->modem_ok_mesg), DEF_MDM_RESP_OK);
	process_back_slash (modem_str_ptr->modem_ok_mesg) ;

	if (!modem_str_ptr->modem_error_mesg[0])
			ConvertControls((modem_str_ptr->modem_error_mesg), DEF_MDM_RESP_ERROR);
	process_back_slash (modem_str_ptr->modem_error_mesg) ;

	if (!modem_str_ptr->modem_busy_mesg[0])
			ConvertControls((modem_str_ptr->modem_busy_mesg), DEF_MDM_RESP_BUSY);
	process_back_slash (modem_str_ptr->modem_busy_mesg) ;

	if (!modem_str_ptr->modem_no_carrier_mesg[0])
			ConvertControls((modem_str_ptr->modem_no_carrier_mesg), DEF_MDM_RESP_NO_CARRIER);
	process_back_slash (modem_str_ptr->modem_no_carrier_mesg) ;

	if (!modem_str_ptr->modem_no_dial_tone_mesg[0])
			ConvertControls((modem_str_ptr->modem_no_dial_tone_mesg), DEF_MDM_RESP_NO_DLTONE);
	process_back_slash (modem_str_ptr->modem_no_dial_tone_mesg) ;

	if (!modem_str_ptr->modem_no_answer_mesg[0])
			ConvertControls((modem_str_ptr->modem_no_answer_mesg), DEF_MDM_RESP_NO_ANSWER);
	process_back_slash (modem_str_ptr->modem_no_answer_mesg) ;

	if (!modem_str_ptr->modem_response_string[0])
			ConvertControls((modem_str_ptr->modem_response_string), DEF_MDM_RESP_CONNECT);
	process_back_slash (modem_str_ptr->modem_response_string) ;

	if (!modem_str_ptr->modem_dial_suffix[0])
		strcpy (modem_str_ptr->modem_dial_suffix, "^M") ;

	construct_dial_string (port_number, modem_str_ptr->modem_dial_number) ;

	wan.port[port_number].modem_info.constant.dial_timeout = DEF_DIAL_TIMEOUT;
	wan.port[port_number].modem_info.constant.break_len =	DEF_BREAK_LEN;
	wan.port[port_number].modem_info.constant.max_retry =	DEF_MAX_RETRY;
	wan.port[port_number].modem_info.constant.sleep_time = DEF_SLEEP_TIME;
	wan.port[port_number].modem_info.constant.retry_wait = DEF_RETRY_WAIT;

	wan.port[port_number].modem_info.status.carrier_loss = 0;
	wan.port[port_number].modem_info.status.init_attempts = 0;
	wan.port[port_number].modem_info.status.stat_retry_fails = 0;
	wan.port[port_number].modem_info.status.check_online_count = 0;

   if (!modem_str_ptr->modem_response_string[0])
      wan.port[port_number].connection_started_by_modem_response = FALSE ;

	if (wan.port[port_number].isdn_ta_enabled)
	{
		for (modem_string_index = 0 ; modem_string_index < NUMBER_OF_ISDN_INIT_STRINGS ; modem_string_index++)
			append_cr_if_necessary (isdn_str_ptr->init_string[modem_string_index]) ;

	}
	else
	{
		for (modem_string_index = 0 ; modem_string_index < NUMBER_OF_MODEM_INIT_STRINGS ; modem_string_index++)
			append_cr_if_necessary (modem_str_ptr->init_string[modem_string_index]) ;
	}
	
	append_cr_if_necessary (modem_str_ptr->dial_string) ;
	append_cr_if_necessary (modem_str_ptr->modem_hangup_string) ;
}

/************************************************************************
 * Routine	:	ConvertControls
 * Input	:	destination and source pointers
 * Return	:	pointer to destination
 * Note		:	the '^' character given in a modem setup string is 
 *				interpreted by this routine. it puts the modified string
 *				in the destination. A pointer to the destination is
 *				returned
 ************************************************************************/
BYTE *ConvertControls(BYTE *dst_str, BYTE *src_str)
{
	BYTE *ret_str = dst_str;
	
	while (*src_str)
	{
		if (*src_str == '^')
		{
			src_str++;
			if (*src_str)
			{
				if (*src_str == '^')
					*dst_str++ = *src_str++;
				else
					*dst_str++ = (BYTE) (*src_str++ - 'A' + 1);
			}
		}
		else
		{
			*dst_str++ = *src_str++;
		}
	}
	*dst_str = 0;
	return ret_str;
}

void TriggerDial(USHORT port_number)
{
	/** If port is SYNC or DTR Dialing enabled, state = DTR_DIAL.
	** Sync port is always in DTR_DIAL_STATE whether answering/dialing
	** because, there are no strings to be sent and CD has to be
	** present for data transfer to take place (even in direct_connect).
	**/
	if (wan.port[port_number].modem_info.dtr_dial) {
		wan.port[port_number].modem_info.status.state = MDM_STATE_DTR_DIAL_DTR_DN;
	} else {	/* Port is Async */
		if (wan.port[port_number].direct_connect_enabled == FALSE) {
			/* Bring up DTR since Command Mode dialing */
			/* SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number); */
			wan.port[port_number].modem_info.status.wait_ticks = 0;
			wan.port[port_number].modem_info.status.state = MDM_STATE_OFFLINE;
		}
	}
}
/*******   The following routines are for modem dial state machine   *******/

/****************************************************************************
Routine	:	MoveModemState
Parameter : USHORT port_number
Synop	:	Checks for modem status and moves state machine
****************************************************************************/
void	MoveModemState(USHORT port_number)
{
	enum WAN_PORT_OWNER wan_owner;

	wan_owner = get_wan_port_owner(port_number);
	
	/* Kamalnath 20\03\1997 SLIP  added OWNED_BY_SLIP too */	
	if (!(wan_owner == OWNED_BY_NONE || wan_owner == OWNED_BY_PPP || wan_owner == OWNED_BY_SLIP))
		return;

	/* Just call the handler for the current state */
	(* MdmStateHandlers[wan.port[port_number].modem_info.status.state]) (port_number);
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateIdle(USHORT port_number)
{
	/* This is dummy state where nothing moves. Only external events can move */
	/* the state machine out of this state (like dial, wait for call) */

	return;
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateOffLine(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	USHORT TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
	{
		return;
	}

	modem_state_ptr->this_end_dialed = FALSE; 
	modem_state_ptr->dialing_initiated_from_proxy_successful = TRUE; /* sudha 18 May 1999 */

#if PROXY_SERVER
   wan.port[port_number].statistics.modem_connect_message[0] = 0 ;
#endif
	modem_state_ptr->init_string_index = 0;	/* start witht the first string */


	/* Bring up DTR since Command Mode dialing */
	SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);

	if ((is_DCD_present(port_number)) && (wan.port[port_number].connection_started_by_DCD))
	{

		TmpSr = _GPL();
		_SPL(7);
		Stop_Tx_and_Rx(port_number);
		Just_FlushRxBufferUART(port_number);
		Just_FlushTxBufferUART(port_number);
/* Added by Naveen ... */
      Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added by Naveen */
		_SPL(TmpSr);

#ifdef EVENT_LOG		/* vidy 11/02/98 */
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "DCD detected on WAN %d", port_number + 1);
	write_log(log_message);
}
#endif
		/* Now change the state */
		inform_hldd_and_change_to_async_hdlc(port_number);
		return;
	}
	if (modem_state_ptr->last_error == MDM_ERR_CMD)
	{
/* sudha 21-Oct-1999... */
/* Commented this out. This is wrong. B'cos, in case
of initial_need_to_dial_out unchecked & modem reported error condition, this 
code will try to dial.*/
#if 0
			if ((!wan.port[port_number].modem_info.auto_answer)
				&& (is_ag_enabled_only_port(port_number) == FALSE) 
				&& (is_wan_port_proxy_enabled(port_number) == TRUE))
			{	/* If caller goto dial */
				modem_state_ptr->wait_ticks = MDM_DELAY_DIAL;
				modem_state_ptr->state = MDM_STATE_DIAL_A;
			}
#endif

		if (!wan.port[port_number].modem_info.auto_answer)
 		{
			if ( need_to_proceed_with_modem_dial_state_and_not_idle_state[port_number] == TRUE )
			{
				modem_state_ptr->wait_ticks = 0;	/* Jo MDM_DELAY_DIAL - 0*/
				if (wan.port[port_number].isdn_ta_enabled)
					modem_state_ptr->state = ISDN_STATE_REINIT;
				else
				{
					modem_state_ptr->state = MDM_STATE_DIAL_A;
					MdmStateDialA(port_number);	/* Jo Direct call 4/2/99 */
				 }
			}
			else
			{
				need_to_proceed_with_modem_dial_state_and_not_idle_state[port_number] = TRUE;				

				if (wan.port[port_number].isdn_ta_enabled)
				{
					WriteToPort (port_number, "AT*FS1\r", 0);		
					printf ("MSM1: Reinitializing ISDN TA for port %04x\n",port_number);

					modem_state_ptr->state = ISDN_STATE_ATFS1 ;
					modem_state_ptr->wait_ticks = ISDN_WAIT_BEFORE_DIAL;
					return;
				}
				WriteToPort(port_number, "ATS0=0\r", 0);		
				printf ("WAN1: Setting Port %04x to IDLE\n",port_number);
				modem_state_ptr->state = MDM_STATE_IDLE;	/* move the state */

				SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
			}
/* ...sudha 21-Oct-1999 */

		}
		else
		{					/* If callee goto wait for ring */
			TmpSr = _GPL();
			_SPL(7);
			FlushRxBufferUART(port_number);
			_SPL(TmpSr);
			PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */
			modem_state_ptr->state = MDM_STATE_WAIT_RING;
			modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;
		}
		modem_state_ptr->last_error = MDM_ERR_NONE;
	}

	if (modem_state_ptr->retry_count >= wan.port[port_number].modem_info.constant.max_retry)
	{
		modem_state_ptr->stat_retry_fails++;		/* Some statistics */
		modem_state_ptr->retry_count = 0;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.sleep_time;

#ifdef EVENT_LOG		/* vidy 11/02/98 */
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "Dial retries fail on WAN %d", port_number + 1);
	write_log(log_message);
}
#endif
		if (modem_state_ptr->call_back_on)
		{
			/* reset any pending callbacks */
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	{
		char log_message[LOG_NORMAL_MSG_LEN];
		sprintf(log_message, "Callback cancelled on WAN %d.", port_number + 1);
		write_log(log_message);
	}
#endif
			modem_state_ptr->call_back_on = FALSE ;	/* reset any pending callbacks */
			wan.port[port_number].modem_info.auto_answer = TRUE;
			modem_state_ptr->wait_ticks = 1;
			callback_attempt_failed (port_number) ;
		}
		return;
	}

/* sudha 26 July 1999 */
	modem_state_ptr->init_attempts++;
 	modem_state_ptr->state = MDM_STATE_CMD_A;
	modem_state_ptr->wait_ticks = 0;

#if 0
/* sudha 18 May 1999 */
	if ((is_wan_port_proxy_enabled(port_number) == TRUE) || (modem_state_ptr->call_back_on == TRUE))
	{
		modem_state_ptr->init_attempts++;
 		modem_state_ptr->state = MDM_STATE_CMD_A;
		modem_state_ptr->wait_ticks = 0;
	}

	else
	{					/* If callee goto wait for ring */
		TmpSr = _GPL();
		_SPL(7);
		FlushRxBufferUART(port_number);
		_SPL(TmpSr);
		PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */
		modem_state_ptr->state = MDM_STATE_WAIT_RING;
		modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;
	}
#endif

#ifdef EVENT_LOG		/* vidy 11/02/98 */
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "Modem initializing on WAN %d", port_number + 1);
	write_log(log_message);
}
#endif
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateOnLine(USHORT	port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
#ifdef DOD_RECONNECT
	enum TEST	need_reconnect;
#endif

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	if ((wan.port[port_number].connection_dropped_by_DCD) && (is_DCD_present(port_number)))
	{
		modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;
		return;
	}
	modem_state_ptr->carrier_loss++;
#ifdef EVENT_LOG		/* vidy 11/02/98 */
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "DCD lost on WAN %d", port_number + 1);
	write_log(log_message);
}
#endif
#ifdef DOD_RECONNECT /* vidy 12/02/98 */
	/* we make an LSL call to inform this unexpected DCD loss.
	if DOD is enabled and the time left over is minute to make
	a reconnect attempt, LSL will return FALSE. also LSL will treat
	as if port goes down by no demand. Also LSL will do the needful
	to put the modem state to idle. */
	need_reconnect = lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT,
						wan.port[port_number].device_driver_id,
						LOWER_DEVICE_DRIVER_LOST_CD,	port_number);
	if (need_reconnect == FAIL)
		return;
#endif
	
	/* In case of SYNC just go to DTR_DIAL state irrespective of whether	answering or
	dialing. Reinitialize the SCC*/
	if (wan.port[port_number].asyncport == FALSE)
	{
		lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			LOWER_DEVICE_DRIVER_DOWN, port_number);

		reinitiaize_SYNC_port(port_number);		
		modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_DN;	/* move the state */
	} 
	else
	{
		
		/* inform HLDD about port no longer available */
		inform_hldd_and_change_to_async(port_number);

		if (wan.port[port_number].modem_info.dtr_dial)
		{
			modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_DN;	/* move the state */
		}
		else
		{
			SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
			modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
			modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
		}
		modem_state_ptr->retry_count = 0;
	}

	/* chetan 22/11/96 */
	if (wan.port[port_number].script_enabled)
	{
		if (wan.port[port_number].restart_script_on_comm_failure)
		{
			if (wan.port[port_number].asyncport
					&& !wan.port[port_number].direct_connect_enabled)
			{
				SetLineConfigUART (SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number) ;
				if (!ScriptRunning ((BYTE) port_number))
				{
					printf ("Ready to restart script- port : %d \n\r", port_number) ;
					StartScript (port_number) ;
				}
			}
		}
	}
	/* chetan 22/11/96 */

}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateCmdA(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	ISDN_STRINGS *isdn_str_ptr = &wan.port[port_number].isdn_info.strings;
	USHORT	TmpSr, number_of_strings, wait_ticks;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

/* sudhir 11/12/97 */
	if (wan.port[port_number].isdn_ta_enabled)
	{
		ConvertControls(modem_state_ptr->cmnd_string, isdn_str_ptr->
						init_string[modem_state_ptr->init_string_index]);
		modem_state_ptr->init_string_index++;
		number_of_strings = NUMBER_OF_ISDN_INIT_STRINGS;
	}
	else
	{
		ConvertControls(modem_state_ptr->cmnd_string, modem_str_ptr->
								init_string[modem_state_ptr->init_string_index]);
		modem_state_ptr->init_string_index++;
		number_of_strings = NUMBER_OF_MODEM_INIT_STRINGS;
	}

	if ((modem_state_ptr->cmnd_string[0]) && (modem_state_ptr->init_string_index <= number_of_strings)) 
/* sudhir 11/12/97 */
	{
#if 0
/* As in Proxy2.03 bin with delay between A & T & rest commands */
		WriteToPort(port_number, modem_state_ptr->cmnd_string, 1); 

		modem_state_ptr->state = MDM_STATE_CMD_T;
		modem_state_ptr->wait_ticks = 0;
#endif

		TmpSr = _GPL();
		_SPL(7);
		FlushRxBufferUART(port_number);
		_SPL(TmpSr);
/* sudha 07 July 1999.Taken from SmallProxy */
		WriteToPort(port_number, &modem_state_ptr->cmnd_string[0], 0);  
		modem_state_ptr->state = MDM_STATE_WAIT_OK ;
		modem_state_ptr->wait_ticks = MDM_WAIT_FOR_OK ;

	}
	else if(modem_state_ptr->init_string_index > number_of_strings)
	{
		if (!wan.port[port_number].modem_info.auto_answer)
		{	/* If caller goto dial */

/* sudha 27 June 1999 */
/* sudha 21-Oct-1999. Changed this var to an array var */
			if ( need_to_proceed_with_modem_dial_state_and_not_idle_state[port_number] == TRUE )
			{
#if 0
/* As in Proxy2.03 bin with delay between A & T & rest commands */
				modem_state_ptr->wait_ticks = MDM_DELAY_DIAL;
#endif
				modem_state_ptr->wait_ticks = 0;	/* Jo MDM_DELAY_DIAL - 0*/
/*sudhir 6/1/98 */
				if (wan.port[port_number].isdn_ta_enabled)
					modem_state_ptr->state = ISDN_STATE_REINIT;
				else
				{
/*sudhir 6/1/98 */
					modem_state_ptr->state = MDM_STATE_DIAL_A;
/* sudha 07 July 1999.Taken from SmallProxy */
					MdmStateDialA(port_number);	/* Jo Direct call 4/2/99 */
				 }
			}
			else
			{
/* sudha 21-Oct-1999. Changed this var to an array var */
				need_to_proceed_with_modem_dial_state_and_not_idle_state[port_number] = TRUE;				

				if (wan.port[port_number].isdn_ta_enabled)
				{
					WriteToPort (port_number, "AT*FS1\r", 0);		
					printf ("MSM1: Reinitializing ISDN TA for port %04x\n",port_number);

					modem_state_ptr->state = ISDN_STATE_ATFS1 ;
					modem_state_ptr->wait_ticks = ISDN_WAIT_BEFORE_DIAL;
					return;
				}
/* sudha 16 July 1999.To reset ISDN TA */
				WriteToPort(port_number, "ATS0=0\r", 0);		
				printf ("WAN1: Setting Port %04x to IDLE\n",port_number);
				modem_state_ptr->state = MDM_STATE_IDLE;	/* move the state */

				SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
			}
		}
		else
		{					/* If callee goto wait for ring */
			TmpSr = _GPL();
			_SPL(7);
			FlushRxBufferUART(port_number);
			_SPL(TmpSr);
			PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */

/* sudha 16 July 1999.To reset ISDN TA */

			if (wan.port[port_number].isdn_ta_enabled)
			{
				WriteToPort (port_number, "AT*FS1\r", 0);		
				printf ("MSM2: Reinitializing ISDN TA for port %04x\n",port_number);

				modem_state_ptr->state = ISDN_STATE_ATFS1 ;
				modem_state_ptr->wait_ticks = ISDN_WAIT_BEFORE_DIAL;
				return;

			}

			if (is_remote_access_enabled_on_port (port_number)) 
			{
				printf ("WAN3: Setting Port %04x to Answering\n",port_number);
				WriteToPort(port_number, "ATS0=1\r", 0);		
			}

			modem_state_ptr->state = MDM_STATE_WAIT_RING;
			modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;

			/* sudha 27 June 1999 */
			SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);

		}
	}
	else
	{
		modem_state_ptr->state = MDM_STATE_CMD_A ;
		modem_state_ptr->wait_ticks = 0 ;/* Jo 1-0 */
		MdmStateCmdA(port_number);	/* Jo Direct Call 4/2/99 */
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	ModemStateCmdT(USHORT port_number)
{
/* sudha 07 July 1999.Taken from SmallProxy to init modem in a single shot */
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	
	if (modem_state_ptr->cmnd_string[1]) 
/* sudhir 11/12/97 */
	{
		WriteToPort(port_number, &modem_state_ptr->cmnd_string[1], 1); 
				
		modem_state_ptr->state = MDM_STATE_CMD_REST;
		modem_state_ptr->wait_ticks = 0;
	}
	else
	{
		WriteToPort(port_number, "\r", 1);		
		if (!wan.port[port_number].modem_info.auto_answer)
		{	/* If caller goto dial */
			modem_state_ptr->wait_ticks = MDM_DELAY_DIAL;
			modem_state_ptr->state = MDM_STATE_DIAL_A;
		}
		else
		{					/* If callee goto wait for ring */
			TmpSr = _GPL();
			_SPL(7);
			FlushRxBufferUART(port_number);
			_SPL(TmpSr);
			PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */
			modem_state_ptr->state = MDM_STATE_WAIT_RING;
			modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;
		}
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateCmdRest(USHORT port_number)
{
/* sudha 07 July 1999.Taken from SmallProxy to init modem in a single shot */
	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	/* Flush the Receive buffer of this port */
	TmpSr = _GPL();
	_SPL(7);
	FlushRxBufferUART(port_number);
	_SPL(TmpSr);


	if (modem_state_ptr->cmnd_string[2])  
	{
		WriteToPort(port_number, &modem_state_ptr->cmnd_string[2], 0);  
		modem_state_ptr->state = MDM_STATE_WAIT_OK ;
		modem_state_ptr->wait_ticks = MDM_WAIT_FOR_OK ;
	}
	else
	{
		WriteToPort(port_number, "\r", 1);		
		if (!wan.port[port_number].modem_info.auto_answer)
		{	/* If caller goto dial */
			modem_state_ptr->wait_ticks = MDM_DELAY_DIAL;
			modem_state_ptr->state = MDM_STATE_DIAL_A;
		}
		else
		{					/* If callee goto wait for ring */
			TmpSr = _GPL();
			_SPL(7);
			FlushRxBufferUART(port_number);
			_SPL(TmpSr);
			PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */
			modem_state_ptr->state = MDM_STATE_WAIT_RING;
			modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;
		}
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateWaitOK(USHORT port_number)
{
//	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	if (SearchLnBuffFor(port_number, modem_str_ptr->modem_ok_mesg))
	{
		modem_state_ptr->state = MDM_STATE_CMD_A ;
		modem_state_ptr->wait_ticks = 0 ;/* Jo 1-0 */
		MdmStateCmdA(port_number);	/* Jo Direct Call 4/2/99 */
/* sudha 07 July 1999.Taken from SmallProxy */
		return ;
	}

	if (SearchLnBuffFor(port_number, modem_str_ptr->modem_error_mesg)) {
#ifdef EVENT_LOG		/* vidy 11/02/98 */
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "Modem Init Error on WAN %d", port_number + 1);
	write_log(log_message);
}
#endif
		modem_state_ptr->retry_count++;
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
		modem_state_ptr->last_error = MDM_ERR_CMD;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
		return;
	}
	if ( ! modem_state_ptr->wait_ticks) {		/* don't move till ticks expire */
		/* This is a timeout case */
#ifdef EVENT_LOG		/* vidy 11/02/98 */
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "No modem response on WAN %d", port_number + 1);
	write_log(log_message);
}
#endif
		modem_state_ptr->retry_count++;
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
		modem_state_ptr->last_error = MDM_ERR_CMD_TMOUT;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateDialA(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	modem_state_ptr->this_end_dialed = TRUE;
	modem_state_ptr->dialing_initiated_from_proxy_successful = FALSE;

	/* Bring up DTR since Command Mode dialing */ /* vidy 13/01/98 */
	SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);

	if ( ! modem_str_ptr->dial_string[0]) {
		modem_state_ptr->state = MDM_STATE_WAIT_CONN;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.dial_timeout;
#if PROXY_SERVER
		modem_state_ptr->flush_rx_buffer_counter = 3 ;
#endif
		return;
	}
	ConvertControls(modem_state_ptr->cmnd_string, modem_str_ptr->dial_string);
	
#ifdef EVENT_LOG		/* vidy 11/02/98 */
{
	char log_message[LOG_NORMAL_MSG_LEN];
	sprintf(log_message, "Dialing on WAN %d", port_number + 1);
	write_log(log_message);
}
#endif
	/* Flush the Receive buffer of this port */
	TmpSr = _GPL();
	_SPL(7);
	FlushRxBufferUART(port_number);
	_SPL(TmpSr);
	WriteToPort(port_number, &modem_state_ptr->cmnd_string, 0);
	modem_state_ptr->state = MDM_STATE_WAIT_CONN;
#if PROXY_SERVER
	modem_state_ptr->flush_rx_buffer_counter = 3 ;
#endif
	modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.dial_timeout;
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateWaitConn(USHORT port_number)
{
	USHORT	ModemResponded;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;
	USHORT	TmpSr;
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	char log_message[LOG_NORMAL_MSG_LEN];
	log_message[0] = 0;
#endif

#if PROXY_SERVER
	if (modem_state_ptr->flush_rx_buffer_counter)
   {
      FlushRxBufferUART(port_number) ;
      return ;
   }
#endif

	/* check if the modem has responded by now */
	if (((wan.port[port_number].connection_started_by_modem_response) && (SearchLnBuffFor(port_number, modem_str_ptr->modem_response_string))) ||
		  ((wan.port[port_number].connection_started_by_DCD) && (is_DCD_present(port_number))))
	{
		modem_state_ptr->state = MDM_STATE_DELAY_ONLINE;
		TmpSr = _GPL();
		_SPL(7);
#if PROXY_SERVER
#else
		Flush_Rx_Tx_Buffers(port_number);
#endif
		_SPL(TmpSr);
		modem_state_ptr->wait_ticks =  1;	
		return ;
	}

	ModemResponded = TRUE;
	if (SearchLnBuffFor(port_number, modem_str_ptr->modem_error_mesg))
	{
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	sprintf(log_message, "Modem reports ERROR on WAN %d", port_number + 1);
#endif
		modem_state_ptr->last_error = MDM_ERR_DIALING;
	}
	else
		if (SearchLnBuffFor(port_number, modem_str_ptr->modem_busy_mesg))
		{
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	sprintf(log_message, "Modem reports BUSY on WAN %d", port_number + 1);
#endif
			modem_state_ptr->last_error = MDM_ERR_BUSY;
		}
		else
		if (SearchLnBuffFor(port_number, modem_str_ptr->modem_no_carrier_mesg)) 
		{
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	sprintf(log_message, "Modem reports NO CARRIER on WAN %d", port_number + 1);
#endif
			modem_state_ptr->last_error = MDM_ERR_NO_CARRIER;
		}
		else
		if (SearchLnBuffFor(port_number, modem_str_ptr->modem_no_dial_tone_mesg))
		{
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	sprintf(log_message, "Modem reports NO DIAL TONE on WAN %d", port_number + 1);
#endif
			modem_state_ptr->last_error = MDM_ERR_NO_DTONE;
		}
		else
		if (SearchLnBuffFor(port_number, modem_str_ptr->modem_no_answer_mesg))
		{
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	sprintf(log_message, "Modem reports NO ANSWER on WAN %d", port_number + 1);
#endif
			modem_state_ptr->last_error = MDM_ERR_NO_ANSWR;
		}
		else
		{
			ModemResponded = FALSE;
		}
#ifdef EVENT_LOG		/* vidy 11/02/98 */
		if (log_message[0])
		{
			write_log(log_message);
		}
#endif



	if (ModemResponded)
	{
	/* sudhir added for isdn ta support */		
		modem_state_ptr->retry_count++;
		if (wan.port[port_number].isdn_ta_enabled)
		{
			if (modem_state_ptr->last_error == MDM_ERR_BUSY ||
			 modem_state_ptr->last_error == MDM_ERR_NO_CARRIER ||
			 modem_state_ptr->last_error == MDM_ERR_NO_DTONE ||
   		 modem_state_ptr->last_error == MDM_ERR_NO_ANSWR)
			{
				modem_state_ptr->state = MDM_STATE_DIAL_A;
				modem_state_ptr->wait_ticks = ISDN_WAIT_BEFORE_DIAL;
			}
			else
			{
				modem_state_ptr->state = MDM_STATE_OFFLINE;
				modem_state_ptr->wait_ticks = ISDN_WAIT_BEFORE_DIAL;
			}
			return;
		}
		else
		{
			SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
			modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
			modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
		}
		return;
	}
	if (!modem_state_ptr->wait_ticks)
	{
		/* This is a timeout case */
		modem_state_ptr->retry_count++;
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
		modem_state_ptr->last_error = MDM_ERR_CONN_TMOUT;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
		WriteToPort(port_number, "\r", 1);	/* Reset the modem */
#ifdef EVENT_LOG		/* vidy 11/02/98 */
		sprintf(log_message, "No Connect response from modem  on WAN %d", port_number + 1);
		write_log(log_message);
#endif
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateWaitRing(USHORT port_number)
{
	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	if (PortModemPoweredOffAndOn(port_number))
	{
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
		modem_state_ptr->wait_ticks = MDM_POWER_ON_DELAY;
		return;
	}

	/* check for CD */
	if ((wan.port[port_number].connection_started_by_DCD) && (is_DCD_present(port_number)))
	{
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	{
		char log_message[LOG_NORMAL_MSG_LEN];
		sprintf(log_message, "Modem connected on WAN %d", port_number + 1);
		write_log(log_message);
	}
#endif
		/* printf ("DCD found on port %d\n", port_number) ; */
		TmpSr = _GPL();
		_SPL(7);
		Stop_Tx_and_Rx(port_number);
		Just_FlushRxBufferUART(port_number);
		Just_FlushTxBufferUART(port_number);
/* Added By Naveen ... */
      Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added By Naveen */
		_SPL(TmpSr);

		/* Now change the state */
		modem_state_ptr->state = MDM_STATE_DELAY_ONLINE;

/*		inform_hldd_and_change_to_async_hdlc(port_number); */
		return;
	}

	/* check if the modem has responded by now */
	if (SearchLnBuffFor(port_number, modem_str_ptr->modem_ring_mesg))
	{
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	{
		char log_message[LOG_NORMAL_MSG_LEN];
		sprintf(log_message, "Modem ring on WAN %d", port_number + 1);
		write_log(log_message);
	}
#endif
		TmpSr = _GPL();
		_SPL(7);
		FlushRxBufferUART(port_number);
		_SPL(TmpSr);
		modem_state_ptr->state = MDM_STATE_WAIT_CONN;
#if PROXY_SERVER
		modem_state_ptr->flush_rx_buffer_counter = 0 ;
#endif
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.dial_timeout;
		return;
	}
	modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;	/* check ring after some tm */

	return ;
}


/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateHupDTRDown(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	int	hardware_model;
	
	/* Set the DTR down for some time */

	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number);

	if (wan.port[port_number].modem_info.dtr_dial)
	{	/* if DTR dialing is enabled, to hangup just lower DTR */
		modem_state_ptr->state = MDM_STATE_IDLE;
	}
	else
	{			/* if not DTR dialing, after lowering DTR, check for CD */
		/* Wait for some time and check for CD */
		printf ("MODEM:Hanging Up modem on port %04x\n",port_number);
		modem_state_ptr->state = MDM_STATE_HUP_CHK_CD;
		modem_state_ptr->wait_ticks = MDM_DTR_DN_TIME;
	}

#if 0
	hardware_model = lsl_control(GET_HARDWARE_MODEL);
	if ((hardware_model == MODEL_MTSR1_202ST) || (hardware_model == MODEL_MTSR1_202NT))
	{
		printf ("MSM: Reiniting ISDN TA on port %04x\n",port_number);
		WriteToPort(port_number, "AT*fs1\r", 0);		
	}
#endif
}
/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateHupCheckCD(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;
	int	hardware_model;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	/* if DCD is still present and async we need to send out HangupStr */
	if (wan.port[port_number].connection_dropped_by_DCD && is_DCD_present(port_number) && wan.port[port_number].asyncport)
	{
		printf ("MODEM: Connection is closed by DCD on port %04x\n",port_number);
		/* we need to send HUP command to modem */
      ConvertControls (modem_state_ptr->cmnd_string, modem_str_ptr->modem_hangup_string) ;

		modem_state_ptr->cmnd_string_index = 0;

		if (modem_state_ptr->cmnd_string[0])
		{
			SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);
			modem_state_ptr->state = MDM_STATE_HUP_STR;
			return;
		}
	}

	hardware_model = lsl_control(GET_HARDWARE_MODEL);

/* After every hangup we have to reset ISDN TA . If we don't reinit it will
	lock the TA after few hangups*/
	
	if ((hardware_model == MODEL_MTSR1_202ST) || (hardware_model == MODEL_MTSR1_202NT))
	{
#if 0
		change_protocol_to_async(port_number, FALSE,ASYNC_PPP_OR_SLIP_MODE);
#endif
		SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		inform_hldd_and_change_to_async(port_number);
		modem_state_ptr->state = MDM_STATE_RESET_ISDN;	/* move the state */
		modem_state_ptr->wait_ticks = 3;
		printf ("MSM3: Reinitializing ISDN TA for port %04x\n",port_number);
		WriteToPort (port_number, "AT*FS1\r", 0);		
		return;
	}

	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */

	if (wan.port[port_number].hangup_and_redial == TRUE)
	{
		printf ("MODEM: Hangup and redial on port %04x\n",port_number);
		wan.port[port_number].hangup_and_redial = FALSE;
		if (!wan.port[port_number].modem_info.auto_answer)
		{
			modem_state_ptr->state = MDM_STATE_DIAL_A;	/* move the state */
			modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
		}
	}
	else
	{
		if (is_remote_access_enabled_on_port (port_number))
		{
			printf ("WAN1: Setting Port %04x to Answering\n",port_number);
			set_modem_to_answering_mode (port_number);
		}
		else
		{
			WriteToPort(port_number, "ATS0=0\r", 0);		
			printf ("WAN2: Setting Port %04x to IDLE\n",port_number);
			modem_state_ptr->state = MDM_STATE_IDLE;	/* move the state */
/* sudha 27 June 1999 */
			SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */

		}
	}
	inform_hldd_and_change_to_async(port_number);
}

#if 0
void inform_hldd(USHORT port_number)
{
	if (wan.port[port_number].packet_analysis_on == TRUE)
	{
		wan.port[port_number].packet_analysis_on = FALSE;
		return;
	}

	lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id, LOWER_DEVICE_DRIVER_DOWN, port_number);

	if (wan.port[port_number].script_enabled)
	{
		if (wan.port[port_number].restart_script_on_comm_failure)
		{
			if (wan.port[port_number].asyncport
					&& !wan.port[port_number].direct_connect_enabled)
			{
				if (!ScriptRunning ((BYTE) port_number))
				{
					printf ("Changing to async : Ready to execute script for port : %d \n\r", port_number) ;
					StartScript (port_number) ;
				}
			}
		}
	}
}
#endif

void MdmStateResetISDN(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */

#if 0
	modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
#endif

/* sudha 07 July 1999.For ras support */
/* For hangup & redial support */
	if (wan.port[port_number].hangup_and_redial == TRUE)
	{
		printf ("MODEM: Hangup and redial on port %04x\n",port_number);
		wan.port[port_number].hangup_and_redial = FALSE;
		if (!wan.port[port_number].modem_info.auto_answer)
		{
			modem_state_ptr->state = MDM_STATE_DIAL_A;	/* move the state */
			modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
		}
	}
	else
	{
		if (is_remote_access_enabled_on_port (port_number))
		{
			printf ("WAN2: Setting Port %04x to Answering\n",port_number);
			set_modem_to_answering_mode (port_number);
		}
		else
		{
			WriteToPort(port_number, "ATS0=0\r", 0);		
			printf ("WAN3: Setting Port %04x to IDLE\n",port_number);
			modem_state_ptr->state = MDM_STATE_IDLE;	/* move the state */
			modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;	/* no activity */
/* sudha 27 June 1999 */
			SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */

		}
	}

#if 0	 /* sudha 07 July 1999 */
	modem_state_ptr->state = MDM_STATE_IDLE;
	modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;	/* no activity */
#endif 
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateHupStr(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	static	BYTE *BreakStr = "<BREAK>";
	BYTE	CmdStrBuff[PHONE_NUM_LEN + MDM_DIAL_PREFIX_LEN * 2];
	BYTE	*CmdStr, *bptr;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	CmdStr = &modem_state_ptr->cmnd_string[modem_state_ptr->cmnd_string_index];

	if (!*CmdStr)
	{
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_IDLE;	/* move the state */

		inform_hldd_and_change_to_async(port_number);
		return;
	}
	if (*CmdStr == MDM_CMD_PAUSE_CHAR) {
		modem_state_ptr->cmnd_string_index++;
		modem_state_ptr->wait_ticks = MDM_CMD_PAUSE_TIME;
		return;
	}
	/* check for break verb */
	strcpy(CmdStrBuff, CmdStr);
	strupr(CmdStrBuff);
	if (bptr = strstr(CmdStrBuff, BreakStr)) {
		modem_state_ptr->cmnd_string_index += bptr - CmdStrBuff;
		modem_state_ptr->cmnd_string_index += strlen(BreakStr);
		TmpSr = _GPL();
		_SPL(7);
		SetBreakUART(port_number);
		_SPL(TmpSr);

		/* wait for break time */
		modem_state_ptr->state = MDM_STATE_BREAK;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.break_len;	/* no activity */
		return;
	}
	if (bptr = strchr(CmdStr, MDM_CMD_PAUSE_CHAR)) {
		WriteToPort (port_number, CmdStr, bptr - CmdStr);
		modem_state_ptr->cmnd_string_index += bptr - CmdStr;
	} else {
		WriteToPort (port_number, CmdStr, 0);
		modem_state_ptr->cmnd_string_index += strlen(CmdStr);
		modem_state_ptr->wait_ticks = 2;	/* no activity */
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateBreak(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;
	modem_state_ptr->state = MDM_STATE_HUP_STR;
	TmpSr = _GPL();
	_SPL(7);
	ResetBreakUART(port_number);
	_SPL(TmpSr);
}
/****************************************************************************
Routine	:
Synop	: As soon as the "CONNECT" string appears we shouldn't start business
****************************************************************************/
#if PROXY_SERVER
void record_connect_message (USHORT) ;
#endif
void	MdmStateDelayOnline(USHORT port_number)
{
	USHORT	TmpSr;

	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;
	
	if (!modem_state_ptr->this_end_dialed || modem_state_ptr->call_back_on)
		modem_state_ptr->remote_access_client_connected = TRUE;
	else 
		modem_state_ptr->remote_access_client_connected = FALSE;
		
		
	if (modem_state_ptr->call_back_on)
	{
      /* Chidanand - 17 May 1997 - Postponed and handled in 
         inform_hldd_and_change_to_async_hdlc() to avoid
         SLIP coming up on call back.
      */
		/* modem_state_ptr->call_back_on = FALSE ; */
		wan.port[port_number].modem_info.auto_answer = TRUE;
	}
	TmpSr = _GPL();
	_SPL(7);
	Stop_Tx_and_Rx(port_number);
#if PROXY_SERVER
   /* Get the connect message */
   record_connect_message (port_number) ;
#ifdef EVENT_LOG		/* vidy 11/02/98 */
{
	char log_message[100];
		sprintf(log_message, "Modem reports %s on WAN %d",
      	wan.port[port_number].statistics.modem_connect_message,
			port_number + 1);
		write_log(log_message);
}
#endif
   Flush_Rx_Tx_Buffers(port_number);
#else
#endif
	Just_FlushRxBufferUART(port_number);
	Just_FlushTxBufferUART(port_number);
/* Added By Naveen ... */
   Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added By Naveen */
	_SPL(TmpSr);

#if 0 /* Code Remove By Naveen */
	/* check if all the queues are in the reset state by checking the forward
	or backward pointers */
	if ((wan.port[port_number].xmited_tx_list.sptr_forward_link != NULL)
	    || (wan.port[port_number].current_rx_list.sptr_forward_link != NULL))
	{
		/* printf ("Buffers not cleared off\n") ; */
		flush_rx_buffers_sticking_around (port_number) ;
		return ;
	}
#endif

	/* Now change the state */
	inform_hldd_and_change_to_async_hdlc(port_number);
}	


void	wan_dec_modem_ticks(void)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number < wan.number_of_ports; ++port_number)
	{
		if(wan.port[port_number].modem_info.status.wait_ticks)
			 wan.port[port_number].modem_info.status.wait_ticks--;
/* Sachin 03/07/1996 */
		if(wan.port[port_number].modem_info.status.call_back_delay)
			 wan.port[port_number].modem_info.status.call_back_delay--;
/* Sachin 03/07/1996 */
#if PROXY_SERVER
      if (wan.port[port_number].modem_info.status.flush_rx_buffer_counter)
         wan.port[port_number].modem_info.status.flush_rx_buffer_counter-- ;
#endif
	}
}

/**************************     							*******************************/
/* The following routines are needed for using the AHDLC microcode from
motorola. But we find that on RF200 the microcode is running into some
problem. SO we resort to software-quoting for rf200
*/

inform_hldd_and_change_to_async_hdlc(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
		
	modem_state_ptr->state = MDM_STATE_ONLINE;
	modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;

#if 0
	if (wan.port[port_number].asyncport == TRUE && 
		wan.port[port_number].modem_info.dial_in_out_type &&
		get_wan_port_owner(port_number) == OWNED_BY_NONE)
	{
		/* Restart the stopped SCC */
		Start_Tx_and_Rx(port_number);

		/* For async ports that are on the answering end, don't inform HLDD.
		** Instead wait for and analyse the first packet.
		*/
		wan.port[port_number].packet_analysis_on = TRUE;
		start_analysing_packets_on_port(port_number);
		wan.port[port_number].analysed_once = FALSE;

/* sudhir 26/6/97 */
#ifdef _SHELL_MENU__
		check_for_user_name_and_send_prompt (port_number);
#endif
      wan.port[port_number].shell_menu_response_length = 0;

		/* Wait for a few seconds for a packet. After that much time expires, 
		** allot the port to AG inbound module rather than the HLDD.
		*/
		wan.port[port_number].packet_analysis_timer = ANALYSIS_WAIT_SECONDS;
		return;
	}
#endif

	/* Kamalnath 20\03\1997 SLIP */
	/* Chidanand 17/5/1997 Added condition for call back */
	if ((wan.port[(USHORT)port_number].modem_info.status.call_back_on == FALSE) &&
		(check_if_slip_is_enabled(port_number) == TRUE))
	{
		printf ("Running slip on (dialing) port %d\n", port_number) ;
		change_protocol_to_async(port_number, TRUE, SLIP_MODE);
		
		/* inform HLDD that port is up */
		lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			LOWER_DEVICE_DRIVER_SLIP_UP, port_number);
	}
	else
	{
   	if (modem_state_ptr->call_back_on)
	   {
         /* Chidanand - 17 May 1997 - Done here to avoid
            SLIP coming up on call back.
         */
		   modem_state_ptr->call_back_on = FALSE ; 
	   }

		change_protocol_to_async_hdlc(port_number);
		
		/* inform HLDD that port is up */
		lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			LOWER_DEVICE_DRIVER_UP, port_number);
	}
/* Kamalnath 20\03\1997 SLIP */

	/* inform HLDD that port is up */
	lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
   wan.port[port_number].statistics.connection_up_time = 0 ;
   wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
   wan.port[port_number].statistics.connection_bytes_received = 0 ;
   wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
   wan.port[port_number].statistics.connection_packets_received = 0 ;
   wan.port[port_number].statistics.number_of_calls++ ;
#endif
}

change_protocol_to_async_hdlc(USHORT port_number)
{
	USHORT	TmpSr;
	USHORT wan_buffer_size;

	TmpSr = _GPL();
	_SPL(7);

/* Sachin 05/07/1996 */
	flush_rx_buffers_sticking_around (port_number) ;
/* Sachin 05/07/1996 */

	Flush_Rx_Tx_Buffers(port_number);

#ifndef SOFTWARE_QUOTING
	wan_buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, port_number+1);
#ifdef DEBUG
	printf ("Changing protocol to Async HDLC\n") ;
#endif /* DEBUG */
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	{
		char log_message[LOG_NORMAL_MSG_LEN];
		sprintf(log_message, "Changing to PPP on WAN %d", port_number + 1);
		write_log(log_message);
	}
#endif

	switch(port_number)
	{
		case	0 :	
				InitSCC2_as_Async_HDLC(GetBaudDivisor(wan.port[port_number].port_speed),wan_buffer_size); 
				TurnOnTXAndRXOfSCC2();
				break;

		case	1 :
				InitSCC3_as_Async_HDLC(GetBaudDivisor(wan.port[port_number].port_speed),wan_buffer_size); 
				TurnOnTXAndRXOfSCC3();
				break;

		case	2 :
				InitSCC4_as_Async_HDLC(GetBaudDivisor(wan.port[port_number].port_speed),wan_buffer_size); 
				TurnOnTXAndRXOfSCC4();
				break;

		default:
				printf ("Invalid port to change protocol to AHDLC\n");
				break;
	}
#else
	change_protocol_to_async(port_number, TRUE);

#endif 			/* SOFTWARE_QUOTING */

	_SPL(TmpSr);
}

inform_hldd_and_change_to_async(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	
	modem_state_ptr->remote_access_client_connected = FALSE;
	modem_state_ptr->this_end_dialed = FALSE;

	if (wan.port[port_number].packet_analysis_on == TRUE)
	{
		wan.port[port_number].packet_analysis_on = FALSE;
		return;
	}
	

	lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id, LOWER_DEVICE_DRIVER_DOWN, port_number);
	/* Kamalnath 14\03\1997 SLIP added fourth parameter */
	change_protocol_to_async(port_number, FALSE,ASYNC_PPP_OR_SLIP_MODE);

	/* if down by no demand don't restart the script */
	if ( !wan.port[port_number].port_down_by_no_demand &&
			wan.port[port_number].script_enabled)
	{
		if (wan.port[port_number].restart_script_on_comm_failure)
		{
			if (wan.port[port_number].asyncport
					&& !wan.port[port_number].direct_connect_enabled)
			{
				if (!ScriptRunning ((BYTE) port_number))
				{
					printf ("Changing to async : Ready to execute script for port : %d \n\r", port_number) ;
					StartScript (port_number) ;
				}
			}
		}
	}
}

/* Kamalnath 14\03\1997 SLIP added fourth parameter */
change_protocol_to_async(USHORT port_number, int for_routing, int mode)
{
	USHORT	TmpSr;
	USHORT wan_buffer_size;

	TmpSr = _GPL();
	_SPL(7);

	Flush_Rx_Tx_Buffers(port_number);

	wan_buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, port_number+1);
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	{
		char log_message[LOG_NORMAL_MSG_LEN];
		sprintf(log_message, "Changing to UART serial WAN %d", port_number + 1);
		write_log(log_message);
	}
#endif

	switch(port_number){
		case	0 :	
				/* Kamalnath 14\03\1997 SLIP added fourth parameter */
				InitSCC2(GetBaudDivisor(wan.port[port_number].port_speed), wan_buffer_size, for_routing, mode); 
 				TurnOnTXAndRXOfSCC2();
				break;

		case	1 :
				/* Kamalnath 14\03\1997 SLIP added fourth parameter */
				InitSCC3(GetBaudDivisor(wan.port[port_number].port_speed), wan_buffer_size, for_routing, mode); 
				TurnOnTXAndRXOfSCC3();
				break;

		case	2 :
				/* Kamalnath 14\03\1997 SLIP added fourth parameter */
				InitSCC4(GetBaudDivisor(wan.port[port_number].port_speed), wan_buffer_size, for_routing, mode); 
				TurnOnTXAndRXOfSCC4();
				break;

		default:
				return;
	}

	_SPL(TmpSr);
}
/**************************     							*******************************/

Flush_Rx_Tx_Buffers(USHORT port_number)
{
	WAN_TX_DESCRIPTOR *sptr_current_tx_descriptor;
	WAN_RX_DESCRIPTOR *sptr_current_rx_descriptor;

	Stop_Tx_and_Rx(port_number);

	/* Free up all the scheduled_for_rx  descriptors cause we are reinitialising
	the RxBDs */

	while (sptr_current_rx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].scheduled_for_rx))
	{
	   add_entry_to_list (&wan.port[port_number].free_rx_list,
										(LINK *) &sptr_current_rx_descriptor->links);
	}

	/* release current and all queued up descriptors by adding them to the 
	xmitted list. It will take care of freeing up the descriptor properly. */

	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].scheduled_for_tx) ) {
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}

	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].current_tx_list) ) {
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}

/* sudha 05 July 1999.Ported the packet length prioritization changes from 
Sir */

#if SMALL_PACKETS_FIRST
	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].current_first_tx_list) ) {
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}
#endif

	wan.port[port_number].sptr_current_tx_descriptor = NULL;

}

Stop_Tx_and_Rx(port_number)
{
	switch(port_number){
		case	0 :						/* SCC 2 */
				Stop_Rx_Tx_on_SCC2();
				break;
		case	1 :						/* SCC 3 */
				Stop_Rx_Tx_on_SCC3();
				break;
		case	2 :						/* SCC 4 */
				Stop_Rx_Tx_on_SCC4();
				break;
		default:
				return;
	}
}

Start_Tx_and_Rx(port_number)
{
	switch(port_number){
		case	0 :						/* SCC 2 */
				Start_Rx_Tx_on_SCC2();
				break;
		case	1 :						/* SCC 3 */
				Start_Rx_Tx_on_SCC3();
				break;
		case	2 :						/* SCC 4 */
				Start_Rx_Tx_on_SCC4();
				break;
		default:
				return;
	}
}


/****************************************************************************
Routine	:	MdmStateDTRDialLinkDn
Synop	: Brings the link down by dropping DTR. Informs PPP that LLDD is down.
Goes to DTR_UP state.
****************************************************************************/
void	MdmStateDTRDialLinkDn(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	/* Set the DTR down for some time */

	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number);
	
	if (wan.port[port_number].asyncport == FALSE)
	{
		lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			LOWER_DEVICE_DRIVER_DOWN, port_number);

		reinitiaize_SYNC_port(port_number);		
	}
	else
	{		
		inform_hldd_and_change_to_async(port_number);
	} 

	modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_UP;	/* move the state */
	modem_state_ptr->wait_ticks = DTR_DIAL_DTR_DN_TIME;
}



/****************************************************************************
Routine	:	MdmStateDTRDialDTRDn
Synop	: Brings DTR down for some time. To facilitate DTR dialing.
****************************************************************************/
void	MdmStateDTRDialDTRDn(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)
		return;

	if (wan.port[port_number].connection_started_by_DCD && is_DCD_present(port_number))
	{
		if (wan.port[port_number].asyncport == FALSE)
		{
			reinitiaize_SYNC_port(port_number);

			modem_state_ptr->state = MDM_STATE_ONLINE;
			modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;

			/* inform HLDD that port is up */
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				LOWER_DEVICE_DRIVER_UP, port_number);
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
         wan.port[port_number].statistics.connection_up_time = 0 ;
         wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
         wan.port[port_number].statistics.connection_bytes_received = 0 ;
         wan.port[port_number].statistics.number_of_calls++ ;
#endif
		}
		else
		{
			TmpSr = _GPL();
			_SPL(7);
			Stop_Tx_and_Rx(port_number);
			Just_FlushRxBufferUART(port_number);
			Just_FlushTxBufferUART(port_number);
/* Added By Naveen ... */
         Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added By Naveen */
			_SPL(TmpSr);

         /* Now change the state */
			inform_hldd_and_change_to_async_hdlc(port_number);

		}
		modem_state_ptr->check_online_count = 0;		
		return;
	} 

	/* Set the DTR down for some time */
	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number);

	modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_UP;	/* move the state */
	modem_state_ptr->wait_ticks = DTR_DIAL_DTR_DN_TIME;
}

	
/****************************************************************************
Routine	:	MdmStateDTRDialDTRUp
Synop	: Brings up DTR and then changes state to check for CD.
****************************************************************************/
void	MdmStateDTRDialDTRUp(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	/* Set the DTR up back */
	SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);

	modem_state_ptr->check_online_count = 0;
	modem_state_ptr->state = MDM_STATE_DTR_DIAL_CHK_ONLINE;	/* move the state */
	modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;

}

/****************************************************************************
Routine	: MdmStateDTRDialChkOnline
Synop	: Checks for CD . If it is not up for a long time, initiates redial
by dropping DTR again.
****************************************************************************/

void	MdmStateDTRDialChkOnline(USHORT port_number)
{
	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)
		return;
		
	if (wan.port[port_number].connection_started_by_DCD && is_DCD_present(port_number))
	{
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	{
		char log_message[LOG_NORMAL_MSG_LEN];
		sprintf(log_message, "Modem connected on WAN %d", port_number + 1);
		write_log(log_message);
	}
#endif
		if (wan.port[port_number].asyncport == FALSE)
		{
			reinitiaize_SYNC_port(port_number);

			modem_state_ptr->state = MDM_STATE_ONLINE;
			modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;

			/* inform HLDD that port is up */
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				LOWER_DEVICE_DRIVER_UP, port_number);
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
         wan.port[port_number].statistics.connection_up_time = 0 ;
         wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
         wan.port[port_number].statistics.connection_bytes_received = 0 ;
         wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
         wan.port[port_number].statistics.connection_packets_received = 0 ;
         wan.port[port_number].statistics.number_of_calls++ ;
#endif
		}
		else
		{
			TmpSr = _GPL();
			_SPL(7);
			Stop_Tx_and_Rx(port_number);
			Just_FlushRxBufferUART(port_number);
			Just_FlushTxBufferUART(port_number);
/* Added By Naveen ... */
         Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added By Naveen */
			_SPL(TmpSr);

         /* Now change the state */
			inform_hldd_and_change_to_async_hdlc(port_number);
		}
		modem_state_ptr->check_online_count = 0;		/* Used below */
	} 
	else
	{
		/**
		 ** The modem may try to dial and the other end does not respond.
		 ** After waiting for some time, the modem goes ON-HOOK. Now, unless
		 ** DTR is toggled, the modem will not redial. So, we wait for some time
		 ** ( 1.5 minute => DTR_DIAL_MAX_CHECK_ONLINE * MDM_STAT_CHK_ONLINE)
		 ** and then toggle DTR to reinitiate dialing.
		**/
		if (!wan.port[port_number].modem_info.auto_answer)
			if (modem_state_ptr->check_online_count++  > DTR_DIAL_MAX_CHECK_ONLINE)
				modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_DN;

		modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;
	}
}

void	reinitiaize_SYNC_port(port_number)
{
	USHORT	TmpSr;

	TmpSr = _GPL();
	_SPL(7);
 
	Flush_Rx_Tx_Buffers (port_number);
	InitSCC (port_number);
	enable_wan_tx_rx (port_number);

	_SPL(TmpSr);
}


/* Sachin 03/07/1996 */

void MdmStateCallBack (USHORT port_number)
{
	/* MODEM_STATUS *modem_state_ptr = &wan.port[port_number].modem_info.status ; */
	MODEM_INFO *modem_info_ptr = &wan.port[port_number].modem_info ;

	/* wait for the client to hangup the line. TILL CD GOES OFF!! */
	if (wan.port[port_number].connection_dropped_by_DCD && is_DCD_present(port_number))
		return;

	inform_hldd_and_change_to_async (port_number) ;

	/* now don't let the modem auto answer to any calls in between */
	WriteToPort(port_number, "ATS0=0\r", 0);		
#ifdef EVENT_LOG		/* vidy 11/02/98 */
	{
		char log_message[LOG_NORMAL_MSG_LEN];
		sprintf(log_message, "Callback arranged on WAN %d.", port_number + 1);
		write_log(log_message);
	}
#endif

	modem_info_ptr->dtr_dial = FALSE;
	modem_info_ptr->auto_answer = FALSE ;
	modem_info_ptr->status.state = MDM_STATE_OFFLINE;
	/*
		Now, start treating the modem state machine as another normal
	   state machine
	*/
}

/* Sachin 03/07/1996 */




/* sudhir added for ISDN Proxy */
void MdmStateReinit (USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	
	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;
	
	strcpy (&modem_state_ptr->cmnd_string[0], "AT*FS1\r");
/*	append_cr_if_necessary (&modem_state_ptr->cmnd_string[0]); */

	if (modem_state_ptr->cmnd_string[0])
	{
		WriteToPort(port_number, &modem_state_ptr->cmnd_string[0], 0);  
		modem_state_ptr->wait_ticks = ISDN_WAIT_BEFORE_DIAL; 
/* sudha 07 July 1999 */
		modem_state_ptr->state = MDM_STATE_DIAL_A;
/* sudha 07 July 1999.Taken from SmallProxy */
		MdmStateDialA(port_number);	/* Jo Direct call 4/2/99 */
	}		
	return;
}
/* sudhir added for ISDN Proxy */



void append_cr_if_necessary (BYTE *string)
{
	int string_length ;

	string_length = strlen(string);
	if (string_length >= 2)
		if(string[string_length - 2] != '^')
			strcat(string, "^M"); 
}

enum BOOLEAN is_callback_on (USHORT port_number)
{
	return (wan.port[port_number].modem_info.status.call_back_on) ;
}

/* Sachin 13/07/1997 */
void null_out_modem_strings (USHORT port_number)
{
   memset (&wan.port[port_number].modem_info.strings, 0, sizeof (MODEM_STRINGS)) ;
}
/* Sachin 13/07/1997 */



/* sudhir calling this from WAN control */

void set_hangup_and_redial_flag_in_wan (port_number)
{
	printf ("Hanging Up Port %d\n",port_number);
	wan.port[port_number].hangup_and_redial = TRUE;
	return;
}

void set_modem_to_answering_mode (USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	
	wan.port[port_number].modem_info.auto_answer = TRUE;

	printf ("WAN : Changing Port %d to Answering\n",port_number);
	modem_state_ptr->state = MDM_STATE_OFFLINE;
	modem_state_ptr->wait_ticks = 0;

	SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number); 

/*	WriteToPort(port_number, "ATS0=1\r", 0);		 */

	return;
}


void set_modem_state_to_dial (USHORT real_port_number)
{
	MODEM_INFO	*modem_info_ptr;
	
	modem_info_ptr = &wan.port[real_port_number].modem_info;

	printf ("WAN :Changing Port %04x to Dialing\n",real_port_number);					
	modem_info_ptr->status.wait_ticks = MDM_DELAY_DIAL ;
	modem_info_ptr->status.state = MDM_STATE_DIAL_A ;
}
#if PROXY_SERVER

extern char *get_rx_buffer_SCC2 () ;
extern char *get_rx_buffer_SCC3 () ;
extern char *get_rx_buffer_SCC4 () ;

extern USHORT get_SCC2_rx_buffer_length () ;
extern USHORT get_SCC3_rx_buffer_length () ;
extern USHORT get_SCC4_rx_buffer_length () ;

void record_connect_message (USHORT port_number)
{
   BYTE *bptr_rx_buffer ;
   USHORT rx_buffer_length ;
   USHORT index ;

   switch (port_number)
   {
      case (0) :
         bptr_rx_buffer = get_rx_buffer_SCC2() ;
/*       rx_buffer_length = get_SCC2_rx_buffer_length() ; */
         break ;

      case (1) :
         bptr_rx_buffer = get_rx_buffer_SCC3() ;
/*       rx_buffer_length = get_SCC3_rx_buffer_length() ; */
         break ;

      case (2) :
         bptr_rx_buffer = get_rx_buffer_SCC4() ;
/*       rx_buffer_length = get_SCC4_rx_buffer_length() ; */
         break ;
   }

   rx_buffer_length = MODEM_CONNECT_MESSAGE_LENGTH ;

   memset (&wan.port[port_number].statistics.modem_connect_message[0], 0, MODEM_CONNECT_MESSAGE_LENGTH) ;

   index = 0 ;
	/* the buffer will be "\0D\0ACONNECT....\0D\0A...." */
   while ((*bptr_rx_buffer) && (index < MODEM_CONNECT_MESSAGE_LENGTH - 1))
   {
      if ((*bptr_rx_buffer != 0x0A) && (*bptr_rx_buffer != 0x0D))
         wan.port[port_number].statistics.modem_connect_message[index++] = *bptr_rx_buffer ;
		else if (index > 4)
			break;
		bptr_rx_buffer++;
   }
}

BYTE is_dialing_initiated_by_this_end (USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	return (modem_state_ptr->this_end_dialed);
}

BYTE is_remote_access_client_active (USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	
	return (modem_state_ptr->remote_access_client_connected);
}

void MdmStateISDNAtfs1(USHORT port_number)
{

	USHORT	TmpSr, wait_ticks;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	TmpSr = _GPL();
	_SPL(7);
	FlushRxBufferUART(port_number);
	_SPL(TmpSr);
	
	if (!wan.port[port_number].modem_info.auto_answer)
	{
		printf ("WAN1: Setting Port %04x to IDLE\n",port_number);
		WriteToPort(port_number, "ATS0=0\r", 0);		
		modem_state_ptr->state = MDM_STATE_IDLE;	/* move the state */
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
	}
	else
	{
		if (is_remote_access_enabled_on_port (port_number)) 
		{
			printf ("WAN3: Setting Port %04x to Answering\n",port_number);
			WriteToPort(port_number, "ATS0=1\r", 0);		
		}

		modem_state_ptr->state = MDM_STATE_WAIT_RING;
		modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;

		/* sudha 27 June 1999 */
		SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);
	}
}

void set_dialing_initiated_from_proxy_successful_to_true (USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	
	modem_state_ptr->dialing_initiated_from_proxy_successful = TRUE;
	return;
}

BYTE is_dialing_initiated_from_proxy_successful_to_bring_link_up (USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	
	return (modem_state_ptr->dialing_initiated_from_proxy_successful);
}

#if 0
/* sudha 27 June 1999 */
void set_modem_dtr_and_ats0_value_and_if_required_reinit_modem(USHORT port_number, enum EVENT_TYPE)
{
	BYTE function_type;
	USHORT port_type;

	function_type = get_wan_port_function_type(port_number);
	port_type = get_wan_port_dial_in_out_type(port_number);

	switch (EVENT_TYPE)
	{
		case INITIAL_NEED_TO_DIAL_OUT:
		case PROXY_LINK_UP_BY_DEMAND:
		case PROXY_LINK_DOWN_BY_NO_DEMAND:
			break;
		case RAS_LINK_DOWN:
		case AG_LINK_DOWN:
		case TELNET_DIAL_OUT_LINK_DOWN:
			/* reinit modem state machine */
			break;
		default:
			break;
	}

	switch (port_type)
	{
		case DIAL_OUT_IN:
		case DIAL_IN:
			/* set DTR high */
			SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);

			/* set ATS0 = 1 */
			WriteToPort(port_number, "ATS0=1\r", 0);		

			/* set modem to answering mode */
			
			break;
		case DIAL_OUT:
			/* set DTR low */
			SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
			
			/* set ATS0 = 0 */
			WriteToPort(port_number, "ATS0=0\r", 0);		

			/* set modem to dialing mode */
			
			break;
		default:
			break;
	}
}

#endif


void set_modem_to_dialing_mode (USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	
	wan.port[port_number].modem_info.auto_answer = FALSE;

	printf ("WAN : Changing Port %d to Dialing\n",port_number);
/* sudha 21-Oct-1999.Changed this var to array var */
	need_to_proceed_with_modem_dial_state_and_not_idle_state[port_number] = FALSE;
	modem_state_ptr->state = MDM_STATE_OFFLINE;
	modem_state_ptr->wait_ticks = 0;

#if 0
	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); 

	WriteToPort(port_number, "ATS0=0\r", 0);		 
#endif

	return;
}

#endif



/**************************     Last  Line    *******************************/
