/****************************************************************************
File	:	modem.h
Synop	:	Header file for modem.c
Modifi	: 17/05/96 Vidy added MDM_STATE_IDLE
				17/05/96 Vidy - Revamped the modem state machine. Refer mdmst.doc
****************************************************************************/

/* first parameter values to SetLineConfig call to line driver */
#define		SET_CONF_SET_SIGS		0x01
#define		SET_CONF_RESET_SIGS	0x02
#define		SET_CONF_GET_SIGS		0x03
#define		SET_CONF_SET_PARAMS	0x04

/* Status check masks */
#define		LINE_STAT_DCD			0x01	/* DCD Status						*/
#define		LINE_STAT_RI			0x02	/* Ring Indicator Status		*/
#define		LINE_STAT_CTS			0x04	/* CTS Status						*/
#define		LINE_STAT_DSR			0x08	/* DSR Status						*/
#define		LINE_STAT_RTS			0x10	/* RTS control						*/
#define		LINE_STAT_DTR			0x20	/* DTR control						*/

/* various states of modem on ports */

#define		MDM_STATE_IDLE			0		/* new state added on 17/05/96 Vidy */

#define		MDM_STATE_OFFLINE		1
#define		MDM_STATE_ONLINE		2
#define		MDM_STATE_CMD_A		3
#define		MDM_STATE_CMD_T		4
#define		MDM_STATE_CMD_REST	5

#define		MDM_STATE_WAIT_OK		6
#define		MDM_STATE_DIAL_A		7
#define		MDM_STATE_WAIT_CONN	8

#define		MDM_STATE_WAIT_RING	9
#define		MDM_STATE_HUP_DTR_DN	10
#define		MDM_STATE_HUP_CHK_CD	11
#define		MDM_STATE_HUP_STR		12
#define		MDM_STATE_BREAK		13

#define		MDM_STATE_DELAY_ONLINE			14
#define		MDM_STATE_DTR_DIAL_LINK_DN		15
#define		MDM_STATE_DTR_DIAL_DTR_DN		16
#define		MDM_STATE_DTR_DIAL_DTR_UP		17
#define		MDM_STATE_DTR_DIAL_CHK_ONLINE	18
#define		MDM_STATE_CALLBACK            19 /* Sachin 03/07/1996 */

/* sudhir for ISDN TA */
#define     ISDN_STATE_REINIT             20
#define		MDM_STATE_RESET_ISDN				21
#define     ISDN_STATE_ATFS1				   22 /* sudha 23 July 1999 */
/* sudhir for ISDN TA */

#if PROXY_SERVER
#define     MDM_STATE_LAST_STATE 22
#endif

#define		MDM_STATE_ABSENT		0xFF

#define		MAX_NUM_LINKESTB_TRIES		3
#define		DTR_DIAL_MAX_CHECK_ONLINE	90


/* Errors reported by modem */
#define		MDM_ERR_NONE			0
#define		MDM_ERR_CMD				1
#define		MDM_ERR_CD_DROP		2
#define		MDM_ERR_CMD_TMOUT		3
#define		MDM_ERR_CONN_TMOUT	4
#define		MDM_ERR_BUSY			5
#define		MDM_ERR_NO_ANSWR		6
#define		MDM_ERR_NO_DTONE		7
#define		MDM_ERR_NO_CARRIER	8
#define		MDM_ERR_DIALING		9		/* Got "ERROR" in response to ATD... */

#ifdef IF_18_TICKS_PER_SEC
#define		MDM_STAT_CHK_ONLINE	18 * 1		/* every second */
#define		MDM_WAIT_FOR_CMD_T	2	/* 9		/* Wait for 9 ticks betwn A and T */ */
#define		MDM_WAIT_FOR_OK		18 * 3		/* Wait for 3 second for command OK */
#define		MDM_CHK_FOR_RING		18 * 5
#define		MDM_POWER_ON_DELAY	18 * 5		/* Delay after power on */
#define		MDM_DTR_DN_TIME		18 * 2		/* lower DTR for 2 sec to HUP	*/
#define		MDM_CMD_PAUSE_TIME	9				/* Half second pause time */
#define		MDM_DELAY_DIAL			5	/* 18 * 5		/* Wait for a few sec before starting to dial */ */
#define		MDM_CHK_LINKUP_TIME	18 * 90 * 2	/* wait for 2.5 minutes to see if link is
															/* established. */

/* sudhir added for ISDN Proxy */
#define     ISDN_WAIT_BEFORE_DIAL   18*5
#else


#define		MDM_STAT_CHK_ONLINE	 1		/* every second */
#define		MDM_WAIT_FOR_CMD_T	1				/* Wait for 9 ticks betwn A and T */
#define		MDM_WAIT_FOR_OK		 3		/* Wait for 3 second for command OK */
#define		MDM_CHK_FOR_RING		5
#define		MDM_POWER_ON_DELAY	 5		/* Delay after power on */
#define		MDM_DTR_DN_TIME		 2		/* lower DTR for 2 sec to HUP	*/
#define		MDM_CMD_PAUSE_TIME	1				/* Half second pause time */
#define		MDM_DELAY_DIAL			1 		/* was 5 Wait for a few sec before starting to dial */
#define		MDM_CHK_LINKUP_TIME	 90 * 2	/* wait for 2.5 minutes to see if link is
															/* established. */
#define     ISDN_WAIT_BEFORE_DIAL  5

#endif

/* Chidanand	- PPP Dial Backup  - 1st October 1996 */
#ifndef PHONE_NUM_LEN
#define		PHONE_NUM_LEN			60
#endif
#define		MDM_CMD_PAUSE_CHAR	'~'

#define		MDM_TYPE_LEN 			50
#define		MDM_DIAL_PREFIX_LEN	21
#define		MDM_DIAL_SUFFIX_LEN	21
#define		MDM_MESG_LEN			21
#define		MDM_HANGUP_STR_LEN	41
#define		MDM_INIT_STR_LEN		45
#define		MDM_CONN_RESP_LEN		41


/* sudhir 11/12/97 */
#define NUMBER_OF_MODEM_INIT_STRINGS 5
#define NUMBER_OF_ISDN_INIT_STRINGS 8 /* Sudha changed this from 7 to 8 on 29 oct 98 */
/* sudhir 11/12/97 */

/* Modem Information - for each modem one struct will be present */
typedef struct
{
  	BYTE	init_string[5][MDM_INIT_STR_LEN];

	/* Chetan 29/06/1996 */
	/* Removed to increase size */
	/* BYTE	dial_string[20]; */

	BYTE	modem_ring_mesg[MDM_MESG_LEN];				/* Modem RING message */
	BYTE	modem_hangup_string[MDM_HANGUP_STR_LEN]; 	/* Modem hangup string */
	BYTE	modem_ok_mesg[MDM_MESG_LEN]; 					/* Modem OK message */
	BYTE	modem_error_mesg[MDM_MESG_LEN]; 				/* Modem ERROR message */
	BYTE	modem_busy_mesg[MDM_MESG_LEN]; 				/* Modem BUSY message */
	BYTE	modem_no_carrier_mesg[MDM_MESG_LEN]; 		/* Modem NO CARRIER message */
	BYTE	modem_no_dial_tone_mesg[MDM_MESG_LEN]; 	/* Modem NO DIALTONE message */
	BYTE	modem_no_answer_mesg[MDM_MESG_LEN]; 		/* Modem NO ANSWER message */
	BYTE	modem_response_string[MDM_CONN_RESP_LEN]; /* The modem response string */

	/* Chetan 29/06/1996 */
	/* These three form part of the Dial String */
	BYTE modem_dial_prefix[MDM_DIAL_PREFIX_LEN] ; /* Modem Dial String Prefix */
	BYTE modem_dial_suffix[MDM_DIAL_SUFFIX_LEN] ; /* Modem Dial String Suffix */
	BYTE modem_dial_number[PHONE_NUM_LEN] ;	/* Modem Dial Number */
	/* Chetan 29/06/1996 */

	BYTE dial_string[MDM_DIAL_PREFIX_LEN + PHONE_NUM_LEN + MDM_DIAL_SUFFIX_LEN];

	/* Chetan 29/06/1996 */
	BYTE modem_type[MDM_TYPE_LEN] ;
	/* Chetan 29/06/1996 */

} MODEM_STRINGS;

/* Modems state in a nutshell */
typedef	struct
{
	BYTE		state;					/* Current state of modem */
	USHORT	wait_ticks;				/* number of ticks to go before moving state */
	USHORT	retry_count;			/* Retry number */
	USHORT init_string_index;
#if 0
	BYTE		init_string_index;	/* init string being sent out now */
#endif
	ULONG		stat_retry_fails;		/* Count of attempts failed */
	BYTE		cmnd_string[PHONE_NUM_LEN + MDM_DIAL_PREFIX_LEN * 2];/* Current Init command to go to modem */
	BYTE		cmnd_string_index;
	BYTE		last_error;
	ULONG		carrier_loss;
	ULONG		init_attempts;
	USHORT	check_online_count;	/* loop count for dtr dialing */
	enum BOOLEAN call_back_on ; /* Sachin 03/07/1996 */
	USHORT	call_back_delay ; /* Sachin 03/07/1996 */
	BYTE     this_end_dialed; /* this is used by PPP to find out which end initiated connection */

	BYTE		dialing_initiated_from_proxy_successful; /* sudha 18 May 1999 */

/* when link is down used to find out whether ras client is disconnecting or 
proxy client bringing up the port due to demand is not successful. */

	BYTE     remote_access_client_connected;
#if PROXY_SERVER
   USHORT flush_rx_buffer_counter ;
#endif
} MODEM_STATUS;

typedef	struct	MODEM_KONST
{
	USHORT	dial_timeout; 
	USHORT	break_len;	
	USHORT	max_retry;	 
	USHORT	sleep_time;	
	USHORT	retry_wait;	
} MODEM_KONST;


typedef	struct	MODEM_INFO
{
	enum BOOLEAN		dtr_dial;
	enum BOOLEAN		auto_answer;
	USHORT				dial_in_out_type; /* Sachin 02/07/1996 */
	BYTE              port_function_type; /* sudha 17 Nov 1998 */
	MODEM_KONST			constant;
	MODEM_STATUS		status;
	MODEM_STRINGS		strings;
} MODEM_INFO;





/* sudhir 11/12/97 */

typedef struct ISDN_STRINGS
{

	BYTE ta_type[MDM_TYPE_LEN] ;

  	BYTE	init_string[NUMBER_OF_ISDN_INIT_STRINGS][MDM_INIT_STR_LEN];
}ISDN_STRINGS;

typedef	struct	ISDN_INFO
{
	ISDN_STRINGS		strings;
} ISDN_INFO;
/* sudhir 11/12/97 */



/* The default modem setup strings */
#define	DEF_MDM_RING_MESG		"RING"	/* The RING message from modem.				*/
#define	DEF_MDM_HANUP_STR		"~~~+++~~~ATH0^M"	/* The Hayes controversial hangup string	*/
#define	DEF_MDM_RESP_OK			"OK"	/* Modem  send a "OK" string for good exec	*/
#define	DEF_MDM_RESP_ERROR		"ERROR"	/* If exec failed modem sends "ERROR"		*/
#define	DEF_MDM_RESP_BUSY		"BUSY"	/* modem sends "BUSY" if number is busy		*/
#define	DEF_MDM_RESP_NO_CARRIER	"NO CARRIER"	/* No carrier detected by modem				*/
#define	DEF_MDM_RESP_NO_DLTONE	"NO DIALTONE"	/* No dialtone from line. Can't dialout		*/
#define	DEF_MDM_RESP_NO_ANSWER	"NO ANSWER"	/* No answer from the destination dialed	*/
#define	DEF_MDM_RESP_CONNECT	"CONNECT"	/* A string starting with CONNECT is send	*/

#ifdef IF_18_TICKS_PER_SEC
#define	DEF_DIAL_TIMEOUT	18 * 60 	/*  60 seconds */
#define	DEF_BREAK_LEN		18 * 5	/* 5 seconds */
#define	DEF_MAX_RETRY		18 * 3	/* 3 retries */
#define	DEF_SLEEP_TIME		18 * 60	/* 60 seconds */
#define	DEF_RETRY_WAIT		18 * 10	/* 10 seconds */
#define	DTR_DIAL_DTR_DN_TIME	18 * 8 /* 8 seconds */
#else
#define	DEF_DIAL_TIMEOUT	 60 	/*  60 seconds */
#define	DEF_BREAK_LEN		 5	/* 5 seconds */
#define	DEF_MAX_RETRY		 3	/* 3 retries */
#define	DEF_SLEEP_TIME		 60	/* 60 seconds */
#define	DEF_RETRY_WAIT		 7		/* was 10 - seconds */
#define	DTR_DIAL_DTR_DN_TIME	8 /* 8 seconds */
#endif

extern	BYTE 	*ConvertControls(BYTE *dst_str, BYTE *src_str);
extern	void	SetModemDefInfo(USHORT port_number);
extern	void	MoveModemState(USHORT port_number);
extern	void	MdmStateIdle(USHORT port_number);
extern	void	MdmStateOffLine(USHORT port_number);
extern	void	MdmStateOnLine(USHORT	port_number);
extern	void	MdmStateCmdA(USHORT port_number);
extern	void	ModemStateCmdT(USHORT port_number);
extern	void	MdmStateCmdRest(USHORT port_number);
extern	void	MdmStateWaitOK(USHORT port_number);
extern	void	MdmStateDialA(USHORT port_number);
extern	void	MdmStateWaitConn(USHORT port_number);
extern	void	MdmStateWaitRing(USHORT port_number);
extern	void	MdmStateHupDTRDown(USHORT port_number);
extern	void	MdmStateHupCheckCD(USHORT port_number);
extern	void	MdmStateHupStr(USHORT port_number);
extern	void	MdmStateBreak(USHORT port_number);
extern	void	MdmStateDelayOnline(USHORT port_number);
extern	void	MdmStateDTRDialLinkDn(USHORT port_number);
extern	void	MdmStateDTRDialDTRDn(USHORT port_number);
extern	void	MdmStateDTRDialDTRUp(USHORT port_number);
extern	void	MdmStateDTRDialChkOnline(USHORT port_number);
extern	void	MdmStateCallBack(USHORT port_number);
extern	void MdmStateReinit (USHORT port_number);
extern	void MdmStateResetISDN(USHORT port_number);
extern   void MdmStateISDNAtfs1(USHORT port_number);

/* Chetan 29/06/1996 */
extern void construct_dial_string (USHORT port_number, char *dial_number) ;

	
/**************************     Last  Line    *******************************/




