#include "defs.h"
#include <stdio.h>
#include "wan.h"
#include	"modemsup.h"

extern	ULONG  LocalIOToMove;	/* Vidy changed to use the global DTR,CLK opts */

/***************************************************************************
File	:	modemsup.c
Synop	:	contains support routines for modem. 
***************************************************************************/

extern void reset_tx_on_SCC2(void);
extern void reset_tx_on_SCC3(void);
extern void reset_tx_on_SCC4(void);

extern void reset_rx_on_SCC2(void);
extern void reset_rx_on_SCC3(void);
extern void reset_rx_on_SCC4(void);

extern void tx_on_SCC2(char *, USHORT);
extern void tx_on_SCC3(char *, USHORT);
extern void tx_on_SCC4(char *, USHORT);

extern char	*get_rx_buffer_SCC2(void);
extern char	*get_rx_buffer_SCC3(void);
extern char	*get_rx_buffer_SCC4(void);

extern void stop_tx_on_SCC2(void);
extern void stop_tx_on_SCC3(void);
extern void stop_tx_on_SCC4(void);

extern void restart_tx_on_SCC2(void);
extern void restart_tx_on_SCC3(void);
extern void restart_tx_on_SCC4(void);

extern void SCC_DTR_status(ULONG);

extern int get_next_scc_rx_buffer(USHORT, BYTE **, USHORT *);

USHORT	SetLineConfigUART(USHORT,USHORT,USHORT);

void	Just_FlushTxBufferUART(USHORT port_number);
void	Just_FlushRxBufferUART(USHORT port_number);

/***************************************************************************/

/***************************************************************************/
void	FlushTxBufferUART(USHORT port_number)
{

	/* All the BDs are reinitialised as all queued up descriptors are freed */
	switch(port_number){
		case	0 :						/* SCC 2 */
				reset_tx_on_SCC2();
				break;

		case	1 :						/* SCC 3 */
				reset_tx_on_SCC3();
				break;

		case	2 :						/* SCC 4 */
				reset_tx_on_SCC4();
				break;

		default:
				return;
	}
	Just_FlushTxBufferUART(port_number);

}
void	Just_FlushTxBufferUART(USHORT port_number)
{
	WAN_TX_DESCRIPTOR *sptr_current_tx_descriptor;

	/* release current and all queued up descriptors by adding them to the 
	xmitted list. It will take care of freeing up the descriptor properly. */

	sptr_current_tx_descriptor = wan.port[port_number].sptr_current_tx_descriptor;
	if(sptr_current_tx_descriptor) {
		/* add this descriptor to the xmited_tx_list */
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
		wan.port[port_number].sptr_current_tx_descriptor = NULL;
	}

	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].current_tx_list) ) {
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}

/* sudha 05 July 1999.Ported the packet length prioritization changes from 
Sir */
#if SMALL_PACKETS_FIRST
	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].current_first_tx_list) ) {
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}
#endif

	wan.port[port_number].scheduled_for_tx.sptr_forward_link = (LINK *)NULL;
}
/***************************************************************************/
void Just_FlushTransmittedTxBufferUART (USHORT port_number)
{
	WAN_TX_DESCRIPTOR *sptr_current_tx_descriptor;

	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].xmited_tx_list)) {
		sptr_current_tx_descriptor->in_use = FALSE;
	   add_entry_to_list (&wan.port[port_number].free_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}
}
/***************************************************************************/
void	FlushRxBufferUART(USHORT port_number)
{
	Just_FlushRxBufferUART(port_number);

	switch(port_number){
		case	0 :						/* SCC 2 */
				reset_rx_on_SCC2();
				break;
		case	1 :						/* SCC 3 */
				reset_rx_on_SCC3();
				break;
		case	2 :						/* SCC 4 */
				reset_rx_on_SCC4();
				break;
		default:
				return;
	}
}


void	Just_FlushRxBufferUART(USHORT port_number)
{
	WAN_RX_DESCRIPTOR *sptr_current_rx_descriptor;
	/* Free up all the scheduled_for_rx  descriptors cause we are reinitialising
	the RxBDs */

	while (sptr_current_rx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].scheduled_for_rx) ) {
	   add_entry_to_list (&wan.port[port_number].free_rx_list,
										(LINK *) &sptr_current_rx_descriptor->links);
	}
}

/***************************************************************************/
/* Chidanand - 30 June 1997 : Added routines */
#if 0
void Just_FlushCurrentRxBufferUART (USHORT port_number)
{
	WAN_RX_DESCRIPTOR *sptr_current_rx_descriptor;
	/* Free up all the scheduled_for_rx  descriptors cause we are reinitialising
	the RxBDs */

	while (sptr_current_rx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].current_rx_list)) {
	   add_entry_to_list (&wan.port[port_number].free_rx_list,
										(LINK *) &sptr_current_rx_descriptor->links);
	}
}
void Just_FlushTransmittedTxBufferUART (USHORT port_number)
{
	WAN_TX_DESCRIPTOR *sptr_current_tx_descriptor;

	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].xmited_tx_list)) {
		sptr_current_tx_descriptor->in_use = FALSE;
	   add_entry_to_list (&wan.port[port_number].free_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}
}

void DLBK_Initialize_Port (USHORT wan_port_number)
{
	USHORT TmpSr;
	TmpSr = _GPL();
	_SPL(7);

	Flush_Rx_Tx_Buffers (wan_port_number);
 	Just_FlushCurrentRxBufferUART (wan_port_number);
 	Just_FlushTransmittedTxBufferUART (wan_port_number);
  	Start_Tx_and_Rx(wan_port_number);

	_SPL(TmpSr);
}
#endif
/* Chidanand - 30 June 1997 */

/***************************************************************************/
void	WriteToPort(USHORT port_number, char *String, USHORT count)
{
	/* int i; */

	if(!count)
		count = strlen(String);

	switch(port_number)
	{
		case	0 :						/* SCC 2 */
			tx_on_SCC2(String,count);
			return;

		case	1 :						/* SCC 3 */
			tx_on_SCC3(String,count);
			return;

		case	2 :						/* SCC 4 */
			tx_on_SCC4(String,count);
			return;
	}
	return;
}

/****************************************************************************
	routine	:	SearchLnBuffFor
	Synop	:	Searches the line buffer of Port for string
	return	:	TRUE if found otherwise FALSE
***************************************************************************/
enum BOOLEAN	SearchLnBuffFor(USHORT port_number, char *String)
{
	char *LineBuffer;
	USHORT	RxSize= 100;
	USHORT	SubStrlen;
	USHORT	i, j, times;

	SubStrlen = strlen(String);

	times = 0;
		switch(port_number)
		{
		case 0 :	LineBuffer = get_rx_buffer_SCC2();
					break;
				
		case 1 :	LineBuffer = get_rx_buffer_SCC3();
					break;
				
		case 2 :	LineBuffer = get_rx_buffer_SCC4();
					break;
		}

		for (i = 0; i <= (RxSize - SubStrlen); i++)
		{
			for (j = 0; j < SubStrlen; j++)
			{
				if (LineBuffer[i + j] != String[j])
					break;
			}
			if (j == SubStrlen) 
				return TRUE;
		}
	return FALSE;
}

/****************************************************************************
*	Routine	:	PortModemPoweredOffandOn
*	Input	:	Port
*	Return	:	Return TRUE is DCD is present on Port else FALSE;
****************************************************************************/
enum BOOLEAN	PortModemPoweredOffAndOn(USHORT port_number)
{
//	BYTE		MdmStat;

	return FALSE;
}


/**************************************************************************/
void SetBreakUART(USHORT port_number)
{
	switch(port_number){
		case	0 :						/* SCC 2 */
				/* stop transmit on the port so that break characters are sent */
				stop_tx_on_SCC2();
				return;

		case	1 :						/* SCC 3 */
				/* stop transmit on the port so that break characters are sent */
				stop_tx_on_SCC3();
				return;

		case	2 :						/* SCC 4 */
				/* stop transmit on the port so that break characters are sent */
				stop_tx_on_SCC4();
				return;
	}
	return;
}

void ResetBreakUART(USHORT port_number)
{
	switch(port_number){
		case	0 :						/* SCC 2 */
					restart_tx_on_SCC2();
					break;

		case	1 :						/* SCC 3 */
					restart_tx_on_SCC3();
					break;

		case	2 :						/* SCC 4 */
					restart_tx_on_SCC4();
					break;
		}
}

/* static BYTE	DTRUp[NUMBER_OF_SERIAL_PORTS] = {FALSE, FALSE, FALSE}; */

USHORT	SetLineConfigUART(USHORT command, USHORT mask, USHORT port_number)
{

	if (command == SET_CONF_RESET_SIGS){
		if (mask == LINE_STAT_DTR){
			switch(port_number){
				case	0:
					LocalIOToMove |= 0x08;
					break;
				case	1:
					LocalIOToMove |= 0x10;
					break;
				case	2:
					LocalIOToMove |= 0x20;
					break;
				default:	
					return(FALSE);
			}
		}
	} else if (command == SET_CONF_SET_SIGS){
		if (mask == LINE_STAT_DTR){
			switch(port_number){
				case	0:
					LocalIOToMove &= ~0x08;
					break;
				case	1:
					LocalIOToMove &= ~0x10;
					break;
				case	2:
					LocalIOToMove &= ~0x20;
					break;
				default:
					return(FALSE);
			}
		}
	}
	SCC_DTR_status(LocalIOToMove);
	return(TRUE);
}

void start_analysing_packets_on_port(int port_number)
{
	/* release the current buffers */
	Just_FlushRxBufferUART(port_number);

	switch(port_number){
		case	0 :						/* SCC 2 */
				setup_SCC2_for_packet_analysis();
				break;
		case	1 :						/* SCC 3 */
				setup_SCC3_for_packet_analysis();
				break;
		case	2 :						/* SCC 4 */
				setup_SCC4_for_packet_analysis();
				break;
		default:
				return;
	}
}




/* chetan 22/11/96 */
extern int ExecuteScriptFile (BYTE PortNum) ;
extern void ResetScriptOverVar (BYTE PortNum) ;

void StartScript (USHORT port_number)
{
	if (!wan.port[port_number].asyncport || 
					wan.port[port_number].direct_connect_enabled)
		return ;
	SetLineConfigUART (SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number) ;
	ResetScriptOverVar ((BYTE) port_number) ; /* make scriptover = 0 */
   ExecuteScriptFile ((BYTE) port_number) ;
}
/* chetan 22/11/96 */

