#include "defs.h"
#include <stdio.h>

/* chetan 18/9/96 */
#include <kstart.h>
/* chetan 18/9/96 */

#include "wan.h"

extern ULONG timer_ulong;

/* chetan 18/9/96 */
extern void ScriptTimer (BYTE PortNum) ;
extern int ScriptRunning (BYTE PortNum) ;
/* chetan 18/9/96 */

ULONG wan1_timer_called;
ULONG wan2_timer_called;
ULONG wan3_timer_called;

/**************************************************************************/
void	wan_timer_function(USHORT port_number) 
{
#if PROXY_SERVER
   if (wan.port[port_number].modem_info.status.state == MDM_STATE_ONLINE)
   {
      wan.port[port_number].statistics.connection_up_time++ ;
      wan.port[port_number].statistics.aggregate_connection_time++ ;
   }
#endif

	if(wan.port[port_number].asyncport &&	wan.port[port_number].direct_connect_enabled) 
		return;


	/* chetan 18/9/96 */
	if (wan.port[port_number].script_enabled)
	{
		if (wan.port[port_number].asyncport && 
					!wan.port[port_number].direct_connect_enabled)
		{
			ScriptTimer ((BYTE) port_number) ;
		}
	}
	/* chetan 18/9/96 */

	/* chetan 12/10/96 */
	if (wan.port[port_number].script_enabled)
	{
		if (wan.port[port_number].asyncport && 
				!wan.port[port_number].direct_connect_enabled)
		{
			if (!ScriptRunning ((BYTE) port_number))
			{
/*				printf ("Modem state : %d\n\r", modem_state_ptr->state) ; */
				MoveModemState (port_number) ;
			}
		}
	}
	else
	{
		MoveModemState (port_number) ;
	}
	/* chetan 12/10/96 */

	
	if (wan.port[port_number].packet_analysis_on == TRUE)
	{
		if (wan.port[port_number].packet_analysis_timer == 0)
		{
			/* No packet received for this much time. Allot port to
			** inbound as it could be a terminal program waiting. But if
			** the port is direct-connect, do not do this. Most probably
			** there is no one at the other end of the direct-connect.
			*/
			if (allot_port_to_inbound_if_required(port_number) == FALSE)
				wan.port[port_number].packet_analysis_timer = ANALYSIS_WAIT_SECONDS;
			else
				wan.port[port_number].packet_analysis_on = FALSE;
		}
		else
			wan.port[port_number].packet_analysis_timer--;
	}
}

/**************************************************************************/
 /*
		This is for all the three routines below. The timer functions get called
		for each timer tick but it may be continously. But the modem state m/c is
		to be called only once in 1 real second. So this optimisation is made.
	*/
/**************************************************************************/
void	wan1_timer_function(void)
{
	if(wan1_timer_called + 20 < timer_ulong ){
		wan1_timer_called = timer_ulong; 
		wan_timer_function(0);
	}
}
/**************************************************************************/

/**************************************************************************/
void	wan2_timer_function(void)
{
	if(wan2_timer_called + 20 < timer_ulong ){
		wan2_timer_called = timer_ulong; 
		wan_timer_function(1);
	}
}
/**************************************************************************/

/**************************************************************************/
void	wan3_timer_function(void)
{
	if(wan3_timer_called + 20 < timer_ulong ){
		wan3_timer_called = timer_ulong; 
		wan_timer_function(2);
	}
}

