/*	                                                          				
* $lgb$
1.0 04/05/94 ross
1.1 04/05/94 ross initial release
1.2 09/22/94 ross
1.3 12/01/94 ross
* $lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/*	$Modname: vasncstr.h$  $version: 1.3$      $date: 12/01/94$   */
/************************************************************************/
/* for commlib.c */

#ifndef LINK_TYPEDEF_DEFINED

#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

#endif

typedef	union	SERIAL_BUFFER
{
	ETHERNET_BUFFER			ethernet_packet;
	BYTE							data[2048];
} SERIAL_BUFFER;

typedef	struct	WAN_TX_DESCRIPTOR
{
	LINK							links;
	USHORT							length;

	SERIAL_BUFFER					*sptr_tx_packet;

	void 								(*fptr_tx_complete) (USHORT port_number,SERIAL_BUFFER *sptr_ethernet_buffer);

	enum BOOLEAN					in_use;

	enum BOOLEAN					device_driver_buffer;
	USHORT							protocol_stack_virtual_port_number;
	void							*vptr_wan_buffer;
	ULONG					current_time;
} WAN_TX_DESCRIPTOR;

typedef	struct	WAN_RX_DESCRIPTOR
{
	LINK				links;
	SERIAL_BUFFER	*sptr_rx_buffer;
	USHORT			buffer_size;
	USHORT			number_of_bytes_rxed;
	ULONG					current_time;
} WAN_RX_DESCRIPTOR;

typedef	union	UNION_WAN_DESCRIPTOR
{
	WAN_TX_DESCRIPTOR		tx;
	WAN_RX_DESCRIPTOR 	rx;
} UNION_WAN_DESCRIPTOR;

#if PROXY_SERVER
#define MODEM_CONNECT_MESSAGE_LENGTH 60
#endif
typedef	struct	WAN_STATISTICS
{
	ULONG				number_of_packets_txed;
	ULONG				number_of_bytes_txed;
	ULONG				number_of_packets_to_tx;
	ULONG				number_of_rejected_tx_packets;
	ULONG				number_of_tx_errors;		/* only hardware errors */

	ULONG				number_of_packets_rxed;
	ULONG				number_of_bytes_rxed;
	ULONG				number_of_rx_errors;
	ULONG				number_of_rx_queue_overflows;

#if 0
	ULONG				number_of_wrong_byte_counts_rxed;
	ULONG				number_of_out_of_receive_descriptors;
	ULONG 			number_of_too_small_packets_received;
	ULONG 			number_of_too_large_packets_received;

	ULONG				number_of_wrong_sized_rx_frames;

	ULONG				number_of_start_tx_commands;
	ULONG				number_of_tx_stalls;
	ULONG				number_of_tx_unknowns;
	ULONG				number_of_queued_tx_commands;

	ULONG				number_of_tx_underruns;

	ULONG				number_of_crc_errors;
	ULONG				number_of_overrun_errors;
	ULONG				number_of_residual_bit_frame_or_normal_end_of_frames;
	ULONG				number_of_frame_with_abort_errors;
	ULONG				number_of_short_frame_errors;
#endif

/*sudhir for proxy server */
	USHORT         number_of_bytes_to_tx;
/*sudhir for proxy server */
#if PROXY_SERVER
   ULONG connection_up_time ;
   ULONG connection_bytes_transmitted ;
   ULONG connection_bytes_received ;

   ULONG connection_packets_transmitted ;    /* Vidy 31/10/97 */
   ULONG connection_packets_received ;

   ULONG number_of_calls ;
   ULONG aggregate_connection_time ;

   BYTE modem_connect_message[MODEM_CONNECT_MESSAGE_LENGTH] ;
#endif
} WAN_STATISTICS;

typedef	struct	WAN_PORT_CLASS
{
	enum BOOLEAN							enabled;
	enum BOOLEAN							InternalClk;

	WAN_TX_DESCRIPTOR					tx_descriptor[NUMBER_OF_TX_BUFFERS];
	WAN_RX_DESCRIPTOR					rx_descriptor[NUMBER_OF_RX_BUFFERS];

	WAN_TX_DESCRIPTOR					*sptr_current_tx_descriptor;

	/* free_tx_list is one where are all the tx_descriptors which are currently
		not being used are placed as a linked list in this. when ever a pkt is 
		to be xmitted these descriptors are put on to current_tx_list if 
		a free 68360 slot is not found. if a free 68360 slot is found they
		are put in scheduled_for_tx_list. descriptors are taken out from this
		list in the send_wan_packet routine. */
	LINK								free_tx_list;

/* sudha 05 July 1999.Ported the packet length prioritization changes from 
Sir */
#if	SMALL_PACKETS_FIRST
/* current_first_tx_list contains all the tx descriptors which are waiting to be
		transmitted but were put here for lack of 68360 tx slots. After a free
		slot is got they are moved to scheduled_for_tx_list. This movement of
		the descriptor takes place in wan_tx_isr_complete called from int. serivce
		routine of the scc*/
/* Vidy 25/06/99 added this list for transmitting short packets first due
to VoIP issues */
	LINK								current_first_tx_list;
#endif

/* current_tx_list contains all the tx descriptors which are waiting to be
		transmitted but were put here for lack of 68360 tx slots. After a free
		slot is got they are moved to scheduled_for_tx_list. This movement of
		the descriptor takes place in wan_tx_isr_complete called from int. serivce
		routine of the scc*/
	LINK								current_tx_list;

/* xmited_tx_list contains all the descriptors which have been already
		transmitted but the completion routines have not yet been called. the descr.
		are moved in wan_tx_isr_Complete which is called from wan
		ISR. These descriptors will be taken out when lsl calls  wan_packet_trans-
		mitted in the foreground and put into free_tx_list.*/
	LINK								xmited_tx_list;

/* scheduled_for_tx contains the descriptors which have been given to
68360 tx slots and are not yet transmitted or may be being transmitted.
After they get transmitted they are put in xmited_tx_list.*/
	LINK								scheduled_for_tx;

	WAN_RX_DESCRIPTOR					*sptr_current_rx_descriptor;
	WAN_RX_DESCRIPTOR					*sptr_partial_rx_descriptor;
/*
	This contains all the descriptors which are ready by having a buffer allocated
	thro device_driver_malloc() but still are not yet scheduled for reception. 
	when ever a packet is received a free descriptor is taken out from here and
	put on scheduled_for_rx_list.
*/
	LINK								free_rx_list;

/*
	This contains all the descriptors which has a packet ready to be processed.
	lsl foreground calls wan_packet_received to check for any packets recvd. 
	we look into this Q and ifa pkt is present we give to lsl. The descriptor
	is now without a buffer. so we try to allocate one. if successfull we put
	the descpr in free_rx_list else we put it in need_buffer_list.
*/
	LINK								current_rx_list;
/* 
	This contains the list of desprs. which are presently in the 68360 rx slots
	ready for receiving pkts. if a pkt is recvd the descpr are taken out from
	here and put in current_rx_list.
*/
	LINK								scheduled_for_rx;

	USHORT								number_of_rx_buffers;
/*
	this contains the descprs. which donot have buffers allocated to them. we
	try to allocate a buffer in wan_return_buffer_to_device_driver,which is called
	whenever the completion routine of the recvd packet is called.
*/
	LINK								rx_descriptor_need_buffer_list;

	BYTE								port_number;
	ULONG								device_driver_id;

	WAN_STATISTICS					statistics;

	BYTE								packet_delimiter;
	USHORT 								minimum_packet_length;

	ULONG								port_speed;
	ULONG								sync_port_speed;
	BYTE 								parity;
	USHORT 								word_length;
	USHORT 								stop_bits;

	enum BOOLEAN						direct_connect_enabled;
	enum BOOLEAN						asyncport;

	MODEM_INFO							modem_info;

/* sudhir 11/12/97 */
	enum BOOLEAN						isdn_ta_enabled;
	ISDN_INFO                     isdn_info;
/* sudhir 11/12/97 */

	USHORT								state;

#ifdef FRAME_RELAY
	enum HLDD_TYPE                hldd_type ;
#endif

/* Sachin 19/07/1996 v */
	enum BOOLEAN                  connection_started_by_DCD ;
	enum BOOLEAN                  connection_started_by_modem_response ;
	enum BOOLEAN                  connection_dropped_by_DCD ;
/* Sachin 19/07/1996 ^ */

/* Vidy 31/07/96 */
	enum BOOLEAN                  sync_xmit_idle_flags;
	
	BYTE_ENUM(BOOLEAN)				packet_analysis_on;	
	ULONG									packet_analysis_timer;
	BYTE_ENUM(BOOLEAN)				analysed_once;	

	enum BOOLEAN						script_enabled ;
	enum BOOLEAN                  restart_script_on_comm_failure ;

	enum SHELL_MENU_STATE         shell_menu_on ;	
	BYTE              				shell_menu_response[SHELL_MENU_MAX_RESPONSE_LENGTH] ;	
	int               				shell_menu_response_length ;	
	int               				shell_menu_idle_timer ;

/* sudhir */
	enum BOOLEAN						port_down_by_no_demand ;
	BYTE                          hangup_and_redial;
	
} WAN_PORT_CLASS;

typedef	struct	WAN_CLASS
{
	BYTE_ENUM  (BOOLEAN)		enabled;
	BYTE_ENUM  (BOOLEAN)		printing_enabled;
	BYTE_ENUM  (BOOLEAN)		initialization_printing_enabled;
	BYTE_ENUM  (BOOLEAN)		rx_printing_enabled;
	BYTE_ENUM  (BOOLEAN)		tx_printing_enabled;

	USHORT 				number_of_ports;
	USHORT 				number_of_lan_ports;

	WAN_PORT_CLASS	port[NUMBER_OF_SERIAL_PORTS];
} WAN_CLASS;

/* sudhir 28/2/97 */
typedef struct
{
	USHORT bd_status ;
	USHORT buffer_length ;
	BYTE *buffer_ptr ;
} SCC_BUFFER_DESCRIPTOR ;
/* sudhir 28/2/97 */

/* asyncini.c */

enum TEST initialize_wan_controller (ULONG clock_ticks_per_second);
void wan_printf (enum WAN_PRINTF_GROUPS printf_group,const char *cptr_format, ...);

/* asynctx.c */

enum TEST send_wan_packet (USHORT port_number,USHORT virtual_port_number,SERIAL_BUFFER *sptr_tx_buffer,USHORT number_of_bytes,
	enum BOOLEAN do_not_calculate_new_crc,enum BOOLEAN device_driver_buffer,
	void (*fptr_tx_completion) (USHORT port_number,SERIAL_BUFFER *sptr_wan_buffer),void *vptr_wan_buffer);

void wan_packet_transmitted (USHORT port_number);

/* asyncrx.c */

enum BOOLEAN wan_packet_received (USHORT port_number,SERIAL_BUFFER **sptr_async_buffer_rxed,
	USHORT *usptr_number_of_bytes_rxed);

void wan_return_buffer_to_device_driver (USHORT real_port_number,void *vptr_buffer);

enum TEST get_a_new_wan_buffer (USHORT real_port_number,WAN_RX_DESCRIPTOR *sptr_current_rx_descriptor);


/* asyndial.c */

void dial_out (USHORT port_number);

/* Kamalnath 19\03\1997 moved these decl.. from modem.c */
/* modem.c */
inform_hldd_and_change_to_async_hdlc(USHORT port_number);
inform_hldd_and_change_to_async(USHORT port_number);
change_protocol_to_async_hdlc(USHORT port_number);
change_protocol_to_async(USHORT port_number, int for_routing, int mode);
Flush_Rx_Tx_Buffers(USHORT port_number);

