#include	"defs.h"
/*	$Modname: asynconf.c$  $version: 1.2$      $date: 12/01/94$   */
/*
* 	$lgb$
1.0 09/22/94 ross initial release.
1.1 09/22/94 ross
1.2 12/01/94 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1992-1993 Router Engines, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stddef.h>
#include 	"wan.h"
#include	<vnvrmstr.h>
#include	"vnvwan.h"
#include	<wanmgr.h>

/* Sachin 18/06/1996 */

char *wan_conf_return_strings[] =
{
	"\n\rPort available for configuration\n\r",
	"\n\rPort is not available for configuration as it is disabled.\n\r",
	"\n\rPort is not available for configuration as it is currently in use\n\r",
	"\n\rDial on demand ports are not available for configuration\n\r",
	NULL
} ;

/* Sachin 18/06/1996 */


/****************************************************************************/
static enum WAN_PORT_OWNER wandrv_wan_owner[NUMBER_OF_SERIAL_PORTS];

void init_wan_port_owner_table()
{
	int i;

	for (i = 0; i < NUMBER_OF_SERIAL_PORTS; i++)
		wandrv_wan_owner[i] = OWNED_BY_NONE;
}

/* NOTE: Following call will unconditionally change ownership assuming
** the calling code knows what it is doing.
*/
void set_wan_port_owner(USHORT port_number, enum WAN_PORT_OWNER wan_owner)
{
	wandrv_wan_owner[port_number] = wan_owner;

	if (wan.port[port_number].enabled == FALSE)
		return ;

	switch (wan_owner)
	{
		case OWNED_BY_NONE:
			/* Restart the modem state machine of the regular WAN driver */
			InitSCC(port_number);
/*			if (wan.port[port_number].asyncport == TRUE)
				initialize_connection_on_port(port_number);
			wan_control((enum DEVICE_CONTROL_OPERATION) OPEN_SERIAL_PORT, port_number, 0); 
			SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number); */
			break;

		/* If new owners are AG or TELNET, we don't need the WANDRV buffers. */

		case OWNED_BY_TELNET:
			Flush_Rx_Tx_Buffers(port_number);
			break ;

		case OWNED_BY_AG:
			Flush_Rx_Tx_Buffers(port_number);
			break;

		case OWNED_BY_PPP:
			/* In case of PPP, the buffers will be released by the call to change
			** protocol to HDLC. This will happen immediately.
			*/
			break;
	
		/* Kamalnath SLIP 07\03\1997 */
		case OWNED_BY_SLIP :
			break;
		/* Kamalnath SLIP 07\03\1997 */
	}
}

enum WAN_PORT_OWNER get_wan_port_owner(USHORT port_number)
{
	return wandrv_wan_owner[port_number];
}

/* ----------- Functions retrieving configuration information ---------- */

enum BOOLEAN is_wan_enabled(USHORT port_number)
{
	return wan.port[port_number].enabled;	
}

enum BOOLEAN is_wan_direct_connect(USHORT port_number)
{
	return wan.port[port_number].direct_connect_enabled;
}

enum BOOLEAN is_wan_async(USHORT port_number)
{
	return (wan.port[port_number].asyncport);
}

/* sudha 23 April 1999... */

enum BOOLEAN is_port_is_in_use_by_ag ( USHORT port_number )
{
	if ( get_wan_port_owner ( port_number ) == OWNED_BY_AG )
		return TRUE;
	else
		return FALSE;
}

enum BOOLEAN is_port_is_in_use_by_telnet ( USHORT port_number )
{
	if ( get_wan_port_owner ( port_number ) == OWNED_BY_TELNET )
		return TRUE;
	else
		return FALSE;
}

USHORT get_wan_port_dial_in_out_type(USHORT port_number)
{
	USHORT port_type;
	port_type = wan.port[port_number].modem_info.dial_in_out_type;	
	printf("\n\rWANCONF: port type is %d", port_type); 
	return port_type;
}

BYTE get_wan_port_function_type(USHORT port_number)
{
	BYTE port_function_type, mask, result;
	
	port_function_type = wan.port[port_number].modem_info.port_function_type;
	mask = 0x07;
	result = port_function_type & mask;
	
/*	printf("\n\rWANCONF: function type is %d", result); */
	return result;
}

enum BOOLEAN is_proxy_enabled_only_port(USHORT port_number)
{
	BYTE port_function_type, mask, result;
	
	port_function_type = wan.port[port_number].modem_info.port_function_type;
	mask = 0x07;
	result = port_function_type & mask;

	if ( result == PORT_PROXY_ENABLE )
		return TRUE;
	else
		return FALSE;				
}

enum BOOLEAN is_ag_enabled_only_port(USHORT port_number)
{
	BYTE port_function_type, mask, result;
	
	port_function_type = wan.port[port_number].modem_info.port_function_type;
	mask = 0x07;
	result = port_function_type & mask;

	if ( result == PORT_AG_ENABLE )		
		return TRUE;
	else
		return FALSE;
}

enum BOOLEAN is_ras_enabled_only_port(USHORT port_number)
{
	BYTE port_function_type, mask, result;
	
	port_function_type = wan.port[port_number].modem_info.port_function_type;
	mask = 0x07;
	result = port_function_type & mask;

	if ( result == PORT_RAS_ENABLE )		
		return TRUE;
	else
		return FALSE;
}

enum BOOLEAN is_wan_port_ag_enabled(USHORT port_number)
{
	BYTE port_function_type, mask, result;
	
	port_function_type = wan.port[port_number].modem_info.port_function_type;
	mask = 0x07;
	result = port_function_type & mask;
	
/*	printf("\n\rWANCONF1: function type is %d", result);	*/

	if (( result == PORT_AG_ENABLE) || (result == PORT_PROXY_AG_ENABLE) ||
		  (result == PORT_AG_RAS_ENABLE) || (result == PORT_PROXY_AG_RAS_ENABLE))
		return TRUE;
	else
		return FALSE;
}

enum BOOLEAN is_wan_port_ras_enabled(USHORT port_number)
{
	BYTE port_function_type, mask, result;
	
	port_function_type = wan.port[port_number].modem_info.port_function_type;
	mask = 0x07;
	result = port_function_type & mask;
	
/*	printf("\n\rWANCONF2: function type is %d", result);*/

	if (( result == PORT_RAS_ENABLE) || (result == PORT_PROXY_RAS_ENABLE) ||
		  (result == PORT_AG_RAS_ENABLE) || (result == PORT_PROXY_AG_RAS_ENABLE))
		return TRUE;
	else
		return FALSE;
}

enum BOOLEAN is_wan_port_proxy_enabled(USHORT port_number)
{
	BYTE port_function_type, mask, result;
	
	port_function_type = wan.port[port_number].modem_info.port_function_type;
	mask = 0x07;
	result = port_function_type & mask;
	
/*	printf("\n\rWANCONF3: function type is %d", result); */

	if (( result == PORT_PROXY_ENABLE) || (result == PORT_PROXY_AG_ENABLE) ||
		  (result == PORT_PROXY_RAS_ENABLE) || (result == PORT_PROXY_AG_RAS_ENABLE))
		return TRUE;
	else
		return FALSE;
}

/* ...sudha 23 April 1999 */

ULONG get_wan_configured_baud_rate(USHORT port_number)
{
	if (wan.port[port_number].asyncport == TRUE)
		return wan.port[port_number].port_speed;
	else
		return wan.port[port_number].sync_port_speed;
}

char **get_wan_modem_init_strings(USHORT port_number, char **modem_init_strings)
{
	int i;

/* sudha 08 July 1999.For ISDN TA */
	if (wan.port[port_number].isdn_ta_enabled)
	{
		for (i = 0; i < NUMBER_OF_ISDN_INIT_STRINGS; i++)
			*(modem_init_strings + i) = &wan.port[port_number].isdn_info.strings.init_string[i][0];
	}
	
	else
	{
		for (i = 0; i < NUMBER_OF_MODEM_INIT_STRINGS; i++)
			*(modem_init_strings + i) = &wan.port[port_number].modem_info.strings.init_string[i][0];
		for (i = NUMBER_OF_MODEM_INIT_STRINGS; i < NUMBER_OF_ISDN_INIT_STRINGS; i++)
			*(modem_init_strings + i) = '\0';

	}
	return modem_init_strings;
}

char *get_wan_modem_hangup_string(USHORT port_number)
{
	return wan.port[port_number].modem_info.strings.modem_hangup_string;
}

char *get_wan_modem_dial_prefix(USHORT port_number)
{
	return wan.port[port_number].modem_info.strings.modem_dial_prefix;
}

char *get_wan_modem_dial_suffix(USHORT port_number)
{
	return wan.port[port_number].modem_info.strings.modem_dial_suffix;
}

enum BOOLEAN is_wan_port_answering (USHORT port_number)
{
	BYTE port_function_type, mask, result;
	
	port_function_type = wan.port[port_number].modem_info.port_function_type;
	mask = 0x07;
	result = port_function_type & mask;

	if (wan.port[port_number].modem_info.dial_in_out_type == DIAL_IN_PORT)
		return TRUE ;
	else
		return FALSE;

}

/* Sachin 18/12/1996 */

enum WAN_PORT_AVAILABILITY is_port_available_for_configuration (USHORT port_number)
{
	if (wan.port[port_number].enabled == FALSE)
		return (PORT_DISABLED) ;

	if (is_wan_port_answering (port_number) == TRUE)
	{
		/* Answering port */

		if (get_wan_port_owner (port_number) != OWNED_BY_NONE)
			return (PORT_IN_USE) ;
		else
			return (PORT_AVAILABLE_FOR_CONFIGURATION) ;
	}
	else
	{
		/* Dialing port */
/*		if (is_port_dial_on_demand (port_number) == TRUE)
			return (PORT_DIAL_ON_DEMAND) ;*/

		if (get_wan_port_owner (port_number) == OWNED_BY_NONE)
			return (PORT_AVAILABLE_FOR_CONFIGURATION) ;

		if (is_DCD_present (port_number) == TRUE)
			return (PORT_IN_USE) ;

		return (PORT_AVAILABLE_FOR_CONFIGURATION) ;
	}
}

/* Sachin 18/12/1996 */

/* chetan 5/11/96 */
int EnquirePortOwner (USHORT port_number)
{
	switch (get_wan_port_owner (port_number))
	{
		case OWNED_BY_NONE :
			set_wan_port_owner (port_number, OWNED_BY_PPP) ;
			return 1 ;

		case OWNED_BY_PPP :
			return 1 ;

		/* Kamalnath SLIP 07\03\1997 */
		case OWNED_BY_SLIP :
			return 0 ;
		/* Kamalnath SLIP 07\03\1997 */
		
		default :
			return 0 ;
	}
}
/* chetan 5/11/96 */


/* sudhir for proxy server */

USHORT get_wan_port_tx_buffer_size (USHORT port_number)
{

/* this is to be removed */
	return wan.port[port_number].statistics.number_of_bytes_txed;
}

enum BOOLEAN is_enough_buffer_is_free (USHORT port_number)
{
	
  if (wan.port[port_number].statistics.number_of_bytes_to_tx > (((NUMBER_OF_TX_BUFFERS * 1500) * 1) / (128*100)))
		return FALSE;

	return TRUE;			
}








