#include <stddef.h>

#if WEB
#define CM_NUMBER_OF_SECTIONS 			16
#else
#define CM_NUMBER_OF_SECTIONS 			15
#endif

#define CM_MAX_NUMBER_OF_SECTIONS 		30
#define CM_NO_PORT_PARAMETER_PRESENT	255
#define CM_LIFE_TIME 						180
#define CM_NUMBER_OF_FLASH_PROMS 		2
#define IP_ADDRES_LENGTH 	            16
#define METRIC_LENGTH 		            4
#define DNS_ADDRESS_LENGTH             255   /* Jyothi 9/3/98 */

#define	CM_INCREMENT_COUNT				1
#define	CM_DECREMENT_COUNT				2

/* sudha 08 June 1999 */
#define FTP20						20
#define FTP21						21
#define SSL_FTP989				989
#define SSL_FTP990				990
#define Q931_VOIP_900			900
#define Q931_VOIP_902			902
#define RTP_VOIP_5004			5004
#define RTP_VOIP_5006			5006
#define RTCP_VOIP_5005  		5005
#define RTCP_VOIP_5007  		5007


BYTE check_whether_value_is_with_in_limits(USHORT lower_limit, ULONG upper_limit, ULONG value);

enum CM_SECTIONS      {	CM_LSL_SECTION = 0, 
								CM_SOCKET_SECTION, 
								CM_IP_SECTION, 
								CM_PPP_SECTION, 
								CM_CCP_SECTION, 
								CM_VJC_SECTION, 
								CM_SNMP_SECTION, 
								CM_WAN_SECTION, 
								CM_TCP_SECTION, 
								CM_TELNET_SECTION,
								CM_TFTP_SECTION, 
								CM_DHCP_SECTION, 
#if WEB
							  	CM_WEB_SECTION, 
#endif
								CM_PROXY_SECTION,
								CM_AG_SECTION, 
								CM_SCRIPT_SECTION
								}; 

enum PHYSICAL_PORT {ETHERNET_PORT = 0, WAN_PORT_1, WAN_PORT_2, WAN_PORT_3};

enum CM_RETURN_TYPE   {CM_STRING_FORMAT = 0, CM_BYTE_FORMAT, CM_USHORT_FORMAT, CM_ULONG_FORMAT, CM_INDEX_FORMAT};
enum CM_GET_RESULTS   {CM_GET_SUCCESSFUL, CM_LHS_STRING_NOT_FOUND_WHILE_GET, CM_RHS_STRING_NOT_FOUND_WHILE_GET, CM_FAILED_TO_READ_FROM_NON_NUMERIC_DATA};
enum CM_AGENT_TYPE    {CM_OWNED_BY_NONE, CM_OWNED_BY_SNMP, CM_OWNED_BY_TELNET, CM_OWNED_BY_HTTP, CM_OWNED_BY_UIM, CM_OWNED_BY_DTTY};
enum CM_WRITE_RESULTS {CM_WRITE_SUCCESS, CM_WRITE_FAILURE};
enum CM_SET_RESULTS   {CM_SET_SUCCESSFUL = 0, CM_UNKNOWN_FORMAT = 1, CM_ERROR_WHILE_VALIDATING = 2, CM_NOT_ENOUGH_MEMORY = 3};
enum CM_INIT_RESULTS  {CM_INIT_FAILED_NOT_ENOUGH_MEMORY = -1, CM_INIT_SUCCESSFUL = 0, CM_MANAGER_IS_SNMP = 1, CM_MANAGER_IS_TELNET = 2, CM_MANAGER_IS_HTTP = 3, CM_MANAGER_IS_UIM = 4, CM_MANAGER_IS_DTTY = 5};

enum CM_GET_AUTHENTICATION_TYPE {CM_NO_AUTHENTICATION, CM_ONLY_PAP_ENABLED, CM_ONLY_CHAP_ENABLED, CM_BOTH_PAP_AND_CHAP_ENABLED};
enum CM_SET_AUTHENTICATION_TYPE {CM_DISABLE_AUTHENTICATION, CM_ENABLE_PAP, CM_DISABLE_PAP, CM_ENABLE_CHAP, CM_DISABLE_CHAP, CM_ENABLE_BOTH_PAP_AND_CHAP};

enum CM_INSERT_STRING_RESULTS {CM_STRING_INSERTION_SUCCESSFUL, CM_NOT_ENOUGH_MEMORY_WHILE_INSERTING};
enum CM_REMOVE_STRING_RESULTS {CM_REMOVING_STRING_SUCCESSFUL,CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING};
enum CM_EDIT_STRING_RESULTS {CM_STRING_EDIT_SUCCESSFUL, CM_RHS_STRING_NOT_FOUND_WHILE_EDIT, CM_EDITING_FAILED_ON_VALIDATION};

/* sudha 21 Jan 1999 */
enum TEST_RESULT {UNIQUE_ENTRY = 0, PROXY_RESERVED_ENTRY, PROXY_ENTRY, PROXY_RANGE_ENTRY};

BYTE check_whether_value_is_with_in_limits(USHORT lower_limit, ULONG upper_limit, ULONG value);


typedef struct PARAMETER_NODE
{
	struct PARAMETER_NODE* next;
	struct PARAMETER_NODE* previous;
	char parameter[255];
}PARAMETER_NODE;

typedef union 
{
	BYTE string[200];
	BYTE byte_value;
	USHORT ushort_value;
	ULONG ulong_value;
}UNION_RETURN_VALUE;

typedef struct
{
	ULONG offset;
	enum CM_SECTIONS section_type;
}STRUCT_OF_OFFSET_SECTION_TYPE;

typedef struct
{
	ULONG offset;
	enum CM_SECTIONS section_type;
	BYTE (*verification_function)(USHORT min_value, ULONG max_value, ULONG value);
	ULONG min_limit;
	ULONG max_limit;
}STRUCT_OFFSET_AND_PTR_TO_VALIDATION_FUNCTION;

typedef struct
{
	ULONG offset;
	enum CM_SECTIONS section_type;
	void (*resolve_dependency_function)();
}STRUCT_OFFSET_AND_RESOLVE_DEPENDENCIES_FUNCTION;
 
typedef struct
{
	enum CM_AGENT_TYPE owner;
	PARAMETER_NODE* sptr_to_first_node;
	ULONG cfg_mgr_timer;
   DHCP_TAG_DEFINITION* sptr_tag_list;
   ULONG  total_number_of_tags;
} CONFIGURATION_MANAGER_CLASS;


typedef struct
{
	BYTE ip_address[IP_ADDRES_LENGTH];
	BYTE address_mask[IP_ADDRES_LENGTH];
	BYTE gateway_address[IP_ADDRES_LENGTH];
	BYTE metric[METRIC_LENGTH];
	USHORT port;
}STRUCT_STATIC_ROUTE;

typedef struct
{
   USHORT port;
   USHORT protocol;
}STRUCT_PROXY_ENTRY;

/* sudha 18 Jan 1999 */
typedef struct
{
	BYTE descrptn[16];
   USHORT lower_port;
   USHORT higher_port;
   USHORT protocol;
}STRUCT_PROXY_USER_ENTRY;
/* sudha 18 Jan 1999 */

typedef	struct
{
	BYTE	global_addr[IP_ADDRES_LENGTH];
	BYTE	local_addr[IP_ADDRES_LENGTH];
}STRUCT_NAT_STATIC_ENTRY;

typedef	struct
{
   BYTE     local_addr[IP_ADDRES_LENGTH];
	USHORT	protocol;
	USHORT	port;
}STRUCT_NAT_DYNAMIC_ENTRY;

typedef	struct
{
	BYTE	addr[DNS_ADDRESS_LENGTH];    /* Jyothi  DNS length = 255 */

}	STRUCT_PROXY_FILTER;

typedef struct
{
   BYTE ip_addr[IP_ADDRES_LENGTH];
   USHORT  port;
}STRUCT_HOST_ENTRY;

 
extern CONFIGURATION_MANAGER_CLASS cfgmgr_class;
extern PARAMETER_NODE* sptr_to_ptr_to_sections[];
extern BYTE* array_of_ptrs_to_global_class_structres[];
extern PARAMETER_NODE* sptr_to_each_section_in_the_configuration[CM_MAX_NUMBER_OF_SECTIONS];
extern CONFIGURATION_TABLE* sptr_to_configuration_table[CM_NUMBER_OF_SECTIONS];
extern STRUCT_OF_OFFSET_SECTION_TYPE array_of_offset_and_section_type[];
extern STRUCT_OFFSET_AND_PTR_TO_VALIDATION_FUNCTION field_validation_lib[];
extern STRUCT_OFFSET_AND_RESOLVE_DEPENDENCIES_FUNCTION dependency_function_lib[];
extern enum CM_INIT_RESULTS cm_initialize_configuration_manager(enum CM_AGENT_TYPE agent_type);
extern void cm_deinitialize_configuration_manager(enum CM_AGENT_TYPE agent_type);
extern void cm_keep_alive_configuration_manager(enum CM_AGENT_TYPE agent_type);
extern enum CM_GET_RESULTS get_parameter(enum CM_SECTIONS section_to_which_it_belongs_to, void* vptr_parameter_ID,
													  USHORT port_number, enum CM_RETURN_TYPE expected_format_of_return_value, 
									 				  void* vptr_return_value, USHORT string_length);

extern enum CM_GET_RESULTS get_parameter_by_name(enum CM_SECTIONS section_to_which_it_belongs_to, BYTE* bptr_lhs_string,
														 		 USHORT port_number, enum CM_RETURN_TYPE expected_format_of_return_value, 
								 						 		 void* vptr_return_value, USHORT string_length);

extern enum CM_SET_RESULTS set_parameter(enum CM_SECTIONS section_to_which_it_belongs_to, void* vptr_parameter_ID,
								 					 		  USHORT port_number, USHORT format_got,
								 					 		  void* vptr_new_value);
extern enum CM_SET_RESULTS set_parameter_by_name(enum CM_SECTIONS section_to_which_it_belongs_to, 
																 BYTE* bptr_lhs_string,
								 					   		 USHORT port_number, USHORT format_got,
								 					 			 void* vptr_new_value);
extern enum CM_WRITE_RESULTS cm_write_configuration();


extern PARAMETER_NODE* cm_insert_string(enum CM_SECTIONS section_to_which_it_belongs_to, 
													BYTE* bptr_lhs_string, 
		  											void* vptr_rhs);
extern enum CM_REMOVE_STRING_RESULTS cm_remove_string(enum CM_SECTIONS section_to_which_it_belongs_to, 
																	  BYTE* bptr_lhs_string, BYTE* bptr_rhs_string);
extern enum CM_EDIT_STRING_RESULTS cm_edit_string(enum CM_SECTIONS section_to_which_it_belongs_to, 
															    BYTE* bptr_lhs_string, 
																 void* vptr_old_rhs,
																 void* vptr_new_rhs);
extern PARAMETER_NODE* cm_get_first_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
													  BYTE* bptr_lhs_string, 
													  void* vptr_rhs);
extern PARAMETER_NODE* cm_get_next_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);
extern PARAMETER_NODE* cm_get_previous_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);


/*........................ Cut Here ............................... */
#define NETWORK_NUMBER_LENGTH 8+1
#define NODE_NUMBER_LENGTH   12+1
#define SOCKET_NUMBER_LENGTH	4+1

#define CM_ETHERNET_ADDRESS_LENGTH 12+1

#define PROTOCOL_PORT_LENGTH  4+1

enum FILTER {FILTER_ON_DESTINATION = 0, FILTER_ON_SOURCE , FORWARD_ON_DESTINATION, FORWARD_ON_SOURCE};
enum IP_PORT_FILTER_PROTOCOL {PROTOCOL_TCP, PROTOCOL_UDP};

typedef struct
{
	BYTE lhs_string[100];
	PARAMETER_NODE* (*insert_function)(enum CM_SECTIONS section_to_which_it_belongs_to, 
												  BYTE* bptr_lhs_string, 
												  void* vptr_rhs);

	enum CM_REMOVE_STRING_RESULTS (*remove_function)(enum CM_SECTIONS section_to_which_it_belongs_to, 
															       BYTE* bptr_lhs_string, 
																	 void* vptr_rhs);

	enum CM_EDIT_STRING_RESULTS (*edit_function)(enum CM_SECTIONS section_to_which_it_belongs_to, 
													    		BYTE* bptr_lhs_string, 
														 		void* vptr_old_rhs,
														 		void* vptr_new_rhs);
	PARAMETER_NODE* (*get_first_entry_function)(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs);
	PARAMETER_NODE* (*get_next_entry_function)(enum CM_SECTIONS section_to_which_it_belongs_to, 
															 PARAMETER_NODE* current_node, 
															 void* vptr_rhs);
	PARAMETER_NODE* (*get_previous_entry_function)(enum CM_SECTIONS section_to_which_it_belongs_to, 
																  PARAMETER_NODE* current_node, 
																  void* vptr_rhs);
}STRUCT_STRINGS_AND_CORR_FUNCTIONS ;

typedef struct
{
	BYTE network_number[NETWORK_NUMBER_LENGTH];
	BYTE node_number[NODE_NUMBER_LENGTH];
	BYTE socket_number[SOCKET_NUMBER_LENGTH];
	enum PHYSICAL_PORT physical_port;
	enum FILTER filter_type;
}STRUCT_IPX_FILTER;

typedef struct
{
	BYTE ethernet_address[CM_ETHERNET_ADDRESS_LENGTH];
	enum PHYSICAL_PORT physical_port;
	enum FILTER filter_type;
}STRUCT_STP_FILTER;

/* Extern Declerations ... */

extern STRUCT_STRINGS_AND_CORR_FUNCTIONS function_lib_for_insert_delete_edit_and_get[];

extern PARAMETER_NODE* insert_a_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, 
												  BYTE* bptr_lhs_string, 
				  								  void* vptr_rhs);

extern enum CM_REMOVE_STRING_RESULTS remove_a_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, 
																	 BYTE* bptr_lhs_string, void* vptr_rhs);

extern enum CM_EDIT_STRING_RESULTS edit_a_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, 
													    		BYTE* bptr_lhs_string, 
														 		void* vptr_old_rhs,
														 		void* vptr_new_rhs);

extern PARAMETER_NODE* get_first_entry_for_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, 
																 BYTE* bptr_lhs_string, 
																 void* vptr_rhs);

extern PARAMETER_NODE* get_next_entry_for_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);

extern PARAMETER_NODE* get_previous_entry_for_static_route(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);

/* Not Reqd for Proxy 
extern PARAMETER_NODE* insert_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs);


extern enum CM_REMOVE_STRING_RESULTS remove_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs);

extern enum CM_EDIT_STRING_RESULTS edit_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs);

extern PARAMETER_NODE* get_first_entry_for_ipx_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs);

extern PARAMETER_NODE* get_first_entry_for_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs);

extern PARAMETER_NODE* get_next_entry_for_ipx_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);
extern PARAMETER_NODE* get_next_entry_for_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);

extern PARAMETER_NODE* get_previous_entry_for_ipx_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);


extern PARAMETER_NODE* insert_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs);


extern enum CM_REMOVE_STRING_RESULTS remove_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs);

extern enum CM_EDIT_STRING_RESULTS edit_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs);

extern PARAMETER_NODE* get_first_entry_for_stp_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs);

extern PARAMETER_NODE* get_first_entry_for_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs);

extern PARAMETER_NODE* get_next_entry_for_stp_filter_main_function(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);

extern PARAMETER_NODE* get_next_entry_for_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);

extern PARAMETER_NODE* get_previous_entry_for_stp_filter(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);


Not Reqd For Proxy Server */


extern PARAMETER_NODE* insert_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs);


extern enum CM_REMOVE_STRING_RESULTS remove_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs);

extern enum CM_EDIT_STRING_RESULTS edit_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs);

extern PARAMETER_NODE* get_first_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs);

extern PARAMETER_NODE* get_next_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);


extern PARAMETER_NODE* get_previous_proxy_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);


/* sudha 19 Jan 1999... */

extern PARAMETER_NODE* insert_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
											 BYTE* bptr_lhs_string, 
				  							 void* vptr_rhs);


extern enum CM_REMOVE_STRING_RESULTS remove_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  	BYTE* bptr_lhs_string, void* vptr_rhs);

extern enum CM_EDIT_STRING_RESULTS edit_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
													     BYTE* bptr_lhs_string, 
														  void* vptr_old_rhs,
														  void* vptr_new_rhs);

extern PARAMETER_NODE* get_first_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, 
															  BYTE* bptr_lhs_string, 
															  void* vptr_rhs);

extern PARAMETER_NODE* get_next_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);


extern PARAMETER_NODE* get_previous_proxy_user_entry(enum CM_SECTIONS section_to_which_it_belongs_to, PARAMETER_NODE* current_node, void* vptr_rhs);

/* ... sudha 19 Jan 1999 */

extern BYTE valid_characters_in(BYTE* address);
extern BYTE is_an_ip_address(BYTE* address);
extern BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
extern BYTE local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);
extern BYTE is_valid_ipx_network_number(BYTE* string_ptr);
extern void format_the_ipx_network_number(BYTE* string_ptr);
extern int  strcmpi(char *source, char *dest);
extern BYTE is_a_default_ip_address(BYTE* address);
extern BYTE is_a_static_ip_address(BYTE* address, BYTE* mask);
extern BYTE is_a_static_ip_address_mask(BYTE* address, BYTE* mask);



/* Extern declarations corresponding to NAT functions */

extern PARAMETER_NODE* insert_nat_static_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_REMOVE_STRING_RESULTS remove_nat_static_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_EDIT_STRING_RESULTS edit_nat_static_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_old_rhs, void* vptr_new_rhs);
extern PARAMETER_NODE* get_first_nat_static_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern PARAMETER_NODE* get_next_nat_static_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);
extern PARAMETER_NODE* get_previous_nat_static_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);

extern PARAMETER_NODE* insert_nat_dynamic_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_REMOVE_STRING_RESULTS remove_nat_dynamic_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_EDIT_STRING_RESULTS edit_nat_dynamic_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_old_rhs, void* vptr_new_rhs);
extern PARAMETER_NODE* get_first_nat_dynamic_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern PARAMETER_NODE* get_next_nat_dynamic_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);
extern PARAMETER_NODE* get_previous_nat_dynamic_mapping(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);

extern PARAMETER_NODE* insert_nat_global_address(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_REMOVE_STRING_RESULTS remove_nat_global_address(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_EDIT_STRING_RESULTS edit_nat_global_address(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_old_rhs, void* vptr_new_rhs);
extern PARAMETER_NODE* get_first_nat_global_address(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern PARAMETER_NODE* get_next_nat_global_address(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);
extern PARAMETER_NODE* get_previous_nat_global_address(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);

/* Extern declarations corresponding to Proxy Filter functions */

extern PARAMETER_NODE* insert_proxy_filter(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_REMOVE_STRING_RESULTS remove_proxy_filter(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_EDIT_STRING_RESULTS edit_proxy_filter(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_old_rhs, void* vptr_new_rhs);
extern PARAMETER_NODE* get_first_proxy_filter(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern PARAMETER_NODE* get_next_proxy_filter(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);
extern PARAMETER_NODE* get_previous_proxy_filter(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);


/* Extern declarations corresponding to Link Control functions */

extern PARAMETER_NODE* insert_user_address(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_REMOVE_STRING_RESULTS remove_user_address(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern enum CM_EDIT_STRING_RESULTS edit_user_address(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_old_rhs, void* vptr_new_rhs);
extern PARAMETER_NODE* get_first_user_address(
				enum CM_SECTIONS section_to_which_it_belongs_to, 
				BYTE* bptr_lhs_string, void* vptr_rhs);
extern PARAMETER_NODE* get_next_user_address(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);
extern PARAMETER_NODE* get_previous_user_address(
				enum CM_SECTIONS section_to_which_it_belongs_to,
				PARAMETER_NODE* current_node, void* vptr_rhs);


/* ... Extern Declerations */
/*........................ Cut Here ............................... */

/* DHCP Related */





#define CM_IP_ADDRESS_LENGTH        16
#define CM_MAX_MAC_ADDRESS_LENGTH   21
#define CM_DHCP_OPTION_VALUE_LENGTH 50

typedef struct 
{
   BYTE ip_address_lower[CM_IP_ADDRESS_LENGTH];
   BYTE ip_address_higher[CM_IP_ADDRESS_LENGTH];
   BYTE net_mask[CM_IP_ADDRESS_LENGTH];
   BYTE exclude_ip_address_lower[CM_IP_ADDRESS_LENGTH];
   BYTE exclude_ip_address_higher[CM_IP_ADDRESS_LENGTH];
}CM_STRUCT_DHCP_RANGE;

typedef struct
{
   BYTE ip_address_to_bind[CM_IP_ADDRESS_LENGTH];
   BYTE mac_address_length;
   BYTE mac_address_to_bind[CM_MAX_MAC_ADDRESS_LENGTH];
}CM_STRUCT_DHCP_BIND;

typedef struct
{
   BYTE option;
   BYTE option_value[CM_DHCP_OPTION_VALUE_LENGTH];
   BYTE position;
}CM_STRUCT_DHCP_OPTION;

typedef struct
{
   BYTE string[100];
   void (*setup_function) (char* cptr_start_of_configuration_string, ULONG parameter_1, ULONG ulptr_parameter_2, ULONG parameter_3);
}STRUCT_OF_STRINGS_AND_CORR_FUNCTIONS;

typedef struct
{
   BYTE option;
   BYTE (*validation_function) (BYTE* new_value, BYTE max_digits, ULONG lower_limit, ULONG upper_limit);
   BYTE max_digits;
   ULONG lower_limit;
   ULONG upper_limit;
}CM_OPTION_VALIDATING_TABLE;

typedef struct
{
   USHORT option;
   void (*convert_function) (BYTE* original, BYTE* converted);  
   void (*revert_function)  (DHCP_OPTION_ENTRY* sptr_option, BYTE* converted);  
}CM_OPTION_CONVERSION_TABLE;

enum CM_DHCP_RANGE_INSERTION_RETURN_TYPE 
{
   CM_DHCP_INSERTION_SUCCESS = 1,

   /* Validations */
   CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS,
   CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS,
   CM_DHCP_INSERTION_FAILED_INVALID_SUBNET_MASK,
   CM_DHCP_INSERTION_FAILED_INVALID_RANGE,
   CM_DHCP_INSERTION_FAILED_INVALID_LOWER_IP_ADDRESS_EXCLUDE, 
            /* this includes whether this address is greater then or equal to lower ip address */
   CM_DHCP_INSERTION_FAILED_INVALID_HIGHER_IP_ADDRESS_EXCLUDE,
            /* this includes whether this address is less then or equal to upper ip address  and this should be greater then above field - lower_ip_address_exclude */
   CM_DHCP_INSERTION_FAILED_INVALID_EXCLUSION,

   /* Overlaps/Duplications */
   CM_DHCP_INSERTION_FAILED_RANGE_DUPLICATION,
   CM_DHCP_INSERTION_FAILED_OVERLAPING_WITH_OTHER_RANGE_EXCLUSION,

   /* Memory */
   CM_DHCP_INSERTION_FAILED_INSUFFICIENT_MEMORY,

   /* Following are for editing the tags ... */
   CM_DHCP_EDITING_FAILED_IP_IS_BOUND_TO_MAC_ADDRESS,
   CM_DHCP_EDITING_FAILED_TO_GET_OLD_RANGE,
   CM_DHCP_EDITING_FAILED_TO_CHANGE_DEFAULT

};

enum CM_DHCP_RANGE_DELETION_RETURN_TYPE
{
   CM_DHCP_DELETION_SUCCESS = 1,
   CM_DHCP_DELETION_RANGE_NOT_FOUND,
   CM_DHCP_DELETION_FAILED_TRYING_TO_DELETE_DEFAULT
};

enum CM_DHCP_BIND_RETURN_TYPE
{
   CM_DHCP_BINDING_SUCCESS = 1,
   CM_DHCP_BINDING_FAILED_DUPLICATED_IP_ADDRESS,
   CM_DHCP_BINDING_FAILED_DUPLICATED_MAC_ADDRESS,

   CM_DHCP_BINDING_FAILED_INVALID_MAC_ADDRESS_LENGTH,
   CM_DHCP_BINDING_FAILED_MAC_ADDRESS_GREATER_THAN_LENGTH,
   CM_DHCP_BINDING_FAILED_INVALID_MAC_ADDRESS,
   CM_DHCP_BINDING_FAILED_INVALID_IP_ADDRESS,
   CM_DHCP_BINDING_FAILED_IP_ADDRESS_OUT_OF_RANGE,
   CM_DHCP_BINDING_FAILED_CAN_NOT_BIND_DEFAULT_RANGE,

   /* Memory */
   CM_DHCP_BINDING_FAILED_INSUFFICIENT_MEMORY
};

enum CM_DHCP_UNBIND_RETURN_TYPE
{
   CM_DHCP_UNBIND_SUCCESS = 1,
   CM_DHCP_UNBIND_FAILED 
};

enum CM_DHCP_INSERT_OPTION_RETURN_TYPE
{
   CM_DHCP_INSERTING_OPTION_SUCCESS = 1,
   CM_DHCP_INSERTING_OPTION_FAILED_INVALID_DATA,
   CM_DHCP_INSERTING_OPTION_FAILED_DUPLICATE_ENTRY,

   /* Memory */
   CM_DHCP_EDITING_OPTION_FAILED_INSUFFICIENT_MEMORY
};

enum CM_DHCP_DELETE_OPTION_RETURN_TYPE
{
   CM_DHCP_DELETING_OPTION_SUCCESS = 1,
   CM_DHCP_DELETING_OPTION_FAILED_OPTION_NOT_FOUND,
   CM_DHCP_DELETING_OPTION_FAILED_CANNOT_DELETE
};


/* API's to be included in \rtrware\include\cfgmgr.h ... */
/* Range */
extern enum CM_DHCP_RANGE_INSERTION_RETURN_TYPE cm_insert_dhcp_address_range(CM_STRUCT_DHCP_RANGE* sptr_range_to_insert);
extern enum CM_DHCP_RANGE_DELETION_RETURN_TYPE  cm_delete_dhcp_address_range(CM_STRUCT_DHCP_RANGE* sptr_range_to_delete);
extern enum CM_DHCP_RANGE_DELETION_RETURN_TYPE  cm_delete_dhcp_address_range_by_tag_number(USHORT tag_number);
extern enum CM_DHCP_RANGE_INSERTION_RETURN_TYPE cm_edit_dhcp_address_range(CM_STRUCT_DHCP_RANGE* sptr_old_range, CM_STRUCT_DHCP_RANGE* sptr_new_range);
extern BYTE                                     cm_get_dhcp_address_range(USHORT tag_number, CM_STRUCT_DHCP_RANGE* sptr_range);
/* Binding */
extern enum CM_DHCP_BIND_RETURN_TYPE            cm_bind_mac_and_ip_address(USHORT tag_number, CM_STRUCT_DHCP_BIND* sptr_bind_info);
extern enum CM_DHCP_UNBIND_RETURN_TYPE          cm_unbind_mac_and_ip_address(USHORT tag_number, CM_STRUCT_DHCP_BIND* sptr_unbind_info);
extern BYTE                                     cm_get_first_dhcp_binding(USHORT tag_number, CM_STRUCT_DHCP_BIND* sptr_bind);
extern BYTE                                     cm_get_next_dhcp_binding(USHORT tag_number, CM_STRUCT_DHCP_BIND* sptr_bind);
extern BYTE                                     cm_get_dhcp_binding(USHORT tag_number, BYTE bind_number, CM_STRUCT_DHCP_BIND* sptr_bind_info);
/* Option */
extern enum CM_DHCP_INSERT_OPTION_RETURN_TYPE   cm_insert_dhcp_range_option(USHORT tag_number, CM_STRUCT_DHCP_OPTION* sptr_dhcp_option_to_insert);
extern enum CM_DHCP_DELETE_OPTION_RETURN_TYPE   cm_delete_dhcp_range_option(USHORT tag_number, CM_STRUCT_DHCP_OPTION* sptr_dhcp_option_to_delete);
extern enum CM_DHCP_INSERT_OPTION_RETURN_TYPE   cm_edit_dhcp_range_option(USHORT tag_number, CM_STRUCT_DHCP_OPTION* sptr_dhcp_old_option, CM_STRUCT_DHCP_OPTION* sptr_dhcp_new_option);
extern BYTE                                     cm_get_dhcp_range_option_by_number(USHORT tag_number, BYTE option_number, CM_STRUCT_DHCP_OPTION* sptr_option);
extern BYTE                                     cm_get_dhcp_range_option_by_option(USHORT tag_number, USHORT option, CM_STRUCT_DHCP_OPTION* sptr_option);
/* General */
extern USHORT   cm_get_total_number_of_ranges();
extern USHORT   cm_get_total_number_of_bindings_in_a_range(USHORT tag_number);
extern USHORT   cm_get_number_of_option_values(USHORT option);

/* ... API's to be included in \rtrware\include\cfgmgr.h */



#if PROXY_SERVER


typedef enum
{
   IDLE,
   OFFLINE,
   WAN_LINK_UP, /* Physical Link up */
   LCP_UP,
   PPP_CLIENT_UP,
   MLPPP_CLIENT_UP,
   SEND_INIT_COMMAND,
   WAIT_FOR_OK,
   DIAL_NUMBER,
   WAIT_FOR_CONNECT,
/* Sachin 09/11/1997 */
   SLIP_CLIENT_UP,
   DISABLED,
/* Sachin 09/11/1997 */

/* sudha 11-Oct-1999. Added these missing states... */
/* new states to display 9/4/98 */
	CALL_BACK,
	RAS_CLIENT_CONNECTED,
	IDLE_WAIT_CALL,
/* sudha 11-Oct-1999. New state for answering ras port */
	RAS_WAIT_CALL,
	HANGING_UP,
/* ...sudha 11-Oct-1999. Added these missing states */

   WAN_PORT_STATUS_NUMBER_OF_STATES
} WAN_LINK_STATUS ;

/* sudha 19 Jan 1999 */
extern enum TEST_RESULT is_user_defined_port_range_unique(USHORT lower_port,USHORT higher_port,USHORT protocol);
extern BOOL is_user_defined_port_desc_not_a_duplicate(BYTE user_desc[16], USHORT protocol);

extern BYTE check_if_ras_address_is_valid_and_unique(char *remote_address, USHORT port_number);
extern BYTE validate_alpha_numeric_underscore_name_and_convert_to_upper_case(BYTE *name);
extern BOOL IsStrNumericAndValid(char *Str);
extern void get_ftp_port_numbers(USHORT *ctrl_port, USHORT *data_port);
extern BYTE *get_physical_port(USHORT port_number);

extern ULONG proxy_get_local_ip_address (USHORT port_number) ;
extern ULONG proxy_get_remote_ip_address (USHORT port_number) ;
extern ULONG proxy_get_subnet_mask (USHORT port_number) ;
extern BYTE get_port_status (USHORT port_number) ;
extern ULONG get_baud_rate (USHORT port_number) ;
extern char *get_modem_name (USHORT port_number, char *modem_name_string, int modem_name_string_length) ;
extern char *get_modem_connect_message (USHORT port_number, char *connect_message_string, int connect_message_string_length) ;
extern char *get_ppp_user_name (USHORT port_number, char *user_name, int user_name_length) ;

extern ULONG get_connection_up_time (USHORT port_number) ;
extern ULONG get_connection_tx_count (USHORT port_number) ;
extern ULONG get_connection_rx_count (USHORT port_number) ;

extern ULONG get_aggregate_rx_count (USHORT port_number) ;
extern ULONG get_aggregate_tx_count (USHORT port_number) ;
extern ULONG get_number_of_calls (USHORT port_number) ;
extern ULONG get_aggregate_connection_time (USHORT port_number) ;

/* Vidy added the following 4 functions 31/10/97 */
extern ULONG get_connection_tx_packet_count (USHORT port_number) ;
extern ULONG get_connection_rx_packet_count (USHORT port_number) ;

extern ULONG get_aggregate_rx_packet_count (USHORT port_number) ;
extern ULONG get_aggregate_tx_packet_count (USHORT port_number) ;

/* Ramana added the following functions for NAT, Filters and Link Control */
extern void update_count_in_ini (BYTE *lhs_string, BYTE flag,USHORT port_num);


#endif

