#ifndef _FLSH_H_

#define _FLSH_H_


#define MAX_FLASH_WRITES_PENDING 600
#define NUMBER_OF_FLASH_PROMS    4

/*
	The idea is to keep track of the state of flash i-o in a global (to be
	extended to have one for each flash). Any process seeking access to flash 
	monitors this global. It is initially in FLASH_ACCESSIBLE state. It moves
	over to the FLASH_WRITE_IN_PROGRESS state once flash write series starts off.
	After the last page of the flash is written, it moves to the FLASH_WRITE_COMPLETE
	state. It is only 10 ms. after this that it moves to the FLASH_ACCESSIBLE
	state.
		The best way is to have an extensible scheme here. We could have a class
	FLASH_CLASS, one for each flash, that describes the parameters (start address
	in the memory map, size of the flash, flash-page-size, etc.) and the status
	(WRITE_IN_PROGRESS, READ_IN_PROGRESS, etc.) of the corresponding flash. The
	functions in the scheduler can be arranged to handle all this stuff transparently.
*/

enum FLASH_ACCESSIBILITY
{
	FLASH_ACCESSIBLE,
	FLASH_WRITE_IN_PROGRESS,
	FLASH_READ_IN_PROGRESS,
	FLASH_WRITE_COMPLETE
} ;

extern enum FLASH_ACCESSIBILITY flash_accessibility[NUMBER_OF_FLASH_PROMS] ;
extern unsigned short Fl1ProId, Fl2ProId ;

typedef struct
{
	char *src_ptr, *dest_ptr ;
	unsigned short block_length ;
	void (*fptr_block_write_complete)(void) ;
	char *buffer_to_free ;
} FLASH_WRITE_BLOCKS ;

struct FLASH_WRITE_SCHEDULE_CLASS
{
	short head_of_Q ;      /* Initialized to 0  */
	short tail_of_Q ;      /* Initialized to -1 */
	FLASH_WRITE_BLOCKS flash_write_blocks[MAX_FLASH_WRITES_PENDING] ;
} ;


/* FLASHMGR.C */
extern void init_flash_write_scheduler (void) ;
extern int schedule_flash_write (char *src_ptr, char *dest_ptr, unsigned short block_length,
                                 void (*fptr_block_write_complete)(), char *buffer_to_free) ;
extern int write_next_page (void) ;


#endif
