/*---------------------------------------------------------------------------
	file	:	log.c
	Auth	:	vidy
	Date	:	30th Jan 98
	Synop	:	Contains the interface routines for the log abstract data type
	Assumptions :
	1. Log can log only message strings with a null termination.
	2. This is for logging events which are not-too-fast. SO it
	assumes that the log read is a much faster operation than log write.
	If this is not the case the read pointers may become invalid during
	a read process as the circular buffer eats up the head
	3. log functions are not to be used from ISRs
---------------------------------------------------------------------------*/
int	init_log(void);
void	clean_log(void);
int	open_log(void);
int	close_log(int log_descriptor);
void	write_log(char *message);
int	read_log(int log_descriptor, char *buffer, int count);
int	get_info_log(int *approx_total_size, int *approx_number_of_msgs);

extern	unsigned long log_size;		/* log file size */
extern	int	log_enabled;			/* flag to turn on/off logging dynamic */
extern	int	time_stamp_log;

#define	LOG_NOT_LOGGING			-1
#define	LOG_INVALID_DESCRIPTOR	-2
#define	LOG_ERR_MAX_OPEN			-3

#define	LOG_NORMAL_MSG_LEN		80	/* just for easy access every where */
