/* SERIAL.H -- Has prototypes for inclusion in other sections that need
**			   functions from here.
*/

#ifndef _SERIAL_H_
#define _SERIAL_H_

enum TX_BUFFER_OWNER { APPLICATION, DRIVER };

/* SERINIT.C */
extern enum TEST setup_serial_port_for_use(USHORT port_number, void *user_parameter,
	void (*fptr_tx_complete)(USHORT port_number, void *user_parameter, BYTE *sptr_tx_buffer),
	void (*fptr_rx_callback)(USHORT port_number, void *user_parameter, BYTE *buf_ptr, USHORT data_size),
	void (**fptr_rx_complete)(USHORT port_number, BYTE *sptr_buffer, USHORT send_status),
	ULONG baud_rate, BYTE data_bits, BYTE parity, BYTE stop_bits);
extern enum TEST free_serial_port_from_use(USHORT port_number);
extern void serial_foreground(void);
extern enum BOOLEAN is_serial_port_in_use_by_driver(USHORT port_number);
extern void modify_serial_parameters(USHORT port_number, BYTE data_bits, BYTE parity, BYTE stop_bits);
extern void modify_serial_baud_rate(USHORT port_number, ULONG baud_rate);
extern USHORT modify_serial_rx_buffer_size(USHORT port_number, USHORT max_rx_buffer_size);
extern void flush_serial_tx_buffers(USHORT port_number);
extern void flush_serial_rx_buffers(USHORT port_number);
extern void set_serial_rts(USHORT port_number);
extern void reset_serial_rts(USHORT port_number);
extern void set_serial_dtr(USHORT port_number);
extern void reset_serial_dtr(USHORT port_number);
extern enum BOOLEAN is_dcd_present(USHORT port_number);
extern USHORT serial_get_tx_time_estimate(USHORT port_number);
extern void associate_user_parameter_with_serial_driver(USHORT port_number, BYTE *user_parameter);
extern enum BOOLEAN is_serial_tx_buffer_empty(USHORT port_number);

/* SERRX.C */

/* SERTX.C */
extern enum TEST serial_tx_packet(USHORT port_number, BYTE *sptr_tx_buffer, USHORT number_of_bytes, enum TX_BUFFER_OWNER tx_buffer_owner);

#endif /* _SERIAL_H_ */
