/*	$Modname: vnvrmstr.h$  $version: 1.7$      $date: 02/11/94$   */
/*
* 	$lgb$
1.0 10/21/93 ross
1.1 10/21/93 ross
1.2 10/21/93 ross
1.3 11/01/93 ross ipx certification version
1.4 12/01/93 ross lsl version 3 additions.
1.5 01/08/94 ross More LSL version 3 changes
1.6 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.7 02/11/94 ross added stuff for dlsw and nlsp.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
typedef	struct	CONFIGURATION_FUNCTION
{
	void 	(*fptr_parameter_function) (char *cptr_start_of_configuration_string,ULONG parameter_1,
		ULONG ulptr_parameter_2,ULONG parameter_3);
	enum BOOLEAN *eptr_enable_string;
	char *cptr_parameter_string;
	ULONG	parameter_1;
	ULONG	ulptr_parameter_2;
	ULONG	parameter_3;
	ULONG	minimum_value;
	ULONG	maximum_value;
} CONFIGURATION_FUNCTION;

typedef	struct	CONFIGURATION_TABLE
{
	enum BOOLEAN 				valid;

	CONFIGURATION_FUNCTION	function[200];

} CONFIGURATION_TABLE;	

typedef	struct	NVRAM_CLASS
{
	enum BOOLEAN 			display_configuration_file;

	BYTE 						current_configuration_section_index;

	CONFIGURATION_TABLE	*sptr_current_configuration_table;

	BYTE 						value[12];
	BYTE 						number_of_configurations;
} NVRAM_CLASS;

_EXTERN void set_variable_port_and_enable (char *cptr_start_of_configuration_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_variable_port_and_enable_ushort (char *cptr_start_of_configuration_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_variable_port_and_enable_ulong (char *cptr_start_of_configuration_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_variable_port_less_one_and_enable (char *cptr_start_of_configuration_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_variable_port_and_ushort_decimal_value (char *cptr_start_of_configuration_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_variable_port_and_ushort_hex_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_variable_port_and_swapped_ushort_hex_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_ushort_swapped_hex_value (char *cptr_start_of_configuration_string,ULONG offset,ULONG ulptr_base);
_EXTERN void set_ushort_decimal_value (char *cptr_start_of_configuration_string,ULONG offset,ULONG ulptr_base);
_EXTERN void set_byte_decimal_value (char *cptr_start_of_configuration_string,ULONG offset,ULONG ulptr_base);
_EXTERN void set_variable_string (char *cptr_start_of_configuration_string,ULONG offset,ULONG ulptr_base);
_EXTERN void set_variable_port_and_string (char *cptr_value_string,ULONG offset,ULONG ulptr_base,ULONG size_of_entry);
_EXTERN void set_ulong_swapped_hex_value (char *cptr_start_of_configuration_string,ULONG offset,ULONG ulptr_base);
_EXTERN void nvram_memcpy (void *vptr_destination,void *vptr_source,USHORT number_of_bytes);
_EXTERN enum BOOLEAN is_parameter_enabled (char *cptr_parameter_string);
_EXTERN USHORT get_port_number_and_string (char *cptr_port_number_and_value,char *return_string);
_EXTERN ULONG get_port_number_and_value (char *cptr_port_number_and_value,USHORT *usptr_port_number);
_EXTERN ULONG get_port_number_and_hex_value (char *cptr_port_number_and_value,USHORT *usptr_port_number);
_EXTERN ULONG get_ulong_hex_value (char *cptr_port_number_and_value);
_EXTERN ULONG get_decimal_value (char *cptr_value);
_EXTERN void set_variable_port_and_ulong_decimal_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_ulong_decimal_value (char *cptr_value_string,ULONG offset,ULONG ulptr_base);
_EXTERN void set_ulong_value (char *cptr_value_string,ULONG offset,ULONG ulptr_base);
_EXTERN void set_variable_port_and_byte_decimal_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_variable_port_and_swapped_ulong_hex_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_variable_port_and_mac_address (char *cptr_ethernet_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_mac_address (char *cptr_mac_address_string,ULONG offset,ULONG ulptr_base);
_EXTERN ULONG convert_4_bytes_to_ulong (BYTE byte_1,BYTE byte_2,BYTE byte_3,BYTE byte_4);
_EXTERN void add_section_name_and_configuration_table_pointer (char *cptr_section_name,
	CONFIGURATION_TABLE *sptr_configuration_table_to_add);
_EXTERN void set_variable_port_and_ip_address (char *cptr_ip_address_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
_EXTERN void set_ip_address (char *cptr_ip_address_string,ULONG offset,ULONG ulptr_base);
/* kamalnath 15/11/96 */
_EXTERN void set_dhcp_server_ip_address (char *cptr_ip_address_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter);
/* kamalnath 15/11/96 */


#if defined (__NEW_CONFIG__)

enum CONFIGURATION_FUNCTION_TYPE
{
	 SET_VARIABLE_PORT_AND_ENABLE = 0x00000001L,
	 SET_VARIABLE_PORT_LESS_ONE_AND_ENABLE ,
	 SET_VARIABLE_PORT_AND_USHORT_DECIMAL_VALUE ,
	 SET_VARIABLE_PORT_AND_USHORT_HEX_VALUE ,
	 SET_VARIABLE_PORT_AND_SWAPPED_USHORT_HEX_VALUE ,
	 SET_USHORT_SWAPPED_HEX_VALUE ,
	 SET_USHORT_DECIMAL_VALUE ,
	 SET_BYTE_DECIMAL_VALUE ,
	 SET_VARIABLE_STRING ,
	 SET_VARIABLE_PORT_AND_STRING ,
	 SET_ULONG_SWAPPED_HEX_VALUE ,
	 SET_VARIABLE_PORT_AND_ULONG_DECIMAL_VALUE ,
	 SET_ULONG_DECIMAL_VALUE ,
	 SET_ULONG_HEX_VALUE ,
	 SET_VARIABLE_PORT_AND_BYTE_DECIMAL_VALUE ,
	 SET_VARIABLE_PORT_AND_SWAPPED_ULONG_HEX_VALUE ,
	 SET_VARIABLE_PORT_AND_MAC_ADDRESS ,
	 SET_MAC_ADDRESS ,
	 SET_VARIABLE_PORT_AND_IP_ADDRESS ,
	 SET_IP_ADDRESS,
	 SET_VARIABLE_PORT_IPX_TX_FRAME_TYPE,
	 LAST_CONFIGURATION_FUNCTION_TYPE
};

#define	 set_variable_port_and_enable SET_VARIABLE_PORT_AND_ENABLE
#define	 set_variable_port_less_one_and_enable  SET_VARIABLE_PORT_LESS_ONE_AND_ENABLE
#define	 set_variable_port_and_ushort_decimal_value  SET_VARIABLE_PORT_AND_USHORT_DECIMAL_VALUE
#define	 set_variable_port_and_ushort_hex_value  SET_VARIABLE_PORT_AND_USHORT_HEX_VALUE
#define	 set_variable_port_and_swapped_ushort_hex_value  SET_VARIABLE_PORT_AND_SWAPPED_USHORT_HEX_VALUE
#define	 set_ushort_swapped_hex_value  SET_USHORT_SWAPPED_HEX_VALUE
#define	 set_ushort_decimal_value  SET_USHORT_DECIMAL_VALUE
#define	 set_byte_decimal_value  SET_BYTE_DECIMAL_VALUE
#define	 set_variable_string  SET_VARIABLE_STRING
#define	 set_variable_port_and_string  SET_VARIABLE_PORT_AND_STRING
#define	 set_ulong_swapped_hex_value  SET_ULONG_SWAPPED_HEX_VALUE
#define	 set_variable_port_and_ulong_decimal_value  SET_VARIABLE_PORT_AND_ULONG_DECIMAL_VALUE
#define	 set_ulong_decimal_value  SET_ULONG_DECIMAL_VALUE
#define	 set_ulong_value  SET_ULONG_HEX_VALUE
#define	 set_variable_port_and_byte_decimal_value  SET_VARIABLE_PORT_AND_BYTE_DECIMAL_VALUE
#define	 set_variable_port_and_swapped_ulong_hex_value  SET_VARIABLE_PORT_AND_SWAPPED_ULONG_HEX_VALUE
#define	 set_variable_port_and_mac_address  SET_VARIABLE_PORT_AND_MAC_ADDRESS
#define	 set_mac_address  SET_MAC_ADDRESS
#define	 set_variable_port_and_ip_address  SET_VARIABLE_PORT_AND_IP_ADDRESS
#define	 set_ip_address  SET_IP_ADDRESS
#define	 set_variable_port_ipx_tx_frame_type SET_VARIABLE_PORT_IPX_TX_FRAME_TYPE

#endif
