#include	"defs.h"
/*	$Modname: lslbuff.c$  $version: 1.16$      $date: 03/31/95$   */
/*
* 	$lgb$
1.0 11/02/93 ross moving out protocol stack buffering.
1.1 11/20/93 ross added aligned buffer strategy.
1.2 11/29/93 ross
1.3 01/08/94 ross More LSL version 3 changes
1.4 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.5 03/06/94 ross adding more rfc 1213 statistics.
1.6 03/09/94 ross removed some duplicate variables
1.7 03/11/94 ross added void * cast.  Courtesy of Lori.
1.8 03/14/94 ross cleaned up braces and white spaces for release.
1.9 03/26/94 ross added size of memory in .ini file.
1.10 06/15/94 ross cosmetic changes.
1.11 09/26/94 ross protected mode changes.
1.12 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.13 01/12/95 ross building rwutils directory.
1.14 02/21/95 ross add close changes.
1.15 03/03/95 ross added lsl control.
1.16 03/31/95 ross New close function, general cleanup.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifdef __MSDOS__
	#include <alloc.h>
	#include <dos.h>
#endif
#include	"lsl.h"
/****************************************************************************/
static void build_device_driver_buffer_list (ULONG size_of_device_driver_buffers,USHORT number_of_real_ports);
static USHORT get_number_of_rx_buffers (ULONG size_for_rx_buffers,USHORT number_of_real_ports);
static void add_buffers_to_rx_list (USHORT number_of_rx_buffers,LSL_PORT_CLASS *sptr_port);
static ULONG align_device_driver_buffer_address (ULONG address_to_align);
static ULONG normalize_address (ULONG address);
static void get_number_of_rx_buffers_for_ports (ULONG size_for_rx_buffers,USHORT number_of_real_ports) ;
/****************************************************************************/
enum TEST initialize_buffer_class (ULONG size_of_memory_for_device_drivers)
{
	ULONG number_of_bytes_to_align;

	if (size_of_memory_for_device_drivers != 0x00000000L)
		{
		lsl.buffer.total_size = size_of_memory_for_device_drivers;
		}
	else
		{
		size_of_memory_for_device_drivers = lsl.buffer.total_size;
		}

#ifndef __MSDOS__
	lsl.buffer.start_address_device_driver_buffers = (ULONG) malloc (size_of_memory_for_device_drivers);
#else
	lsl_printf (LSL_BUFFER_PRINTF,
		"Buffer Memory:  Buffer Memory Total Size %08lx\r\n",farcoreleft ());

	lsl.buffer.start_address_device_driver_buffers = (ULONG) farcalloc (size_of_memory_for_device_drivers,1);
#endif

	if (lsl.buffer.start_address_device_driver_buffers == (int) NULL)
		{
		lsl_printf (LSL_ALARM_PRINTF,"Out of Memory For Device Drivers\r\n");

		return (FAIL);
		}
	else
		{
		number_of_bytes_to_align = align_device_driver_buffer_address (lsl.buffer.start_address_device_driver_buffers);

		lsl.buffer.aligned_start_address_device_driver_buffers =	number_of_bytes_to_align + 
			lsl.buffer.start_address_device_driver_buffers;

		size_of_memory_for_device_drivers -= number_of_bytes_to_align;

		lsl.buffer.end_address_device_driver_buffers = lsl.buffer.aligned_start_address_device_driver_buffers +
			size_of_memory_for_device_drivers;

		lsl.buffer.size_of_device_driver_buffers = size_of_memory_for_device_drivers;
		lsl.buffer.current_device_driver_buffer = lsl.buffer.aligned_start_address_device_driver_buffers;
		}

	lsl_printf (LSL_BUFFER_PRINTF,
		"Device Drivers:  Buffer Start Address %08lx, Buffer End Address %08lx, Size %08lx \r\n",
		lsl.buffer.start_address_device_driver_buffers,lsl.buffer.end_address_device_driver_buffers,
		size_of_memory_for_device_drivers);

	build_device_driver_buffer_list (lsl.buffer.size_of_device_driver_buffers,
		(USHORT) (lsl.number_of_lan_ports + lsl.number_of_wan_ports));

	return (PASS);
}
/****************************************************************************/
static ULONG align_device_driver_buffer_address (ULONG address_to_align)
{
	ULONG normalized_address;
	ULONG number_of_bytes_added;

	normalized_address = normalize_address (address_to_align);

	number_of_bytes_added = normalized_address & BUFFER_ALIGNMENT_SIZE_MASK;

	number_of_bytes_added = BUFFER_ALIGNMENT_BOUNDARY - number_of_bytes_added;

	number_of_bytes_added &= BUFFER_ALIGNMENT_SIZE_MASK;

	return (number_of_bytes_added);
}
/****************************************************************************/
static ULONG normalize_address (ULONG address)
{
	#ifdef __MSDOS__
		ULONG linear_address;
		ULONG	segment;
		ULONG	offset;

		segment = FP_SEG (address);
		offset = FP_OFF (address);

		linear_address = ((DWORD) segment << 4) + (0x0000ffff & (DWORD) offset);

		return (linear_address);
	#else
		return (address);
	#endif
}
/****************************************************************************/
void close_buffer_class (void)
{
#ifndef __MSDOS__
	buffer_free ((void *) lsl.buffer.start_address_device_driver_buffers);
#else
	farfree ((void *) lsl.buffer.start_address_device_driver_buffers);
#endif
}
/****************************************************************************/
USHORT default_buffer_ratio[] = {10,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1} ;
#define MAX_BUFFER_SHARE_FACTOR 50
static void build_device_driver_buffer_list (ULONG size_of_device_driver_buffers,USHORT number_of_real_ports)
{
	USHORT real_port_number;
   enum BOOLEAN buffer_division_ratio_defined = TRUE ;

   for (real_port_number = 0x0000 ; real_port_number < number_of_real_ports ; real_port_number++)
   {
      if ((lsl.port[real_port_number].buffer_share_factor == 0) ||
          (lsl.port[real_port_number].buffer_share_factor > MAX_BUFFER_SHARE_FACTOR))
      {
         buffer_division_ratio_defined = FALSE ;
         break ;
      }
   }

   if (buffer_division_ratio_defined == FALSE)
   {
      for (real_port_number = 0 ; real_port_number < number_of_real_ports ; real_port_number++)
      {
         lsl.port[real_port_number].buffer_share_factor = default_buffer_ratio[real_port_number] ;
      }
   }

	for (real_port_number = 0x0000; real_port_number < number_of_real_ports; ++real_port_number)
	{
      lsl.port[real_port_number].number_of_system_buffers_free = 0 ;

		lsl.port[real_port_number].buffer_size = (USHORT) lsl.port[real_port_number].rfc1213_ifEntry.ifMtu;

		lsl.port[real_port_number].buffer_size += (USHORT) sizeof (BUFFER_HEADER);

		lsl.port[real_port_number].buffer_size += (USHORT) 
			align_device_driver_buffer_address (lsl.port[real_port_number].buffer_size);

		lsl.port[real_port_number].current_rx_buffers_in_list = 0x0000;
		lsl.port[real_port_number].current_tx_buffers_in_list = 0x0000;
	}

	lsl_printf (LSL_BUFFER_PRINTF,"Device Drivers:  Buffer Size Per Port %04x \r\n",lsl.port[0].buffer_size);

#if 0
	number_of_rx_buffers = get_number_of_rx_buffers (size_of_device_driver_buffers,number_of_real_ports);
#endif
   get_number_of_rx_buffers_for_ports (size_of_device_driver_buffers,number_of_real_ports);

	for (real_port_number = 0x0000; real_port_number < number_of_real_ports; ++real_port_number)
	{
#if 0
		lsl.port[real_port_number].number_of_system_buffers_free = number_of_rx_buffers;
		add_buffers_to_rx_list (number_of_rx_buffers,&lsl.port[real_port_number]);
#endif
		add_buffers_to_rx_list (lsl.port[real_port_number].number_of_system_buffers_free,&lsl.port[real_port_number]);
	}
}
/****************************************************************************/
static USHORT get_number_of_rx_buffers (ULONG size_for_rx_buffers,USHORT number_of_real_ports)
{
	USHORT number_of_rx_buffers;
	USHORT real_port_number;
	ULONG buffer_size;

	for (number_of_rx_buffers = MAXIMUM_NUMBER_OF_RX_BUFFERS; number_of_rx_buffers > 0x0000;  --number_of_rx_buffers)
		{
		for (buffer_size = 0x00000000L,real_port_number = 0x0000; real_port_number < number_of_real_ports; ++real_port_number)
			{
			buffer_size +=	((ULONG) lsl.port[real_port_number].buffer_size *
				(ULONG) number_of_rx_buffers);
			}

		if (buffer_size < size_for_rx_buffers)
			{
			break;
			}
		}

	return (number_of_rx_buffers);
}
/****************************************************************************/
static void add_buffers_to_rx_list (USHORT number_of_rx_buffers,LSL_PORT_CLASS *sptr_port)
{
	LINK *sptr_buffer_to_add_to_rx_list;
	USHORT buffer_index;

	sptr_buffer_to_add_to_rx_list = (LINK *) lsl.buffer.current_device_driver_buffer;

	for (buffer_index = 0x0000; buffer_index < number_of_rx_buffers; ++buffer_index)
		{
#ifdef __MSDOS__
	#ifndef __FLAT__
		FP_SEG (sptr_buffer_to_add_to_rx_list) += (FP_OFF (sptr_buffer_to_add_to_rx_list) >> 4);

		FP_OFF (sptr_buffer_to_add_to_rx_list) &= 0x000f;
	#endif
#endif

		add_entry_to_list (&sptr_port->rx_buffer_list,sptr_buffer_to_add_to_rx_list);

#if 0
		lsl_printf (LSL_BUFFER_PRINTF,"Device Drivers: Buffer Added to Device Driver List %08lx \r\n",
			sptr_buffer_to_add_to_rx_list);
#endif

		sptr_buffer_to_add_to_rx_list = (LINK *) (ULONG) ((ULONG) sptr_buffer_to_add_to_rx_list +
			sptr_port->buffer_size);
		}

#ifdef __MSDOS__
	#ifndef __FLAT__
		FP_SEG (sptr_buffer_to_add_to_rx_list) += (FP_OFF (sptr_buffer_to_add_to_rx_list) >> 4);

		FP_OFF (sptr_buffer_to_add_to_rx_list) &= 0x000f;
	#endif
#endif

	lsl.buffer.current_device_driver_buffer = (ULONG) sptr_buffer_to_add_to_rx_list;
}
/****************************************************************************/
void *device_driver_malloc (USHORT real_port_number,ULONG device_driver_id,USHORT number_of_bytes)
{
	BUFFER *sptr_buffer;

	sptr_buffer =
		(BUFFER *) get_entry_from_list (&((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->rx_buffer_list);

	if (sptr_buffer == NULL)
		{
		return (NULL);
		}

#ifdef DEBUG
	lsl_printf (LSL_BUFFER_PRINTF,
		"LSL:  Allocate Buffer Port %04x,Buffer %08lx, left %04x\r\n",real_port_number,
		sptr_buffer,((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->number_of_buffers_allocated);
#endif

	sptr_buffer->header.rx_device_id = device_driver_id;
	sptr_buffer->header.rx_real_port_number = real_port_number;
	sptr_buffer->header.in_use = TRUE;
	sptr_buffer->header.device_driver = TRUE;
	sptr_buffer->header.number_of_bytes = number_of_bytes;
	sptr_buffer->header.number_of_broadcasts_left = 0x0000;
	sptr_buffer->header.fptr_tx_completion = NULL;
	sptr_buffer->header.magic_number = DEVICE_DRIVER_BUFFER_MAGIC_NUMBER;

	++((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->number_of_buffers_allocated;
	--((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->number_of_system_buffers_free;

	return (&sptr_buffer->data);
}
/****************************************************************************/
enum TEST device_driver_free (USHORT real_port_number,ULONG device_driver_id,void *vptr_buffer_data)
{
	BUFFER_HEADER *sptr_buffer;
	ULONG ptr_data;

	ptr_data = (ULONG) vptr_buffer_data;

	ptr_data &=	BUFFER_BOUNDARY_MASK;

	sptr_buffer = (BUFFER_HEADER *) ptr_data;

	if (sptr_buffer->magic_number != DEVICE_DRIVER_BUFFER_MAGIC_NUMBER)
		{
		lsl_printf (LSL_ALARM_PRINTF,
		"ILLEGAL FREE:  Free Buffer Port %04x, From Device Driver %04x, Buffer %p %04x\r\n",real_port_number,
		device_driver_id,sptr_buffer,((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->number_of_buffers_allocated);

		return (FAIL);
		}

	if (sptr_buffer->in_use == FALSE)
		{
		lsl_printf (LSL_ALARM_PRINTF,
		"ILLEGAL FREE:  Double Free Buffer Port %04x, From Device Driver %04x, Buffer %p %04x\r\n",real_port_number,
		device_driver_id,sptr_buffer,((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->number_of_buffers_allocated);

		return (FAIL);
		}

	add_entry_to_list (&((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->rx_buffer_list,
		(LINK *) &sptr_buffer->links);

#ifdef DEBUG
	lsl_printf (LSL_BUFFER_PRINTF,
		"LSL: Free Buffer Port %04x,Buffer %08lx %04x\r\n",real_port_number,
		sptr_buffer,((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->number_of_buffers_allocated);
#endif

	sptr_buffer->tx_device_id = device_driver_id;
	sptr_buffer->tx_real_port_number = real_port_number;
	sptr_buffer->in_use = FALSE;
	sptr_buffer->device_driver = TRUE;
	sptr_buffer->number_of_bytes = 0x0000;
	sptr_buffer->number_of_broadcasts_left = 0x0000;

	/* this weird line zeroes out the 8 bytes prior to the start of data (where the snap header might be) */

	*((ULONG *)&sptr_buffer->reserved[sizeof (sptr_buffer->reserved) - (sizeof (ULONG) * 4)]) = 0x00000000L;
	*((ULONG *)&sptr_buffer->reserved[sizeof (sptr_buffer->reserved) - (sizeof (ULONG) * 3)]) = 0x00000000L;
	*((ULONG *)&sptr_buffer->reserved[sizeof (sptr_buffer->reserved) - (sizeof (ULONG) * 2)]) = 0x00000000L;
	*((ULONG *)&sptr_buffer->reserved[sizeof (sptr_buffer->reserved) - (sizeof (ULONG) * 1)]) = 0x00000000L;

	--((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->number_of_buffers_allocated;
	++((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->number_of_system_buffers_free;

	return (PASS);
}
/****************************************************************************/
enum TEST packet_forward_device_driver_free (USHORT real_tx_port_number,ULONG tx_device_driver_id,void *vptr_buffer_data)
{
	BUFFER_HEADER *sptr_buffer;
	ULONG ptr_data;

	ptr_data = (ULONG) vptr_buffer_data;

	ptr_data &=	BUFFER_BOUNDARY_MASK;

	sptr_buffer = (BUFFER_HEADER *) ptr_data;

	if (sptr_buffer->magic_number != DEVICE_DRIVER_BUFFER_MAGIC_NUMBER)
		{
		lsl_printf (LSL_ALARM_PRINTF,
		"ILLEGAL FREE:  Free Buffer Rx Port %04x, From Rx Device Driver %04x, Buffer %p %04x\r\n",
		sptr_buffer->rx_real_port_number,
		sptr_buffer->rx_device_id,sptr_buffer,
		((DEVICE_DRIVER_REGISTRATION_ENTRY *) sptr_buffer->rx_device_id)->number_of_buffers_allocated);

		return (FAIL);
		}

	if (sptr_buffer->in_use == FALSE)
		{
		lsl_printf (LSL_ALARM_PRINTF,
		"ILLEGAL FREE:  Double Free Buffer Rx Port %04x, From Rx Device Driver %04x, Buffer %p %04x\r\n",
		sptr_buffer->rx_real_port_number,
		sptr_buffer->rx_device_id,sptr_buffer,
		((DEVICE_DRIVER_REGISTRATION_ENTRY *) sptr_buffer->rx_device_id)->number_of_buffers_allocated);

		return (FAIL);
		}

	add_entry_to_list (&((DEVICE_DRIVER_REGISTRATION_ENTRY *) sptr_buffer->rx_device_id)->rx_buffer_list,
		(LINK *) &sptr_buffer->links);

#ifdef DEBUG
	lsl_printf (LSL_BUFFER_PRINTF,
		"LSL: Packet Forward Free Buffer Port %04x, Buffer %08lx %04x\r\n",
		sptr_buffer->rx_real_port_number,sptr_buffer,
		((DEVICE_DRIVER_REGISTRATION_ENTRY *) sptr_buffer->rx_device_id)->number_of_buffers_allocated);
#endif

	sptr_buffer->tx_device_id = tx_device_driver_id;
	sptr_buffer->tx_real_port_number = real_tx_port_number;
	sptr_buffer->in_use = FALSE;
	sptr_buffer->device_driver = TRUE;
	sptr_buffer->number_of_bytes = 0x0000;
	sptr_buffer->number_of_broadcasts_left = 0x0000;

	/* this weird line zeroes out the 8 bytes prior to the start of data (where the snap header might be) */

	*((ULONG *)&sptr_buffer->reserved[sizeof (sptr_buffer->reserved) - (sizeof (ULONG) * 4)]) = 0x00000000L;
	*((ULONG *)&sptr_buffer->reserved[sizeof (sptr_buffer->reserved) - (sizeof (ULONG) * 3)]) = 0x00000000L;
	*((ULONG *)&sptr_buffer->reserved[sizeof (sptr_buffer->reserved) - (sizeof (ULONG) * 2)]) = 0x00000000L;
	*((ULONG *)&sptr_buffer->reserved[sizeof (sptr_buffer->reserved) - (sizeof (ULONG) * 1)]) = 0x00000000L;

	--((DEVICE_DRIVER_REGISTRATION_ENTRY *) sptr_buffer->rx_device_id)->number_of_buffers_allocated;
	++((DEVICE_DRIVER_REGISTRATION_ENTRY *) sptr_buffer->rx_device_id)->number_of_system_buffers_free;

	return (PASS);
}
/****************************************************************************/
enum BOOLEAN lsl_tx_list_upper_limit_reached (ULONG tx_device_driver_id)
{
	if ((((DEVICE_DRIVER_REGISTRATION_ENTRY *) tx_device_driver_id)->current_tx_buffers_in_list + 1) >
		((DEVICE_DRIVER_REGISTRATION_ENTRY *) tx_device_driver_id)->tx_buffer_upper_limit)
		{
		return (TRUE);
		}
	else
		{
		++((DEVICE_DRIVER_REGISTRATION_ENTRY *) tx_device_driver_id)->current_tx_buffers_in_list;

		return (FALSE);
		}
}
/****************************************************************************/
enum BOOLEAN lsl_tx_list_packet_sent (ULONG tx_device_driver_id)
{
	--((DEVICE_DRIVER_REGISTRATION_ENTRY *) tx_device_driver_id)->current_tx_buffers_in_list;

	return (TRUE);
}
/****************************************************************************/
void set_current_rx_buffer_list_size (ULONG rx_device_driver_id,USHORT size_of_rx_list)
{
	((DEVICE_DRIVER_REGISTRATION_ENTRY *) rx_device_driver_id)->current_rx_buffers_in_list = size_of_rx_list;
}
/****************************************************************************/
ULONG get_current_rx_buffer_list_size (ULONG rx_device_driver_id)
{
	return (((DEVICE_DRIVER_REGISTRATION_ENTRY *) rx_device_driver_id)->number_of_system_buffers_free);
}
/****************************************************************************/
enum BOOLEAN lsl_rx_list_lower_limit_reached (ULONG rx_device_driver_id)
{
	if ((((DEVICE_DRIVER_REGISTRATION_ENTRY *) rx_device_driver_id)->current_rx_buffers_in_list - 1) <
		((DEVICE_DRIVER_REGISTRATION_ENTRY *) rx_device_driver_id)->rx_buffer_lower_limit)
		{
		return (TRUE);
		}
	else
		{
		--((DEVICE_DRIVER_REGISTRATION_ENTRY *) rx_device_driver_id)->current_rx_buffers_in_list;

		return (FALSE);
		}
}
/****************************************************************************/
ULONG lsl_rx_list_add (ULONG rx_device_driver_id)
{
	++((DEVICE_DRIVER_REGISTRATION_ENTRY *) rx_device_driver_id)->current_rx_buffers_in_list;

	return ((ULONG) TRUE);
}
/****************************************************************************/
enum DEVICE_DRIVER_TYPE lsl_get_device_driver_type_from_receive_port (void *vptr_buffer)
{
	BUFFER_HEADER *sptr_buffer_header;
	ULONG ptr_data;
	enum DEVICE_DRIVER_TYPE type;

	ptr_data = (ULONG) vptr_buffer;

	ptr_data &=	BUFFER_BOUNDARY_MASK;

	sptr_buffer_header = (BUFFER_HEADER *) ptr_data;

	type = ((DEVICE_DRIVER_REGISTRATION_ENTRY *) sptr_buffer_header->rx_device_id)->type;

	return (type);
}
/****************************************************************************/
ULONG lsl_get_buffer_size (USHORT real_port_number)
{
	ULONG buffer_size;

	buffer_size = (ULONG) lsl.port[real_port_number].buffer_size;

	return (buffer_size);
}
/****************************************************************************/
ULONG lsl_get_port_mtu (USHORT real_port_number)
{
	return(lsl.port[real_port_number].rfc1213_ifEntry.ifMtu);
}


static void get_number_of_rx_buffers_for_ports (ULONG size_for_rx_buffers,USHORT number_of_real_ports)
{
   ULONG buffer_used_up = 0x00000000L ;
   USHORT real_port_number, i ;

   while (1)
   {
      for (real_port_number = 0 ; real_port_number < number_of_real_ports ; real_port_number++)
      {
         for (i = 0 ; i < lsl.port[real_port_number].buffer_share_factor ; i++)
         {
            buffer_used_up += lsl.port[real_port_number].buffer_size ;
            if (buffer_used_up > size_for_rx_buffers)
            {
               for (real_port_number = 0 ; real_port_number < number_of_real_ports ; real_port_number++)
                  lsl_printf (LSL_BUFFER_PRINTF, "Number of Buffers for Port %d : %d\n",
                              real_port_number,
                              lsl.port[real_port_number].number_of_system_buffers_free) ;
               return ;
            }
            lsl.port[real_port_number].number_of_system_buffers_free++ ;
         }
      }
   }
}
