#include	"defs.h"
/*	$Modname: lsltimer.c$  $version: 1.13$      $date: 02/21/95$   */
/*
* 	$lgb$
1.0 06/29/93 ross new register version.
1.1 06/29/93 ross added copyright.
1.2 07/01/93 ross
1.3 10/11/93 ross changes for frame relay and spanning tree
1.4 11/10/93 ross added device driver support.
1.5 01/08/94 ross More LSL version 3 changes
1.6 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.7 03/09/94 ross removed some duplicate variables
1.8 03/14/94 ross cleaned up braces and white spaces for release.
1.9 06/15/94 ross Changed dlsx to dlsw.
1.10 09/29/94 ross added BYTE_ENUM and USHORT_ENUM
1.11 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.12 01/12/95 ross building rwutils directory.
1.13 02/21/95 ross add close changes.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifdef __FLAT__
	#include <time.h>
#endif
#include	"lsl.h"
/****************************************************************************/
ULONG lsl_timer_ulong;
ULONG timer_ulong;
ULONG old_timer_ulong;

ULONG	_1_second_counter;
/****************************************************************************/
#if STATUS_DEBUG
extern void debug_manager_timer () ;
#endif
/* Naveen Added this for configuration manager ...*/
extern void cm_decrement_configuration_manager_lifetime();
/* ... Naveen Added this for configuration manager */

void polling_timer_interrupt (void)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry;
	TRANSPORT_REGISTRATION_ENTRY *sptr_transport_entry;
	APPLICATION_REGISTRATION_ENTRY *sptr_application_entry;
	
#if defined (__FLAT__) && !defined (IS_32)
	timer_ulong = (clock ())/55;

	lsl_timer_ulong = timer_ulong;
#endif
	while (old_timer_ulong != lsl_timer_ulong)
		{
		if (++_1_second_counter >= lsl.clock_ticks_per_second)
			{
			++bridge_timer;
			++router_timer;

/* Added By Naveen (Call placed by Chidanand) for Decrementing LifeTime of Configuration Manager ...*/	
	       cm_decrement_configuration_manager_lifetime();
/* ... Added By Naveen for Decrementing LifeTime of Configuration Manager */	

#if STATUS_DEBUG
			debug_manager_timer () ;
#endif

			_1_second_counter = 0x00000000L;
			}


		for (sptr_device_driver_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.device_drivers_list);
			sptr_device_driver_entry != NULL;
			sptr_device_driver_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_device_driver_entry->links))
			{
			if (sptr_device_driver_entry->fptr_timer_routine != NULL)
				{
				(*sptr_device_driver_entry->fptr_timer_routine) ();
				}
			}

		for (sptr_protocol_stack_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.protocol_stacks_list);
			sptr_protocol_stack_entry != NULL;
			sptr_protocol_stack_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_protocol_stack_entry->links))
			{
			if (sptr_protocol_stack_entry->fptr_timer_routine != NULL)
				{
				(*sptr_protocol_stack_entry->fptr_timer_routine) ();
				}
			}

		for (sptr_transport_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.transports_list);
			sptr_transport_entry != NULL;
			sptr_transport_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_transport_entry->links))
			{
			if (sptr_transport_entry->fptr_timer_routine != NULL)
				{
				(*sptr_transport_entry->fptr_timer_routine) ();
				}
			}

		for (sptr_application_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.applications_list);
			sptr_application_entry != NULL;
			sptr_application_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_application_entry->links))
			{
			if (sptr_application_entry->fptr_timer_routine != NULL)
				{
				(*sptr_application_entry->fptr_timer_routine) ();
				}
			}

#if 0
/* Commented out by Chidanand and called for one second once */
/* Added By Naveen for Decrementing LifeTime of Configuration Manager ...*/	
       cm_decrement_configuration_manager_lifetime();
/* ... Added By Naveen for Decrementing LifeTime of Configuration Manager */	
#endif
		++old_timer_ulong;
		}
}

