#include	"defs.h"
/*	$Modname: lsltx.c$  $version: 1.18$      $date: 02/21/95$   */
/*
* 	$lgb$
1.0 10/30/92 ross shortened 132 columns.
1.1 01/31/93 ross
1.2 06/29/93 ross new register version.
1.3 07/01/93 ross Fixed timer_ulong bug with 82596 driver
1.4 07/28/93 ross changed parameter names.
1.5 08/17/93 ross minor fixes
1.6 10/11/93 ross changes for frame relay and spanning tree
1.7 11/01/93 ross ipx certification version
1.8 11/19/93 ross
1.9 01/08/94 ross More LSL version 3 changes
1.10 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.11 03/06/94 ross adding more rfc 1213 statistics.
1.12 03/09/94 ross removed some duplicate variables
1.13 03/09/94 ross added support for passing virtual port number to device driver.
1.14 03/14/94 ross rename protocol stack id to shifted left.
1.15 04/21/94 ross added code to handle rfc1042.
1.16 09/26/94 ross added protected mode functions.
1.17 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.18 02/21/95 ross add close changes.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stdio.h>
#include	"lsl.h"
/****************************************************************************/
static enum BOOLEAN is_destination_address_in_packet_unicast (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,
	MAC_ADDRESS *sptr_mac_address);
/****************************************************************************/
enum TEST send_packet (ULONG protocol_stack_id,USHORT virtual_port_number,void *vptr_tx_buffer,USHORT number_of_bytes,
	enum BOOLEAN do_not_calculate_new_crc,enum BOOLEAN device_driver_buffer,
	void (*fptr_tx_completion) (USHORT port_number,void *sptr_buffer))
{
	enum TEST return_value;
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;
	USHORT real_port_number ;

	return_value = PASS;

#ifndef LSL_HEADER_TRANSLATION
	real_port_number = virtual_port_number;
#endif

#if defined (DEBUG) && defined (__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) vptr_tx_buffer < (ULONG) send_packet)
		{
		while (TRUE)
			{
			printf ("Illegal Buffer %08lx %08lx\r\n",vptr_tx_buffer,(ULONG) send_packet);
			}
		}
#endif

	sptr_device_driver_entry = get_device_driver_entry_from_protocol_stack_id (
		(PROTOCOL_STACK_REGISTRATION_ENTRY *) protocol_stack_id,virtual_port_number);

#ifdef LSL_HEADER_TRANSLATION
		vptr_tx_buffer = convert_stack_header_for_tx ((PROTOCOL_STACK_REGISTRATION_ENTRY *) protocol_stack_id,
			virtual_port_number,(PACKET *) vptr_tx_buffer,&number_of_bytes);
#endif

/* Chidanand - 10/04/1997
   Instead of checking status of currently mapped physical port, 
   the 1-1 corresponding physical port's status is being checked */
      if (1)
/* Chidanand 10/04/1997 */
		{

		if (is_destination_address_in_packet_unicast (sptr_device_driver_entry,(MAC_ADDRESS *) vptr_tx_buffer) == TRUE)
			{
			++sptr_device_driver_entry->rfc1213_ifEntry.ifOutUcastPkts;
			}
		else
			{
			++sptr_device_driver_entry->rfc1213_ifEntry.ifOutNUcastPkts;
			}

/* Commented out by Sanjay -- code moved to drivers */
/*		sptr_device_driver_entry->rfc1213_ifEntry.ifOutOctets += number_of_bytes; */
		return_value = (*sptr_device_driver_entry->fptr_tx_routine)
			(protocol_stack_id,sptr_device_driver_entry->real_port_number,virtual_port_number,vptr_tx_buffer,number_of_bytes,
				do_not_calculate_new_crc,device_driver_buffer,fptr_tx_completion);
		}
	else
		{
/* Commented out by Sanjay -- code moved to drivers */
/*		++sptr_device_driver_entry->rfc1213_ifEntry.ifOutDiscards; */


		if (device_driver_buffer == TRUE)
			{
			packet_forward_device_driver_free (sptr_device_driver_entry->real_port_number-lsl.number_of_lan_ports,(ULONG) sptr_device_driver_entry,
				vptr_tx_buffer);
			}
		if (fptr_tx_completion != NULL)
			{
			(fptr_tx_completion) (virtual_port_number,vptr_tx_buffer);
			}
		}
   if (return_value == FAIL)
      printf ("Tx Packet failed on port %04X\n", virtual_port_number) ;
	return (return_value);
}
/****************************************************************************/
static enum BOOLEAN is_destination_address_in_packet_unicast (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,
	MAC_ADDRESS *sptr_mac_address)
{
	if (sptr_device_driver_entry->type == TOKEN_RING_DEVICE_DRIVER)
		{
		if (sptr_mac_address->_ulong & 0x00000080L)
			{
			return (FALSE);
			}
		}
	else
		{
		if (sptr_mac_address->_ulong & 0x00000001L)
			{
			return (FALSE);
			}
		}

	return (TRUE);
}
#if defined (__BORLANDC__) && !defined (__FLAT__)
/****************************************************************************/
enum TEST send_device_driver_packet (ULONG protocol_stack_id,USHORT real_port_number,USHORT virtual_port_number,
	void *vptr_tx_buffer,USHORT number_of_bytes,enum BOOLEAN do_not_calculate_new_crc,enum BOOLEAN device_driver_buffer,
	void (*fptr_tx_completion) (USHORT port_number,void *sptr_buffer))
{
	enum TEST return_value;
	USHORT wan_driver_port_number;
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = find_matching_device_driver_for_port_number (real_port_number);

	if (real_port_number < lsl.number_of_lan_ports)
		{
		return_value = (*sptr_device_driver_entry->fptr_tx_routine)
			(protocol_stack_id,real_port_number,virtual_port_number,vptr_tx_buffer,number_of_bytes,do_not_calculate_new_crc,
				device_driver_buffer,fptr_tx_completion);
		}
	else
		{
		wan_driver_port_number = (USHORT) (real_port_number - lsl.number_of_lan_ports);

		return_value = (*sptr_device_driver_entry->fptr_tx_routine)
			(protocol_stack_id,wan_driver_port_number,virtual_port_number,vptr_tx_buffer,number_of_bytes,do_not_calculate_new_crc,
				device_driver_buffer,fptr_tx_completion);
		}

	return (return_value);
}
/****************************************************************************/
void device_driver_transmit_complete (USHORT real_port_number)
{
	USHORT wan_driver_port_number;
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = find_matching_device_driver_for_port_number (real_port_number);

	if (real_port_number < lsl.number_of_lan_ports)
		{
		(*sptr_device_driver_entry->fptr_tx_complete) (real_port_number);
		}
	else
		{
		wan_driver_port_number = (USHORT) (real_port_number - lsl.number_of_lan_ports);

		(*sptr_device_driver_entry->fptr_tx_complete) (wan_driver_port_number);
		}
}
#endif

