#include	"defs.h"
/*	$Modname: lslutil.c$  $version: 1.17$      $date: 07/05/95$   */
/*
* 	$lgb$
1.0 06/29/93 ross new register version.
1.1 06/29/93 ross added copyright.
1.2 07/27/93 ross
1.3 08/02/93 ross Changes for version 2.0
1.4 10/11/93 ross changes for frame relay and spanning tree
1.5 10/29/93 ross took out the __BORLAND conditionals.
1.6 11/01/93 ross ipx certification version
1.7 11/19/93 ross
1.8 01/08/94 ross More LSL version 3 changes
1.9 03/06/94 ross adding more rfc 1213 statistics.
1.10 03/14/94 ross cleaned up braces and white spaces for release.
1.11 03/26/94 ross put swap functions in BIG_ENDIAN wrapper.  Found by Lori.
1.12 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.13 11/04/94 ross added ifdef around strlwr.
1.14 01/12/95 ross building rwutils directory.
1.15 02/21/95 ross add close changes.
1.16 03/31/95 ross New close function, general cleanup.
1.17 07/05/95 ross changes in lsl class.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stdio.h>
#include	<string.h>
#include	<stdarg.h>
#include <time.h>
#include	"lsl.h"
/****************************************************************************/
ULONG get_number_of_real_ports (void)
{
	ULONG number_of_real_ports;

	number_of_real_ports = (ULONG) lsl.number_of_real_ports;

	return (number_of_real_ports);
}
/****************************************************************************/
enum TEST get_protocol_stack_id (char *cptr_stack_name_to_find,ULONG *usptr_return_stack_id)
{
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry;

	for (sptr_protocol_stack_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.protocol_stacks_list);
		sptr_protocol_stack_entry != NULL;
		sptr_protocol_stack_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_protocol_stack_entry->links))
		{
		if (strcmp (&sptr_protocol_stack_entry->name[0],cptr_stack_name_to_find) == STRINGS_MATCH)
			{
			*usptr_return_stack_id = sptr_protocol_stack_entry->id;

			return (PASS);
			}
		}

	return (FAIL);
}
/*************************************************************************/
void pass_stack_id_to_device_driver (char *cptr_stack_name,ULONG stack_id)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	for (sptr_device_driver_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.device_drivers_list);
		sptr_device_driver_entry != NULL;
		sptr_device_driver_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_device_driver_entry->links))
		{
		if (sptr_device_driver_entry->fptr_control_routine != NULL)
			{
			(*sptr_device_driver_entry->fptr_control_routine) (STACK_HAS_REGISTERED,(ULONG) cptr_stack_name,(ULONG) stack_id);
			}
		}
}
/*************************************************************************/
void lsl_printf (enum LSL_PRINTF_GROUPS printf_group,const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format);

	if (lsl.print.enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case LSL_INITIALIZATION_PRINTF:
			print_string = lsl.print.enabled;
			break;
		case LSL_SNAP_PRINTF:
			print_string = lsl.print.snap_enabled;
			break;
		case LSL_SNMP_PRINTF:
			print_string = lsl.print.snmp_enabled;
			break;
		case LSL_BUFFER_PRINTF:
			print_string = lsl.print.buffer_enabled;
			break;
		case LSL_ALARM_PRINTF:
			print_string = lsl.print.alarm_enabled;
			break;
		default:
			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format,argptr);
		}

	va_end (argptr);
}
#ifdef RTRERROR
#undef vprintf
/****************************************************************************/
int _vprintf (const char *cptr_format,void *vptr_arglist)
{
	int return_value;
	USHORT length_of_string;

	if (lsl.console.remote_printing == TRUE)
		{
		if (lsl.console.cptr_current_buffer_string == NULL)
			{
			return ((int) NULL);
			}

		/* The function assumes that length of string will never exceed 255 */

		if (((ULONG) lsl.console.cptr_current_buffer_string + 256) >
			((ULONG) lsl.console.cptr_remote_buffer + lsl.console.size_of_remote_buffer))
			{
			lsl.console.cptr_current_buffer_string = lsl.console.cptr_remote_buffer;
			}

		return_value = vsprintf (lsl.console.cptr_current_buffer_string, cptr_format, vptr_arglist);

		length_of_string = (USHORT) strlen (lsl.console.cptr_current_buffer_string);

		if (length_of_string < 256)
			{
			lsl.console.cptr_current_buffer_string = (char *) ((ULONG) lsl.console.cptr_current_buffer_string + length_of_string);
			}
		}

	if (lsl.console.local_printing == TRUE)
		{
		return_value = vprintf (cptr_format,vptr_arglist);
		}

	return (return_value);
}
#endif
