#include	"defs.h"
/*	$Modname: nvram.c$  $version: 1.21$      $date: 06/27/95$   */
/*
* 	$lgb$
1.0 02/11/94 ross checking in version 2.0 of nvram.
1.1 03/09/94 ross added copyright.
1.2 03/14/94 ross added set ulong decimal routine.
1.3 03/15/94 ross added set ulong value.
1.4 03/15/94 ross added borlandc ifdefs.
1.5 03/28/94 ross added 960 specific support.
1.6 04/12/94 ross got rid of scanf, warnings.
1.7 04/21/94 ross added byte access routine.
1.8 08/18/94 ross add several more access routines.
1.9 08/25/94 ross fixed sscanf bug.  Courtesy of Danny.
1.10 08/25/94 ross fixed scanf bug.  Courtesy of Danny.
1.11 09/02/94 ross changed 960 to RAM_FILE.
1.12 09/29/94 ross new functions.  Courtesy of Danny.
1.13 10/03/94 ross changed boolean variable setting the BYTE_ENUM for certain compilers.
1.14 11/21/94 ross added consoles.
1.15 12/11/94 ross added check for bad configuration.
1.16 01/12/95 ross added check for port number.
1.17 01/26/95 ross increased the number of sections from 16 to 64.
1.18 02/01/95 ross dynamic configuration
1.19 02/27/95 ross fixed port number issue now up to 20 ports.  Courtesy of Dan.
1.20 04/20/95 ross changed parsing ram file routine because of PPP.
1.21 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#define GLOBAL_FILE
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <kstart.h>
#include "knvram.h"
#include <vnvrmstr.h>
#include "vnvram.h"
#include <v8022str.h>
#include <lslproto.h>
#include <rwarebuf.h>
/****************************************************************************/
    char *
my_strtok(register char *s1, register const char *s2);
static void nvram_printf (const char *cptr_format, ...);
static enum TEST read_router_ini_parameters (char *cptr_name_of_ini_file,ULONG location_of_ini_file);
static enum TEST router_management_parameters (char *cptr_string_from_config_file,char *cptr_value_string);
static BYTE get_section_name (char *cptr_section_name);
static void check_port_number (char *cptr_port_number_string);
#ifdef __RAM_FILE__
	static char *find_cr_newline (char *cptr_string_from_config_file);
#endif

#ifdef __RAM_FILE__
static enum TEST get_string_from_memory_file_image (char *cptr_return_string,USHORT size_of_return_string,
	ULONG location_of_ini_file);

	#if defined (_MSC_VER)
		#define __FLAT__
	#endif
#endif

/* sudhir 29/5/97 */
extern int strcmpi (char *, char *);

/****************************************************************************/
enum TEST initialize_nvram (char *cptr_file_name,ULONG location_of_ini_file)
{
	enum TEST return_code;

	return_code = read_router_ini_parameters (cptr_file_name,location_of_ini_file);

	return (return_code);
}
/****************************************************************************/
static enum TEST read_router_ini_parameters (char *cptr_name_of_ini_file,ULONG location_of_ini_file)
{
	char *cptr_value_string;
	char string_from_ini_file[256];

#ifndef __RAM_FILE__
	FILE *filptr_ini_file;
#endif

	if ((cptr_name_of_ini_file == NULL) && (location_of_ini_file == 0x00000000L))
		{
		nvram_printf ("NVRAM FAIL 100: No Configuration File Given!\r\n");
		return (FAIL);
		}
	else
		{
#ifndef __RAM_FILE__
		nvram_printf ("File Open\r\n",cptr_name_of_ini_file);

		if ((filptr_ini_file = fopen (cptr_name_of_ini_file, "rt")) == NULL)
			{
			nvram_printf ("NVRAM FAIL 101: Could not find %s file, \r\n",cptr_name_of_ini_file);
			return (FAIL);
			}
#endif
		}

#ifndef __RAM_FILE__
	nvram_printf ("Current Configuration Setup in %s\r\n",cptr_name_of_ini_file);
#else
/*	nvram_printf ("Current Configuration Setup at %08lx\r\n",location_of_ini_file);*/
#endif

	nvram.current_configuration_section_index = ILLEGAL_SECTION_INDEX;
	nvram.display_configuration_file = TRUE;

#ifndef __RAM_FILE__
	while (fgets (string_from_ini_file,sizeof (string_from_ini_file),filptr_ini_file) != NULL)
#else
	while (get_string_from_memory_file_image (string_from_ini_file,sizeof (string_from_ini_file),location_of_ini_file) == PASS)
#endif
		{
		if (string_from_ini_file[0] == '/' && string_from_ini_file[1] == '/')
			continue;
		else if ((cptr_value_string = strchr (string_from_ini_file,'=')) == NULL)
			continue;

		cptr_value_string += 2;

		if (nvram.display_configuration_file == TRUE)
			{
#ifndef __RAM_FILE__
			nvram_printf ("%s",string_from_ini_file);
#else
/*			nvram_printf ("%s\r\n",string_from_ini_file);*/
#endif
			}

		if (router_management_parameters (string_from_ini_file,cptr_value_string) == FAIL)
			{
#ifndef __RAM_FILE__
		   fclose (filptr_ini_file);
#endif

while(1);
			return (FAIL);
			}
		}

#ifndef __RAM_FILE__
   fclose (filptr_ini_file);

	PARAMETER_NOT_USED (location_of_ini_file);
#endif

	return (PASS);
}
#ifdef __RAM_FILE__
static char *cptr_current_string;
/****************************************************************************/
static enum TEST get_string_from_memory_file_image (char *cptr_return_string,USHORT size_of_return_string,
	ULONG location_of_ini_file)
{
	char *cptr_next_string;

	if (cptr_current_string == NULL)
		{
		cptr_current_string = (char *) location_of_ini_file;
		}

	if (cptr_current_string != NULL && *cptr_current_string == 0x00)
		{
		return (FAIL);
		}

	cptr_next_string = find_cr_newline (cptr_current_string);

	if (*cptr_current_string == 0x00 && cptr_next_string != NULL)
		{
		cptr_current_string = find_cr_newline (cptr_next_string);
		}

	if (cptr_current_string == NULL)
		{
		return (FAIL);
		}
	else
		{
		strncpy (cptr_return_string,cptr_current_string,size_of_return_string);

		cptr_current_string = cptr_next_string;

		return (PASS);
		}
}
/****************************************************************************/
static char *find_cr_newline (char *cptr_string_from_config_file)
{
	char *cptr_first_occurrence_of_byte;

	cptr_first_occurrence_of_byte = NULL;

	while (*cptr_string_from_config_file != 0x00)
		{
		if (*cptr_string_from_config_file == 0x0d || *cptr_string_from_config_file == 0x0a)
			{
			if (cptr_first_occurrence_of_byte == NULL)
				{
				cptr_first_occurrence_of_byte = cptr_string_from_config_file;
				}

			while (*cptr_string_from_config_file != 0x00)
				{
				if (*cptr_string_from_config_file == 0x0d || *cptr_string_from_config_file == 0x0a)
					{
					++cptr_string_from_config_file;
					continue;
					}

				break;
				}

			break;
			}

		++cptr_string_from_config_file;
		}

	if (*cptr_string_from_config_file != 0x00)
		{
		if (cptr_first_occurrence_of_byte != NULL)
			{
			*cptr_first_occurrence_of_byte = 0x00;
			}
		}

	return (cptr_string_from_config_file);
}
#endif
/****************************************************************************/
static enum TEST router_management_parameters (char *cptr_string_from_config_file,char *cptr_value_string)
{
	USHORT number_of_configuration_functions;
	enum BOOLEAN processed_parameter;

	*(cptr_value_string - 1) = (char) NULL;

	if (*cptr_string_from_config_file == '[' && *(cptr_string_from_config_file + 1) == '[')
		{
		nvram.current_configuration_section_index = get_section_name (cptr_string_from_config_file + 2);

		if (nvram.current_configuration_section_index == ILLEGAL_SECTION_INDEX)
			{
			printf ("Illegal section defined\r\n");

			return (FAIL);
			}
		else
			{
			nvram.sptr_current_configuration_table = sptr_configuration_table[nvram.current_configuration_section_index];

			if (nvram.sptr_current_configuration_table == NULL)
				{
				printf ("No configuration table defined %s\r\n",cptr_string_from_config_file);

				return (FAIL);
				}
			else
				{
				return (PASS);
				}
			}
		}
	else if (nvram.current_configuration_section_index == ILLEGAL_SECTION_INDEX)
		{
		printf ("Illegal section defined\r\n");

		return (FAIL);
		}

	processed_parameter = FALSE;

	for (number_of_configuration_functions = 0x0000;
		(nvram.sptr_current_configuration_table->function[number_of_configuration_functions].cptr_parameter_string != NULL) ||
		(nvram.sptr_current_configuration_table->function[number_of_configuration_functions].eptr_enable_string != NULL);
		++number_of_configuration_functions)
		{
/* sudhir replaced strcmp by strcmpi */
		if (strcmpi (
			(nvram.sptr_current_configuration_table->function[number_of_configuration_functions].cptr_parameter_string),
			(cptr_string_from_config_file)) == STRINGS_MATCH)
			{
			if (nvram.sptr_current_configuration_table->function[number_of_configuration_functions].eptr_enable_string != NULL)
				{
				*(BYTE_ENUM (BOOLEAN) *)(
					(ULONG) nvram.sptr_current_configuration_table->function[number_of_configuration_functions].ulptr_parameter_2 +
					(ULONG) nvram.sptr_current_configuration_table->function[number_of_configuration_functions].parameter_1) =
					is_parameter_enabled (cptr_value_string);

				processed_parameter = TRUE;
				}
			else
				{
				(*nvram.sptr_current_configuration_table->function[number_of_configuration_functions].fptr_parameter_function)
				(cptr_value_string,nvram.sptr_current_configuration_table->function[number_of_configuration_functions].parameter_1,
					nvram.sptr_current_configuration_table->function[number_of_configuration_functions].ulptr_parameter_2,
					nvram.sptr_current_configuration_table->function[number_of_configuration_functions].parameter_3);

				processed_parameter = TRUE;
				}

			break;
			}
		}

	if (processed_parameter == FALSE)
		{
		printf ("Unknown Parameter line %s in section %s\r\n",cptr_string_from_config_file,
			section_name_array[nvram.current_configuration_section_index]);

		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
void set_variable_port_and_enable (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	char enable_string[20];

	port_number = get_port_number_and_string (cptr_value_string,&enable_string[0]);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) >
		(ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	if (is_parameter_enabled (enable_string) == TRUE)
		*(BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = TRUE;
	else
		*(BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = FALSE;
}
/****************************************************************************/
void set_variable_port_less_one_and_enable (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	char enable_string[20];

	port_number = get_port_number_and_string (cptr_value_string,&enable_string[0]);

	--port_number;

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) >
		(ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	if (is_parameter_enabled (enable_string) == TRUE)
		*(BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = TRUE;
	else
		*(BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = FALSE;
}
/****************************************************************************/
void set_variable_port_and_byte_decimal_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	USHORT port_value;

	port_value = (USHORT) get_port_number_and_value (cptr_value_string,&port_number);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(BYTE *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = port_value;
}
/****************************************************************************/
void set_variable_port_and_ushort_decimal_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	USHORT port_value;

	port_value = (USHORT) get_port_number_and_value (cptr_value_string,&port_number);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = port_value;
}
/****************************************************************************/
void set_variable_port_and_ulong_decimal_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	ULONG port_value;

	port_value = get_port_number_and_value (cptr_value_string,&port_number);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(ULONG *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = port_value;
}
/****************************************************************************/
void set_variable_port_and_swapped_ulong_hex_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	ULONG port_value;

	port_value = get_port_number_and_hex_value (cptr_value_string,&port_number);

	port_value = swap_long (port_value);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(ULONG *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = port_value;
}
/****************************************************************************/
void set_variable_port_and_swapped_ushort_hex_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	USHORT port_value;

	port_value = (USHORT) get_port_number_and_hex_value (cptr_value_string,&port_number);

	port_value = swap (port_value);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = port_value;
}
/****************************************************************************/
void set_variable_port_and_ushort_hex_value (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	USHORT port_value;

	port_value = (USHORT) get_port_number_and_hex_value (cptr_value_string,&port_number);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = port_value;
}
/****************************************************************************/
void set_variable_port_and_mac_address (char *cptr_ethernet_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	char ethernet_string[20];
	char scanf_string[20];
	char *cptr_ethernet_address;

	port_number = get_port_number_and_string (cptr_ethernet_string,&ethernet_string[0]);

	cptr_ethernet_address = &scanf_string[0];

	sscanf (&ethernet_string[0],"%02jx%02jx%02jx%02jx%02jx%02jx",(int *)(cptr_ethernet_address + 0),(int *)(cptr_ethernet_address + 1),
		(int *)(cptr_ethernet_address + 2),(int *)(cptr_ethernet_address + 3),(int *)(cptr_ethernet_address + 4),
		(int *)(cptr_ethernet_address + 5));

	memcpy ((MAC_ADDRESS *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)),cptr_ethernet_address,
		sizeof (MAC_ADDRESS));
}
/****************************************************************************/
void set_mac_address (char *cptr_mac_address_string,ULONG offset,ULONG ulptr_base)
{
	sscanf (cptr_mac_address_string,"%02jx%02jx%02jx%02jx%02jx%02jx",
		(int *)(offset + ulptr_base + 0),(int *)(offset + ulptr_base + 1),
		(int *)(offset + ulptr_base + 2),(int *)(offset + ulptr_base + 3),(int *)(offset + ulptr_base + 4),
		(int *)(offset + ulptr_base + 5));
}
/****************************************************************************/
void set_variable_port_and_ip_address (char *cptr_ip_address_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	char ip_address_string[20];
	char scanf_string[20];
	char *cptr_ip_address;
	ULONG ip_address;

	port_number = get_port_number_and_string (cptr_ip_address_string,&ip_address_string[0]);

	cptr_ip_address = &scanf_string[0];

	sscanf (&ip_address_string[0],"%03ju.%03ju.%03ju.%03ju",(int *)(cptr_ip_address + 0),(int *)(cptr_ip_address + 1),
		(int *)(cptr_ip_address + 2),(int *)(cptr_ip_address + 3));

	ip_address = *((ULONG *) cptr_ip_address);

	ip_address = swap_long (ip_address);

	memcpy ((ULONG *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)),&ip_address,sizeof (ULONG));
}
/****************************************************************************/
void set_ip_address (char *cptr_ip_address_string,ULONG offset,ULONG ulptr_base)
{
	ULONG ip_address;
	ULONG ip_address_array[4];

	sscanf (cptr_ip_address_string,"%03u.%03u.%03u.%03u",
		(int *)(&ip_address_array[0]),(int *)(&ip_address_array[1]),
		(int *)(&ip_address_array[2]),(int *)(&ip_address_array[3]));

	ip_address = convert_4_bytes_to_ulong (ip_address_array[0],ip_address_array[1],ip_address_array[2],ip_address_array[3]);

	ip_address = swap_long (ip_address);

	memcpy ((ULONG *)(offset + ulptr_base),&ip_address,sizeof (ULONG));
}
/****************************************************************************/
void set_ulong_swapped_hex_value (char *cptr_value_string,ULONG offset,ULONG ulptr_base)
{
#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) (BYTE *) (offset + ulptr_base) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) (BYTE *) (offset + ulptr_base) < (ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(ULONG *) (offset + ulptr_base) = swap_long ((ULONG) get_ulong_hex_value (cptr_value_string));
}
/****************************************************************************/
void set_ulong_value (char *cptr_value_string,ULONG offset,ULONG ulptr_base)
{
#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) (BYTE *) (offset + ulptr_base) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) (BYTE *) (offset + ulptr_base) < (ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(ULONG *) (offset + ulptr_base) = (ULONG) get_ulong_hex_value (cptr_value_string);
}
/****************************************************************************/
void set_ushort_swapped_hex_value (char *cptr_value_string,ULONG offset,ULONG ulptr_base)
{
#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) (BYTE *) (offset + ulptr_base) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) (BYTE *) (offset + ulptr_base) < (ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(USHORT *) (offset + ulptr_base) =
		swap ((USHORT) get_ulong_hex_value (cptr_value_string));
}
/****************************************************************************/
void set_ushort_decimal_value (char *cptr_value_string,ULONG offset,ULONG ulptr_base)
{
#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) (BYTE *) (offset + ulptr_base) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) (BYTE *) (offset + ulptr_base) < (ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(USHORT *) (offset + ulptr_base) = (USHORT) get_decimal_value (cptr_value_string);
}
/****************************************************************************/
void set_ulong_decimal_value (char *cptr_value_string,ULONG offset,ULONG ulptr_base)
{
#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) (BYTE *) (offset + ulptr_base) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) (BYTE *) (offset + ulptr_base) < (ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(ULONG *) (offset + ulptr_base) = (ULONG) get_decimal_value (cptr_value_string);
}
/****************************************************************************/
void set_byte_decimal_value (char *cptr_value_string,ULONG offset,ULONG ulptr_base)
{
#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) (BYTE *) (offset + ulptr_base) > (ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) (BYTE *) (offset + ulptr_base) < (ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	*(BYTE *) (offset + ulptr_base) = (BYTE) get_decimal_value (cptr_value_string);
}
/****************************************************************************/
void set_variable_string (char *cptr_value_string,ULONG offset,ULONG ulptr_base)
{
	char *cptr_line_feed;

	cptr_line_feed = strchr (cptr_value_string,0x0a);

	if (cptr_line_feed != NULL)
		*cptr_line_feed = (char) NULL;

	strcpy ((void *) (offset + ulptr_base),cptr_value_string);
}
/****************************************************************************/
void set_variable_port_and_string (char *cptr_value_string,ULONG offset,ULONG ulptr_base,ULONG size_of_entry)
{
	USHORT port_number;
	char *cptr_line_feed;
	char variable_string[256];

	port_number = get_port_number_and_string (cptr_value_string,&variable_string[0]);

	cptr_line_feed = strchr (&variable_string[0],0x0a);

	if (cptr_line_feed != NULL)
		*cptr_line_feed = (char) NULL;

	strcpy ((void *) (offset + ulptr_base + (port_number * size_of_entry) ),&variable_string[0]);
}
/****************************************************************************/
ULONG get_port_number_and_hex_value (char *cptr_port_number_and_value,USHORT *usptr_port_number)
{
	ULONG port_number;

	check_port_number (cptr_port_number_and_value);

	memset (&nvram.value[0],(int) NULL,9);

	sscanf (cptr_port_number_and_value,"%02u,%08lx",(int *) &port_number,(ULONG *)&nvram.value[0]);

	*usptr_port_number = (USHORT) port_number;

	return (*((ULONG *) &nvram.value[0]));
}
/****************************************************************************/
ULONG get_ulong_hex_value (char *cptr_port_number_and_value)
{
	memset (&nvram.value[0],(int) NULL,9);

	sscanf (cptr_port_number_and_value,"%08lx",(ULONG *) &nvram.value[0]);

	return (*((ULONG *) &nvram.value[0]));
}
/****************************************************************************/
USHORT get_port_number_and_string (char *cptr_port_number_and_value,char *return_string)
{
	ULONG port_number;

	check_port_number (cptr_port_number_and_value);

	*return_string = (char) NULL;

	sscanf (cptr_port_number_and_value,"%02u,%s",(int *) &port_number,return_string);

	return ((USHORT) port_number);
}
/****************************************************************************/
enum BOOLEAN is_parameter_enabled (char *cptr_parameter_string)
{
/* sudhir removed strlwr */
	if (strstr((cptr_parameter_string),"enable") != NULL)
		return (TRUE);
	else 
		return (FALSE);
}
/****************************************************************************/
ULONG get_decimal_value (char *cptr_value)
{
	sscanf (cptr_value,"%011lu",(ULONG *) &nvram.value[0]);

	return (*((ULONG *) &nvram.value[0]));
}
/****************************************************************************/
ULONG get_port_number_and_value (char *cptr_port_number_and_value,USHORT *usptr_port_number)
{
	USHORT port_number[2];

	check_port_number (cptr_port_number_and_value);

	memset (&nvram.value[0],(int) NULL,9);

	sscanf (cptr_port_number_and_value,"%02hu,%08lu",(int *) &port_number[0],(ULONG *) &nvram.value[0]);

	*usptr_port_number = port_number[0];

	return (*((ULONG *) &nvram.value[0]));
}
/****************************************************************************/
void nvram_memcpy (void *vptr_destination,void *vptr_source,USHORT number_of_bytes)
{
	BYTE *bptr_destination;
	BYTE *bptr_source;

	bptr_destination = (BYTE *) vptr_destination;
	bptr_source = (BYTE *) vptr_source;

	do
		{
		*bptr_destination++ = *bptr_source++;
		}
	while (--number_of_bytes);
}
/****************************************************************************/
static void nvram_printf (const char *cptr_format, ...)
{
	va_list argptr;

	va_start (argptr,cptr_format);

	vprintf (cptr_format,argptr);

	va_end (argptr);
}
/****************************************************************************/
static BYTE get_section_name (char *cptr_section_name)
{
	BYTE section_name_index;

	for (section_name_index = 0x00; section_name_index < 64; section_name_index += (BYTE) 1)
		{
/* sudhir removed strlwr */
		if (strstr ((cptr_section_name),(section_name_array[section_name_index])) != NULL)
			{
			return (section_name_index);
			}
		}

	return (ILLEGAL_SECTION_INDEX);
}
/****************************************************************************/
ULONG convert_4_bytes_to_ulong (BYTE byte_1,BYTE byte_2,BYTE byte_3,BYTE byte_4)
{
	ULONG return_value;
	ULONG byte_array[4];

#ifdef BIG_ENDIAN
	byte_array[3] = byte_1;
	byte_array[2] = byte_2;
	byte_array[1] = byte_3;
	byte_array[0] = byte_4;
#else
	byte_array[0] = byte_1;
	byte_array[1] = byte_2;
	byte_array[2] = byte_3;
	byte_array[3] = byte_4;
#endif

	return_value = (ULONG) byte_array[0];
	return_value |= (ULONG) (byte_array[1] << 8);
	return_value |= (ULONG) (byte_array[2] << 16);
	return_value |= (ULONG) (byte_array[3] << 24);

/*	return_value = swap_long (return_value); */

	return (return_value);
}
/****************************************************************************/
static void check_port_number (char *cptr_port_number_string)
{
	if ((*cptr_port_number_string != '0') && (*cptr_port_number_string != '1'))
		{
		while (TRUE)
			{
			nvram_printf ("Illegal Port Enabled Value %s\n",cptr_port_number_string);
			}
		}
}
/****************************************************************************/
void add_section_name_and_configuration_table_pointer (char *cptr_section_name,
	CONFIGURATION_TABLE *sptr_configuration_table_to_add)
{
	section_name_array[nvram.number_of_configurations] = cptr_section_name;

	sptr_configuration_table[nvram.number_of_configurations] = sptr_configuration_table_to_add;

	nvram.number_of_configurations = (BYTE) (nvram.number_of_configurations + 1);
}
/****************************************************************************/
void set_nvram_class_to_zero (void)
{
	memset (&nvram,(int) NULL,sizeof (NVRAM_CLASS));
}
/****************************************************************************/
void set_variable_port_and_enable_ushort (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	char enable_string[20];

	port_number = get_port_number_and_string (cptr_value_string,&enable_string[0]);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) >
		(ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif
	if (is_parameter_enabled (enable_string) == TRUE)
		*(USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = TRUE;
	else
		*(USHORT *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = FALSE;
}
/****************************************************************************/
void set_variable_port_and_enable_ulong (char *cptr_value_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	USHORT port_number;
	char enable_string[20];

	port_number = get_port_number_and_string (cptr_value_string,&enable_string[0]);

#if defined(__BORLANDC__) && !defined (__FLAT__)
	if ((ULONG) ((BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) >
		(ULONG) &nvram)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}

	if ((ULONG) ((BYTE_ENUM (BOOLEAN) *)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter))) <
		(ULONG) set_variable_port_and_enable)
		{
		printf ("Illegal Address for %s\r\n",cptr_value_string);
		return;
		}
#endif

	if (is_parameter_enabled (enable_string) == TRUE)
		*(ULONG*)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = TRUE;
	else
		*(ULONG*)(vptr_parameter_1 + ulptr_parameter_2 + (port_number * size_of_parameter)) = FALSE;
}


/* Sachin 23/07/1996 */

/*
	Does an in-place processing on strings that have '\b'
   and replaces them by blanks.
	Eg : MultiTech\bSoftware\bSystems becomes
	     MultiTech Software Systems
*/

char *process_back_slash (char *string)
{
	char new_string[256] ;
	char *src_ptr = string, *dest_ptr = &new_string[0] ;
	int flag = 0 ;

	while (*dest_ptr = *src_ptr)
	{
		if ((*src_ptr == '\\') && (*(src_ptr+1) == 'b'))
		{
			*dest_ptr++ = ' ' ;
			src_ptr += 2 ;
			flag++ ;
		}
		else
			*dest_ptr++ = *src_ptr++ ;
	}
	strcpy (string, &new_string[0]) ;
	return (string) ;
}

/* Sachin 23/07/1996 */

/* kamalnath 15/11/96 */
void set_dhcp_server_ip_address (char *cptr_ip_address_string,ULONG vptr_parameter_1,
	ULONG ulptr_parameter_2,ULONG size_of_parameter)
{
	char *cptr_ip_address;
	char scanf_string[20] ;
	ULONG ip_address;

	cptr_ip_address = &scanf_string[0];

	sscanf (cptr_ip_address_string,"%03ju.%03ju.%03ju.%03ju",(int *)(cptr_ip_address + 0),(int *)(cptr_ip_address + 1),
		(int *)(cptr_ip_address + 2),(int *)(cptr_ip_address + 3));

	ip_address = *((ULONG *) cptr_ip_address);

	ip_address = swap_long (ip_address);

	memcpy ((ULONG *)(vptr_parameter_1 + ulptr_parameter_2),&ip_address,sizeof (ULONG));
}
/* kamalnath 15/11/96 */
