/*	$Modname: vnvram.h$  $version: 1.13$      $date: 06/27/95$   */
/*
* 	$lgb$
1.0 03/09/94 ross new release.
1.1 03/09/94 ross added copyright.
1.2 06/15/94 ross
1.3 06/20/94 ross added snmp configuration table
1.4 08/18/94 ross added vj,tcp, cipx tables.
1.5 09/29/94 ross added sockets.
1.6 11/21/94 ross added consoles.
1.7 12/11/94 ross added sca and odi.
1.8 01/12/95 ross added netbios gateway.
1.9 01/26/95 ross changes for rwutils
1.10 02/01/95 ross dynamic configuration
1.11 02/27/95 ross dynamic load changes including lsl_control.
1.12 04/20/95 ross added ram file parsing addition
1.13 06/27/95 ross added ip address function to reduce redundancy in ip family protocols

26/9/95 Vidy added a section for ethernet _ UTP/AUI bug reported from Bombay
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/

GLOBAL NVRAM_CLASS nvram;

extern CONFIGURATION_TABLE lsl_configuration_table;
extern CONFIGURATION_TABLE ipx_configuration_table;
extern CONFIGURATION_TABLE stp_configuration_table;
extern CONFIGURATION_TABLE ip_configuration_table;
extern CONFIGURATION_TABLE ppp_configuration_table;
extern CONFIGURATION_TABLE ccp_configuration_table;
extern CONFIGURATION_TABLE cipx_configuration_table;
extern CONFIGURATION_TABLE vjc_configuration_table;
extern CONFIGURATION_TABLE wan_configuration_table;
/* chetan 4/11/96 */
extern CONFIGURATION_TABLE script_configuration_table;
/* chetan 4/11/96 */
extern CONFIGURATION_TABLE socket_configuration_table;
extern CONFIGURATION_TABLE snmp_configuration_table;
extern CONFIGURATION_TABLE tftp_configuration_table;
extern CONFIGURATION_TABLE ethernet_configuration_table;

/* sudhir 23/7/97  */
extern CONFIGURATION_TABLE proxy_configuration_table ;
/* sudhir 23/7/97  */

/* FRAME_RELAY */
extern CONFIGURATION_TABLE frame_relay_configuration_table ;
/* FRAME_RELAY */

#ifdef RTRERROR
extern CONFIGURATION_TABLE frame_relay_configuration_table;
extern CONFIGURATION_TABLE token_mac_configuration_table;
extern CONFIGURATION_TABLE dlsw_configuration_table;
extern CONFIGURATION_TABLE nlsp_configuration_table;
extern CONFIGURATION_TABLE appletalk_configuration_table;
#endif

extern CONFIGURATION_TABLE spx_configuration_table;
extern CONFIGURATION_TABLE tcp_configuration_table;
extern CONFIGURATION_TABLE telnet_configuration_table;
extern CONFIGURATION_TABLE ag_configuration_table;
#if WEB
extern CONFIGURATION_TABLE web_configuration_table;
#endif
extern CONFIGURATION_TABLE dhcp_configuration_table;

#ifdef RTRERROR
extern CONFIGURATION_TABLE cipx_configuration_table;
extern CONFIGURATION_TABLE vjc_configuration_table;
extern CONFIGURATION_TABLE bootp_configuration_table;
extern CONFIGURATION_TABLE remote_console_configuration_table;
extern CONFIGURATION_TABLE server_console_configuration_table;
extern CONFIGURATION_TABLE console_driver_configuration_table;
extern CONFIGURATION_TABLE odi_configuration_table;
extern CONFIGURATION_TABLE sca_configuration_table;
extern CONFIGURATION_TABLE netbios_gateway_configuration_table;
extern CONFIGURATION_TABLE ndis_configuration_table;
extern CONFIGURATION_TABLE tftp_configuration_table;
#endif

#if !defined (__DLL__)

char *section_name_array[] =
{
	{"LSL Multiplex Layer"},
#if PROXY_SERVER
#else
	{"IPX Routing"},
#endif
	{"PPP Device Driver"},
	{"CCP Compression"},
	{"CIPX Compression"},
	{"VJC Compression"},
#if PROXY_SERVER
#else
	{"Spanning Tree"},
#endif
   {"IP Routing"},
	{"WAN Serial Device Driver"},

	/* 4/11/96 chetan */
	{"Script Section"},
	/* 4/11/96 chetan */

	{"SNMP Management"},
	{"TFTP"},
	{"SOCKET Interface"},
	{"Ethernet Device Driver"},

#if PROXY_SERVER
#else
	{"Frame Relay Device Driver"},
#endif

#ifdef RTRERROR
	{"Frame Relay Device Driver"},
	{"Source Routing"},
	{"Token MAC"},
	{"CIPX Compression"},
	{"VJC Compression"},
	{"DLSW Routing"},
	{"NLSP Routing"},
	{"AppleTalk Routing"},
#endif

#if PROXY_SERVER
#else
	{"SPX Transport"},
#endif
   {"TCP Transport"},
	{"TELNET Server"},
	{"AsyncGateway"}, /* Sudha 06 July 1998 */
#if WEB
   {"WEB Server"},
#endif
	{"DHCP"},
	{"PROXY Server"}, /* sudhir 24/7/97 */

#ifdef RTRERROR
	{"BOOTP"},
	{"Remote Console"},
	{"Server Console"},
	{"ODI Driver"},
	{"Console Driver"},
	{"SCA Driver"},
	{"Netbios Gateway"},
	{"NDIS Device Driver"},
	{"TFTP"},
#endif
	{""}
};

CONFIGURATION_TABLE *sptr_configuration_table[] =
{
	&lsl_configuration_table,
#if PROXY_SERVER
#else
	&ipx_configuration_table,
#endif
	&ppp_configuration_table,
	&ccp_configuration_table,
	&cipx_configuration_table,
	&vjc_configuration_table,
#if PROXY_SERVER
#else
	&stp_configuration_table,
#endif
   &ip_configuration_table,
	&wan_configuration_table,

	/* 4/11/96 chetan */
	&script_configuration_table,
	/* 4/11/96 chetan */

	&snmp_configuration_table,
	&tftp_configuration_table,
	&socket_configuration_table,
	&ethernet_configuration_table,

#if PROXY_SERVER
#else
	&frame_relay_configuration_table,
#endif

#ifdef RTRERROR
	&frame_relay_configuration_table,
	&token_mac_configuration_table,
	&cipx_configuration_table,
	&vjc_configuration_table,
	&dlsw_configuration_table,
	&nlsp_configuration_table,
	&appletalk_configuration_table,
#endif

#if PROXY_SERVER
#else
	&spx_configuration_table,
#endif
   &tcp_configuration_table,

	&telnet_configuration_table,
	&ag_configuration_table, /* Sudha 06/07/98 */
#if WEB
   &web_configuration_table,
#endif
   &dhcp_configuration_table,
	&proxy_configuration_table,  /* sudhir 23/7/97 */

#ifdef RTRERROR
	&bootp_configuration_table,
	&remote_console_configuration_table,
	&server_console_configuration_table,
	&odi_configuration_table,
	&console_driver_configuration_table,
	&sca_configuration_table,
	&netbios_gateway_configuration_table,
	&ndis_configuration_table,
	&tftp_configuration_table,
#endif
	NULL
};

#else

char *section_name_array[] =
{
	{"LSL Multiplex Layer"},
	{"NDIS Device Driver"},
#if PROXY_SERVER
#else
	{"IPX Routing"},
#endif
   {"IP Routing"},
	{"PPP Device Driver"},
	{"CCP Compression"},
	{"CIPX Compression"},
	{"VJC Compression"},
	{"Console Driver"},
	{"Server Console"},
	{"SOCKET Interface"},
	{"NLSP Routing"},
	{""}
};

CONFIGURATION_TABLE *sptr_configuration_table[] =
{
	&lsl_configuration_table,
	&ndis_configuration_table,
#if PROXY_SERVER
#else
	&ipx_configuration_table,
#endif
   &ip_configuration_table,
	&ppp_configuration_table,
	&ccp_configuration_table,
	&cipx_configuration_table,
	&vjc_configuration_table,
	&console_driver_configuration_table,
	&server_console_configuration_table,
	&socket_configuration_table,
	&nlsp_configuration_table,
	NULL
};

#endif

