/*---------------------------------------------------------------------------
	file	:	log.h
	Auth	:	vidy
	Date	:	30th Jan 98
	Synop	:	Contains the routines for the log abstract data type
	Assumptions :
	1. Log can log only message strings with a null termination.
	2. This is for logging events which are not-too-fast. SO it
	assumes that the log read is a much faster operation than log write.
	If this is not the case the read pointers may become invalid during
	a read process as the circular buffer eats up the head
	3. log functions are not to be used from ISRs
---------------------------------------------------------------------------*/

/*
#ifndef TRUE
#define	FALSE	0
#define	TRUE 1
#define	NULL 0
#endif
*/

#define	LOG_MIN_FILE_SIZE		(20 * 1024)
#define	LOG_MAX_FILE_SIZE		(100 * 1024)
#define	LOG_DEF_FILE_SIZE		LOG_MIN_FILE_SIZE
#define	LOG_MIN_FREE_SIZE		100
#define	LOG_FREE_UP_QUANTUM	(LOG_MIN_FREE_SIZE * 10)

#if 0
#define	LOG_MIN_FILE_SIZE		(41)
#define	LOG_MAX_FILE_SIZE		(100 * 1024)
#define	LOG_DEF_FILE_SIZE		LOG_MIN_FILE_SIZE
#define	LOG_MIN_FREE_SIZE		2
#define	LOG_FREE_UP_QUANTUM	(LOG_MIN_FREE_SIZE * 5)
#endif

#define	LOG_MAX_OPENS	10
#define	CHAR_NEW_LINE	'\n'

typedef struct log_descriptor {
	char *read_ptr;
	char valid;
}log_descriptor_type;

static int get_log_time_stamp(char *buffer);
static void make_space_in_log_buffer(void);
static void copy_buffer_to_log(char *buffer, int copy_len);

