#include	"defs.h"
/*	$Modname: snmpglbl.c$  $version: 1.5$      $date: 06/27/95$   */
/*
* 	$lgb$
1.0 01/26/95 ross
1.1 01/26/95 ross SNMP file added
1.2 01/30/95 ross removing duplicate configuration options
1.3 01/30/95 ross fixed problem with secondary port class row.
1.4 02/01/95 ross added sr snmp index variable - special case.
1.5 06/27/95 ross snmp global changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define __SNMP__
#include <string.h>
#include <stdlib.h>
#include <kstart.h>
#include <v8022str.h>
#include <visnpstr.h>
#include <lslproto.h>
#include <rwarebuf.h>
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the function prototype as a result of change in object id type from */
/* BYTE to OBJECT_ID */
static void set_mib_access_parameters (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	enum MIB_OPERATION mib_operation, char *cptr_mib_string, BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value,
	USHORT *usptr_size_of_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name);
static SNMP_TABLE_ENTRY *get_first_mib_variable (SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum BOOLEAN check_if_snmp_table_entry_is_valid (SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static SNMP_TABLE_ENTRY *get_next_mib_variable (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters);
static enum TEST process_scalar_mib_variable (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
/* Srikar, Mar 20, 1997. Changed the function prototype as a result of change in object id type from */
/* BYTE to OBJECT_ID */
static void build_indices_for_scalar_mib_variable (OBJECT_ID *sptr_table_indices, USHORT *usptr_size_of_table_indices);
/* Srikar, 6 Jan 97 */
static enum TEST process_table_mib_variable (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry, enum BOOLEAN *eptr_good_value);
/* Srikar, 6 Jan 97 */
static enum BOOLEAN check_if_mib_table_exists (void);
static void create_mib_table_sorted_on_indices (void);
/* Srikar, Mar 20, 1997. Changed the function prototype as a result of change in object id type from */
/* BYTE to OBJECT_ID */
static enum BOOLEAN get_mib_table_indices (OBJECT_ID *sptr_table_indices, USHORT *usptr_size_of_table_indices,
	enum BOOLEAN *eptr_received_indices, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static void allocate_memory_for_mib_table_indices (SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static void free_memory_for_mib_table_indices (SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum TEST find_row_in_mib_table (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,	void **ptr_to_vptr_row_in_table);
static void	process_all_table_indices (SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static void *get_first_row_in_mib_table (SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum TEST get_next_row_in_mib_table (void **ptr_to_vptr_row_in_table, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);

static enum TEST get_next_row_in_mib_table_if_mib_table_is_an_array (void **ptr_to_vptr_row_in_table, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);

static BYTE get_size_of_table_indices (SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum TEST find_pointer_to_next_row_when_mib_table_is_an_array (void **ptr_to_vptr_row_in_table,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum TEST find_pointer_to_row_when_mib_table_is_an_array_of_linked_lists (void **ptr_to_vptr_row_in_table,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static void *get_next_row_from_linked_list (void *vptr_current_mib_row,	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum TEST search_linked_list_for_mib_table_entry_that_matches_the_received_indices (void **ptr_to_vptr_mib_table_entry,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum BOOLEAN check_if_the_received_indices_match_the_one_for_the_current_row_of_the_mib_table (
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry, void *vptr_mib_table_entry);

static enum BOOLEAN junk ( SNMP_TABLE_ENTRY *sptr_snmp_table_entry, void *vptr_mib_table_entry);

static void *get_next_array_element_from_mib_table (void *vptr_array_element, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum TEST find_pointer_to_row_when_mib_table_is_a_linked_list (void **ptr_to_vptr_row_in_table);
/* Srikar, Mar 20, 1997. Changed the function prototype as a result of change in object id type from */
/* BYTE to OBJECT_ID */
static void store_table_indices_in_snmp_table_entry (OBJECT_ID *sptr_table_indices, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static enum TEST apply_mib_operation_on_current_instance_of_mib_variable (void *vptr_row_in_table,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
/* Srikar, Mar 20, 1997. Changed the function prototype as a result of change in object id type from */
/* BYTE to OBJECT_ID */
static enum TEST build_table_indices_for_current_instance_of_mib_variable (void *vptr_row_in_table,
	OBJECT_ID *sptr_table_indices, USHORT *usptr_size_of_table_indices, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
/* Srikar, Mar 20, 1997. Changed the function prototype as a result of change in object id type from */
/* BYTE to OBJECT_ID. Changed the return type from void to USHORT */
static USHORT memcpy_table_indices (BYTE number_of_indices, OBJECT_ID *sptr_table_indices, void *vptr_row_in_table,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static void adjust_mib_access_parameters (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
static void clear_pointer_to_next_variable_name (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters);
/* Srikar, Apr 11, 1997. Added function prototype */
void dummy(void *);
/**********************************************************************************/
/* Srikar, 6 Jan 97 */
/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
enum TEST process_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name,
	SNMP_TABLE_ENTRY *sptr_first_table_entry)
{
	enum TEST found_variable;
	enum BOOLEAN good_value;
	MIB_ACCESS_PARAMETERS mib_access_parameters;
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry;

#ifdef DDDEBUG
if(mib_operation == SET_OPERATION)
printf("\r\n OPERATION IS %d\r\n",mib_operation);
#endif

	set_mib_access_parameters (&mib_access_parameters, mib_operation, cptr_mib_string, bptr_variable_value,
		usptr_size_of_variable_value, usptr_size_of_table_indices, sptr_table_indices, eptr_end_of_table,
		ptr_to_cptr_next_variable_name);

	for (sptr_snmp_table_entry = get_first_mib_variable (sptr_first_table_entry);
		check_if_snmp_table_entry_is_valid (sptr_snmp_table_entry) == TRUE;
		sptr_snmp_table_entry = get_next_mib_variable (sptr_snmp_table_entry, &mib_access_parameters))
		{
		if (strcmp (sptr_snmp_table_entry->mib_name, mib_access_parameters.cptr_mib_string) == STRINGS_MATCH)
			{
			if (sptr_snmp_table_entry->sptr_parameters->is_a_table_entry == FALSE)
				{
				found_variable = process_scalar_mib_variable (&mib_access_parameters, sptr_snmp_table_entry);

				return (found_variable);
				}
			else
				{
				allocate_memory_for_mib_table_indices (sptr_snmp_table_entry);
				found_variable = process_table_mib_variable (&mib_access_parameters, sptr_snmp_table_entry, &good_value);

				if (found_variable == PASS)
					{
					free_memory_for_mib_table_indices (sptr_snmp_table_entry);

					if(good_value == TRUE)
						return (PASS);
					else
						return (FAIL);
					}

				adjust_mib_access_parameters (&mib_access_parameters, sptr_snmp_table_entry);

				free_memory_for_mib_table_indices (sptr_snmp_table_entry);
				}
			}
		}

	clear_pointer_to_next_variable_name (&mib_access_parameters);
	
	return (FAIL);
}					  
/* Srikar, 6 Jan 97 */
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the type and name of the following parameters */
/* bptr_table_indices - sptr_table_indices(BYTE * - OBJECT_ID *) */
static void set_mib_access_parameters (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	enum MIB_OPERATION mib_operation, char *cptr_mib_string, BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value,
	USHORT *usptr_size_of_table_indices, OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table,
	char **ptr_to_cptr_next_variable_name)
{
	sptr_mib_access_parameters->mib_operation = mib_operation;
	sptr_mib_access_parameters->cptr_mib_string = cptr_mib_string;
	sptr_mib_access_parameters->bptr_variable_value = bptr_variable_value;
	sptr_mib_access_parameters->usptr_size_of_variable_value = usptr_size_of_variable_value;
	sptr_mib_access_parameters->usptr_size_of_table_indices = usptr_size_of_table_indices;
	sptr_mib_access_parameters->sptr_table_indices = sptr_table_indices;
	sptr_mib_access_parameters->eptr_end_of_table = eptr_end_of_table;
	sptr_mib_access_parameters->ptr_to_cptr_next_variable_name = ptr_to_cptr_next_variable_name;
}
/**********************************************************************************/
static SNMP_TABLE_ENTRY *get_first_mib_variable (SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	return (sptr_snmp_table_entry);
}
/**********************************************************************************/
static enum BOOLEAN check_if_snmp_table_entry_is_valid (SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	if (sptr_snmp_table_entry->fptr_mib_access_function != NULL)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/**********************************************************************************/
static SNMP_TABLE_ENTRY *get_next_mib_variable (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters)
{
	PARAMETER_NOT_USED (sptr_mib_access_parameters);

	++sptr_snmp_table_entry;

	return (sptr_snmp_table_entry);
}
/**********************************************************************************/
/* Srikar, 6 Jan 97 */
static enum TEST process_scalar_mib_variable (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	USHORT arg_not_used;
	enum TEST return_code;

	arg_not_used = 0x0000;

	*(sptr_mib_access_parameters->usptr_size_of_variable_value) = sptr_snmp_table_entry->size_of_mib_variable;

	return_code = (sptr_snmp_table_entry->fptr_mib_access_function) (arg_not_used, sptr_mib_access_parameters->mib_operation,
		sptr_snmp_table_entry->offset_of_mib_variable,
		sptr_snmp_table_entry->sptr_parameters->address_of_structure_containing_mib_variable,
		(ULONG) arg_not_used,
		sptr_mib_access_parameters->bptr_variable_value, sptr_mib_access_parameters->usptr_size_of_variable_value);

	if (sptr_snmp_table_entry->need_to_swap == TRUE)
		{
		*((ULONG *) sptr_mib_access_parameters->bptr_variable_value) =
			swap_long (*((ULONG *) sptr_mib_access_parameters->bptr_variable_value));
		}

	build_indices_for_scalar_mib_variable (sptr_mib_access_parameters->sptr_table_indices,
		sptr_mib_access_parameters->usptr_size_of_table_indices);

	return (return_code);
}
/* Srikar, 6 Jan 97 */
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the type and name of the following parameters */
/* bptr_table_indices - sptr_table_indices(BYTE * - OBJECT_ID *) */
static void build_indices_for_scalar_mib_variable (OBJECT_ID *sptr_table_indices, USHORT *usptr_size_of_table_indices)
{
	*sptr_table_indices = 0x00;

	*usptr_size_of_table_indices = 0x0001;
}
/**********************************************************************************/
/* Srikar, 6 Jan 97 */
static enum TEST process_table_mib_variable (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry, enum BOOLEAN *eptr_good_value)
{
	enum BOOLEAN table_does_exist;
	void *vptr_row_in_table;

	table_does_exist = check_if_mib_table_exists ();

	if (table_does_exist == FALSE)
		{
		create_mib_table_sorted_on_indices ();
		}

	if (find_row_in_mib_table (sptr_snmp_table_entry, sptr_mib_access_parameters, &vptr_row_in_table) == FAIL)
		{
		return (FAIL);
		}

	if (apply_mib_operation_on_current_instance_of_mib_variable (vptr_row_in_table, 
			sptr_mib_access_parameters, sptr_snmp_table_entry) == PASS)
		*eptr_good_value = TRUE;
	else
		*eptr_good_value = FALSE;
	build_table_indices_for_current_instance_of_mib_variable (vptr_row_in_table,
		sptr_mib_access_parameters->sptr_table_indices, sptr_mib_access_parameters->usptr_size_of_table_indices,
		sptr_snmp_table_entry);

	return (PASS);
}
/* Srikar, 6 Jan 97 */
/**********************************************************************************/
static enum BOOLEAN check_if_mib_table_exists (void)
{
	return (TRUE);
}
/**********************************************************************************/
static void create_mib_table_sorted_on_indices (void)
{

}
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the type and name of the following parameters */
/* bptr_table_indices - sptr_table_indices(BYTE * - OBJECT_ID *) */
static enum BOOLEAN get_mib_table_indices (OBJECT_ID *sptr_table_indices, USHORT *usptr_size_of_table_indices,
	enum BOOLEAN *eptr_received_indices, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	USHORT size_of_indices;

	*eptr_received_indices = TRUE;

	size_of_indices = get_size_of_table_indices (sptr_snmp_table_entry);

	if (*usptr_size_of_table_indices == 0x0000)
		{
		*eptr_received_indices = FALSE;

		/* Srikar, Mar 19, 1997. Added the following to initialize the table of indices in the snmp table entry. */
		store_table_indices_in_snmp_table_entry (NULL, sptr_snmp_table_entry);
		}
	else if (*usptr_size_of_table_indices == size_of_indices)
		{
		store_table_indices_in_snmp_table_entry (sptr_table_indices, sptr_snmp_table_entry);
		}
	else
		{
		return (FALSE);
		}

	return (TRUE);
}
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the code to return the size of the table indices in terms of the */
/* number of subidentifiers constituting all the table indices put together, not the number of bytes */
/* needed for the table indices */
static BYTE get_size_of_table_indices (SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	BYTE size_of_indices;
	BYTE number_of_indices;

	size_of_indices = 0x00;

	for (number_of_indices = 0x00;  number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
		number_of_indices = (BYTE) (number_of_indices + 1))
		{
		switch(sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_type)
			{
			case SNMP_STRING_TYPE:
				size_of_indices += (BYTE)sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].size_of_index + 1;
				break;
			case SNMP_FIXED_STRING_TYPE:
				size_of_indices += (BYTE)sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].size_of_index;
				break;
			case SNMP_SCALAR_TYPE:
				size_of_indices++;
				break;
			case SNMP_IP_ADDRESS_TYPE:
				size_of_indices += 4;
				break;
			/* Srikar, Mar 31, 1997. Added code to take care of the SNMP_IP_NETWORK_ADDRESS_TYPE */
			case SNMP_IP_NETWORK_ADDRESS_TYPE:
				size_of_indices += 5;
				break;
			}
		}

	return (size_of_indices);
}
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the parameter bptr_table_indices to sptr_table_indices and its type from BYTE * to */
/* OBJECT_ID *. Also changed the function definition as a result of these changes in object id type. */
static void store_table_indices_in_snmp_table_entry (OBJECT_ID *sptr_table_indices, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	BYTE number_of_indices;
	USHORT index_size;
	void	*ptr_to_index;
	USHORT i;
	USHORT bits;

	/* Srikar, Mar 19, 1997. Added the following to initialize the table of indices when the indices are not */
	/* received from the manager. */
	if (sptr_table_indices == NULL)
		{
		for (number_of_indices = 0x00; number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
			number_of_indices = (BYTE) (number_of_indices + 1))
			{
			sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_received = FALSE;
			index_size = sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].size_of_index;
			if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_type == SNMP_STRING_TYPE)
				index_size++;
			memset(sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].vptr_index_value, 0, index_size);
			}
		return;
		}

	for (number_of_indices = 0x00; number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
		number_of_indices = (BYTE) (number_of_indices + 1))
		{
		/* Srikar, Mar 19, 1997. Added the following to indicate that the indices were received from the manager. */
		sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_received = TRUE;

		index_size = sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].size_of_index;
		ptr_to_index = sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].vptr_index_value;

		switch(sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_type)
			{
			case SNMP_STRING_TYPE:
			case SNMP_FIXED_STRING_TYPE:
				if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_type == SNMP_STRING_TYPE)
					{
					if (*sptr_table_indices < index_size)
						index_size = *sptr_table_indices;
					sptr_table_indices++;
					}
				for(i = 0; i < index_size; i++)
					{
					*((BYTE *)ptr_to_index) = (BYTE)(*sptr_table_indices);
					sptr_table_indices++;
					ptr_to_index = (void *)((BYTE *)ptr_to_index + 1);
					}
				break;
			/* Srikar, Mar 31, 1997. Added code to decode SNMP_IP_NETWORK_ADDRESS_TYPE */
			case SNMP_IP_NETWORK_ADDRESS_TYPE:
				sptr_table_indices++;
			case SNMP_IP_ADDRESS_TYPE:
				bits = 32;
				*(ULONG *) ptr_to_index = 0;
				while (bits)
					{
					bits -= 8;
					*(ULONG *) ptr_to_index |= (0x000000ff & *sptr_table_indices) << bits;
					sptr_table_indices++;
					}
				break;
			case SNMP_SCALAR_TYPE:
				switch(index_size)
					{
					case sizeof(BYTE):
						*((BYTE *)ptr_to_index) = (BYTE)*sptr_table_indices;
						break;
					case sizeof(USHORT):
						*((USHORT *)ptr_to_index) = (USHORT)*sptr_table_indices;
						break;
					case sizeof(ULONG):
						*((ULONG *)ptr_to_index) = (ULONG)*sptr_table_indices;
						break;
					}
				sptr_table_indices++;
				break;
			}

		/* Srikar, Mar 19, 1997. Added support for table indices which are incremented before being sent to the manager. */
		/* Subsequent to the addition, in a get operation, a 0-relative index is sent to the manager as a 1-relative index. */
		/* Hence the manager gives the next GET_NEXT operation with the index as 1-relative which needs to be translated */
		/* to a 0-relative index. For example, for ipxCircIndex, the intrnal 0-relative port number is incremented to make it */
		/* 1-relative before sending to the manager. The subsequent GET_NEXT operation is issued by the manager with */
		/* an index of 1, which actually maps to our local index of 0, and so we need to decrement the index got from the */
		/* manager to map it to our local representation. */

		if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].need_to_increment == TRUE)
			{
			switch (index_size)
				{
				case sizeof(BYTE) :
					*((BYTE *) ptr_to_index) = *((BYTE *) ptr_to_index) - 1;
					break;
				case sizeof(USHORT) :
					*((USHORT *) ptr_to_index) = *((USHORT *) ptr_to_index) - 1;
					break;
				case sizeof(ULONG) :
					*((ULONG *) ptr_to_index) = *((ULONG *) ptr_to_index) - 1;
					break;
				}
			}
		}
}
/**********************************************************************************/
static void	process_all_table_indices (SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	ULONG index_value;
	ULONG count;

	for (count = 0x0000; count < sptr_snmp_table_entry->sptr_parameters->number_of_indices; ++count)
		{
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].need_to_increment == TRUE)
			{
			if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].size_of_index == sizeof (ULONG))
				{
				index_value = *((ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value);

/*
				--index_value;
*/

			 	*((ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value) = index_value;
				}
			else if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].size_of_index == sizeof (USHORT))
				{
				index_value = (ULONG) *((USHORT *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value);

/*
				--index_value;
*/

			 	*((USHORT *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value) = (USHORT) index_value;
				}
			}
		}
}
/**********************************************************************************/
static void *get_first_row_in_mib_table (SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	void *vptr_first_mib_row;
	USHORT array_index;
	LINK *sptr_linked_list;
	void *vptr_array_element;

	vptr_first_mib_row = NULL;

	switch (sptr_snmp_table_entry->sptr_parameters->table_type)
		{
		case MIB_TABLE_AS_AN_ARRAY:

			vptr_first_mib_row = sptr_snmp_table_entry->sptr_parameters->vptr_first_row_in_mib_table;

			break;

		case MIB_TABLE_AS_AN_ARRAY_OF_LINKED_LISTS:

			for (array_index = 0x0000; array_index < sptr_snmp_table_entry->sptr_parameters->number_of_array_elements;
				++array_index)
				{
				vptr_array_element = (void *) ((ULONG) sptr_snmp_table_entry->sptr_parameters->vptr_first_row_in_mib_table +
					(sptr_snmp_table_entry->sptr_parameters->size_of_array_element * array_index));

				sptr_linked_list = (LINK *) ((ULONG) vptr_array_element +
					sptr_snmp_table_entry->sptr_parameters->offset_of_first_linked_list_pointer);

				vptr_first_mib_row = (void *) get_pointer_to_first_entry_in_list (sptr_linked_list);

				if (vptr_first_mib_row != NULL)
					{
					return (vptr_first_mib_row);
					}
				}

			break;

		case MIB_TABLE_AS_A_LINKED_LIST:

			vptr_first_mib_row = (void *) get_pointer_to_first_entry_in_list ((LINK *)
				sptr_snmp_table_entry->sptr_parameters->vptr_first_row_in_mib_table);

			break;

		default:

			break;
		}

	return (vptr_first_mib_row);
}
/**********************************************************************************/
static enum TEST get_next_row_in_mib_table (void **ptr_to_vptr_row_in_table, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	enum TEST return_code;

	process_all_table_indices (sptr_snmp_table_entry);

	switch (sptr_snmp_table_entry->sptr_parameters->table_type)
		{
		case MIB_TABLE_AS_AN_ARRAY:

			return_code = find_pointer_to_next_row_when_mib_table_is_an_array (ptr_to_vptr_row_in_table, sptr_snmp_table_entry);

			break;

		case MIB_TABLE_AS_AN_ARRAY_OF_LINKED_LISTS:

			return_code = find_pointer_to_row_when_mib_table_is_an_array_of_linked_lists (ptr_to_vptr_row_in_table,
				sptr_snmp_table_entry);

			break;

		case MIB_TABLE_AS_A_LINKED_LIST:

			return_code = find_pointer_to_row_when_mib_table_is_a_linked_list (ptr_to_vptr_row_in_table);

			break;

		default:

			return_code = FAIL;

			break;
		}

	return (return_code);
}
/**********************************************************************************/
static enum TEST find_pointer_to_next_row_when_mib_table_is_an_array (void **ptr_to_vptr_row_in_table,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	USHORT count;


	for (count = 0x0000; count < sptr_snmp_table_entry->sptr_parameters->number_of_indices; ++count)
		{
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].should_be_used_to_get_pointer_to_next_array_element ==
			TRUE)
			{
			if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index != NULL)
				{
				if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].size_of_index == sizeof (ULONG))
					{
					if (*((ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value) >=
						*((ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index))
						{
						return (FAIL);
						}
					}
				else
					{
					if (*((USHORT *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value) >=
						*((USHORT *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index))
						{
						return (FAIL);
						}
					}
				}
			}
		}
	for (count = 0x0000; count < sptr_snmp_table_entry->sptr_parameters->number_of_indices; ++count)
		{
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].should_be_used_to_get_pointer_to_next_array_element
			== TRUE)
			{
/*printf("\r\n vptr index value = %x and count is %x  and maximum value is %x\r\n",*(ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value,count,*(ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index);*/

			*ptr_to_vptr_row_in_table = (void *) ((ULONG) sptr_snmp_table_entry->sptr_parameters->vptr_first_row_in_mib_table +
				(sptr_snmp_table_entry->sptr_parameters->size_of_array_element *
				(*(ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value)));
			} 
		}
	return (PASS);

}
/**********************************************************************************/
static enum TEST find_pointer_to_row_when_mib_table_is_an_array_of_linked_lists (void **ptr_to_vptr_row_in_table,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	void *vptr_mib_table_entry;
	void *vptr_last_mib_table_entry;
	LINK *sptr_linked_list;
	USHORT count;
	void *vptr_array_element;

	vptr_array_element = sptr_snmp_table_entry->sptr_parameters->vptr_first_row_in_mib_table;

	for (count = 0x0000; count < sptr_snmp_table_entry->sptr_parameters->number_of_indices; ++count)
		{
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].should_be_used_to_get_pointer_to_next_array_element
			== TRUE)
			{
			vptr_array_element = (void *) ((ULONG) vptr_array_element +
				(sptr_snmp_table_entry->sptr_parameters->size_of_array_element *
				(*(ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value)));
			}
		}

	sptr_linked_list = (LINK *) ((ULONG) vptr_array_element +
		sptr_snmp_table_entry->sptr_parameters->offset_of_first_linked_list_pointer);

	vptr_mib_table_entry = get_pointer_to_first_entry_in_list (sptr_linked_list);

	if (search_linked_list_for_mib_table_entry_that_matches_the_received_indices (&vptr_mib_table_entry, sptr_snmp_table_entry)
		== PASS)
		{
		vptr_last_mib_table_entry = get_pointer_to_last_entry_in_list (sptr_linked_list);

		if (vptr_mib_table_entry != vptr_last_mib_table_entry)
			{
			*ptr_to_vptr_row_in_table = (void *) get_next_row_from_linked_list (vptr_mib_table_entry,	sptr_snmp_table_entry);

			if (*ptr_to_vptr_row_in_table == NULL)
				{
				return (FAIL);
				}

			return (PASS);
			}
		}
	else
		{
		return (FAIL);
		}

	vptr_array_element = (void *) get_next_array_element_from_mib_table (vptr_array_element, sptr_snmp_table_entry);

	while (vptr_array_element != NULL)
		{
		sptr_linked_list = (LINK *) ((ULONG) vptr_array_element +
			sptr_snmp_table_entry->sptr_parameters->offset_of_first_linked_list_pointer);

		vptr_mib_table_entry = get_pointer_to_first_entry_in_list (sptr_linked_list);

		if (vptr_mib_table_entry != NULL)
			{
			*ptr_to_vptr_row_in_table = (void *) vptr_mib_table_entry;

			return (PASS);
			}

		vptr_array_element = (void *) get_next_array_element_from_mib_table (vptr_array_element, sptr_snmp_table_entry);
		}

	return (FAIL);
}
/**********************************************************************************/
static void *get_next_row_from_linked_list (void *vptr_current_mib_row,	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	void *vptr_next_mib_row;

	vptr_next_mib_row = NULL;

	switch (sptr_snmp_table_entry->sptr_parameters->table_type)
		{
		case MIB_TABLE_AS_AN_ARRAY_OF_LINKED_LISTS:

			vptr_next_mib_row = (void *) get_pointer_to_next_entry_in_list ((LINK *) vptr_current_mib_row);

			break;
		}

	return (vptr_next_mib_row);
}
/**********************************************************************************/
static enum TEST search_linked_list_for_mib_table_entry_that_matches_the_received_indices (void **ptr_to_vptr_mib_table_entry,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	while (*ptr_to_vptr_mib_table_entry != NULL)
		{
		if (check_if_the_received_indices_match_the_one_for_the_current_row_of_the_mib_table (sptr_snmp_table_entry,
			*ptr_to_vptr_mib_table_entry) == TRUE)
			{
			return (PASS);
			}

		*ptr_to_vptr_mib_table_entry = get_pointer_to_next_entry_in_list ((LINK *) *ptr_to_vptr_mib_table_entry);
		}

	return (FAIL);
}
/**********************************************************************************/
static enum BOOLEAN check_if_the_received_indices_match_the_one_for_the_current_row_of_the_mib_table (
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry, void *vptr_mib_table_entry)
{
	USHORT count;
	ULONG received_index_value;
	ULONG index_value_of_mib_table_entry;
	ULONG xxx;

/*	printf("\r\nin function val is %x\r\n",vptr_mib_table_entry);*/

	for (count = 0x0000; count < sptr_snmp_table_entry->sptr_parameters->number_of_indices; ++count)
		{
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].size_of_index == sizeof (ULONG))
			{
			received_index_value = *((ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value);

			index_value_of_mib_table_entry = *((ULONG *) ((ULONG) vptr_mib_table_entry +
				sptr_snmp_table_entry->sptr_parameters->table_indices[count].offset_to_index));

			xxx = (ULONG) vptr_mib_table_entry + sptr_snmp_table_entry->sptr_parameters->table_indices[count].offset_to_index;

/*			printf("\r\n address of index_valueof_mib_table = %x index_value_of_mib_table_entry %x\r\n",xxx,index_value_of_mib_table_entry);*/
			if (received_index_value != index_value_of_mib_table_entry)
				{
				return (FALSE);
				}
			}
		else if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].size_of_index == sizeof (USHORT))
			{
			received_index_value = *((USHORT *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value);

			index_value_of_mib_table_entry = *((USHORT *) ((ULONG) vptr_mib_table_entry +
				sptr_snmp_table_entry->sptr_parameters->table_indices[count].offset_to_index));

			if (received_index_value != index_value_of_mib_table_entry)
				{
				return (FALSE);
				}
			}
/* Sanjays code */
		else /* indices of types other than USHORT and ULONG are memcmp()-ed */
			{
				if (memcmp((void *)sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value,
						(void *) ((ULONG) vptr_mib_table_entry +
						sptr_snmp_table_entry->sptr_parameters->table_indices[count].offset_to_index),
						sptr_snmp_table_entry->sptr_parameters->table_indices[count].size_of_index) != 0)
					{
					return FALSE;
					}
			}
/* Sanjays code */
		}

	return (TRUE);
}
/**********************************************************************************/
static void *get_next_array_element_from_mib_table (void *vptr_array_element, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	USHORT count;
	ULONG index_value;
	ULONG maximum_value_of_index;

	index_value = 0x00000000L;

	maximum_value_of_index = 0x00000000L;

	for (count = 0x0000; count < sptr_snmp_table_entry->sptr_parameters->number_of_indices; ++count)
		{
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].should_be_used_to_get_pointer_to_next_array_element
			== TRUE)
			{
			if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].size_of_index == sizeof (ULONG))
				{
				index_value = *((ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value) + 1;

				if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index != NULL)
					{
					maximum_value_of_index =
						*((ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index);
					}
				}
			else if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].size_of_index == sizeof (USHORT))
				{
				index_value = *((USHORT *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_index_value) + 1;

				if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index != NULL)
					{
					maximum_value_of_index =
						*((USHORT *) sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index);
					}
				}
			}

		if (sptr_snmp_table_entry->sptr_parameters->table_indices[count].vptr_maximum_value_of_index != NULL)
			{
			if (index_value >	maximum_value_of_index)
				{
				return (NULL);
				}
			}

		vptr_array_element = (void *) ((ULONG) vptr_array_element +
			(sptr_snmp_table_entry->sptr_parameters->size_of_array_element *	index_value));
		}

	return (vptr_array_element);
}
/**********************************************************************************/
static enum TEST find_pointer_to_row_when_mib_table_is_a_linked_list (void **ptr_to_vptr_row_in_table)
{
	*ptr_to_vptr_row_in_table = (void *) get_pointer_to_next_entry_in_list ((LINK *) *ptr_to_vptr_row_in_table);

	if (*ptr_to_vptr_row_in_table == NULL)
		{
		return (FAIL);
		}

	return  (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
static enum TEST build_table_indices_for_current_instance_of_mib_variable (void *vptr_row_in_table,
	OBJECT_ID *sptr_table_indices, USHORT *usptr_size_of_table_indices, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	BYTE number_of_indices;

	for (number_of_indices = 0x00; number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
		number_of_indices = (BYTE) (number_of_indices + 1))
		{
		/* Srikar, Mar 20, 1997. Changed the code to update the variable sptr_table_indices by adding the number of */
		/* sub identifiers constituting the table index */
		sptr_table_indices += memcpy_table_indices (number_of_indices, sptr_table_indices, vptr_row_in_table, sptr_snmp_table_entry);
		}

	*usptr_size_of_table_indices = get_size_of_table_indices (sptr_snmp_table_entry);

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID *. Also changed the function as a result of the change in the type of */
/* object id from BYTE to OBJECT_ID */
/* Changed the return type to USHORT and modified the code to return */
/* the number of sub identifiers in a particular table index */
static USHORT memcpy_table_indices (BYTE number_of_indices, OBJECT_ID *sptr_table_indices, void *vptr_row_in_table,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	void *vptr_local_index;
	USHORT index_size;
	USHORT i;
	USHORT bits;
	ULONG mask;
	USHORT number_of_sub_ids_in_table_index = 0;
	ULONG temp;

	vptr_local_index = (void *) ((ULONG) vptr_row_in_table +
		sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].offset_to_index);

	index_size = sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].size_of_index;
	switch (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_type)
		{
		case SNMP_STRING_TYPE:
		case SNMP_FIXED_STRING_TYPE:
			if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_type == SNMP_STRING_TYPE)
				{
				*sptr_table_indices = (BYTE)index_size;
				sptr_table_indices++;
				number_of_sub_ids_in_table_index++;
				}
			for (i = 0; i < (BYTE) index_size; i++)
				{
				*sptr_table_indices = *((BYTE *)vptr_local_index);
				sptr_table_indices++;
				number_of_sub_ids_in_table_index++;
				vptr_local_index = (void *)((BYTE *)vptr_local_index + 1);
				}
			break;
		/* Srikar, Mar 31, 1997. Added code to encode SNMP_IP_NETWORK_ADDRESS_TYPE */
		case SNMP_IP_NETWORK_ADDRESS_TYPE:
			*sptr_table_indices = 1;
			sptr_table_indices++;
		case SNMP_IP_ADDRESS_TYPE:
			mask = 0xff000000;
			bits = 24;
			while(mask)
				{
				*sptr_table_indices = (mask & *(ULONG *)vptr_local_index) >> bits;
				mask >>= 8;
				bits -= 8;
				sptr_table_indices++;
				}
			number_of_sub_ids_in_table_index += 4;
			break;
		case SNMP_SCALAR_TYPE:
			switch(index_size)
				{
				case sizeof(BYTE):
					*sptr_table_indices = *((BYTE *)vptr_local_index);
					break;
				case sizeof(USHORT):
					*sptr_table_indices = *((USHORT *)vptr_local_index);
					break;
				case sizeof(ULONG):
					*sptr_table_indices = *((ULONG *)vptr_local_index);
					break;
				}
			if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].need_to_increment == TRUE)
				(*sptr_table_indices)++;
			number_of_sub_ids_in_table_index++;
			break;
		}
	return number_of_sub_ids_in_table_index;
}
/**********************************************************************************/
static void adjust_mib_access_parameters (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,
	SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	*(sptr_mib_access_parameters->eptr_end_of_table) = sptr_snmp_table_entry->sptr_parameters->is_a_table_entry;

	*(sptr_mib_access_parameters->usptr_size_of_table_indices) = 0x0000;

	++sptr_snmp_table_entry;

	sptr_mib_access_parameters->cptr_mib_string = sptr_snmp_table_entry->mib_name;

	*(sptr_mib_access_parameters->ptr_to_cptr_next_variable_name) = sptr_snmp_table_entry->mib_name;

	*(sptr_mib_access_parameters->usptr_size_of_variable_value) = sptr_snmp_table_entry->size_of_mib_variable;
}
/**********************************************************************************/
static void allocate_memory_for_mib_table_indices (SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	BYTE number_of_indices;
	/* Srikar, Mar 19, 1997. Added the following local to save the size of the index. */
	ULONG	size_of_index;

	for (number_of_indices = 0x00; number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
		number_of_indices = (BYTE) (number_of_indices + 1))
		{
		/* Srikar, Mar 19, 1997. For string type index the length of the string is passed as the first byte. So */
		/* we must allocate 1 byte extra for this. */

		size_of_index = sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].size_of_index;
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].index_type == SNMP_STRING_TYPE)
			size_of_index++;
		sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].vptr_index_value =
			table_malloc (1, size_of_index);

		if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].vptr_index_value == NULL)
			{
			break;
			}
		}
}
/**********************************************************************************/
static void free_memory_for_mib_table_indices (SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	BYTE number_of_indices;

	for (number_of_indices = 0x00; number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
		number_of_indices = (BYTE) (number_of_indices + 1))
		{
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].vptr_index_value != NULL)
			{
			table_free (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].vptr_index_value);
			}
		}
}
/**********************************************************************************/
static void clear_pointer_to_next_variable_name (MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters)
{
	*(sptr_mib_access_parameters->ptr_to_cptr_next_variable_name) = NULL;

	*(sptr_mib_access_parameters->eptr_end_of_table) = TRUE;
}
/**********************************************************************************/
static enum TEST apply_mib_operation_on_current_instance_of_mib_variable (void *vptr_row_in_table,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	USHORT arg_not_used;

	arg_not_used = 0x0000;

	if ((sptr_snmp_table_entry->fptr_mib_access_function) (arg_not_used,
		sptr_mib_access_parameters->mib_operation, sptr_snmp_table_entry->offset_of_mib_variable,
		(ULONG) vptr_row_in_table, (ULONG) arg_not_used, sptr_mib_access_parameters->bptr_variable_value,
		sptr_mib_access_parameters->usptr_size_of_variable_value) == FAIL)
		{
		return (FAIL);
		}

	/* Srikar, Mar 15, 1997. size is now set in the mib access functions, we only change if it exceeds limit */
	if (*(sptr_mib_access_parameters->usptr_size_of_variable_value) > sptr_snmp_table_entry->size_of_mib_variable)
		*(sptr_mib_access_parameters->usptr_size_of_variable_value) = sptr_snmp_table_entry->size_of_mib_variable;

	if (sptr_snmp_table_entry->need_to_increment_mib_value_for_get_operation == TRUE)
		{
		if (sptr_snmp_table_entry->size_of_mib_variable == sizeof (ULONG))
			{
			*((ULONG *) sptr_mib_access_parameters->bptr_variable_value) =
				swap_long (swap_long (*((ULONG *) sptr_mib_access_parameters->bptr_variable_value)) + 1);
			}
		else if (sptr_snmp_table_entry->size_of_mib_variable == sizeof (USHORT))
			{
			*((USHORT *) sptr_mib_access_parameters->bptr_variable_value) =
				swap ((USHORT) (swap (*((USHORT *) sptr_mib_access_parameters->bptr_variable_value)) + 1));
			}
		}

	if (sptr_snmp_table_entry->need_to_swap == TRUE)
		{
		if (sptr_snmp_table_entry->size_of_mib_variable == sizeof (ULONG))
			{
			*((ULONG *) sptr_mib_access_parameters->bptr_variable_value) =
				swap_long (*((ULONG *) sptr_mib_access_parameters->bptr_variable_value));
			}
		else if (sptr_snmp_table_entry->size_of_mib_variable == sizeof (USHORT))
			{
			*((USHORT *) sptr_mib_access_parameters->bptr_variable_value) =
				swap (*((USHORT *) sptr_mib_access_parameters->bptr_variable_value));
			}
		}

	return (PASS);
}
static enum TEST get_next_row_in_mib_table_if_mib_table_is_an_array (void **ptr_to_vptr_row_in_table, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
/*	printf("\r\naddress is = %x\r\n",*(ULONG *)ptr_to_vptr_row_in_table);*/
/*	printf("\r\nmaximum value of index is = %x\r\n", (*(ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[0].vptr_maximum_value_of_index) );*/

			if( (ULONG) *ptr_to_vptr_row_in_table >= ( (ULONG) ((ULONG) sptr_snmp_table_entry->sptr_parameters->vptr_first_row_in_mib_table +
				(ULONG) (sptr_snmp_table_entry->sptr_parameters->size_of_array_element *
				(*(ULONG *) sptr_snmp_table_entry->sptr_parameters->table_indices[0].vptr_maximum_value_of_index - 1) ) ) ) ){
				*ptr_to_vptr_row_in_table = NULL;
				return(FAIL);
			}

			if( *ptr_to_vptr_row_in_table == NULL){
				*ptr_to_vptr_row_in_table = sptr_snmp_table_entry->sptr_parameters->vptr_first_row_in_mib_table; 
				return(PASS);
			}

			*ptr_to_vptr_row_in_table = (void *) ( (ULONG)*ptr_to_vptr_row_in_table + sptr_snmp_table_entry->sptr_parameters->size_of_array_element);

/*	printf("\r\naddress is = %x and the size is = %x \r\n",*(ULONG *)ptr_to_vptr_row_in_table, sptr_snmp_table_entry->sptr_parameters->size_of_array_element);*/

	return(PASS);
}
static enum BOOLEAN junk ( SNMP_TABLE_ENTRY *sptr_snmp_table_entry, void *vptr_mib_table_entry){
/*		printf("\r\nin junk function val is %x\r\n",vptr_mib_table_entry);*/
		return(TRUE);
}
/* Srikar, Mar 19, 1997. Added the following function to get the lexicographically correct entry in the table. */
/* BEGINNING OF ADDED CODE Feb 7, 1997 >>>>>>>>>>>>>> */

extern	void	*get_least_index_row_in_table(SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
extern	void	*get_this_index_row_in_table(SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
extern	void	*get_next_index_row_in_table(SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
extern	int		compare_indices_with_snmp_table_entry(void *vptr_this_entry, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
extern	int		compare_indices_of_two_rows(void *vptr_first, void *vptr_second, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);
extern	void	*get_next_row_in_table(void *vptr_current_entry, SNMP_TABLE_ENTRY *sptr_snmp_table_entry);

static enum TEST find_row_in_mib_table (SNMP_TABLE_ENTRY *sptr_snmp_table_entry,
	MIB_ACCESS_PARAMETERS *sptr_mib_access_parameters,	void **ptr_to_vptr_row_in_table)
{
	enum BOOLEAN received_indices;
	enum BOOLEAN valid_table_indices;
	enum BOOLEAN all_comparison_functions_available;
	enum TEST return_code;
	BYTE number_of_indices;

	valid_table_indices = get_mib_table_indices (sptr_mib_access_parameters->sptr_table_indices,
		sptr_mib_access_parameters->usptr_size_of_table_indices, &received_indices, sptr_snmp_table_entry);

	if (valid_table_indices == FALSE)
		{
		return (FAIL);
		}

	*ptr_to_vptr_row_in_table = NULL;

	/* We need to get the lexicographically correct entry in the table. For that we need the comparison functions for */
	/* all the indices for the given variable. Even if one of them is missing, we shall take the first or the next */
	/* entry in the table. If all the functions are available, then we shall apply the operation to all the entries */
	/* in the table to get at the correct entry. */

	all_comparison_functions_available = TRUE;
	for (number_of_indices = 0; number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
		number_of_indices++)
		{
		if (sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].fptr_compare_indices == NULL)
			{
			all_comparison_functions_available = FALSE;
			break;
			}
		}

	if (all_comparison_functions_available == TRUE || sptr_snmp_table_entry->lexicographic_ordering_needed == TRUE)
		{
		if (received_indices == FALSE)
			{
			*ptr_to_vptr_row_in_table = get_least_index_row_in_table(sptr_snmp_table_entry);
			return (*ptr_to_vptr_row_in_table == NULL ? FAIL : PASS);
			}
		if (sptr_mib_access_parameters->mib_operation == GET_NEXT_OPERATION)
			{
			*ptr_to_vptr_row_in_table = get_next_index_row_in_table(sptr_snmp_table_entry);
			return (*ptr_to_vptr_row_in_table == NULL ? FAIL : PASS);
			}
		*ptr_to_vptr_row_in_table = get_this_index_row_in_table(sptr_snmp_table_entry);
		return (*ptr_to_vptr_row_in_table == NULL ? FAIL : PASS);
		}

	if (received_indices == FALSE)
		{
		/* no indices have been received, so we will be accessing first instance of mib variable */

		*ptr_to_vptr_row_in_table = get_first_row_in_mib_table (sptr_snmp_table_entry);
		return (*ptr_to_vptr_row_in_table == NULL ? FAIL : PASS);
		}
	else
		{
		*ptr_to_vptr_row_in_table = get_first_row_in_mib_table (sptr_snmp_table_entry);
		if (*ptr_to_vptr_row_in_table == NULL)
			{
			return (FAIL);
			}
		if (sptr_snmp_table_entry->sptr_parameters->table_type == MIB_TABLE_AS_A_LINKED_LIST)
			{
			return_code = search_linked_list_for_mib_table_entry_that_matches_the_received_indices (ptr_to_vptr_row_in_table, sptr_snmp_table_entry);
			}
		else if (sptr_snmp_table_entry->sptr_parameters->table_type == MIB_TABLE_AS_AN_ARRAY)
			{
			return_code = PASS;
			while (*ptr_to_vptr_row_in_table != NULL && return_code == PASS)
				{
            /* Srikar, Apr 11, 1997. Added call to dummy function to overcome
            compiler bug */
				dummy(*ptr_to_vptr_row_in_table);
				if (check_if_the_received_indices_match_the_one_for_the_current_row_of_the_mib_table (sptr_snmp_table_entry, *ptr_to_vptr_row_in_table) == TRUE)
					break;
				return_code = get_next_row_in_mib_table_if_mib_table_is_an_array (ptr_to_vptr_row_in_table, sptr_snmp_table_entry);
				}
			}
		if (*ptr_to_vptr_row_in_table == NULL)
			return (FAIL);
		if (return_code == FAIL)
			{
			*ptr_to_vptr_row_in_table = NULL;
			return (FAIL);
			}
		if (sptr_mib_access_parameters->mib_operation == GET_NEXT_OPERATION)
			{
			if (sptr_snmp_table_entry->sptr_parameters->table_type == MIB_TABLE_AS_AN_ARRAY)
				return_code = get_next_row_in_mib_table_if_mib_table_is_an_array (ptr_to_vptr_row_in_table, sptr_snmp_table_entry);
			if (sptr_snmp_table_entry->sptr_parameters->table_type == MIB_TABLE_AS_A_LINKED_LIST)
				return_code = get_next_row_in_mib_table (ptr_to_vptr_row_in_table, sptr_snmp_table_entry);
			}
		}
	return (return_code);
}

void	*get_least_index_row_in_table(SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	void	*vptr_last_found_entry;
	void	*vptr_current_entry;
	void	*vptr_next_entry;

	vptr_last_found_entry = vptr_current_entry = get_first_row_in_mib_table(sptr_snmp_table_entry);
	while (vptr_current_entry)
		{
		vptr_next_entry = get_next_row_in_table(vptr_current_entry, sptr_snmp_table_entry);
		if (vptr_next_entry == NULL)
			break;
		if (compare_indices_of_two_rows(vptr_last_found_entry, vptr_next_entry, sptr_snmp_table_entry) > 0)
			vptr_last_found_entry = vptr_next_entry;
		vptr_current_entry = vptr_next_entry;
		}
	return(vptr_last_found_entry);
}

void	*get_this_index_row_in_table(SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	void	*vptr_last_found_entry;
	void	*vptr_current_entry;
	void	*vptr_next_entry;

	vptr_last_found_entry = NULL;
	vptr_current_entry = get_first_row_in_mib_table(sptr_snmp_table_entry);
	while (vptr_current_entry)
		{
		if (compare_indices_with_snmp_table_entry(vptr_current_entry, sptr_snmp_table_entry) == 0) {
			vptr_last_found_entry = vptr_current_entry;
			break;
		}
		vptr_next_entry = get_next_row_in_table(vptr_current_entry, sptr_snmp_table_entry);
		if (vptr_next_entry == NULL)
			break;
		vptr_current_entry = vptr_next_entry;
		}
	return(vptr_last_found_entry);
}

void	*get_next_index_row_in_table(SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	void	*vptr_last_found_entry;
	void	*vptr_current_entry;
	void	*vptr_next_entry;

	/* vptr_last_entry points to the entry immediately higher than the indices in the snnp table as of now. */

	vptr_last_found_entry = NULL;
	vptr_current_entry = get_first_row_in_mib_table(sptr_snmp_table_entry);
	while (vptr_current_entry)
		{
		if (compare_indices_with_snmp_table_entry(vptr_current_entry, sptr_snmp_table_entry) > 0)
			{
			if (vptr_last_found_entry == NULL)
				{
				vptr_last_found_entry = vptr_current_entry;
				}
			else
				{
				if (compare_indices_of_two_rows(vptr_last_found_entry, vptr_current_entry, sptr_snmp_table_entry) > 0)
					vptr_last_found_entry = vptr_current_entry;
				}
			}
		vptr_next_entry = get_next_row_in_table(vptr_current_entry, sptr_snmp_table_entry);
		if (vptr_next_entry == NULL)
			break;
		vptr_current_entry = vptr_next_entry;
		}
	return(vptr_last_found_entry);
}

/* This function compares the indices in the specified row with the indices saved in the snmp table entry. */

int		compare_indices_with_snmp_table_entry(void *vptr_this_entry, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	TABLE_ENTRY_INDEX	*sptr_table_index_entry;
	void	*vptr_value_1, *vptr_value_2;
	int		return_value;
	long	diff;
	BYTE	number_of_indices;

	return_value = 0;
	for (number_of_indices = 0; return_value == 0 && number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
		number_of_indices++)
		{
		sptr_table_index_entry = &sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices];
		vptr_value_1 = (void *) ((ULONG) vptr_this_entry + sptr_table_index_entry->offset_to_index);
		vptr_value_2 = sptr_table_index_entry->vptr_index_value;
		if (sptr_table_index_entry->fptr_compare_indices)
			{
			diff = (*(sptr_table_index_entry->fptr_compare_indices))(vptr_value_1, vptr_value_2, sptr_snmp_table_entry, number_of_indices);
			}
		else
			{
			if (sptr_table_index_entry->index_type == SNMP_SCALAR_TYPE)
				{
				switch (sptr_table_index_entry->size_of_index)
					{
					case sizeof(BYTE) :
						diff = *((BYTE *) vptr_value_1) - *((BYTE *) vptr_value_2);
						break;
					case sizeof(USHORT) :
						diff = *((USHORT *) vptr_value_1) - *((USHORT *) vptr_value_2);
						break;
					case sizeof(ULONG) :
						diff = *((ULONG *) vptr_value_1) - *((ULONG *) vptr_value_2);
						break;
					}
				}
			else
				{
				diff = memcmp(vptr_value_1, vptr_value_2, sptr_table_index_entry->size_of_index);
				}
			}
			if (diff > 0)
				return_value = 1;
			else if (diff < 0)
				return_value = -1;
		}
	return(return_value);
}

/* This function compares the indices of two rows. */

int		compare_indices_of_two_rows(void *vptr_first, void *vptr_second, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	TABLE_ENTRY_INDEX	*sptr_table_index_entry;
	void	*vptr_value_1, *vptr_value_2;
	ULONG	offset;
	int		return_value;
	long	diff;
	BYTE	number_of_indices;

	return_value = 0;
	for (number_of_indices = 0; return_value == 0 && number_of_indices < sptr_snmp_table_entry->sptr_parameters->number_of_indices;
		number_of_indices++)
		{
		sptr_table_index_entry = &sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices];
		offset = sptr_snmp_table_entry->sptr_parameters->table_indices[number_of_indices].offset_to_index;
		vptr_value_1 = (void *) ((ULONG) vptr_first + offset);
		vptr_value_2 = (void *) ((ULONG) vptr_second + offset);
		if (sptr_table_index_entry->fptr_compare_indices)
			{
			diff = (*(sptr_table_index_entry->fptr_compare_indices))(vptr_value_1, vptr_value_2, sptr_snmp_table_entry, number_of_indices);
			}
		else
			{
			if (sptr_table_index_entry->index_type == SNMP_SCALAR_TYPE)
				{
				switch (sptr_table_index_entry->size_of_index)
					{
					case sizeof(BYTE) :
						diff = *((BYTE *) vptr_value_1) - *((BYTE *) vptr_value_2);
						break;
					case sizeof(USHORT) :
						diff = *((USHORT *) vptr_value_1) - *((USHORT *) vptr_value_2);
						break;
					case sizeof(ULONG) :
						diff = *((ULONG *) vptr_value_1) - *((ULONG *) vptr_value_2);
						break;
					}
				}
			else
				{
				diff = memcmp(vptr_value_1, vptr_value_2, sptr_table_index_entry->size_of_index);
				}
			}
			if (diff > 0)
				return_value = 1;
			else if (diff < 0)
				return_value = -1;
		}
	return(return_value);
}
/* The following function gets the pointer to the next row in the mib table. */

void	*get_next_row_in_table(void *vptr_current_entry, SNMP_TABLE_ENTRY *sptr_snmp_table_entry)
{
	void	*vptr_next_entry;
	enum	TEST return_code;

	vptr_next_entry = vptr_current_entry;
	switch (sptr_snmp_table_entry->sptr_parameters->table_type)
		{
		case MIB_TABLE_AS_AN_ARRAY :
			return_code = get_next_row_in_mib_table_if_mib_table_is_an_array(&vptr_next_entry, sptr_snmp_table_entry);
			break;
		case MIB_TABLE_AS_AN_ARRAY_OF_LINKED_LISTS:
			return_code = find_pointer_to_row_when_mib_table_is_an_array_of_linked_lists (&vptr_next_entry,
				sptr_snmp_table_entry);
			break;
		case MIB_TABLE_AS_A_LINKED_LIST:
			return_code = find_pointer_to_row_when_mib_table_is_a_linked_list (&vptr_next_entry);
			break;
		default:
			return_code = FAIL;
			break;
		}
	if (return_code == PASS)
		return(vptr_next_entry);
	return(NULL);
}
/* END OF ADDED CODE Mar 19, 1997 >>>>>>>>>>>>>> */

/* Srikar, Apr 11, 1997. Added a function definition */
void dummy(void *p)
{
}
