#include	"defs.h"
/*	$Modname: sockinit.c$  $version: 1.8$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 11/04/94 titus Cosmetic changes for c++ compilation.
1.4 11/15/94 titus Changed the class name sock to socket_class etc.
1.5 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.6 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.7 04/06/95 titus Changes for dynamic loading
1.8 04/06/95 titus Changes for lint
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#define GLOBAL_FILE
#include <stdlib.h>
#include <string.h>
#include "socket.h"
#include "vsockstc.h"

#ifndef __LSL__
	#include "vsocklnk.h"
#endif /* __LSL__ */
/*********************************************************************************************/
#ifdef __LSL__
	static enum TEST initialize_transport_interface (enum ISO_LAYER_TYPE iso_layer_type, ULONG protocol,
		char *cptr_printf_string);
	static enum TEST initialize_interface_for_transports (enum ISO_LAYER_TYPE iso_layer_type, ULONG protocol,
		char *cptr_printf_string);
	static enum TEST initialize_interface_for_protocol_stacks (enum ISO_LAYER_TYPE iso_layer_type, ULONG protocol,
		char *cptr_printf_string);
#endif /* __LSL__ */
/*********************************************************************************************/
enum TEST initialize_socket (ULONG clock_ticks_per_second)
{
	PARAMETER_NOT_USED (clock_ticks_per_second);

	if (socket_class.enabled == TRUE)
		{
		#ifdef __LSL__
   
		/* register socket as an application with lsl */

			if (socket_class.blocking_enabled == FALSE)
				{
				if ((enum TEST) lsl_control (REGISTER_APPLICATION, "Sockets Interface", SOCKETS_INTERFACE, socket_timer,
					socket_configuration, &socket_class.application_id) == FAIL)
					{
					return (FAIL);
					}
				}
			else
				{
				if ((enum TEST) lsl_control (REGISTER_APPLICATION, "Sockets Interface", SOCKETS_INTERFACE, (void (*) (void)) NULL,
					socket_configuration, &socket_class.application_id) == FAIL)
					{
					return (FAIL);
					}

				if ((enum TEST) lsl_control (INITIALIZE_LSL_FUNCTION_POINTERS, SOCKETS_INTERFACE,
					&socket_class.fptr_poll_for_packet_received,	&socket_class.fptr_polling_timer_interrupt) == FAIL)
					{
					return (FAIL);
					}
				}

			initialize_transport_interface (TRANSPORT_LAYER_TYPE, (ULONG) TCP_TRANSPORT,
				"Error in initializing tcp socket interface\n");

			initialize_transport_interface (NETWORK_LAYER_TYPE, (ULONG) IP_PROTOCOL_STACK,
				"Error in initializing udp socket interface\n");

			initialize_transport_interface (NETWORK_LAYER_TYPE, (ULONG) IPX_PROTOCOL_STACK,
				"Error in initializing ipx socket interface\n");

			initialize_transport_interface (TRANSPORT_LAYER_TYPE, (ULONG) SPX_TRANSPORT,
				"Error in initializing spx socket interface\n");

			initialize_transport_interface (NETWORK_LAYER_TYPE, (ULONG) CONSOLE_PROTOCOL_STACK,
				"Error in initializing console socket interface\n");

		#else

			socket_class.transport_interface_list->sptr_forward_link = &socket_transport_interface_array[0];

			/*
			 *	if blocking is enabled then socket layer has to register with some other layer so that the timer is called
			 * periodically.
			 */

		#endif /* __LSL__ */

		if ((enum TEST) lsl_control (RESOLVE_FUNCTION_POINTERS, (ULONG) TRANSPORT_LAYER_TYPE,
			(ULONG) INITIALIZE_TRANSPORT_FUNCTION_POINTERS,	(ULONG) TCP_TRANSPORT,	NULL)	== FAIL)
			{
			return (FAIL);
			}

		if ((enum TEST) lsl_control (RESOLVE_FUNCTION_POINTERS, NETWORK_LAYER_TYPE, (ULONG) INITIALIZE_PROTOCOL_FUNCTION_POINTERS,
			IP_PROTOCOL_STACK, NULL) == FAIL)
			{
			return (FAIL);
			}

/*
		if ((enum TEST) lsl_control (RESOLVE_FUNCTION_POINTERS, NETWORK_LAYER_TYPE, (ULONG) INITIALIZE_PROTOCOL_FUNCTION_POINTERS,
			IPX_PROTOCOL_STACK, NULL) == FAIL)
			{
			return (FAIL);
			}

		if ((enum TEST) lsl_control (RESOLVE_FUNCTION_POINTERS, TRANSPORT_LAYER_TYPE,
			(ULONG) INITIALIZE_TRANSPORT_FUNCTION_POINTERS,	SPX_TRANSPORT,	NULL)	== PASS)
			{
			return (FAIL);
			}
*/
		socket_class.number_of_already_allocated_ports = START_OF_USER_PORT_NUMBERS;

	}

	return (PASS);
}

#ifdef __LSL__
/*********************************************************************************************/
static enum TEST initialize_transport_interface (enum ISO_LAYER_TYPE iso_layer_type, ULONG protocol, char *cptr_printf_string)
{
	if (iso_layer_type == TRANSPORT_LAYER_TYPE)
		{
		initialize_interface_for_transports (iso_layer_type, protocol, cptr_printf_string);
		}
	else if (iso_layer_type == NETWORK_LAYER_TYPE)
		{
		initialize_interface_for_protocol_stacks (iso_layer_type, protocol, cptr_printf_string);
		}

	return (FAIL);
}
/*********************************************************************************************/
static enum TEST initialize_interface_for_transports (enum ISO_LAYER_TYPE iso_layer_type, ULONG protocol,
	char *cptr_printf_string)
{
	enum BOOLEAN protocol_enabled;

	TRANSPORT_INTERFACE *sptr_transport_interface;

	protocol_enabled = FALSE;

	if ((enum TEST) lsl_control (RESOLVE_SOCKET_API, iso_layer_type, (ULONG) IS_TRANSPORT_ENABLED, protocol,
		(ULONG) &protocol_enabled)	== PASS)
		{
		if (protocol_enabled == TRUE)
			{
			sptr_transport_interface = (TRANSPORT_INTERFACE *) table_malloc (1, sizeof (TRANSPORT_INTERFACE));

			if (sptr_transport_interface == NULL)
				{
				socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: initialize_interface_for_transports (): table_malloc failed\n");

				return (FAIL);
				}

			if ((enum TEST) lsl_control (RESOLVE_SOCKET_API, iso_layer_type, (ULONG) INITIALIZE_SOCKET_TRANSPORT_INTERFACE,
				protocol, (ULONG) sptr_transport_interface) == PASS)
				{
				add_entry_to_list ((LINK *) &socket_class.transport_interface_list, (LINK *) sptr_transport_interface);

				if (protocol == (ULONG) TCP_TRANSPORT)
					{
					sptr_transport_interface->socket_type_of_service = TYPE_TCP;
					sptr_transport_interface->accept = TRUE;
					sptr_transport_interface->end_of_line = (char *) inet_end_of_line;
					sptr_transport_interface->error = &cptr_socket_error_list[0];
					}
				else if (protocol == (ULONG) SPX_TRANSPORT)
					{
					sptr_transport_interface->socket_type_of_service = TYPE_SPX;
					sptr_transport_interface->accept = TRUE;
					sptr_transport_interface->end_of_line = (char *) netware_end_of_line;
					sptr_transport_interface->error = &cptr_socket_error_list[0];
					}

				return (PASS);
				}
			else
				{
				socket_printf (SOCKET_INIT_PRINTF, "SOCKET: %s\n", cptr_printf_string);

				table_free ((void *) sptr_transport_interface);
				}
			}
		}

	return (PASS);
}
/*********************************************************************************************/
static enum TEST initialize_interface_for_protocol_stacks (enum ISO_LAYER_TYPE iso_layer_type, ULONG protocol,
	char *cptr_printf_string)
{
#ifdef RTRERROR
	enum BOOLEAN protocol_enabled;
#endif

	BYTE_ENUM	(BOOLEAN) protocol_enabled;
	TRANSPORT_INTERFACE *sptr_transport_interface;

	protocol_enabled = FALSE;

	if ((enum TEST) lsl_control (RESOLVE_SOCKET_API, iso_layer_type, (ULONG) IS_PROTOCOL_STACK_ENABLED, protocol,
		(ULONG) &protocol_enabled)	== PASS)
		{
		if (protocol_enabled == TRUE)
			{
			sptr_transport_interface = (TRANSPORT_INTERFACE *) table_malloc (1, sizeof (TRANSPORT_INTERFACE));

			if (sptr_transport_interface == NULL)
				{
				socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: initialize_interface_for_protocol_stacks (): table_malloc failed\n");

				return (FAIL);
				}

			if ((enum TEST) lsl_control (RESOLVE_SOCKET_API, iso_layer_type, (ULONG) INITIALIZE_SOCKET_PROTOCOL_STACK_INTERFACE,
				protocol, (ULONG) sptr_transport_interface) == PASS)
				{
				add_entry_to_list ((LINK *) &socket_class.transport_interface_list, (LINK *) sptr_transport_interface);

				if (protocol == (ULONG) IP_PROTOCOL_STACK)
					{
					sptr_transport_interface->socket_type_of_service = TYPE_UDP;
					sptr_transport_interface->end_of_line = (char *) inet_end_of_line;
					}
				else if (protocol == (ULONG) IPX_PROTOCOL_STACK)
					{
					sptr_transport_interface->socket_type_of_service = TYPE_IPX;
					sptr_transport_interface->end_of_line = (char *) netware_end_of_line;
					}
				else if (protocol == (ULONG) CONSOLE_PROTOCOL_STACK)
					{
					sptr_transport_interface->socket_type_of_service = TYPE_CONSOLE;
					sptr_transport_interface->end_of_line = (char *) inet_end_of_line;
					}

				return (PASS);
				}
			else
				{
				socket_printf (SOCKET_INIT_PRINTF, "SOCKET: %s\n", cptr_printf_string);

				table_free ((void *) sptr_transport_interface);
				}
			}
		}

	return (PASS);
}
#endif /* __LSL__ */
/*********************************************************************************************/
void set_socket_class_to_zero (void)
{
	memset ((void *) &socket_class, sizeof (SOCKET_CLASS), 0x00);
}

