#include	"defs.h"
/*	$Modname: sockoapi.c$  $version: 1.7$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 11/04/94 titus Initial Release. Broke up sockapi.c into socklapi.c and sockoapi.c .
1.1 11/04/94 titus Cosmetic changes to adhere to codestyle.
1.2 11/10/94 titus Cosmetic changes for c++ compilation.
1.3 11/15/94 titus Utilization of links for list manipulation and ULONG socket_descriptors.
1.4 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.5 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.6 02/06/95 titus Modified function closesocket () and deleted net_to_host () and host_to_net ()
1.7 04/06/95 titus Changes for dynamic loading
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#include <stdlib.h>
#include "socket.h"
/*********************************************************************************************/
/*
 * Post a listen on a socket
 */
int listen (int socket_descriptor, int mode)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	if (sptr_user_socket->vptr_protocol_control_block != NULL)
		{
		socket_class.error_number = IS_CONNECTED_ERROR;

		return (FAILED);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Fail if listen routine isn't present */

	if ((sptr_transport_interface->listen == NULL) ||
		((*sptr_transport_interface->listen) (sptr_user_socket, (USHORT) mode) == FAIL))
		{
		socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

		return (FAILED);
		}

	return (DONE);
}
/****************************************************************************************/
/*
 * Receive routine, intended for connection-oriented sockets. Can be used with datagram sockets, although the
 * sender id is lost. flags are unused; will be used eventually to select oob data, etc
 */
int recv (int socket_descriptor, char *cptr_data, int length, int flags)
{
	USHORT count;
	enum TEST error;
	int return_value;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	if (length == 0x00000000L)
		{
		/* Otherwise would be interp as "all" */

		return (DONE);
		}

	if ((length < 0x00000000L) && (length > 0x0000ffffL))
		{
		socket_class.error_number = BAD_LENGTH;

		return (FAILED);
		}

	error = PASS;

	count = socket_receive_data ((ULONG) socket_descriptor, (void *) cptr_data, (USHORT) length, (ULONG) flags, NULL, NULL,
		&error);

	if (error == FAIL)
		{
		return (FAILED);
		}

	return_value = (int) count;

	return (return_value);
}
/****************************************************************************************/
/*
 * High level send routine
 */
int send (int socket_descriptor, char *cptr_data, int length, int flags)
{
	SOCKADDR sockaddr;
	int return_value;
	USHORT sockaddr_length;
	enum TEST error;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	if ((length <= 0x00000000L) || (length > 0x0000ffffL))
		{
		socket_class.error_number = BAD_LENGTH;

		return (FAILED);
		}

	sockaddr_length = sizeof (SOCKADDR);

	if (get_peer_address ((ULONG) socket_descriptor, &sockaddr, &sockaddr_length) == FAIL)
		{
		socket_class.error_number = BAD_DATA;

		return (FAILED);
		}

	error = PASS;

	return_value = (int) socket_send_data ((ULONG) socket_descriptor, (void *) cptr_data, (USHORT) length, (ULONG) flags,
		&sockaddr, sockaddr_length, &error);

	if (error == FAIL)
		{
		return (FAILED);
		}

	return (return_value);
}
/*********************************************************************************************/
/*
 * Close down a socket three ways. Type 0 means "no more receives"; this replaces the incoming data upcall with a routine that
 * discards further data. Type 1 means "no more sends", and obviously corresponds to sending a TCP FIN. Type 2 means "no more
 * receives or sends". This is interpreted as "abort the connection".
 */
int shutdown (int socket_descriptor, int direction)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	if (sptr_user_socket->vptr_protocol_control_block == NULL)
		{
		socket_class.error_number = NOT_CONNECTED_ERROR;

		return (FAILED);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Just close the socket if special shutdown routine not present */

	if (sptr_transport_interface->shut == NULL)
		{
		closesocket (socket_descriptor);
		}
	else if ((*sptr_transport_interface->shut) (sptr_user_socket, (USHORT) direction) == FAIL)
		{
		return (FAILED);
		}

/*	--socket_class.current_number_of_sockets;*/

	return (DONE);
}
/*********************************************************************************************/
/*
 * Close a socket, freeing it for reuse. Try to do a graceful close on a TCP socket, if possible
 */
int closesocket (int socket_descriptor)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;
	enum TEST result;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	--sptr_user_socket->reference_count;

	if (sptr_user_socket->reference_count > 0x0000)
		{
		/* Others are still using it */

		return (DONE);
		}

	/* Call proto-specific close routine if there is one */

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	if ((sptr_transport_interface != NULL) && (sptr_transport_interface->close != NULL))
		{
		result = (*sptr_transport_interface->close) (sptr_user_socket);
		}
	else
		{
		result = PASS;
		}

	if (result == PASS)
		{
		if (sptr_user_socket->vptr_address != NULL)
			{
			table_free (sptr_user_socket->vptr_address);
			}

		if (sptr_user_socket->vptr_peer_address != NULL)
			{
			table_free (sptr_user_socket->vptr_peer_address);
			}

		delete_entry_from_list ((LINK *) &socket_class.user_socket_list, (LINK *) sptr_user_socket);

		table_free ((void *) sptr_user_socket);

		--socket_class.current_number_of_sockets;

		return (DONE);
		}

	return (FAILED);
}
/*********************************************************************************************/
int getpeername (int socket_descriptor, SOCKADDR *sptr_sockaddr, int *iptr_sockaddr_length)
{
	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	if ((USHORT) *iptr_sockaddr_length < sizeof (SOCKADDR))
		{
		socket_class.error_number = BAD_DATA;

		return (FAILED);
		}

	if (get_peer_address ((ULONG) socket_descriptor, sptr_sockaddr, (USHORT *) iptr_sockaddr_length) == FAIL)
		{
		socket_class.error_number = BAD_DATA;

		return (FAILED);
		}

	return (DONE);
}
/*************************************************************************/
int associate_application_with_socket (int socket_descriptor, ULONG application_id)
{
	USER_SOCKET *sptr_user_socket;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	sptr_user_socket->application_id = application_id;

	return (DONE); 
}

#ifndef __LSL__
/*************************************************************************/
int register_application_to_socket_interface (ULONG application_id,
	void (*fptr_application_entry_point) (enum SOCKET_EVENT socket_event_occured))
{
	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	if (socket_class.number_of_user_applications < MAXIMUM_NUMBER_OF_SOCKET_USER_APPLICATIONS)
		{
		socket_class.socket_user_applications[socket_class.number_of_user_applications].application_id = application_id;

			socket_class.socket_user_applications[socket_class.number_of_user_applications].socket_event_waited_on = NULL_EVENT;

		socket_class.socket_user_applications[socket_class.number_of_user_applications].socket_event_occured = NULL_EVENT;

		socket_class.socket_user_applications[socket_class.number_of_user_applications].fptr_application_entry_point =
			fptr_application_entry_point;

		++socket_class.number_of_user_applications;
		}
	else
		{
		socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: Can not register user application %u\n", application_id);

		return (FAILED);
		}

	return (DONE);
}
#endif /* __LSL__ */
