#include	"defs.h"
/*	$Modname: socksubr.c$  $version: 1.5$      $date: 01/26/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 11/04/94 titus Cosmetic changes for c++ compilation.
1.4 11/15/94 titus Utilization of links for list manipulation and ULONG socket_descriptors.
1.5 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "socket.h"
/*********************************************************************************************/
/*
 * Low-level receive routine. Passes data back to user; Datagram sockets ignore the length parameter.
 */
USHORT socket_receive_data (ULONG socket_descriptor, void *vptr_data, USHORT length, ULONG flags, SOCKADDR *sptr_sockaddr,
	USHORT *usptr_sockaddr_length, enum TEST *eptr_error)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;
	USHORT number_of_bytes;

	PARAMETER_NOT_USED (flags);

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		*eptr_error = FAIL;

		return (0x0000);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Fail if recv routine isn't present */

	if (sptr_transport_interface->receive == NULL)
		{
		socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

		*eptr_error = FAIL;

		return (0x0000);
		}

	number_of_bytes = (*sptr_transport_interface->receive) (sptr_user_socket, vptr_data, length, sptr_sockaddr,
		usptr_sockaddr_length, eptr_error);

	return (number_of_bytes);
}
/*********************************************************************************************/
/*
 * Low level send routine; The "to" and "tolen" parameters are ignored on connection-oriented sockets.
 * In case of error, bp is freed so the caller doesn't have to worry about it.
 */
USHORT socket_send_data (ULONG socket_descriptor, void *vptr_data, USHORT length, ULONG flags, SOCKADDR *sptr_sockaddr,
	USHORT sockaddr_length, enum TEST *eptr_error)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;
	USHORT count;

	/*	The socket_send_data routine is expected to free the buffer we pass it even if it fails to send */

	PARAMETER_NOT_USED (flags);

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		table_free ((void *) vptr_data); 

		*eptr_error = FAIL;

		return (0x0000);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Fail if send routine isn't present (shouldn't happen) */

	if (sptr_transport_interface->send == NULL)
		{
		socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

		table_free ((void *) vptr_data);

		*eptr_error = FAIL;

		return (0x0000);
		}

	/* If remote address is supplied, check it */

	if (((sptr_sockaddr != NULL) && (sockaddr_length != 0x00000000L)) && (sptr_transport_interface->check !=
		NULL) && ((*sptr_transport_interface->check) (sptr_sockaddr, sockaddr_length) == FAIL))
		{
		socket_class.error_number = ADDRESS_FAMILY_NOT_SUPPORTED_ERROR;

		table_free ((void *) vptr_data);

		*eptr_error = FAIL;

		return (0x0000);
		}

	/*	The proto send routine is expected to free the buffer we pass it even if the send fails */

	count = (*sptr_transport_interface->send) (sptr_user_socket, vptr_data, length, sptr_sockaddr, eptr_error);

	return (count);
}
/*********************************************************************************************/
/*
 * Return local name passed in an earlier bind () call
 */
enum TEST get_socket_address (ULONG socket_descriptor, SOCKADDR *sptr_sockaddr, USHORT *usptr_sockaddr_length)
{
	USER_SOCKET *sptr_user_socket;

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAIL);
		}

	if ((sptr_sockaddr == NULL) || (usptr_sockaddr_length == NULL))
		{
		socket_class.error_number = NULL_SOCKET_ADDRESS;

		return (FAIL);
		}

	if (sptr_user_socket->vptr_address == NULL)
		{
		/* Not bound yet */

		*usptr_sockaddr_length = 0x0000;

		socket_class.error_number = NOT_BOUND_TO_ADDRESS;

		return (FAIL);
		}

	if (sptr_user_socket->address_length < *usptr_sockaddr_length)
		{
		*usptr_sockaddr_length = sptr_user_socket->address_length;
		}

	memcpy ((void *) sptr_sockaddr, (void *) sptr_user_socket->vptr_address, *usptr_sockaddr_length);

	return (PASS);
}
/*********************************************************************************************/
/*
 * Get remote name, returning result of earlier connect () call.
 */
enum TEST get_peer_address (ULONG socket_descriptor, SOCKADDR *sptr_sockaddr, USHORT *usptr_sockaddr_length)
{
	USER_SOCKET *sptr_user_socket;

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAIL);
		}

	if (sptr_user_socket->vptr_peer_address == NULL)
		{
		socket_class.error_number = NOT_CONNECTED_ERROR;

		return (FAIL);
		}

	if ((sptr_sockaddr == NULL) || (usptr_sockaddr_length == NULL))
		{
		socket_class.error_number = NULL_PEER_ADDRESS;

		return (FAIL);
		}

	if (sptr_user_socket->peer_address_length < *usptr_sockaddr_length)
		{
		*usptr_sockaddr_length = sptr_user_socket->peer_address_length;
		}

	memcpy ((void *) sptr_sockaddr, (void *) sptr_user_socket->vptr_peer_address, *usptr_sockaddr_length);

	return (PASS);
}
/*********************************************************************************************/
/*
 * Return length of protocol queue, either send or receive.
 */
USHORT get_queue_length_for_socket (ULONG socket_descriptor, USHORT queue_type, enum TEST *eptr_error)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;
	USHORT length;

 	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		*eptr_error = FAIL;

		return (0x0000);
		}

	if (sptr_user_socket->vptr_protocol_control_block == NULL)
		{
		socket_class.error_number = NOT_CONNECTED_ERROR;

		*eptr_error = FAIL;

		return (0x0000);
		}

	if ((queue_type != RECEIVE_QUEUE) || (queue_type != SEND_QUEUE))
		{
		socket_class.error_number = BAD_DATA;

		*eptr_error = FAIL;

		return (0x0000);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Fail if queue_length routine isn't present */

	if ((sptr_transport_interface->queue_length != NULL))
		{
		length = (*sptr_transport_interface->queue_length) (sptr_user_socket, queue_type, eptr_error);

		if (*eptr_error == FAIL)
			{
			return (0x0000);
			}

		return (length);
		}

	socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

	*eptr_error = FAIL;

	return (0x0000);
}
/*********************************************************************************************/
/*
 * Force retransmission. Valid only for connection-oriented sockets.
 */
enum TEST socket_kick (ULONG socket_descriptor)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAIL);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Fail if kick routine isn't present */

	if (sptr_transport_interface->kick == NULL)
		{
		socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

		return (FAIL);
		}

 	if ((*sptr_transport_interface->kick) (sptr_user_socket) == FAIL)
		{
		return (FAIL);
		}

	return (PASS);
}
/*********************************************************************************************/
/*
 * Increment reference count for specified socket
 */
enum TEST increment_reference_count_of_socket (ULONG socket_descriptor)
{
	USER_SOCKET *sptr_user_socket;

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAIL);
		}

	++sptr_user_socket->reference_count;

	return (PASS);
}
/*********************************************************************************************/
/*
 * Set Internet type-of-service to be used
 */
enum TEST set_type_of_service (ULONG socket_descriptor, ULONG type_of_service)
{
	USER_SOCKET *sptr_user_socket;

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAIL);
		}

	sptr_user_socket->internet_type_of_service = (BYTE) type_of_service;

	return (PASS);
}
/*********************************************************************************************/
/*
 * Return end-of-line convention for socket
 */
char *end_of_line_seq (ULONG socket_descriptor)
{
	char *cptr_end_of_line;
	USER_SOCKET *sptr_user_socket;

	cptr_end_of_line = (char *) NULL;

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (cptr_end_of_line);
		}

	cptr_end_of_line = sptr_user_socket->sptr_transport_interface->end_of_line;

	return (cptr_end_of_line);
}

