#include	"defs.h"
/*	$Modname: tsockipx.c$  $version: 1.8$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 10/12/94 titus Minute changes in function receive_tsockipx_reply etc.
1.4 11/04/94 titus Cosmetic changes for c++ compilation.
1.5 11/15/94 titus Changed tsock to test_socket_ and included rwarebuf.h etc.
1.6 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.7 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.8 04/06/95 titus Changes for dynamic loading
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#ifdef __SOCKET_TEST_APPS__
#define GLOBAL_FILE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include <v8022str.h>
#include <lslproto.h>
#include "socklib.h"
#include "ktstsipx.h"
#include "vtsistr.h"
#include <rwarebuf.h>
/****************************************************************************/
char *cptr_test_socket_ipx_static_messages[] =
{
	"HELLO THERE! STATION 6\0",
	"HELLO STATION 6\0",
	"HELLO THERE! STATION 2\0",
	"HELLO STATION 2\0"
};

TEST_SOCKET_IPX_CLASS test_socket_ipx;
/****************************************************************************/
enum TEST initialize_test_socket_ipx (ULONG clock_ticks_per_second);
void test_socket_ipx_application_entry_point (void);
/****************************************************************************/
static enum TEST initialize_test_socket_ipx_socket_interface (void);
static enum TEST issue_test_socket_ipx_message (void);
static enum TEST receive_test_socket_ipx_reply (void);
static void test_socket_ipx_timer (void);
/****************************************************************************/
enum TEST initialize_test_socket_ipx (ULONG clock_ticks_per_second)
{
	if (test_socket_ipx.enabled == TRUE)
		{
		test_socket_ipx.clock_ticks_per_second = clock_ticks_per_second;

		if ((enum TEST) lsl_control (REGISTER_APPLICATION,"Test Socket IPX Application", TEST_SOCKET_IPX_APPLICATION,
			test_socket_ipx_application_entry_point,
			(enum TEST (*) (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)) NULL,
			&test_socket_ipx.application_id) ==  FAIL)
			{
			socket_printf (SOCKET_INIT_PRINTF,
				"TEST_SOCKET_IPX: register_application () failed to register Test Socket IPX with lsl\n");

			return (FAIL);
			}
		}

	return (PASS);
 }
/****************************************************************************/
void test_socket_ipx_application_entry_point (void)
{
	if (test_socket_ipx.enabled == TRUE)
		{
		if (test_socket_ipx.socket_interface_initialized == FALSE)
			{
			if (initialize_test_socket_ipx_socket_interface () == FAIL)
				{
				socket_printf (SOCKET_INIT_PRINTF, "TEST_SOCKET_IPX: failed to initialize test_socket_ipx socket interface\n");
				}
			else if (issue_test_socket_ipx_message () == FAIL)
				{
				socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_IPX: issue_test_socket_ipx_message failed\n");
				}
			}
		else
			{
			if (receive_test_socket_ipx_reply () == FAIL)
				{
				socket_printf (SOCKET_BLOCK_PRINTF, "TEST_SOCKET_IPX: receive_test_socket_ipx_reply failed\n");
				}
			}

		test_socket_ipx_timer ();
		}
}
/****************************************************************************/
static enum TEST initialize_test_socket_ipx_socket_interface (void)
{
	int bind_return_value;
	SOCKADDR_IPX local_read_sockaddr_ipx;

	local_read_sockaddr_ipx.family = AF_NETWARE;
	local_read_sockaddr_ipx.port = TEST_SOCKET_IPX_PORT;

	memcpy ((void *) &local_read_sockaddr_ipx.ipx_address[0], (void *) &test_socket_ipx.local_network_address, sizeof (ULONG));

	memcpy ((void *) ((ULONG) &local_read_sockaddr_ipx.ipx_address[0] + sizeof (ULONG)),
		(void *) &test_socket_ipx.local_node_address[0], SIZEOF_NODE_ADDRESS);

	test_socket_ipx.socket_descriptor = socket (AF_NETWARE, SOCK_DGRAM, 0x00000000L);

	if (test_socket_ipx.socket_descriptor == FAILED)
		{
		return (FAIL);
		}

	associate_application_with_socket (test_socket_ipx.socket_descriptor, test_socket_ipx.application_id);

	bind_return_value = bind (test_socket_ipx.socket_descriptor, (SOCKADDR *) &local_read_sockaddr_ipx,
		sizeof (SOCKADDR_IPX));

	if (bind_return_value == FAILED)
		{
		return (FAIL);
		}

	test_socket_ipx.socket_interface_initialized = TRUE;

	return (PASS);
}
/****************************************************************************/
static enum TEST issue_test_socket_ipx_message (void)
{
	char *cptr_test_socket_ipx_message_to_be_send;
	SOCKADDR_IPX remote_sockaddr_ipx;

	cptr_test_socket_ipx_message_to_be_send = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_IPX_MESSAGE);

	if (cptr_test_socket_ipx_message_to_be_send == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_IPX: issue_test_socket_ipx_message (): table_malloc failed\n");

		return (FAIL);
		}

	remote_sockaddr_ipx.family = AF_NETWARE;
	remote_sockaddr_ipx.port = TEST_SOCKET_IPX_PORT;

	memcpy ((void *) &remote_sockaddr_ipx.ipx_address[0], (void *) &test_socket_ipx.remote_network_address, sizeof (ULONG));

	memcpy ((void *) ((ULONG) &remote_sockaddr_ipx.ipx_address[0] + sizeof (ULONG)),
		(void *) &test_socket_ipx.remote_node_address[0], SIZEOF_NODE_ADDRESS);

	memcpy ((void *) cptr_test_socket_ipx_message_to_be_send,
		(void *) cptr_test_socket_ipx_static_messages[2*test_socket_ipx.station_number], SIZEOF_TEST_SOCKET_IPX_MESSAGE);

	if (sendto (test_socket_ipx.socket_descriptor, cptr_test_socket_ipx_message_to_be_send, SIZEOF_TEST_SOCKET_IPX_MESSAGE,
		0x00000000L, (SOCKADDR *) &remote_sockaddr_ipx, sizeof (SOCKADDR_IPX)) != FAILED)
		{
		socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_IPX: sent message : %s\n", cptr_test_socket_ipx_message_to_be_send);

		socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_IPX: sent %u number of bytes\n", SIZEOF_TEST_SOCKET_IPX_MESSAGE);

		table_free ((void *) cptr_test_socket_ipx_message_to_be_send);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST receive_test_socket_ipx_reply (void)
{
	char *cptr_test_socket_ipx_message_received;
	char *cptr_test_socket_ipx_message_to_be_send;
	int number_of_bytes_received;
	SOCKADDR_IPX remote_sockaddr_ipx;

	cptr_test_socket_ipx_message_received = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_IPX_MESSAGE);

	if (cptr_test_socket_ipx_message_received == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_IPX: receive_test_socket_ipx_reply (): table_malloc failed\n");

		return (FAIL);
		}

	number_of_bytes_received = recv (test_socket_ipx.socket_descriptor, cptr_test_socket_ipx_message_received,
		SIZEOF_TEST_SOCKET_IPX_MESSAGE, 0x00000000L);

	if (((short) number_of_bytes_received) <= 0x0000)
		{
		table_free ((void *) cptr_test_socket_ipx_message_received);

		return (FAIL);
		}

	socket_printf (SOCKET_RX_PRINTF, "TEST_SOCKET_IPX: received message:%d: %s\n", number_of_bytes_received,
		cptr_test_socket_ipx_message_received);

	if (((test_socket_ipx.station_number == 0x00) &&
		(strcmp (cptr_test_socket_ipx_message_received,
		cptr_test_socket_ipx_static_messages[2*(test_socket_ipx.station_number + 1)]) == 0)) ||
		((test_socket_ipx.station_number == 0x01) &&
		(strcmp (cptr_test_socket_ipx_message_received,
		cptr_test_socket_ipx_static_messages[2*(test_socket_ipx.station_number - 1)]) == 0)))
		{
		cptr_test_socket_ipx_message_to_be_send = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_IPX_MESSAGE);

		if (cptr_test_socket_ipx_message_to_be_send == NULL)
			{
			socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_IPX: receive_test_socket_ipx_reply (): table_malloc failed\n");

			table_free ((void *) cptr_test_socket_ipx_message_received);

			return (FAIL);
			}

		remote_sockaddr_ipx.family = AF_NETWARE;
		remote_sockaddr_ipx.port = TEST_SOCKET_IPX_PORT;

		memcpy ((void *) &remote_sockaddr_ipx.ipx_address[0], (void *) &test_socket_ipx.remote_network_address, sizeof (ULONG));

		memcpy ((void *) ((ULONG) &remote_sockaddr_ipx.ipx_address[0] + sizeof (ULONG)),
			(void *) &test_socket_ipx.remote_node_address[0], SIZEOF_NODE_ADDRESS);

		memcpy ((void *) cptr_test_socket_ipx_message_to_be_send,
			(void *) cptr_test_socket_ipx_static_messages[2*test_socket_ipx.station_number + 1], SIZEOF_TEST_SOCKET_IPX_MESSAGE);

		if (sendto (test_socket_ipx.socket_descriptor, cptr_test_socket_ipx_message_to_be_send, SIZEOF_TEST_SOCKET_IPX_MESSAGE,
			0x00000000L, (SOCKADDR *) &remote_sockaddr_ipx, sizeof (SOCKADDR_IPX)) != FAILED)
			{
			socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_IPX: sent message : %s\n", cptr_test_socket_ipx_message_to_be_send);

			table_free ((void *) cptr_test_socket_ipx_message_to_be_send);
			}
		}

	table_free ((void *) cptr_test_socket_ipx_message_received);

	return (PASS);
}
/****************************************************************************/
static void test_socket_ipx_timer (void)
{
	if (test_socket_ipx.timer_enabled == FALSE)
		{
		return;
		}

	++test_socket_ipx.tick_counter;

	if (test_socket_ipx.tick_counter >= test_socket_ipx.clock_ticks_per_second)
		{
		test_socket_ipx.tick_counter = 0x00000000L;

		++test_socket_ipx.current_seconds;

		if (test_socket_ipx.current_seconds > test_socket_ipx.seconds_between_retransmission)
			{
			test_socket_ipx.current_seconds = 0x00000000L;

			issue_test_socket_ipx_message ();
			}
		}
}
#endif /* __SOCKET_TEST_APPS__ */
