#include	"defs.h"
/*	$Modname: tsockudp.c$  $version: 1.7$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 11/04/94 titus Cosmetic changes for c++ compilation.
1.4 11/15/94 titus Changed occurences of tsock to test_socket_ and included file rwarebuf.h etc.
1.5 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.6 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.7 04/06/95 titus Changes for dynamic loading
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#ifdef __SOCKET_TEST_APPS__
#define GLOBAL_FILE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <kstart.h>
#include <v8022str.h>
#include <lslproto.h>
#include "socklib.h"
#include "ktstsudp.h"
#include "vtsustr.h"
#include <rwarebuf.h>
/****************************************************************************/
char *cptr_test_socket_udp_static_messages[] =
{
	"HELLO THERE! STATION 6\0",
	"HELLO STATION 6\0",
	"HELLO THERE! STATION 2\0",
	"HELLO STATION 2\0"
};

TEST_SOCKET_UDP_CLASS test_socket_udp;
/****************************************************************************/
enum TEST initialize_test_socket_udp (ULONG clock_ticks_per_second);
void test_socket_udp_application_entry_point (void);
/****************************************************************************/
static enum TEST initialize_test_socket_udp_socket_interface (void);
static enum TEST issue_test_socket_udp_message (void);
static enum TEST receive_test_socket_udp_reply (void);
static void test_socket_udp_timer (void);
enum TEST set_test_socket_udp_local_ip_address (char *cptr_ip_address_string);
enum TEST set_test_socket_udp_remote_ip_address (char *cptr_ip_address_string);
/****************************************************************************/
enum TEST initialize_test_socket_udp (ULONG clock_ticks_per_second)
{
	if (test_socket_udp.enabled == TRUE)
		{
		test_socket_udp.clock_ticks_per_second = clock_ticks_per_second;

		if ((enum TEST) lsl_control (REGISTER_APPLICATION,"Test Socket UDP Application", TEST_SOCKET_UDP_APPLICATION,
			test_socket_udp_application_entry_point,
			(enum TEST (*) (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)) NULL,
			&test_socket_udp.application_id) ==  FAIL)
			{
			socket_printf (SOCKET_INIT_PRINTF,
				"TEST_SOCKET_UDP: register_application () failed to register Test Socket UDP with lsl\n");

			return (FAIL);
			}
		}

	return (PASS);
 }
/****************************************************************************/
void test_socket_udp_application_entry_point (void)
{
	if (test_socket_udp.enabled == TRUE)
		{
		if (test_socket_udp.socket_interface_initialized == FALSE)
			{
			if (initialize_test_socket_udp_socket_interface () == FAIL)
				{
				socket_printf (SOCKET_INIT_PRINTF, "TEST_SOCKET_UDP: failed to initialize test_socket_udp socket interface\n");
				}
			else if (issue_test_socket_udp_message () == FAIL)
				{
				socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_UDP: issue_test_socket_udp_message failed\n");
				}
			}
		else
			{
			if (receive_test_socket_udp_reply () == FAIL)
				{
				socket_printf (SOCKET_BLOCK_PRINTF, "TEST_SOCKET_UDP: receive_test_socket_udp_reply failed\n");
				}
			}

		test_socket_udp_timer ();
		}
}
/****************************************************************************/
static enum TEST initialize_test_socket_udp_socket_interface (void)
{
	int bind_return_value;
	SOCKADDR_IN local_read_sockaddr_in;

	local_read_sockaddr_in.sin_family = AF_INET;
	local_read_sockaddr_in.sin_port = TEST_SOCKET_UDP_PORT;
	local_read_sockaddr_in.sin_addr.s_addr = test_socket_udp.local_ip_address;

	test_socket_udp.socket_descriptor = socket (AF_INET, SOCK_DGRAM, 0x00000000L);

	if (test_socket_udp.socket_descriptor == FAILED)
		{
		return (FAIL);
		}

	associate_application_with_socket (test_socket_udp.socket_descriptor, test_socket_udp.application_id);

	bind_return_value = bind (test_socket_udp.socket_descriptor, (SOCKADDR *) &local_read_sockaddr_in,
		sizeof (SOCKADDR_IN));

	if (bind_return_value == FAILED)
		{
		return (FAIL);
		}

	test_socket_udp.socket_interface_initialized = TRUE;

	return (PASS);
}
/****************************************************************************/
static enum TEST issue_test_socket_udp_message (void)
{
	char *cptr_test_socket_udp_message_to_be_send;
	SOCKADDR_IN remote_sockaddr_in;

	cptr_test_socket_udp_message_to_be_send = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_UDP_MESSAGE);

	if (cptr_test_socket_udp_message_to_be_send == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_UDP: issue_test_socket_udp_message (): table_malloc failed\n");

		return (FAIL);
		}

	remote_sockaddr_in.sin_family = AF_INET;
	remote_sockaddr_in.sin_port = TEST_SOCKET_UDP_PORT;
	remote_sockaddr_in.sin_addr.s_addr = test_socket_udp.remote_ip_address;

	memcpy ((void *) cptr_test_socket_udp_message_to_be_send,
		(void *) cptr_test_socket_udp_static_messages[2*test_socket_udp.station_number], SIZEOF_TEST_SOCKET_UDP_MESSAGE);

	if (sendto (test_socket_udp.socket_descriptor, cptr_test_socket_udp_message_to_be_send, SIZEOF_TEST_SOCKET_UDP_MESSAGE,
		(int) NULL, (SOCKADDR *) &remote_sockaddr_in, sizeof (SOCKADDR_IN)) != FAILED)
		{
		socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_UDP: sent message : %s\n", cptr_test_socket_udp_message_to_be_send);

		table_free ((void *) cptr_test_socket_udp_message_to_be_send);
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST receive_test_socket_udp_reply (void)
{
	char *cptr_test_socket_udp_message_received;
	char *cptr_test_socket_udp_message_to_be_send;
	int number_of_bytes_received;
	SOCKADDR_IN remote_sockaddr_in;

	cptr_test_socket_udp_message_received = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_UDP_MESSAGE);

	if (cptr_test_socket_udp_message_received == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_UDP: receive_test_socket_udp_reply (): table_malloc failed\n");

		return (FAIL);
		}

	number_of_bytes_received = recv (test_socket_udp.socket_descriptor, cptr_test_socket_udp_message_received,
		SIZEOF_TEST_SOCKET_UDP_MESSAGE, (int) NULL);

	if (number_of_bytes_received <= 0x0000)
		{
		table_free ((void *) cptr_test_socket_udp_message_received);

		return (FAIL);
		}

	socket_printf (SOCKET_RX_PRINTF, "TEST_SOCKET_UDP: received message : %s\n", cptr_test_socket_udp_message_received);

	if (((test_socket_udp.station_number == 0x00) &&
		(strcmp (cptr_test_socket_udp_message_received,
		cptr_test_socket_udp_static_messages[2*(test_socket_udp.station_number + 1)]) == 0)) ||
		((test_socket_udp.station_number == 0x01) &&
		(strcmp (cptr_test_socket_udp_message_received,
		cptr_test_socket_udp_static_messages[2*(test_socket_udp.station_number - 1)]) == 0)))
		{
		cptr_test_socket_udp_message_to_be_send = (char *) table_malloc (1, SIZEOF_TEST_SOCKET_UDP_MESSAGE);

		if (cptr_test_socket_udp_message_to_be_send == NULL)
			{
			socket_printf (SOCKET_ALARM_PRINTF, "TEST_SOCKET_UDP: receive_test_socket_udp_reply (): table_malloc failed\n");

			table_free ((void *) cptr_test_socket_udp_message_received);

			return (FAIL);
			}

		remote_sockaddr_in.sin_family = AF_INET;
		remote_sockaddr_in.sin_port = TEST_SOCKET_UDP_PORT;
		remote_sockaddr_in.sin_addr.s_addr = test_socket_udp.remote_ip_address;

		memcpy ((void *) cptr_test_socket_udp_message_to_be_send,
			(void *) cptr_test_socket_udp_static_messages[2*test_socket_udp.station_number + 1], SIZEOF_TEST_SOCKET_UDP_MESSAGE);

		if (sendto (test_socket_udp.socket_descriptor, cptr_test_socket_udp_message_to_be_send, SIZEOF_TEST_SOCKET_UDP_MESSAGE,
			(int) NULL, (SOCKADDR *) &remote_sockaddr_in, sizeof (SOCKADDR_IN)) != FAILED)
			{
			socket_printf (SOCKET_TX_PRINTF, "TEST_SOCKET_UDP: sent message : %s\n", cptr_test_socket_udp_message_to_be_send);

			table_free ((void *) cptr_test_socket_udp_message_to_be_send);
			}
		}

	table_free ((void *) cptr_test_socket_udp_message_received);

	return (PASS);
}
/****************************************************************************/
static void test_socket_udp_timer (void)
{
	if (test_socket_udp.timer_enabled == FALSE)
		{
		return;
		}

	++test_socket_udp.tick_counter;

	if (test_socket_udp.tick_counter >= test_socket_udp.clock_ticks_per_second)
		{
		test_socket_udp.tick_counter = 0x00000000L;

		++test_socket_udp.current_seconds;

		if (test_socket_udp.current_seconds > test_socket_udp.seconds_between_retransmission)
			{
			test_socket_udp.current_seconds = 0x00000000L;

			issue_test_socket_udp_message ();
			}
		}
}
/****************************************************************************/
enum TEST set_test_socket_udp_local_ip_address (char *cptr_ip_address_string)
{
	BYTE ip_address_array[10];

	sscanf (cptr_ip_address_string,"%03ju.%03ju.%03ju.%03ju",
		(int *) &ip_address_array[0],(int *) &ip_address_array[1],(int *) &ip_address_array[2],(int *) &ip_address_array[3]);

	test_socket_udp.local_ip_address = net_to_host_long ( *((ULONG *) &ip_address_array[0]));

	return (PASS);
}
/****************************************************************************/
enum TEST set_test_socket_udp_remote_ip_address (char *cptr_ip_address_string)
{
	BYTE ip_address_array[10];

	sscanf (cptr_ip_address_string,"%03ju.%03ju.%03ju.%03ju",
		(int *) &ip_address_array[0],(int *) &ip_address_array[1],(int *) &ip_address_array[2],(int *) &ip_address_array[3]);

	test_socket_udp.remote_ip_address = net_to_host_long ( *((ULONG *) &ip_address_array[0]));

	return (PASS);
}
#endif /* __SOCKET_TEST_APPS__ */

