/*	$Modname: vsocklnk.h$  $version: 1.7$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
1.3 11/04/94 titus Cosmetic changes for c++ compilation.
1.4 11/15/94 titus Changed the array name socket_link_array to socket_transport_interface_array .
1.5 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.6 04/06/95 titus Added function pointers for console stack
1.7 04/06/95 titus Changes for lint
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#ifndef _VSOCKLNK_H_
#define _VSOCKLNK_H_

#ifndef __LSL__

	TRANSPORT_INTERFACE socket_transport_interface_array[] =
	{
	  /*
		*  {sptr_forward_link,				sptr_backward_link},
		*	type,									accept,
 		* 	socket,								bind,								 	listen,								connect,
 		* 	recv,								 	send,									qlen, 								kick,
		*  shut,								 	close, 								check_if_window_open, 			check,
		*  error, 								state, 								status, 								eol_seq
 		*/

		#ifdef __TCP__
		{
			{NULL,								NULL},
			TYPE_TCP, 							TRUE,
			socket_tcp,							NULL, 		 						socket_tcp_listen,				socket_tcp_connect,
			socket_tcp_receive,			 	socket_tcp_send,					socket_tcp_queue_length,		socket_tcp_kick,
			socket_tcp_shut,				 	socket_tcp_close,					check_if_window_open,			tcp_check_ip_address,
			&cptr_socket_error_list[0],	socket_tcp_get_state_string,	socket_tcp_status,				inet_end_of_line
		},
		#endif /* __TCP__ */

		#ifdef __IP__
		{
			{NULL,								NULL},
			TYPE_UDP, 							FALSE,
			socket_udp,							socket_udp_bind,					NULL,									socket_udp_connect,
			socket_udp_receive,				socket_udp_send,					socket_udp_queue_length,		NULL,
			NULL,									socket_udp_close,					NULL,									check_ip_address,
			NULL,									NULL,									socket_udp_status, 				inet_end_of_line
		},
		#endif /* __IP__ */

		#ifdef __IPX__
		{
			{NULL,								NULL},
			TYPE_IPX, 							FALSE,
			socket_ipx,							socket_ipx_bind,					NULL,									socket_ipx_connect,
			socket_ipx_receive,				socket_ipx_send,					socket_ipx_queue_length, 		NULL,
			NULL,									socket_ipx_close,					NULL,									check_ipx_address,
			NULL,									NULL,									socket_ipx_status, 				netware_end_of_line
		},
		#endif /* __IPX__ */

		#ifdef __SPX__
		{
			{NULL,								NULL},
			TYPE_SPX, 							TRUE,
			socket_spx,							NULL, 		 						socket_spx_listen,				socket_spx_connect,
			socket_spx_receive,			 	socket_spx_send,					socket_spx_queue_length,		socket_spx_kick,
			socket_spx_shut,				 	socket_spx_close,					NULL,									spx_check_ipx_address,
			&cptr_socket_error_list[0],	socket_spx_get_state_string,	socket_spx_status,				netware_end_of_line
		},
		#endif /* __SPX__ */

		#ifdef __CONSOLE__
		{
			{NULL,								NULL},
			TYPE_CONSOLE, 						TRUE,
			console_socket,					console_socket_bind, 		 	NULL,									console_socket_connect,
			console_socket_receive,			console_socket_send,				NULL,									NULL,
			NULL,									console_socket_close,			NULL,									NULL,
			&cptr_socket_error_list[0],	NULL,									NULL,									inet_end_of_line
		},
		#endif /* __CONSOLE__ */

		{
			{NULL,								NULL},
			INVALID_USER_SOCKET_TYPE
		}
	};
#endif /* __LSL__ */

#endif 	/* _VSOCKLNK_H_ */
