#include	"defs.h"
/*
 * $Log: /IP/ARP.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: arp.c$  $version: 1.17$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/22/94 yarran Fix i960 compiler errors for names longer than 32 characters
1.4 03/01/94 yarran Change ARP_FLAGS bit structure to enum BOOLEAN structure.
1.5 03/03/94 yarran Handle NVRAM parameters directly by IP
1.6 05/02/94 yarran added rfc1042 support.
1.7 05/03/94 yarran fixed rfc1042 bug.
1.8 06/15/94 yarran cosmetic changes.
1.9 09/26/94 ross
1.10 10/10/94 ross added rarp, proxy arp, remote access functions
1.11 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.12 11/04/94 ross remote access testing and fixes.
1.13 12/20/94 ross
1.14 12/27/94 ross added better table instrumentation via new snmp.
1.15 01/17/95 ross fixed arp problems from snmp
1.16 10/25/95 ross
1.17 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdio.h>
#include <string.h>
#include "ip.h"
/*************************************************************************/
static void initialize_arp_virtual_ports (void);
static void initialize_arp_port (USHORT port_number);
static void arp_one_second_timer (void);
static void arp_one_minute_timer (void);
/*************************************************************************/
enum TEST initialize_arp (void)
{
	initialize_arp_virtual_ports ();

	ip.arp.timer_enabled = FALSE;
	ip.arp.second_counter = 0x0000;

	memset (&ip.arp.statistics, (int) NULL, sizeof (ARP_STATISTICS));

	ip.arp.timer_enabled = TRUE;

	return (PASS);
}
/*************************************************************************/
static void initialize_arp_virtual_ports (void)
{
	USHORT port_number;

   /* Noted : The check made inside the while loop need
      not be done. It is already done in initialize_arp_ports(). */

	for (port_number = 0x0000; port_number > ip.number_of_ports; ++port_number)
		{
		if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE))
			{
			initialize_arp_port (port_number);
			}
		}
}
/****************************************************************************/
static void initialize_arp_port (USHORT port_number)
{
	if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE))
		{
		if (ip.arp.port[port_number].config.cache_timeout == 0x0000)
			{
			ip.arp.port[port_number].config.cache_timeout = DEFAULT_ARP_CACHE_TIMEOUT;
			}
		else
			{
			if (ip.arp.port[port_number].config.cache_timeout > 60)
				{
				ip.arp.port[port_number].config.cache_timeout = ip.arp.port[port_number].config.cache_timeout / 60;
				}
			else
				{
				ip.arp.port[port_number].config.cache_timeout = (USHORT) 1;
				}
			}

		if (ip.arp.port[port_number].config.reply_timeout != 0x0000)
			{
			ip.arp.port[port_number].config.reply_timeout = DEFAULT_ARP_REPLY_TIMEOUT;
			}
		}
}
/****************************************************************************/
void call_arp_timer_if_enabled (void)
{
	if (ip.arp.timer_enabled == TRUE)
		{
		++ip.arp.second_counter;

		arp_one_second_timer ();

		if (ip.arp.second_counter >= 60)
			{
			/* scan arp table entrys */

			arp_one_minute_timer ();

			ip.arp.second_counter = 0x0000;
			}
		}
}
/*************************************************************************/
static void arp_one_second_timer (void)
{
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
	ARP_TABLE_ENTRY *sptr_next_arp_table_entry;
	USHORT port_number;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE))
			{
			if (ip.arp.port[port_number].number_of_arp_table_entries_awaiting_reply > 0x0000)
				{
				sptr_arp_table_entry = ip.arp.port[port_number].current_list.sptr_forward_link;

				while (sptr_arp_table_entry != NULL)
					{
					sptr_next_arp_table_entry = sptr_arp_table_entry->links.sptr_forward_link;

					if (sptr_arp_table_entry->type == INVALID_ARP_ENTRY)
						{
						++sptr_arp_table_entry->timer;

						if (sptr_arp_table_entry->timer >= ip.arp.port[port_number].config.reply_timeout)
							{
							if (sptr_arp_table_entry->number_of_retransmissions >= ip.arp.port[port_number].config.number_of_retries)
								{
							#ifdef __IP_DEBUG__
								ip_printf (ARP_PRINTF,
									"IP/ARP: table entry has aged (timer:%u, iaddr:%s, haddr:%x%x, port:%u, type:%u\n",
									sptr_arp_table_entry->timer,
									convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_arp_table_entry->ip_address),
									sptr_arp_table_entry->hardware_address._ulong, sptr_arp_table_entry->hardware_address._ulong,
									sptr_arp_table_entry->port_number, sptr_arp_table_entry->type);
							#endif /* __IP__DEBUG__ */

								if (ip.arp.port[port_number].sptr_cached_arp_entry == sptr_arp_table_entry)
									{
									ip.arp.port[port_number].sptr_cached_arp_entry = NULL;
									}

								delete_arp_table_entry (sptr_arp_table_entry);
								}
							else
								{
								send_arp_request_packet (port_number, sptr_arp_table_entry->ip_address, FALSE, 0x00000000L,
									(ULONG) NULL);

/* Sachin 17th May, 1997 */
                        sptr_arp_table_entry->number_of_retransmissions++ ;
/* Sachin 17th May, 1997 */
								}

							sptr_arp_table_entry->timer = 0x0000;
							}
						}

					sptr_arp_table_entry = sptr_next_arp_table_entry;
					}
				}
			}
		}
}
/*************************************************************************/
static void arp_one_minute_timer (void)
{
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
	ARP_TABLE_ENTRY *sptr_next_arp_table_entry;
	USHORT port_number;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE))
			{
			sptr_arp_table_entry = ip.arp.port[port_number].current_list.sptr_forward_link;

			while (sptr_arp_table_entry != NULL)
				{
				sptr_next_arp_table_entry = sptr_arp_table_entry->links.sptr_forward_link;

				if (sptr_arp_table_entry->type == DYNAMIC_ARP_ENTRY)
					{
					++sptr_arp_table_entry->timer;

					if (sptr_arp_table_entry->timer >= ip.arp.port[port_number].config.cache_timeout)
						{
					#ifdef __IP_DEBUG__
						ip_printf (ARP_PRINTF, "IP/ARP: table entry has aged (timer:%u, iaddr:%s, haddr:%x%x, port:%u, type:%u\n",
							sptr_arp_table_entry->timer,
							convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_arp_table_entry->ip_address),
							sptr_arp_table_entry->hardware_address._ulong, sptr_arp_table_entry->hardware_address._ulong,
							sptr_arp_table_entry->port_number, sptr_arp_table_entry->type);
					#endif /* __IP__DEBUG__ */

						if (ip.arp.port[port_number].sptr_cached_arp_entry == sptr_arp_table_entry)
							{
							ip.arp.port[port_number].sptr_cached_arp_entry = NULL;
							}

						delete_arp_table_entry (sptr_arp_table_entry);
						}
					}

				sptr_arp_table_entry = sptr_next_arp_table_entry;
				}
			}
		}

#ifdef __IP_DEBUG__
	arp_print_table ();
#endif /* __IP__DEBUG__ */
}
/*************************************************************************/
void arp_print_table (void)
{
	USHORT port_number;
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
	char *ptr_to_string;

	if (ip.print_class.arp_printing_enabled == TRUE)
	{
		ptr_to_string = &ip.string_to_print[0];

		ptr_to_string += sprintf (ptr_to_string, "IP/ARP: arp table:\n");

		for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
			/* if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE)) */
			if (ip.port[port_number].config.port_enabled == TRUE)
			{
				sptr_arp_table_entry = (ARP_TABLE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *)
					&ip.arp.port[port_number].current_list);

				while (sptr_arp_table_entry != NULL)
				{
					convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_arp_table_entry->ip_address);

					if (sptr_arp_table_entry->type == OTHER_ARP_ENTRY)
					{
						ptr_to_string += sprintf (ptr_to_string, "   ARP ENTRY: other,");
					}
					else if (sptr_arp_table_entry->type == INVALID_ARP_ENTRY)
					{
						ptr_to_string += sprintf (ptr_to_string, "   ARP ENTRY: invalid,");
					}
					else if (sptr_arp_table_entry->type == DYNAMIC_ARP_ENTRY)
					{
						ptr_to_string += sprintf (ptr_to_string, "   ARP ENTRY: dynamic,");
					}
					else if (sptr_arp_table_entry->type == STATIC_ARP_ENTRY)
					{
						ptr_to_string += sprintf (ptr_to_string, "   ARP ENTRY: static,");
					}

					ptr_to_string += sprintf (ptr_to_string, "target:%s,mac address:%x%x,port:%u,age:%u\n", &ip.print_buffer[0],
						sptr_arp_table_entry->hardware_address._ulong, sptr_arp_table_entry->hardware_address._ushort,
						sptr_arp_table_entry->port_number, sptr_arp_table_entry->timer);

					ip_printf (ARP_PRINTF, &ip.string_to_print[0]);

					ptr_to_string = &ip.string_to_print[0];

					sptr_arp_table_entry = (ARP_TABLE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_arp_table_entry);
				}
			}
		}
	}
}
