/* sudha 17 sep 1998 */

#include	"defs.h"

#include <stdlib.h>
#include <string.h>
#include "dns.h"
#include "ip.h"
#include "kdns.h"
#include "vdnsstr.h"

void get_dns_response_packet(UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, BYTE *dns_resp_pkt, 
	USHORT length, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet));
USHORT process_rr_types_and_store (USHORT count, RESOURCE_REC *src_rr, RR_PKT **dest_rr );
enum BOOLEAN insert_rr ( RESOURCE_REC *rr_ptr, RR_PKT **rr_pkt_ptr );
enum BOOLEAN copy_rr_data (RESOURCE_REC *src_rr_ptr, RESOURCE_REC *dest_rr_ptr );
USHORT get_length_of_dns_reply_pkt ( REPLY_PKT *reply_pkt );

extern void allocate_space_and_copy_data_to_udp_packet (UNION_IP_PACKET **ptr_to_sptr_udp_packet,
	USHORT *usptr_size_of_udp_packet, void *vptr_user_data, USHORT number_of_data_bytes);
extern void	compute_checksum_for_packet (PSEUDO_IP_PARAMETERS *sptr_pseudo_header, UDP_PACKET *sptr_udp_packet, USHORT length);
extern USHORT ip_get_outgoing_port_number_from_ip_address (ULONG destination_ip_address);
extern USHORT get_udp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern void print_udp_header (UDP_HEADER *sptr_udp_header);
extern HEADER *get_dns_header_from_rxed_packet (BYTE *in_buff);
extern void free_allocated_buffers (HEADER *dns_hdr_type, USHORT port_number);

extern DNS_REPLY_CACHE dns_cache_entry[MAX_NUMBER_OF_CACHE];
extern RESOURCE_REC *ans_rr[MAX_WAN_PORTS], *auth_rr[MAX_WAN_PORTS], *add_rr[MAX_WAN_PORTS];

DNS_REPLY_PKT *get_free_dns_entry_from_cache ()
{
   USHORT i=0;
printf("\n\rDNSRESP: get free dns entry.");
   for (i = 0; i < MAX_NUMBER_OF_CACHE; i++)
   {
      if (dns_cache_entry[i].in_use == FALSE)
      {
         dns_cache_entry[i].in_use = TRUE ;         
			dns_cache_entry[i].reply_pkt.query_info.send_hdr.send_id = 0 ;
			dns_cache_entry[i].reply_pkt.query_info.send_hdr.ctrl_fld = 0 ;
			dns_cache_entry[i].reply_pkt.query_info.send_hdr.qdcnt = 0 ;
			dns_cache_entry[i].reply_pkt.query_info.send_hdr.ancnt = 0 ;
			dns_cache_entry[i].reply_pkt.query_info.send_hdr.nscnt = 0 ;
			dns_cache_entry[i].reply_pkt.query_info.send_hdr.arcnt = 0 ;

			dns_cache_entry[i].reply_pkt.query_info.send_quest = NULL ;
		
			dns_cache_entry[i].reply_pkt.query_info.send_qtype = 0 ;
			dns_cache_entry[i].reply_pkt.query_info.send_qclass = 0 ;

			dns_cache_entry[i].reply_pkt.ans_rr = NULL ;
			dns_cache_entry[i].reply_pkt.auth_rr = NULL ;
			dns_cache_entry[i].reply_pkt.add_rr = NULL ;

         return ( &dns_cache_entry[i].reply_pkt ) ;
      }
   }
   return NULL;
}

enum BOOLEAN process_dns_response_and_store_in_local_cache ( BYTE *ptr_to_dns_pkt, BYTE *domain_name )
{
	USHORT quest_len,index ;
	USHORT offset, port_number = 0 ;
	USHORT anscnt,authcnt,addcnt ;
	BYTE *temp_ptr, *ptr_to_rr ;
	HEADER *dns_hdr_type ;
	DNS_REPLY_PKT *ptr_to_cache ;

	quest_len = strlen ( domain_name ) ;
printf("\n\rDNSRESP: Process dns response & store in local cache.");
	for(index = 0 ;index < MAX_NUMBER_OF_CACHE;index++)
	{
		if ( strcmpi ( dns_cache_entry[index].reply_pkt.query_info.send_quest , domain_name ))
			continue ;
		else
			return FALSE ;
	}

   ptr_to_cache = get_free_dns_entry_from_cache();

   if (ptr_to_cache == NULL)
      return FALSE ;
	
   dns_hdr_type = get_dns_header_from_rxed_packet ( ptr_to_dns_pkt ) ;
   if (dns_hdr_type == NULL)
      return FALSE ;
	
   if (!CHECK_IF_RESPONSE_PKT (dns_hdr_type))
   {
	   free (dns_hdr_type ) ;
   	printf("DNS2: Not a response packet\n") ;
		return FALSE ;
   }
	
	if (!CHECK_IF_ERROR_PKT (dns_hdr_type))
   {
		ptr_to_cache->query_info.send_quest = ( BYTE * ) malloc ( quest_len ) ;
printf("n\rDNSRESP : query_info.send_quest addr is %x",ptr_to_cache->query_info.send_quest);
	
		if ( ptr_to_cache->query_info.send_quest == NULL )
		{
			free ( dns_hdr_type ) ;
			return FALSE ;
		}

		memcpy (ptr_to_cache->query_info.send_quest, domain_name, quest_len+1) ;
		
		offset = sizeof (HEADER) + quest_len + 1 ;
		temp_ptr = (BYTE *) ( ptr_to_dns_pkt + offset );

		ptr_to_cache->query_info.send_qtype = net_to_host_short (*(USHORT *) temp_ptr); 
			
		offset += sizeof(USHORT);
		temp_ptr = (BYTE *) ( ptr_to_dns_pkt + offset );

		ptr_to_cache->query_info.send_qclass = net_to_host_short (*(USHORT *) temp_ptr); 
		
	   if (allocate_buffers_and_copy_rrs (dns_hdr_type, ptr_to_dns_pkt, port_number, quest_len ) == FAIL)
   	{
			printf("DNS2: Malloc failed for rrs\n");
			free ( ptr_to_cache->query_info.send_quest );
			free ( dns_hdr_type ) ;
			return FALSE;
   	}

/* copy rrs with their resp links in the cache */
		
		anscnt = process_rr_types_and_store ( dns_hdr_type->ancnt, ans_rr[port_number], &ptr_to_cache->ans_rr );
		authcnt = process_rr_types_and_store ( dns_hdr_type->nscnt, auth_rr[port_number], &ptr_to_cache->auth_rr );
		addcnt = process_rr_types_and_store ( dns_hdr_type->arcnt, add_rr[port_number], &ptr_to_cache->add_rr );

		free_allocated_buffers ( dns_hdr_type, port_number );

/* copy dns_hdr_info into cache */

/* Doubt ????? In control field, set the 5th bit position to 0 since 
response is not from the authoritative server & it is from the cache */

		dns_hdr_type->ctrl_fld &= 0xfbff ; 
		dns_hdr_type->ancnt = anscnt ;
   	dns_hdr_type->nscnt = authcnt ;
		dns_hdr_type->arcnt = addcnt ;
		
		ptr_to_cache->query_info.send_hdr.send_id = dns_hdr_type->send_id ;
		ptr_to_cache->query_info.send_hdr.ctrl_fld = dns_hdr_type->ctrl_fld ;	
		ptr_to_cache->query_info.send_hdr.qdcnt = dns_hdr_type->qdcnt ;	
		ptr_to_cache->query_info.send_hdr.ancnt = dns_hdr_type->ancnt ;	
		ptr_to_cache->query_info.send_hdr.nscnt = dns_hdr_type->nscnt ;	
		ptr_to_cache->query_info.send_hdr.arcnt = dns_hdr_type->arcnt ;	
	
		
	}
	else
	{
	   free (dns_hdr_type ) ;
   	printf("DNS2: Error packet\n") ;
		return FALSE ;
	}
	free ( dns_hdr_type ) ;
	return TRUE ;
}	

void get_dns_response_packet(UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, BYTE *dns_resp_pkt, 
	USHORT number_of_bytes, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet))
{
	BYTE time_to_live, type_of_service ;
	enum BOOLEAN do_not_fragment_flag ;
	USHORT size_of_udp_packet,length, pdu_length ;
	USHORT source_port, destination_port ;
	USHORT tx_port_number = NO_SUCH_PORT, sequence_identifier ;
	ULONG source_ip_address, destination_ip_address ;
	UNION_IP_PACKET *ip_packet;
	UDP_PACKET *sptr_udp_packet;
	PSEUDO_IP_PARAMETERS pseudo_header;
	IP_UPPER_LAYER_PARAMETERS ip_upper_layer_parameters;
	UNION_SERVICE_TYPE_BIT_STRUCTURE structure_type_of_service;

	length = number_of_bytes + (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IP_HEADER)
				+ sizeof (UDP_HEADER));
	tx_port_number = 0 ; /* Proxy Lan Port */
	time_to_live = 0x0032;			/* value for these variables correct ? doubt ? */
	do_not_fragment_flag = TRUE;
	sequence_identifier = 0x0000;

	destination_ip_address = sptr_ip_packet->ip.header.source_ip_address ;
/*	source_ip_address = ip_get_address_of_outgoing_interface ( destination_ip_address ); */
	source_ip_address = sptr_ip_packet->ip.header.destination_ip_address ;


	source_port = get_udp_port_number_from_ip_packet ( sptr_ip_packet, sptr_ip_parameters, &destination_port );

	type_of_service = 0x00;
	structure_type_of_service._byte = type_of_service ;

	allocate_space_and_copy_data_to_udp_packet(&ip_packet, &size_of_udp_packet, dns_resp_pkt, number_of_bytes ) ;
printf("\n\rDNSRESP: after allocate_space");
	
	sptr_udp_packet = (UDP_PACKET *)ip_packet;
	pdu_length = (USHORT) (length - (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IP_HEADER)));

/* build pseudo header without any socket info */
	
	pseudo_header.length = host_to_net_short (pdu_length);
	pseudo_header.source_address = host_to_net_long (source_ip_address);
	pseudo_header.destination_address = host_to_net_long (destination_ip_address);
	pseudo_header.zero_field = 0x00;
	pseudo_header.protocol = UDP_PROTOCOL;

/* build udp header in packet without any socket info */

	sptr_udp_packet->header.source_port = host_to_net_short (source_port);
	sptr_udp_packet->header.destination_port = host_to_net_short (destination_port);
	sptr_udp_packet->header.length = pseudo_header.length;
	sptr_udp_packet->header.checksum = 0x0000;	/* clear checksum */

#ifndef NO_UDP_CHECKSUM
	compute_checksum_for_packet (&pseudo_header, sptr_udp_packet, pdu_length);
#endif

#ifdef __IP_DEBUG__
	print_udp_header (&sptr_udp_packet->header);
#endif /* __IP__DEBUG__ */

	memset (&ip_upper_layer_parameters, 0x00, sizeof (IP_UPPER_LAYER_PARAMETERS));

/* build ip parameters without any socket info */

	ip_upper_layer_parameters.source_address = source_ip_address;
	ip_upper_layer_parameters.destination_address = destination_ip_address;
	ip_upper_layer_parameters.do_not_fragment_flag = (BYTE_ENUM (BOOLEAN)) do_not_fragment_flag;
	ip_upper_layer_parameters.type_of_service = structure_type_of_service._bit;
	ip_upper_layer_parameters.sequence_id = sequence_identifier;
	ip_upper_layer_parameters.time_to_live = time_to_live;
	ip_upper_layer_parameters.protocol = UDP_PROTOCOL;	 
	ip_upper_layer_parameters.option_length = 0x00; 
	ip_upper_layer_parameters.virtual_port_number = tx_port_number;

/* udp_control_block is not at all used. So no checking of whether 
udp_control_block is != NULL. */

	ip_upper_layer_parameters.vptr_cached_route = NULL;
printf("n\rDNSRESP : send ip packet from upper layer");	
	send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_udp_packet, length,
		(void (*) (USHORT port_number, IP_PACKET *sptr_tx_packet)) fptr_tx_completion);
printf("n\rDNSRESP : after send ip packet from upper layer");	

	return ;

}

USHORT process_rr_types_and_store (USHORT count, RESOURCE_REC *src_rr, RR_PKT **dest_rr )
{
	USHORT index, ancnt = 0 ;
	RESOURCE_REC *temp_rr, *temp_ptr_rr ;

	temp_rr = src_rr ;

	for (index = 0; index < count; index++ )
	{
		if ( insert_rr ( temp_rr , dest_rr ) == TRUE )
		{
			ancnt++;
			temp_rr++;
		}
	}
	return (ancnt);
}

enum BOOLEAN insert_rr ( RESOURCE_REC *rr_ptr, RR_PKT **rr_pkt_ptr )
{
	RR_PKT *temp_rr_link, *temp_rr, *trr_pkt_ptr ;

	temp_rr_link = *rr_pkt_ptr;

	if ( *rr_pkt_ptr == NULL )
	{
/* create a new link */
		*rr_pkt_ptr = (RR_PKT *)malloc(sizeof(RR_PKT)) ;
printf("\n\rDNSRESP : rr_pkt_ptr addr is %x",*rr_pkt_ptr );
		if ( *rr_pkt_ptr == NULL )
		{
			printf("\n\rDNS RR : malloc failed");
			return FALSE ;
		}
		trr_pkt_ptr = *rr_pkt_ptr;

		trr_pkt_ptr->prev_rr = trr_pkt_ptr->next_rr = NULL ;
		trr_pkt_ptr->res_rec = (RESOURCE_REC *) malloc (sizeof (RESOURCE_REC)) ;
printf("\n\rDNSRESP : rr_pkt_ptr->res_rec addr is %x",trr_pkt_ptr->res_rec );

		if ( trr_pkt_ptr->res_rec == NULL )
		{
			printf("\n\rDNS RR2 : malloc failed");
			free ( *rr_pkt_ptr ) ;
			return FALSE ;
		}

		if ( copy_rr_data ( rr_ptr , trr_pkt_ptr->res_rec ) == FALSE )
		{
			printf("\n\rDNSRES1 : copy_rr_data failed.");
			free ( trr_pkt_ptr->res_rec );
			free ( *rr_pkt_ptr ) ;
			return FALSE ;
		}
	}
	else
	{
/* traverse the links till the last rr link is reached */

		while ( temp_rr_link->next_rr != NULL )
			temp_rr_link = temp_rr_link->next_rr ;

/* add a new link at the end */
		temp_rr = (RR_PKT *) malloc ( sizeof (RR_PKT));
		temp_rr->next_rr = NULL ;

		temp_rr->res_rec = (RESOURCE_REC *) malloc (sizeof (RESOURCE_REC)) ;
printf("\n\rDNSRESP : temp_rr->res_rec addr is %x",temp_rr->res_rec );

		if ( temp_rr->res_rec == NULL )
		{
			printf("\n\rDNS RR2 : malloc failed");
			free ( temp_rr ) ;
			return FALSE ;
		}

		if ( copy_rr_data ( rr_ptr, temp_rr->res_rec ) == FALSE )
		{
			printf ( "\n\rDNSRES : copy_rr_data failed.") ;
			free ( temp_rr->res_rec );
			free ( temp_rr ) ;
			return FALSE ;
		}	

		temp_rr->prev_rr = temp_rr_link;
		temp_rr_link->next_rr = temp_rr;
	}
	return TRUE ;
}

enum BOOLEAN copy_rr_data (RESOURCE_REC *src_rr_ptr, RESOURCE_REC *dest_rr_ptr )
{
	USHORT name_len = 0, data_len = 0 ;		
	RESOURCE_REC *temp_ptr ;

	temp_ptr = dest_rr_ptr ;

	name_len = strlen ( src_rr_ptr->re_name ) + 1;
	temp_ptr->re_name = (BYTE *)malloc ( name_len );
printf("\n\rDNSRESP : temp_ptr->re_name addr is %x",temp_ptr->re_name );

	if ( temp_ptr->re_name == NULL )
	{
		printf ("\n\rDNSRES1 : malloc failed.");
		return FALSE ;
	}

	memcpy ( temp_ptr->re_name, src_rr_ptr->re_name, name_len );

	temp_ptr->re_type = src_rr_ptr->re_type ;
	temp_ptr->re_class = src_rr_ptr->re_class ;
	temp_ptr->re_ttl = src_rr_ptr->re_ttl ;
	temp_ptr->re_rdlen = src_rr_ptr->re_rdlen ;

	data_len = src_rr_ptr->re_rdlen ;
	temp_ptr->re_rdata = ( BYTE * ) malloc ( data_len ) ;
printf("\n\rDNSRESP : temp_ptr->re_rdata addr is %x",temp_ptr->re_rdata );

	if ( temp_ptr->re_rdata == NULL )
	{
		printf ("\n\rDNSRES2 : malloc failed.");
		free ( temp_ptr->re_name ); 
		return FALSE ;
	}

	memcpy ( temp_ptr->re_rdata, src_rr_ptr->re_rdata, data_len ) ;

#ifdef DEBUG
      printf ("RR_NAME: %s\n",temp_ptr->re_name);
      printf ("RR_TYPE: %d\n",temp_ptr>re_type);
      printf ("RR_CLASS: %d\n",temp_ptr->re_class);
      printf ("RR_TTL: %d\n",temp_ptr->re_ttl);
      printf ("RR_RDLEN: %d\n",temp_ptr->re_rdlen);
      if (temp_ptr->re_type == 2)
         printf ("RR_DATA is %s\n",temp_ptr->re_rdata);
      else
         printf ("RR_RDATA: %d%d%d%d\n",((USHORT)(*temp_ptr->re_rdata)),
               ((USHORT)(*(temp_ptr->re_rdata+1))),((USHORT)(*(temp_ptr->re_rdata+2))),((USHORT)(*(ptr_to_dest_rr->re_rdata+3))));
#endif

	return TRUE ;
}

USHORT get_length_of_dns_reply_pkt ( REPLY_PKT *reply_pkt )
{
	USHORT length = 0, index ;
	USHORT name_len, data_len, quest_len ;
	USHORT ancnt, nscnt, arcnt ;
	RESOURCE_REC *temp_pkt_ptr ;

	quest_len = strlen ( reply_pkt->query_info.send_quest ) + 1;		
printf("\n\rDNSRES : Quest Length is %d",quest_len);
	length = sizeof ( HEADER ) + quest_len + 2 * sizeof (USHORT) ;

	ancnt = reply_pkt->query_info.send_hdr.ancnt ;
	nscnt = reply_pkt->query_info.send_hdr.nscnt ;
	arcnt = reply_pkt->query_info.send_hdr.arcnt ;

	temp_pkt_ptr = reply_pkt->ans_rr ;

	for ( index = 0; index < ancnt; index++ )
	{
		name_len = strlen (temp_pkt_ptr->re_name) + 1;
		data_len = temp_pkt_ptr->re_rdlen ;
		length += name_len + data_len + 3 * sizeof (USHORT) + sizeof (ULONG);
		temp_pkt_ptr++;
	}


	temp_pkt_ptr = reply_pkt->auth_rr ;
	for( index = 0; index < nscnt; index++ )
	{
		name_len = strlen (temp_pkt_ptr->re_name) + 1;
		data_len = temp_pkt_ptr->re_rdlen ;
		length += name_len + data_len + 3 * sizeof (USHORT) + sizeof (ULONG);
		temp_pkt_ptr++ ;
	}

	temp_pkt_ptr = reply_pkt->add_rr ;
	for( index = 0; index < arcnt; index++ )
	{
		name_len = strlen (temp_pkt_ptr->re_name) + 1;
		data_len = temp_pkt_ptr->re_rdlen ;
		length += name_len + data_len + 3 * sizeof (USHORT) + sizeof (ULONG);
		temp_pkt_ptr++ ;
	}

	printf("\n\rDNSRES : Length of dns pkt : %d",length);
	return (length);
}

enum BOOLEAN delete_rr ( RR_PKT **rr_pkt_ptr, USHORT count )
{
	USHORT index = 0 ;
	RR_PKT *temp_rr_link , *rec_del_ptr ;

	temp_rr_link = *rr_pkt_ptr;

/* traverse the links till the rr to be deleted is reached */
	for ( index = 0; index < count ; index++ )
		temp_rr_link = temp_rr_link->next_rr ;

/* delete the current link */
	rec_del_ptr = temp_rr_link ;
	if ( temp_rr_link->next_rr != NULL )
		temp_rr_link->next_rr->prev_rr = temp_rr_link->prev_rr ;

	if ( temp_rr_link->prev_rr != NULL )
		temp_rr_link->prev_rr->next_rr = temp_rr_link->next_rr ;
		
	if ( *rr_pkt_ptr == temp_rr_link )
		*rr_pkt_ptr = temp_rr_link->next_rr ;

printf("\n\rDNSRESP : Free re_name addr is %x", rec_del_ptr->res_rec->re_name );
	free ( rec_del_ptr->res_rec->re_name );
	rec_del_ptr->res_rec->re_name = NULL ;
printf("\n\rDNSRESP : Free re_data addr is %x", rec_del_ptr->res_rec->re_rdata );
	free ( rec_del_ptr->res_rec->re_rdata );
	rec_del_ptr->res_rec->re_rdata = NULL ;
printf("\n\rDNSRESP : Free res_rec addr is %x", rec_del_ptr->res_rec );
	free ( rec_del_ptr->res_rec ) ;
	rec_del_ptr->res_rec = NULL ;
printf("\n\rDNSRESP : Free rr_pkt addr is %x", rec_del_ptr );
	free ( rec_del_ptr ) ;
	rec_del_ptr = NULL ;

	return TRUE ;
}

/* Sudha 11 Sep 1998 */
BYTE *get_ptr_to_dns_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
    BYTE *ptr_to_dns;

    ptr_to_dns = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+ sptr_ip_parameters->header_length + sizeof (UDP_HEADER)) ;

    return (ptr_to_dns);
}

BYTE *get_domain_name_from_dns_query_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	BYTE *ptr_to_dns_query;

   ptr_to_dns_query = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+ sptr_ip_parameters->header_length + sizeof (UDP_HEADER)
								+ sizeof(struct HEADER));
	
	printf("\n\rIPUTIL: Domain Name is %s",ptr_to_dns_query);
	return (ptr_to_dns_query) ;

}
/* Sudha 11 Sep 1998 */

void display_proxy_dns_cache_info ()
{
	USHORT ancnt, nscnt, arcnt, index, i;
	DNS_REPLY_PKT *temp_dns_pkt ;
	RR_PKT *anptr, *nsptr, *arptr ;
	RESOURCE_REC *ansres, *authres, *addres ;
	BYTE ip_addr[4], *ip_address ;
	
	printf("DNSIP : Proxy Server DNS Cache Entry List........\n");
	for ( index = 0; index < MAX_NUMBER_OF_CACHE; index++ )
	{
      if (dns_cache_entry[index].in_use == TRUE)
      {
			temp_dns_pkt = &dns_cache_entry[index].reply_pkt ;
			printf ("\n\rDomain Name : %s",temp_dns_pkt->query_info.send_quest);
			ancnt = temp_dns_pkt->query_info.send_hdr.ancnt ;
			nscnt = temp_dns_pkt->query_info.send_hdr.nscnt ;
			arcnt = temp_dns_pkt->query_info.send_hdr.arcnt ;

			anptr = temp_dns_pkt->ans_rr ;
			nsptr = temp_dns_pkt->auth_rr ;
			arptr = temp_dns_pkt->add_rr ;

			printf ("\n\rQdcnt : %d, Anscnt : %d, Authcnt : %d, Addcnt : %d",
temp_dns_pkt->query_info.send_hdr.qdcnt,ancnt,nscnt,arcnt );
			printf ("\n\rResolved Address List");

			for ( i = 0; i < ancnt; i++ )
			{
				ansres = anptr->res_rec ;
				strcpy(ip_addr,ansres->re_rdata) ;
				sprintf(ip_address,"%d.%d.%d.%d",ip_addr[0],ip_addr[1],ip_addr[2],ip_addr[3]);
				printf ("\n\r%d. %s",i,ip_address);
				anptr = anptr->next_rr ;
			}
			
			for ( i = 0; i < nscnt; i++ )
			{
				authres = nsptr->res_rec ;
				strcpy(ip_addr,authres->re_rdata) ;
				sprintf(ip_address,"%d.%d.%d.%d",ip_addr[0],ip_addr[1],ip_addr[2],ip_addr[3]);
				printf ("\n\r%d. %s",i,ip_address);
				nsptr = nsptr->next_rr ;
			}

			for ( i = 0; i < arcnt; i++ )
			{
				addres = arptr->res_rec ;
				strcpy(ip_addr,addres->re_rdata) ;
				sprintf(ip_address,"%d.%d.%d.%d",ip_addr[0],ip_addr[1],ip_addr[2],ip_addr[3]);
				printf ("\n\r%d. %s",i,ip_address);
				arptr = arptr->next_rr ;
			}
		}
	}
}
