/* sudha 17 sep 1998 */

/************************************************************************/
/*
Changes History : 
	{ sudha 11-Nov-1999. DNS Server Addr if 0xFFFFFFFFL Bug Fix. Changes in 
		get_dns_server_address() function.
	}
*/
/************************************************************************/

#include	"defs.h"

#include <stdlib.h>
#include <string.h>
#include "dns.h"
#include "ip.h"
#include "kdns.h"
#include "vdnsstr.h"
extern DNS_CLASS dns;
extern QUERY_INFORMATION query_info[MAX_WAN_PORTS];

extern ULONG recent_ppp_negotiated_dns_primary_server_address[MAX_WAN_PORTS];
extern ULONG recent_ppp_negotiated_dns_secondary_server_address[MAX_WAN_PORTS];

void get_dns_response_packet(UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, BYTE *dns_resp_pkt, 
	USHORT length, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet));


USHORT get_length_of_dns_reply_pkt (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
USHORT get_quest_count_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
enum BOOLEAN check_if_dns_pkt_has_any_reply(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
USHORT get_send_id_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
ULONG get_dns_server_address (USHORT port_number);


extern void allocate_space_and_copy_data_to_udp_packet (UNION_IP_PACKET **ptr_to_sptr_udp_packet,
	USHORT *usptr_size_of_udp_packet, void *vptr_user_data, USHORT number_of_data_bytes);
extern void	compute_checksum_for_packet (PSEUDO_IP_PARAMETERS *sptr_pseudo_header, UDP_PACKET *sptr_udp_packet, USHORT length);
extern USHORT ip_get_outgoing_port_number_from_ip_address (ULONG destination_ip_address);
extern USHORT get_udp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern void print_udp_header (UDP_HEADER *sptr_udp_header);
extern HEADER *get_dns_header_from_rxed_packet (BYTE *in_buff);
extern void free_allocated_buffers (HEADER *dns_hdr_type, USHORT port_number);

extern DNS_REPLY_CACHE dns_cache_entry[MAX_NUMBER_OF_CACHE];
extern RESOURCE_REC *ans_rr[MAX_WAN_PORTS], *auth_rr[MAX_WAN_PORTS], *add_rr[MAX_WAN_PORTS];

ULONG min_ttl_value = 1;

DNS_REPLY_CACHE *get_free_dns_entry_from_cache ()
{
   USHORT i=0;
   for (i = 0; i < MAX_NUMBER_OF_CACHE; i++)
   {
      if (dns_cache_entry[i].in_use == FALSE)
      {
         dns_cache_entry[i].in_use = TRUE ;         
			dns_cache_entry[i].rr_min_ttl = 1 ;
			dns_cache_entry[i].data_len = 0 ;

			dns_cache_entry[i].send_quest = NULL ;
			dns_cache_entry[i].reply_pkt = NULL ;

         return ( &dns_cache_entry[i] ) ;
      }
   }
   return NULL;
}

enum BOOLEAN process_dns_response_and_store_in_local_cache ( BYTE *ptr_to_dns_pkt, BYTE *domain_name, USHORT dns_len )
{
	USHORT quest_len,index ;
	USHORT offset, port_number = 0 ;
	BYTE *temp_dns_ptr, *reply_pkt ;
	HEADER *dns_hdr_type ;
	DNS_REPLY_CACHE *ptr_to_cache ;

	temp_dns_ptr = ptr_to_dns_pkt ;
	quest_len = strlen ( domain_name ) ;

	for(index = 0 ;index < MAX_NUMBER_OF_CACHE;index++)
	{
		if ( strcmpi ( dns_cache_entry[index].send_quest , domain_name ))
			continue ;
		else
			return FALSE ;
	}

   ptr_to_cache = get_free_dns_entry_from_cache();

   if (ptr_to_cache == NULL)
      return FALSE ;
	
   dns_hdr_type = get_dns_header_from_rxed_packet ( temp_dns_ptr ) ;
   if (dns_hdr_type == NULL)
      return FALSE ;
	
   if (!CHECK_IF_RESPONSE_PKT (dns_hdr_type))
   {
	   free (dns_hdr_type ) ;
   	printf("DNS2: Not a response packet\n") ;
		ptr_to_cache->in_use = FALSE ;
		return FALSE ;
   }
	
	if (!CHECK_IF_ERROR_PKT (dns_hdr_type))
   {
		ptr_to_cache->send_quest = ( BYTE * ) malloc ( quest_len ) ;
#if __Sudha__
printf("n\rDNSRESP : send_quest addr is %x",ptr_to_cache->send_quest);
#endif
	
		if ( ptr_to_cache->send_quest == NULL )
		{
			free ( dns_hdr_type ) ;
			ptr_to_cache->in_use = FALSE ;
			return FALSE ;
		}

		memcpy (ptr_to_cache->send_quest, domain_name, quest_len+1) ;
		
	   if (allocate_buffers_and_copy_rrs (dns_hdr_type, temp_dns_ptr, port_number, quest_len ) == FAIL)
   	{
			printf("DNS2: Malloc failed for rrs\n");
			free ( ptr_to_cache->send_quest );
			ptr_to_cache->in_use = FALSE ;
			free ( dns_hdr_type ) ;
			return FALSE;
   	}

/* Doubt ????? In control field, set the 5th bit position to 0 since 
response is not from the authoritative server & it is from the cache */

		dns_hdr_type->ctrl_fld &= 0xfbff ;
		
 		reply_pkt = (BYTE *) malloc ( dns_len ) ;
		if ( reply_pkt == NULL )
		{
			printf("DNS2: Malloc failed for reply pkt\n");
			free ( ptr_to_cache->send_quest );
			ptr_to_cache->in_use = FALSE ;
			free ( dns_hdr_type ) ;
			return FALSE;
		}
		
		ptr_to_cache->reply_pkt = reply_pkt ;

		memcpy( reply_pkt, ptr_to_dns_pkt, sizeof ( USHORT ));
		memcpy((reply_pkt + sizeof (USHORT)),&dns_hdr_type->ctrl_fld, sizeof (USHORT));
		memcpy((reply_pkt + ( 2 *sizeof (USHORT))), (ptr_to_dns_pkt + ( 2 * sizeof (USHORT))),
					(dns_len - ( 2 * sizeof (USHORT))));
		
		ptr_to_cache->rr_min_ttl = min_ttl_value ;
		ptr_to_cache->data_len = dns_len ;
	}
	else
	{
	   free (dns_hdr_type ) ;
   	printf("DNS2: Error packet\n") ;
		ptr_to_cache->in_use = FALSE ;
		return FALSE ;
	}
	free ( dns_hdr_type ) ;
	return TRUE ;
}	

void get_dns_response_packet(UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, BYTE *dns_resp_pkt, 
	USHORT number_of_bytes, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet))
{
	BYTE time_to_live, type_of_service ;
	enum BOOLEAN do_not_fragment_flag ;
	USHORT size_of_udp_packet,length, pdu_length ;
	USHORT source_port, destination_port ;
	USHORT tx_port_number = NO_SUCH_PORT, sequence_identifier ;
	ULONG source_ip_address, destination_ip_address ;
	UNION_IP_PACKET *ip_packet;
	UDP_PACKET *sptr_udp_packet;
	PSEUDO_IP_PARAMETERS pseudo_header;
	IP_UPPER_LAYER_PARAMETERS ip_upper_layer_parameters;
	UNION_SERVICE_TYPE_BIT_STRUCTURE structure_type_of_service;

	length = number_of_bytes + (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IP_HEADER)
				+ sizeof (UDP_HEADER));
	tx_port_number = 0 ; /* Proxy Lan Port */
	time_to_live = 0x0032;			/* value for these variables correct ? doubt ? */
	do_not_fragment_flag = TRUE;
	sequence_identifier = 0x0000;

	destination_ip_address = sptr_ip_packet->ip.header.source_ip_address ;
/*	source_ip_address = ip_get_address_of_outgoing_interface ( destination_ip_address ); */
	source_ip_address = sptr_ip_packet->ip.header.destination_ip_address ;


	source_port = get_udp_port_number_from_ip_packet ( sptr_ip_packet, sptr_ip_parameters, &destination_port );

	type_of_service = 0x00;
	structure_type_of_service._byte = type_of_service ;

	allocate_space_and_copy_data_to_udp_packet(&ip_packet, &size_of_udp_packet, dns_resp_pkt, number_of_bytes ) ;
	
	sptr_udp_packet = (UDP_PACKET *)ip_packet;
	pdu_length = (USHORT) (length - (USHORT) (sizeof (UNION_MAC_HEADER) + sizeof (IP_HEADER)));

/* build pseudo header without any socket info */
	
	pseudo_header.length = host_to_net_short (pdu_length);
	pseudo_header.source_address = host_to_net_long (source_ip_address);
	pseudo_header.destination_address = host_to_net_long (destination_ip_address);
	pseudo_header.zero_field = 0x00;
	pseudo_header.protocol = UDP_PROTOCOL;

/* build udp header in packet without any socket info */

	sptr_udp_packet->header.source_port = host_to_net_short (source_port);
	sptr_udp_packet->header.destination_port = host_to_net_short (destination_port);
	sptr_udp_packet->header.length = pseudo_header.length;
	sptr_udp_packet->header.checksum = 0x0000;	/* clear checksum */

#ifndef NO_UDP_CHECKSUM
	compute_checksum_for_packet (&pseudo_header, sptr_udp_packet, pdu_length);
#endif

#ifdef __IP_DEBUG__
	print_udp_header (&sptr_udp_packet->header);
#endif /* __IP__DEBUG__ */

	memset (&ip_upper_layer_parameters, 0x00, sizeof (IP_UPPER_LAYER_PARAMETERS));

/* build ip parameters without any socket info */

	ip_upper_layer_parameters.source_address = source_ip_address;
	ip_upper_layer_parameters.destination_address = destination_ip_address;
	ip_upper_layer_parameters.do_not_fragment_flag = (BYTE_ENUM (BOOLEAN)) do_not_fragment_flag;
	ip_upper_layer_parameters.type_of_service = structure_type_of_service._bit;
	ip_upper_layer_parameters.sequence_id = sequence_identifier;
	ip_upper_layer_parameters.time_to_live = time_to_live;
	ip_upper_layer_parameters.protocol = UDP_PROTOCOL;	 
	ip_upper_layer_parameters.option_length = 0x00; 
	ip_upper_layer_parameters.virtual_port_number = tx_port_number;

/* udp_control_block is not at all used. So no checking of whether 
udp_control_block is != NULL. */

	ip_upper_layer_parameters.vptr_cached_route = NULL;
	send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_udp_packet, length,
		(void (*) (USHORT port_number, IP_PACKET *sptr_tx_packet)) fptr_tx_completion);

	return ;

}

USHORT get_length_of_dns_reply_pkt (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT length ;
   BYTE *ptr_to_dns;

   ptr_to_dns = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+ sptr_ip_parameters->header_length + ( 2 * sizeof(USHORT))) ;

	length = net_to_host_short (*(USHORT *)ptr_to_dns) - sizeof (UDP_HEADER);
#if __Sudha__
printf("\n\rDNSRESP : Reply pkt data length is %x",length);	
#endif
	return (length);
}

/* Sudha 11 Sep 1998 */
BYTE *get_ptr_to_dns_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
    BYTE *ptr_to_dns;

    ptr_to_dns = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+ sptr_ip_parameters->header_length + sizeof (UDP_HEADER)) ;

    return (ptr_to_dns);
}

BYTE *get_domain_name_from_dns_query_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	BYTE *ptr_to_dns_query;

   ptr_to_dns_query = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+ sptr_ip_parameters->header_length + sizeof (UDP_HEADER)
								+ sizeof(struct HEADER));
#if __Sudha__	
	printf("\n\rIPUTIL: Domain Name is %s",ptr_to_dns_query);
#endif
	return (ptr_to_dns_query) ;

}
/* Sudha 11 Sep 1998 */

void display_proxy_dns_cache_info ()
{
	USHORT index = 0;

/* sudha 08-Oct-1999. For displaying all DNS server addr, used by Proxy... */
	ULONG dns_server_addr = 0x00000000L;

	printf("\n\r\t\t\tDNS Server Addresses used by Proxy");
	printf("\n\r\t\t\t----------------------------------");

	printf("\n\r\n\r\t\tConfigured DNS Server Address");
	printf("\n\rPrimary : %LX", dns.config.s_belt.dns_ip_addr1);
	printf("\n\rSecondary : %LX", dns.config.s_belt.dns_ip_addr2);

	printf("\n\r\n\r\t\tISP Negotiated DNS Server Address");
	printf("\n\r\n\rPrimary : %LX",
			recent_ppp_negotiated_dns_primary_server_address[0]);
	printf("\n\rSecondary : %LX",
			recent_ppp_negotiated_dns_secondary_server_address[0]);
		
	dns_server_addr = get_dns_server_address(index);
	printf("\n\r\n\rDNS Server Address used for DNS caching is %LX", dns_server_addr);

/* ...sudha 08-Oct-1999. For displaying all DNS server addr, used by Proxy */

	printf("\n\rCached domain list........");
	printf("\n\r\t\tTTL		Domain Name.");
	printf("\n\r\t\t---		------------");

	for ( index = 0; index < MAX_NUMBER_OF_CACHE; index++ )
	{
		if ( dns_cache_entry[index].in_use == FALSE )
			continue;
		printf("\n\r%d\t%s", dns_cache_entry[index].rr_min_ttl,dns_cache_entry[index].send_quest);
	}
}

USHORT get_quest_count_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT qdcnt = 0;
   BYTE *ptr_to_dns;

   ptr_to_dns = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+ sptr_ip_parameters->header_length + sizeof (UDP_HEADER) +
								( 2 * sizeof(USHORT))) ;

	qdcnt = net_to_host_short (*(USHORT *)ptr_to_dns) ;
#if __Sudha__
printf("\n\rDNSRESP : Quest Count is %d",qdcnt);	
#endif
	return qdcnt ;
}

enum BOOLEAN check_if_dns_pkt_has_any_reply(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT ancnt = 0;
   BYTE *ptr_to_dns;

   ptr_to_dns = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+ sptr_ip_parameters->header_length + ( 3 * sizeof(USHORT))) ;

	ancnt = net_to_host_short (*(USHORT *)ptr_to_dns) ;
	if ( ancnt > 0 )
		return TRUE ;
	else
	{
	   ptr_to_dns += sizeof(USHORT) ;	
		ancnt = net_to_host_short (*(USHORT *)ptr_to_dns) ;
		if (ancnt > 0)
			return TRUE ;
		else
		{
		   ptr_to_dns += sizeof(USHORT) ;	
			ancnt = net_to_host_short (*(USHORT *)ptr_to_dns) ;
			if (ancnt > 0)
				return TRUE ;
		}
	}
#if __Sudha__
printf("\n\rDNSRESP : Answer Count is %d",ancnt);	
#endif
	return FALSE ;
}

USHORT get_send_id_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT send_id;
   BYTE *ptr_to_dns;

   ptr_to_dns = (BYTE *)((ULONG)uptr_ip_rx_packet+sizeof (UNION_MAC_HEADER)
	 							+ sptr_ip_parameters->header_length + sizeof (UDP_HEADER));

	send_id = net_to_host_short (*(USHORT *)ptr_to_dns) ;
#if __Sudha__
printf("\n\rDNSRESP : Send Id is %d",send_id);	
#endif
	return send_id ;
}

ULONG get_dns_server_address (USHORT port_number)
{
/* sudha 12-Oct-1999. Configured primary has to be given fist preference than
negotiated primary */
	if ((dns.config.s_belt.dns_ip_addr1)
/* sudha 11-Nov-1999... */
		&& (dns.config.s_belt.dns_ip_addr1 != 0xFFFFFFFFL))
/* ...sudha 11-Nov-1999 */
	{
		/* configured primary, non-zero, if any */
		return dns.config.s_belt.dns_ip_addr1;
	}
/* sudha 10-Oct-1999. DNS Primary needs to be given preference first than 
DNS secondary, irrespective of configured or negotiated */
	else /* if not "configured primary" */
	{
		if ((recent_ppp_negotiated_dns_primary_server_address[port_number])
/* sudha 11-Nov-1999... */
		&&	(recent_ppp_negotiated_dns_primary_server_address[port_number] != 0xFFFFFFFFL))
/* ...sudha 11-Nov-1999 */
		{
			/* latest negotiated primary, non_zero, if any */
			return (recent_ppp_negotiated_dns_primary_server_address[port_number]);
		}
		else /* if not "negotiated primary" */
		{
			if ((dns.config.s_belt.dns_ip_addr2)
/* sudha 11-Nov-1999... */
				&& (dns.config.s_belt.dns_ip_addr2 != 0xFFFFFFFFL))
/* ...sudha 11-Nov-1999 */
			{
				/* configured secondary, non-zero, if any */
				return dns.config.s_belt.dns_ip_addr2;
			}
			else /* if not configured secondary */
			{
				if ((recent_ppp_negotiated_dns_secondary_server_address[port_number])
/* ...sudha 11-Nov-1999 */
					&& (recent_ppp_negotiated_dns_secondary_server_address[port_number] != 0xFFFFFFFFL))
/* sudha 11-Nov-1999... */
				{
					/* negotiated secondary, non-zero, if any */
					return (recent_ppp_negotiated_dns_secondary_server_address[port_number]);
				}
				else /* if not negotiated secondary */
				{
					return 0; 
				} /* end of negotiated secondary else */
			} /* end of configured secondary else */
		} /* end of negotiated primary else */
	} /* end of configured primary else */
}
