#include "dns.h"
#include "ip.h"
#include "kdns.h"
#include "vdnsstr.h"

#include <string.h>
 
extern ULONG get_ip_address (USHORT);
extern USHORT host_to_net_short (USHORT);
extern ULONG str_to_net (BYTE *);
extern BYTE *net_to_str (BYTE *Addr, ULONG Address);
extern int strcmpi (char *, char *);
BYTE * resolve_ip_address_from_cache (BYTE *name_ptr);

extern DNS_CLASS dns;
extern QUERY_INFORMATION query_info[MAX_WAN_PORTS];
extern SEND_PACKET *pkt_to_send[MAX_WAN_PORTS];
extern RESOURCE_REC *ans_rr, *auth_rr, *add_rr; 
extern DNS_LOCAL_CACHE dns_cache[MAX_NUMBER_OF_CACHE];
extern DNS_REPLY_CACHE dns_cache_entry[MAX_NUMBER_OF_CACHE] ;

extern USHORT get_free_dns_port();
DNS_RESOLVED_MULTI_IP_ADDR dns_ip_addr;

USHORT dns_free_port = START_FREE_DNS_PORT;
int ip_addr_rcvd[MAX_WAN_PORTS];

/* sudha 25 sep 1998 */

extern USHORT get_length_of_dns_reply_pkt (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern USHORT get_quest_count_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;

void dns_hdr_hton (HEADER *sptr_new_hdr, HEADER sptr_old_hdr)
{
   sptr_new_hdr->send_id = host_to_net_short (sptr_old_hdr.send_id);
   sptr_new_hdr->ctrl_fld= host_to_net_short (sptr_old_hdr.ctrl_fld);
   sptr_new_hdr->qdcnt   = host_to_net_short (sptr_old_hdr.qdcnt);
   sptr_new_hdr->ancnt   = host_to_net_short (sptr_old_hdr.ancnt);
   sptr_new_hdr->nscnt   = host_to_net_short (sptr_old_hdr.nscnt);
   sptr_new_hdr->arcnt   = host_to_net_short(sptr_old_hdr.arcnt);
}



ULONG check_if_ip_addr (BYTE *ip_str)
{
   BYTE *temp_ptr;
   USHORT i=0;
   int ip_addr[4];

   temp_ptr = ip_str;
   while (*temp_ptr++)
   {
      if (*temp_ptr == '.')
         i++;
   }
   if (i != 3 )
      return 0;

   if (sscanf (ip_str, "%03u.%03u.%03u.%03u", &ip_addr[0], &ip_addr[1], &ip_addr[2], &ip_addr[3]) != 4)
      return 0;

/*   printf ("IPAd%d\n%d\n%d\n%d\n",ip_addr[0], ip_addr[1], ip_addr[2], ip_addr[3]); */

   if ((ip_addr[0] > 255) || (ip_addr[0] <0) || (ip_addr[1] > 255) || (ip_addr[1] <0) || 
            (ip_addr[2] > 255) || (ip_addr[2] < 0) || (ip_addr[3] > 255) || (ip_addr[3] < 0))
      return 0;

   return 1;
}

enum TEST convert_received_name_to_domain_format (USHORT port_number, BYTE *domain_name)
{
/*
sudhir may 2 1997
*/
   pkt_to_send[port_number] = (struct SEND_PACKET *) malloc (sizeof (struct SEND_PACKET)); 
   if (pkt_to_send[port_number] == NULL)
   {
      printf("DNS: Malloc failed in send\n");
      return FAIL;
   }
   pkt_to_send[port_number]->send_quest = malloc (strlen (domain_name) + 2);
   if (pkt_to_send[port_number]->send_quest == NULL)
   {
      free (pkt_to_send[port_number]);
      pkt_to_send[port_number] = NULL;
      printf("DNS: Malloc failed in send\n");
      return FAIL;
   }   
   if (form_quest_portion (pkt_to_send[port_number]->send_quest, domain_name) == FALSE)
   {
      free(pkt_to_send[port_number]->send_quest);
      pkt_to_send[port_number]->send_quest = NULL; /* sudha 28 June 1999 */
      free(pkt_to_send[port_number]);
      pkt_to_send[port_number] = NULL;
      printf("DNS: Invalid domain name\n");
      return(FAIL);
   }
   return PASS;
}

enum TEST get_ip_address_from_name(BYTE *domain_name, USHORT port_number, void (*fptr_complete_routine)(ULONG*,USHORT, USHORT, enum TEST))
{
   BYTE *ret_val;
	USHORT index=0,count=0;
	ULONG *temp_ptr, *ptr_addr;

   ip_addr_rcvd[port_number] = 1;

   pkt_to_send[port_number] = NULL;

   if (check_if_ip_addr (domain_name) > 0)
   {
      dns.port[port_number].resolved_address = str_to_net (domain_name);
		dns.port[port_number].dns_resolved_multi_ip_addr.count = 1;
		dns.port[port_number].dns_resolved_multi_ip_addr.ip_address = (ULONG *)malloc ( sizeof (ULONG));
		*(dns.port[port_number].dns_resolved_multi_ip_addr.ip_address) = str_to_net (domain_name);
      dns.port[port_number].dns_state = IDLE;
      fptr_complete_routine(dns.port[port_number].dns_resolved_multi_ip_addr.ip_address,
									 dns.port[port_number].dns_resolved_multi_ip_addr.count,										
								    port_number,RESOLVED);
      return PASS;
   }


   if (dns.enabled == FALSE) 
   {
	return(FAIL);			/* If its a name and DNS is not */
   }					/* return error and FAIL	*/

   dns.port[port_number].fptr_complete_routine = fptr_complete_routine;

   if (convert_received_name_to_domain_format (port_number, domain_name) == FAIL)
   {
/*
sudhir may 2 1997
*/
	dns.port[port_number].dns_state = RESOLVE_ERR;
	return FAIL;
   }

   /* check in local cache and process  */
   ret_val = resolve_ip_address_from_cache (pkt_to_send[port_number]->send_quest);
   if (ret_val != NULL)
   {
		dns.port[port_number].resolved_address = net_to_host_long(*((ULONG *)ret_val));

/* Sudha 24 June 1998 */
/* Support for multiple ip address if exists for the same domain name.*/

		count = dns_ip_addr.count;
		dns.port[port_number].dns_resolved_multi_ip_addr.count = 0;
		dns.port[port_number].dns_resolved_multi_ip_addr.ip_address = 
			(ULONG *)calloc ( count,sizeof(ULONG));
		temp_ptr = dns.port[port_number].dns_resolved_multi_ip_addr.ip_address;

/* Sudha 28 June 1998 */
		if ( temp_ptr == NULL )
		{
			printf("\n\rDNSTX:Error allocating memory.");
			return FAIL;
		}	
/* Sudha 28 June 1998 */
      
      *temp_ptr = 0;
		ptr_addr = dns_ip_addr.ip_address;

		for( index = 0;index < count;index++)
		{
			*(temp_ptr) = *(ptr_addr);
   		dns.port[port_number].dns_resolved_multi_ip_addr.count++;
			temp_ptr++;
			ptr_addr++;
		}
		dns.port[port_number].dns_state = RESOLVED;
		free (ret_val);
		free (dns_ip_addr.ip_address);
		dns_ip_addr.ip_address = NULL;
      ptr_addr = NULL;
		dns_ip_addr.count = 0;
/* Sudha 24 June 1998 */
		return PASS;
   }

   if (initialize_dns_socket (port_number) == FAIL)
   {
/*
sudhir may 2 1997
*/
	dns.port[port_number].dns_state = RESOLVE_ERR;
	printf("DNS: Init socket failed\n");
	return FAIL;
   }
   ip_addr_rcvd[port_number] = 0;
   dns.port[port_number].dns_state = READY_TO_SEND;
   return PASS;
}


enum TEST initialize_dns_socket (USHORT port_number)
{
	SOCKADDR_IN loc_addr;

	if (dns.no_of_connections > MAX_DNS_CONNECTIONS)
		return FAIL;
	dns.port[port_number].socket_num = socket (AF_INET, SOCK_DGRAM, 0);
	if (dns.port[port_number].socket_num == FAILED)
	{
		return FAIL;
	}

	loc_addr.sin_family = AF_INET ;
	loc_addr.sin_port = get_free_dns_port();
/*	loc_addr.sin_addr.s_addr = get_ip_address (0); */
	loc_addr.sin_addr.s_addr = INTERNET_ADDRESS_ANY;

	if ((bind(dns.port[port_number].socket_num, (SOCKADDR *) &loc_addr, sizeof (SOCKADDR_IN)) < 0))
	{
		printf("DNS: bind failed\n");
		closesocket(dns.port[port_number].socket_num);
		return FAIL;
	} 
	dns.no_of_connections++;
	return PASS;
}

void initialize_query_info (USHORT port_number)
{
   USHORT rand_id=0;

   query_info[port_number].S_TYPE = 1;
   query_info[port_number].S_CLASS = 1;
   query_info[port_number].match_count = 0;  
   rand_id = rand ();
   query_info[port_number].identifier += rand_id;
   query_info[port_number].rtx_timeout = 0;
}   

HEADER *form_request_packet_header (USHORT port_number)
{
   HEADER *hdr_in_net_order;

   pkt_to_send[port_number]->send_hdr.send_id = query_info[port_number].identifier;

   pkt_to_send[port_number]->send_hdr.ctrl_fld = 0x0100; /* for recursion desired */
/*   pkt_to_send[port_number]->send_hdr.ctrl_fld = 0x0000;      */
   pkt_to_send[port_number]->send_hdr.qdcnt = 0x0001;
   pkt_to_send[port_number]->send_hdr.ancnt = 0x0000;
   pkt_to_send[port_number]->send_hdr.nscnt = 0x0000;
   pkt_to_send[port_number]->send_hdr.arcnt = 0x0000;

   pkt_to_send[port_number]->send_qtype = host_to_net_short (0x0001);
   pkt_to_send[port_number]->send_qclass = host_to_net_short (0x0001);
   hdr_in_net_order = (HEADER *) malloc (sizeof (HEADER));
   if (hdr_in_net_order == NULL)
   {
	printf("DNS: Malloc failed in HDR send\n");
	return NULL;
   }
   dns_hdr_hton (hdr_in_net_order, pkt_to_send[port_number]->send_hdr); 
   return hdr_in_net_order;
}   

/* funcion return 0 if send fails else return number of bytes send */

BYTE *form_request_packet (USHORT port_number)
{
   HEADER *hdr_in_net_order;
   USHORT dns_size=0, buffer_size=0;
   BYTE *temp_buff, *buffer;

   hdr_in_net_order = form_request_packet_header (port_number);
   if (hdr_in_net_order == NULL)
   {
	printf("DNS: Header formation fail\n");
      	return NULL;
   }
   
   dns_size = strlen (pkt_to_send[port_number]->send_quest) + 1;
   memcpy ((void *)query_info[port_number].S_NAME, (void *)pkt_to_send[port_number]->send_quest, dns_size);

   buffer_size = sizeof (struct HEADER)+ dns_size+ (2 * sizeof (USHORT));
   temp_buff = malloc (buffer_size);
   if (temp_buff == NULL)
   {
	printf("DNS: Malloc failed in send\n");
	return NULL;
   }
   buffer = temp_buff;

   memcpy ((void *)temp_buff, (void *)hdr_in_net_order, sizeof (struct HEADER));
   temp_buff += sizeof (struct HEADER); 
   memcpy ((void *)temp_buff, (void *) pkt_to_send[port_number]->send_quest, dns_size);
   temp_buff += (dns_size);
   memcpy ((void *)temp_buff, (void *)(&pkt_to_send[port_number]->send_qtype), sizeof (USHORT));
   temp_buff += sizeof (USHORT);
   memcpy ((void *)temp_buff, (void *)(&pkt_to_send[port_number]->send_qclass), sizeof (USHORT));

   free (hdr_in_net_order); 
   return buffer;
}

enum TEST send_query_to_the_address (USHORT port_number)
{
   USHORT  dns_size=0;
   BYTE *temp_buff,ipad[25];
   SOCKADDR_IN rem_addr;
   int num_of_bytes=0;
         
   dns_size = strlen (pkt_to_send[port_number]->send_quest) + 1;
   rem_addr.sin_family = AF_INET;
   rem_addr.sin_port = IPPORT_DOMAIN;

   if (query_info[port_number].index_of_ref_info > query_info[port_number].no_of_ns)
      query_info[port_number].index_of_ref_info = 0;
      
   dns.port[port_number].server_ip_address = query_info[port_number].reference_info[query_info[port_number].index_of_ref_info].Serveraddr;
   query_info[port_number].num_of_referals++;

   net_to_str (ipad, dns.port[port_number].server_ip_address);

   rem_addr.sin_addr.s_addr = dns.port[port_number].server_ip_address; 

	initialize_query_info (port_number);
   
   temp_buff = form_request_packet (port_number);
   if (temp_buff == NULL)
      return FAIL;

/*	printf ("DNS: Sending DNS query\n");*/
   num_of_bytes = sendto (dns.port[port_number].socket_num, (BYTE *)temp_buff , (sizeof (struct HEADER)+ dns_size + (2 * sizeof(USHORT))), 0, (SOCKADDR *) &rem_addr, sizeof (SOCKADDR_IN)); 
   if (num_of_bytes < 0)
   {
      return FAIL;
   }
/*
sudhir may 2nd 1997
*/
   free (temp_buff);
   return PASS;
}

enum BOOLEAN form_quest_portion (BYTE *fill_addr, BYTE *domain_name)
{
#define	MAX_LEN_OF_DOMAIN	63

   USHORT label_len = 0;
   BYTE label_data[MAX_LEN_OF_DOMAIN];
   USHORT i;

   while (*domain_name)
   {
      if (*domain_name == '.')
      {
	 if (label_len == 0)
 	 	return(FALSE);

         *fill_addr++ = label_len;

         for (i = 0; i < label_len ; i++)
            *fill_addr++ = label_data[i];

         label_len = 0;
         domain_name++;
      }
      else
      {
	      if (label_len > MAX_LEN_OF_DOMAIN)		/* Make sure we dont go more than 63 and screw  */
	      	return(FALSE);

	      label_data[label_len] = *domain_name;
	      label_len++;
	      domain_name++;
      }
   }

   if (label_len)
   {
	   *fill_addr++ = label_len;
	   for (i = 0; i < label_len ; i++)
	      *fill_addr++ = label_data[i];
   }
   *fill_addr = 0;
   return(TRUE);
}


BYTE * resolve_ip_address_from_cache (BYTE *name_ptr)
{
   BYTE *temp_ptr, *ret_ptr;
   USHORT i;
	ULONG *temp_ip_ptr;
   
	dns_ip_addr.count = 0;
	dns_ip_addr.ip_address = (ULONG *)calloc(MAX_NUMBER_OF_CACHE,sizeof(ULONG));

	temp_ip_ptr = dns_ip_addr.ip_address; 
   if ( temp_ip_ptr == NULL )
   {
      printf ("\n\rCACHE: Error allocating memory.\n\r");
      return NULL;
   }
   
   *temp_ip_ptr = 0;
   temp_ptr = name_ptr;
   for (i = 0; i < MAX_NUMBER_OF_CACHE; i++)
   {
      if (dns_cache[i].in_use ==  FALSE)
         continue;

      if (strcmpi (dns_cache[i].resource_rec->re_name, temp_ptr) != 0)
         continue;
      
      if ( dns_cache[i].resource_rec->re_type != HOST_ADDRESS)
         continue;

      ret_ptr = malloc (dns_cache[i].resource_rec->re_rdlen);
		
      if (ret_ptr == NULL)
         return NULL;
      memcpy (ret_ptr, dns_cache[i].resource_rec->re_rdata,dns_cache[i].resource_rec->re_rdlen);      
		dns_ip_addr.count++;
		*(temp_ip_ptr) = *(ULONG *)(dns_cache[i].resource_rec->re_rdata);
		temp_ip_ptr++;
 	}
	if ( dns_ip_addr.count > 0 )
	   return ret_ptr;
	else
	   return NULL;
}

USHORT get_free_dns_port()
{
	dns_free_port++;
	if (!dns_free_port)
		dns_free_port = START_FREE_DNS_PORT;
	return(dns_free_port);
}

/* sudha 13 sep 1998 */
BYTE *get_dns_response_from_local_cache_if_any ( BYTE *domain_name, USHORT *data_len, USHORT dns_id)
{
	USHORT index, qdcnt, length ;
	USHORT send_id ;
	BYTE *dns_ret_ptr ;
 
	dns_ret_ptr = NULL ;
	if ( domain_name == NULL )
		return NULL;


	for (index = 0; index < MAX_NUMBER_OF_CACHE; index++)
   {
      if (dns_cache_entry[index].in_use ==  FALSE)
         continue ;

      if (strcmpi (dns_cache_entry[index].send_quest, domain_name) != 0)
         continue ;
   	else
		{
			send_id = *(USHORT *)dns_cache_entry[index].reply_pkt ;
#if 0
printf("\n\rDNSTX : query id is %d, cache_dns_id is %d for domain_name %s",
dns_id, send_id, domain_name);
#endif			
			if ( send_id != dns_id )
				memcpy(dns_cache_entry[index].reply_pkt, &dns_id, sizeof (USHORT));
							
			*data_len = dns_cache_entry[index].data_len ;
			length = sizeof (HEADER) + (2 * (sizeof(USHORT))) + 
						strlen ( dns_cache_entry[index].send_quest ) + 1 ;
#if 0
printf("\n\rDNSTX : data_len is %x", *data_len);
#endif
			if ( *data_len > length )
				dns_ret_ptr = ( BYTE *) malloc ( *data_len );
			if ( dns_ret_ptr == NULL )
				return NULL ;
			else
				memcpy(dns_ret_ptr, dns_cache_entry[index].reply_pkt, *data_len );
			return ( dns_ret_ptr );
		}
	}		
	return NULL;
}

