#include	"defs.h"
/*
 * $Log: /IP/ICMPRX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: icmprx.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c) (1) (ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#include	"ip.h"
#include	"vicmp.h"
/****************************************************************************/
static enum BOOLEAN check_if_packet_size_is_valid (USHORT rx_port_number, ICMP_PACKET *sptr_icmp_packet,
	USHORT icmp_packet_size);
static enum BOOLEAN check_if_checksum_is_valid (ICMP_HEADER *sptr_icmp_header, USHORT icmp_packet_size);
static void icmp_error (void);
static void extract_icmp_header (ICMP_PARAMETERS *sptr_parameters, ICMP_HEADER *sptr_icmp_header);
static enum TEST verify_icmp_packet (ICMP_HEADER *sptr_icmp_header, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size);
static enum TEST verify_unsupported_icmp_types (ICMP_HEADER *sptr_icmp_header, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size);
static enum TEST verify_icmp_packet_size (ICMP_HEADER *sptr_icmp_header, IP_PARAMETERS *sptr_ip_parameters,
	USHORT icmp_packet_size, IP_HEADER **ptr_to_sptr_icmp_ipdata);
static void	processing_unsupported_icmp_types (ICMP_PARAMETERS *sptr_icmp_parameters);
/****************************************************************************/
enum TEST initialize_icmp (void)
{
	ip.icmp.mib.icmpInMsgs = 0x00000000L;
	ip.icmp.mib.icmpInErrors = 0x00000000L;
	ip.icmp.mib.icmpInDestUnreachs = 0x00000000L;
	ip.icmp.mib.icmpInTimeExcds = 0x00000000L;
	ip.icmp.mib.icmpInParmProbs = 0x00000000L;
	ip.icmp.mib.icmpInSrcQuenchs = 0x00000000L;
	ip.icmp.mib.icmpInRedirects = 0x00000000L;
	ip.icmp.mib.icmpInEchos = 0x00000000L;
	ip.icmp.mib.icmpInEchoReps = 0x00000000L;
	ip.icmp.mib.icmpInTimestamps = 0x00000000L;
	ip.icmp.mib.icmpInTimestampReps = 0x00000000L;
	ip.icmp.mib.icmpInAddrMasks = 0x00000000L;
	ip.icmp.mib.icmpInAddrMaskReps = 0x00000000L;
	ip.icmp.mib.icmpOutMsgs = 0x00000000L;
	ip.icmp.mib.icmpOutErrors = 0x00000000L;
	ip.icmp.mib.icmpOutDestUnreachs = 0x00000000L;
	ip.icmp.mib.icmpOutTimeExcds = 0x00000000L;
	ip.icmp.mib.icmpOutParmProbs = 0x00000000L;
	ip.icmp.mib.icmpOutSrcQuenchs = 0x00000000L;
	ip.icmp.mib.icmpOutRedirects = 0x00000000L;
	ip.icmp.mib.icmpOutEchos = 0x00000000L;
	ip.icmp.mib.icmpOutEchoReps = 0x00000000L;
	ip.icmp.mib.icmpOutTimestamps = 0x00000000L;
	ip.icmp.mib.icmpOutTimestampReps = 0x00000000L;
	ip.icmp.mib.icmpOutAddrMasks = 0x00000000L;
	ip.icmp.mib.icmpOutAddrMaskReps = 0x00000000L;

	ip.icmp.wait_for_echo_reply = FALSE;

	return (PASS);
}
/****************************************************************************/
enum IP_PACKET_STATE receive_icmp_packet (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PACKET *sptr_icmp_packet, USHORT icmp_packet_size)
{
	ICMP_PARAMETERS icmp_parameters;
	ICMP_HEADER *sptr_icmp_header;
	enum IP_PACKET_STATE return_code;

	++ip.icmp.mib.icmpInMsgs;

	if (check_if_packet_size_is_valid (rx_port_number, sptr_icmp_packet, icmp_packet_size) == FALSE)
		{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}

	sptr_icmp_header = (ICMP_HEADER *) ((ULONG) &sptr_icmp_packet->ip_header + sptr_ip_parameters->header_length);

	if (check_if_checksum_is_valid (sptr_icmp_header, icmp_packet_size) == FALSE)
		{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}

#ifdef __IP_DEBUG__
	print_icmp_header (sptr_icmp_header);
#endif /* __IP__DEBUG__ */

	extract_icmp_header (&icmp_parameters, sptr_icmp_header);

	if (verify_icmp_packet (sptr_icmp_header, sptr_ip_parameters, &icmp_parameters, icmp_packet_size) == FAIL)
		{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}

/* sudhir added rx_port_number */
	return_code = process_icmp_packet (sptr_icmp_packet, sptr_ip_parameters, &icmp_parameters, icmp_packet_size, rx_port_number);

	return (return_code);
}
/****************************************************************************/
static enum BOOLEAN check_if_packet_size_is_valid (USHORT rx_port_number, ICMP_PACKET *sptr_icmp_packet,
	USHORT icmp_packet_size)
{
	if (received_broadcast_from_interface (rx_port_number, (UNION_IP_PACKET *) sptr_icmp_packet) == TRUE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "ICMP: rxed mac broadcast message\n");
	#endif /* __IP_ALARM_DEBUG__ */

		icmp_error ();

		return (FALSE);
		}

	if (icmp_packet_size < MINIMUM_ICMP_SIZE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "ICMP: rxed short message: size: %d\n", icmp_packet_size);
	#endif /* __IP_ALARM_DEBUG__ */

		icmp_error ();

		return (FALSE);
		}

#ifdef __IP_DEBUG__
	ip_printf (ICMP_PRINTF, "ICMP: rxed message: size: %d\n", icmp_packet_size);
#endif /* __IP__DEBUG__ */

	return (TRUE);
}
/****************************************************************************/
static enum BOOLEAN check_if_checksum_is_valid (ICMP_HEADER *sptr_icmp_header, USHORT icmp_packet_size)
{
	USHORT calculated_checksum;
#ifdef __IP_ALARM_DEBUG__
	USHORT original_checksum;
#endif /* __IP_ALARM_DEBUG__ */

	/* calculate checksum for the whole ICMP message */

	if (sptr_icmp_header->checksum != 0x0000)
		{
	#ifdef __IP_ALARM_DEBUG__
		original_checksum = sptr_icmp_header->checksum;
	#endif /* __IP_ALARM_DEBUG__ */

		calculated_checksum = calculate_ip_checksum (NULL, (BYTE *) sptr_icmp_header, icmp_packet_size);

		if (calculated_checksum != 0x0000)
			{
		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALARM_PRINTF, "ICMP: CHECKSUM ERROR: original checksum:%x, calculated checksum:%x \n",
				original_checksum, calculated_checksum);
		#endif /* __IP_ALARM_DEBUG__ */

			icmp_error ();

			return (FALSE);
			}
		}

	return (TRUE);
}
/****************************************************************************/
static void icmp_error (void)
{
	++ip.icmp.mib.icmpInErrors;

	return;
}
/****************************************************************************/
static void extract_icmp_header (ICMP_PARAMETERS *sptr_icmp_parameters, ICMP_HEADER *sptr_icmp_header)
{
	ULONG icmp_type;

	sptr_icmp_parameters->type = sptr_icmp_header->type;
	sptr_icmp_parameters->code = sptr_icmp_header->code;

	icmp_type = sptr_icmp_header->type;

	switch (icmp_type)
		{
		case ICMP_DESTINATION_UNREACHABLE_TYPE:

			/* Retrieve Deering/Mogul MTU value, rfc792 does not require mtu */

			if (sptr_icmp_header->code.unreachable == ICMP_FRAGMENT_NEEDED_CODE)
				{
				sptr_icmp_parameters->icmp_options.mtu = net_to_host_short (sptr_icmp_header->option.unreachable_message.mtu);
				}

			break;

		case ICMP_PARAMETER_PROBLEM_TYPE:

			sptr_icmp_parameters->icmp_options.pointer = sptr_icmp_header->option.parameter_problem_message.pointer;

			break;

		case ICMP_REDIRECT_TYPE:

			sptr_icmp_parameters->icmp_options.gateway_address =
				net_to_host_long (sptr_icmp_header->option.redirect_message.gateway);

			break;

		case ICMP_ECHO_REQUEST_TYPE:
		case ICMP_ECHO_REPLY_TYPE:

			sptr_icmp_parameters->icmp_options.echo.identifier =
				net_to_host_short (sptr_icmp_header->option.echo_message.identifier);

			sptr_icmp_parameters->icmp_options.echo.sequence_number =
					net_to_host_short (sptr_icmp_header->option.echo_message.sequence_number);

			break;

		case ICMP_TIMESTAMP_TYPE:
		case ICMP_TIMESTAMP_REPLY_TYPE:
		case ICMP_INFO_REQUEST_TYPE:
		case ICMP_INFO_REPLY_TYPE:
			break;

		default:
			break;
		}
}
/****************************************************************************/
static enum TEST verify_icmp_packet (ICMP_HEADER *sptr_icmp_header, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size)
{
	switch (sptr_icmp_parameters->type)
		{
		case ICMP_TIME_EXCEEDED_TYPE:
		case ICMP_DESTINATION_UNREACHABLE_TYPE:
		case ICMP_SOURCE_QUENCH_TYPE:
		case ICMP_PARAMETER_PROBLEM_TYPE:
		case ICMP_REDIRECT_TYPE:

			verify_unsupported_icmp_types (sptr_icmp_header, sptr_ip_parameters, sptr_icmp_parameters, icmp_packet_size);

			return (FAIL);

		case ICMP_TIMESTAMP_TYPE:

			++ip.icmp.mib.icmpInTimestamps;

			break;

		case ICMP_TIMESTAMP_REPLY_TYPE:

			++ip.icmp.mib.icmpInTimestampReps;

			break;

		case ICMP_ADDRESS_MASK_TYPE:

			++ip.icmp.mib.icmpInAddrMasks;

			break;

		case ICMP_ADDR_MASK_REPLY_TYPE:

			++ip.icmp.mib.icmpInAddrMaskReps;

			break;

		case ICMP_INFO_REQUEST_TYPE:
		case ICMP_INFO_REPLY_TYPE:
		default:

			break;
		}

	return (PASS);
}
/****************************************************************************/
static enum TEST verify_unsupported_icmp_types (ICMP_HEADER *sptr_icmp_header, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size)
{
	IP_HEADER *sptr_icmp_ipdata;

	if (verify_icmp_packet_size (sptr_icmp_header, sptr_ip_parameters, icmp_packet_size, &sptr_icmp_ipdata) == FAIL)
		{
		return (FAIL);
		}

	extract_ip_header (sptr_ip_parameters, sptr_icmp_ipdata, sptr_ip_parameters->header_length);

#ifdef __IP_DEBUG__
	ip_printf (ICMP_PRINTF, "ICMP: rxed error message from %s:",
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address));

	ip_printf (ICMP_PRINTF, " original destination %s %s",
		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address),
		select_print_message (icmp_type_messages, (USHORT) TOTAL_ICMP_TYPES, (USHORT) sptr_icmp_parameters->type));
#endif /* __IP__DEBUG__ */

	processing_unsupported_icmp_types (sptr_icmp_parameters);

	return (PASS);
}
/****************************************************************************/
static enum TEST verify_icmp_packet_size (ICMP_HEADER *sptr_icmp_header, IP_PARAMETERS *sptr_ip_parameters,
	USHORT icmp_packet_size, IP_HEADER **ptr_to_sptr_icmp_ipdata)
{
	if (icmp_packet_size < (MINIMUM_ICMP_SIZE + MINIMUM_IP_HEADER_LENGTH)) 			/* check if icmp message carries ip data */
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "ICMP: rxed short message size %d\n", icmp_packet_size);
	#endif /* __IP__ALARM_DEBUG__ */

		icmp_error ();

		return (FAIL);
		}

	switch (sptr_icmp_header->type)
		{
		case ICMP_TIME_EXCEEDED_TYPE:

			*ptr_to_sptr_icmp_ipdata = &sptr_icmp_header->option.time_exceeded_message.ip_data;

			break;

		case ICMP_DESTINATION_UNREACHABLE_TYPE:

			*ptr_to_sptr_icmp_ipdata = &sptr_icmp_header->option.unreachable_message.ip_data;

			break;

		case ICMP_SOURCE_QUENCH_TYPE:

			*ptr_to_sptr_icmp_ipdata = &sptr_icmp_header->option.source_quench_message.ip_data;

			break;

		case ICMP_PARAMETER_PROBLEM_TYPE:

			*ptr_to_sptr_icmp_ipdata = &sptr_icmp_header->option.parameter_problem_message.ip_data;

			break;

		case ICMP_REDIRECT_TYPE:

			*ptr_to_sptr_icmp_ipdata = &sptr_icmp_header->option.redirect_message.ip_data;

			break;

		default:

			break;
		}

	sptr_ip_parameters->header_length = (USHORT) ((*ptr_to_sptr_icmp_ipdata)->version_header_length.header_length << 2);

	if (icmp_packet_size < (MINIMUM_ICMP_SIZE + sptr_ip_parameters->header_length))
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "ICMP: rxed short message size %d\n", icmp_packet_size);
	#endif /* __IP__ALARM_DEBUG__ */

		icmp_error ();

		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static void	processing_unsupported_icmp_types (ICMP_PARAMETERS *sptr_icmp_parameters)
{
	switch (sptr_icmp_parameters->type)
		{
		case ICMP_TIME_EXCEEDED_TYPE:

			++ip.icmp.mib.icmpInTimeExcds;

		#ifdef __IP_DEBUG__
			ip_printf (ICMP_PRINTF, " %s\n", select_print_message (icmp_time_exceed_messages, TOTAL_TIME_EXCEED_CODES,
				sptr_icmp_parameters->code.generic));
		#endif /* __IP__DEBUG__ */

			break;

		case ICMP_DESTINATION_UNREACHABLE_TYPE:

			++ip.icmp.mib.icmpInDestUnreachs;

		#ifdef __IP_DEBUG__
			ip_printf (ICMP_PRINTF, " %s\n",
				select_print_message (icmp_unreachable_messages, TOTAL_UNREACHABLE_CODES, sptr_icmp_parameters->code.generic));
		#endif /* __IP__DEBUG__ */

			break;

		case ICMP_SOURCE_QUENCH_TYPE:

			++ip.icmp.mib.icmpInSrcQuenchs;

		#ifdef __IP_DEBUG__
			ip_printf (ICMP_PRINTF, " %u\n", sptr_icmp_parameters->code.generic);
		#endif /* __IP__DEBUG__ */

			break;

		case ICMP_PARAMETER_PROBLEM_TYPE:

			++ip.icmp.mib.icmpInParmProbs;

		#ifdef __IP_DEBUG__
			ip_printf (ICMP_PRINTF, " %u\n", sptr_icmp_parameters->code.generic);
		#endif /* __IP__DEBUG__ */

			break;

		case ICMP_REDIRECT_TYPE:

			++ip.icmp.mib.icmpInRedirects;

		#ifdef __IP_DEBUG__
			ip_printf (ICMP_PRINTF, "ICMP: rxed redirect message, new gateway is %s\n",
				convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_icmp_parameters->icmp_options.gateway_address));
		#endif /* __IP__DEBUG__ */

			break;
		}
}

enum BOOLEAN is_icmp_echo_request_message (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	ICMP_HEADER *sptr_icmp_header;

	sptr_icmp_header = (ICMP_HEADER *) ((ULONG) ip_rx_packet + 
				sizeof(UNION_MAC_HEADER) + sptr_ip_parameters->header_length); 

	if (sptr_icmp_header->type == ICMP_ECHO_REQUEST_TYPE)
		return TRUE;
	else
		return FALSE;
}

/* sudhir for proxy */
BYTE *get_ptr_to_icmp_header (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	ICMP_HEADER *sptr_icmp_header;

	sptr_icmp_header = (ICMP_HEADER *) ((ULONG) ip_rx_packet + 
			sizeof(UNION_MAC_HEADER) + sizeof (IP_HEADER));

	return ((BYTE *) sptr_icmp_header);
}
 
USHORT get_icmp_echo_request_id (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	ICMP_HEADER *sptr_icmp_header;
	USHORT sequence_number=0;

	sptr_icmp_header = (ICMP_HEADER *) ((ULONG) ip_rx_packet + 
			sizeof(UNION_MAC_HEADER) + sizeof (IP_HEADER));

	sequence_number = ip_rx_packet->icmp.header.option.echo_message.identifier;	

	return sequence_number;

}

void set_icmp_checksum (BYTE *ptr_to_icmp_header, USHORT new_csum)
{

	ICMP_HEADER *sptr_icmp_header ;
	
	sptr_icmp_header = (ICMP_HEADER *)ptr_to_icmp_header;
	
	sptr_icmp_header->checksum = new_csum;
	return;
}
