#include	"defs.h"
/*
 * $Log: /IP/ICMPRXPR.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<string.h>
#include	"ip.h"
/****************************************************************************/
enum TEST process_icmp_echo_request (ICMP_PACKET *sptr_icmp_packet, IP_PARAMETERS *sptr_ip_parameters,
	USHORT icmp_packet_size, USHORT);
static enum TEST process_icmp_address_mask_request (ICMP_PACKET *sptr_icmp_packet,
	IP_PARAMETERS *sptr_ip_parameters, ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size);
static enum TEST process_icmp_address_mask_reply (ICMP_PACKET *sptr_icmp_packet, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size);
static ULONG get_address_mask_for_target (ULONG target);
static void	rip_set_icmp_address_mask (ULONG destination, ULONG target_netmask);
/****************************************************************************/

/* sudhir added rx_port_number */
enum IP_PACKET_STATE process_icmp_packet (ICMP_PACKET *sptr_icmp_packet, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size, USHORT rx_port_number)
 {
	switch (sptr_icmp_parameters->type)
		{
		case ICMP_ECHO_REQUEST_TYPE:
/* sudhir added rx_port_number */
			process_icmp_echo_request (sptr_icmp_packet, sptr_ip_parameters, icmp_packet_size, rx_port_number);
			break;

		case ICMP_ECHO_REPLY_TYPE:

			++ip.icmp.mib.icmpInEchoReps;

			if ((ip.icmp.wait_for_echo_reply == TRUE) &&
				(sptr_icmp_parameters->icmp_options.echo.identifier == ip.icmp.echo_request_id) &&
				(sptr_icmp_parameters->icmp_options.echo.sequence_number == ip.icmp.echo_sequence_number))
				{
			#ifdef __IP_DEBUG__
				ip_printf (ICMP_PRINTF, "ICMP: rxed echo reply packet of length %u\n", icmp_packet_size);
			#endif /* __IP__DEBUG__ */
				}

			break;

		case ICMP_ADDRESS_MASK_TYPE:

			process_icmp_address_mask_request (sptr_icmp_packet, sptr_ip_parameters, sptr_icmp_parameters, icmp_packet_size);

			break;

		case ICMP_ADDR_MASK_REPLY_TYPE:

			process_icmp_address_mask_reply (sptr_icmp_packet, sptr_ip_parameters, sptr_icmp_parameters, icmp_packet_size);

			break;

		default:

		#ifdef __IP_DEBUG__
			ip_printf (ICMP_PRINTF, "ICMP: rxed UNSUPPORTED message\n");
		#endif /* __IP__DEBUG__ */

			break;
		}

	return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
}
/****************************************************************************/
static enum TEST process_icmp_address_mask_request (ICMP_PACKET *sptr_icmp_packet,
	IP_PARAMETERS *sptr_ip_parameters, ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size)
{
	ICMP_HEADER *sptr_icmp_header;
	IP_UPPER_LAYER_PARAMETERS ip_upper_layer_parameters;
	ICMP_PACKET *sptr_icmp_tx_packet;
	ICMP_HEADER *sptr_icmp_tx_header;
	USHORT icmp_tx_packet_size;

	PARAMETER_NOT_USED (sptr_icmp_parameters);

	sptr_icmp_header = (ICMP_HEADER *) ((ULONG) &sptr_icmp_packet->ip_header + sptr_ip_parameters->header_length);

	++ip.icmp.mib.icmpInAddrMasks;

	icmp_tx_packet_size = (USHORT) (icmp_packet_size + sptr_ip_parameters->header_length + sizeof (UNION_MAC_HEADER));

/* Sachin 02/05/1997 */
	/* sptr_icmp_tx_packet = (ICMP_PACKET *) get_an_ip_send_packet (sptr_ip_parameters->rx_port_number, icmp_tx_packet_size); */
   sptr_icmp_tx_packet = (ICMP_PACKET *) get_an_icmp_send_packet (icmp_tx_packet_size) ;
/* Sachin 02/05/1997 */

	if (sptr_icmp_tx_packet == NULL)
		{
		++ip.icmp.mib.icmpOutErrors;

		return (FAIL);
		}

	++ip.icmp.mib.icmpOutAddrMaskReps;

	sptr_icmp_tx_header = &sptr_icmp_tx_packet->header;

	memcpy ((void *) sptr_icmp_tx_header, (void *) sptr_icmp_header, icmp_packet_size);

	/* Set type to ADDR_MASK_REPLY, compute checksum */

	sptr_icmp_tx_header->type = ICMP_ADDR_MASK_REPLY_TYPE;

	sptr_icmp_tx_header->option.address_mask_message.mask =
		host_to_net_long (get_address_mask_for_target (sptr_ip_parameters->destination_address));

	sptr_icmp_tx_header->checksum = 0x0000;

	sptr_icmp_tx_header->checksum = calculate_ip_checksum (NULL, (BYTE *) sptr_icmp_tx_header, icmp_packet_size);

	/* set up ip request block */

	memset (&ip_upper_layer_parameters, 0x00, sizeof (IP_UPPER_LAYER_PARAMETERS));

	sptr_ip_parameters->destination_address =
		ip_get_address_of_outgoing_interface (sptr_ip_parameters->destination_address);

	setup_reflected_ip_header (&ip_upper_layer_parameters, sptr_ip_parameters, ICMP_PROTOCOL,
		(BYTE *) ((ULONG) sptr_icmp_header - sptr_ip_parameters->options_length), NULL, NULL);

	ip_upper_layer_parameters.virtual_port_number = sptr_ip_parameters->rx_port_number;

#ifdef __IP_DEBUG__
	print_icmp_header (sptr_icmp_tx_header);
#endif /* __IP__DEBUG__ */

/* Sachin 02/05/1997 */
#if 0
	send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_icmp_tx_packet, icmp_tx_packet_size,
		(void (*) (USHORT port_number, IP_PACKET *sptr_ip_packet)) send_completion_ip_packet);
#endif
	send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_icmp_tx_packet, icmp_tx_packet_size,
		(void (*) (USHORT port_number, IP_PACKET *sptr_ip_packet)) send_completion_icmp_packet);
/* Sachin 02/05/1997 */

/* Sachin 07.06.1996 */
	/*
	Note that it is the business of send_ip_packet_from_upper_layer() to free
	up the buffer whether the transmission is successful or otherwise. This holds
	for all places where calls to send_ip_packet_from_upper_layer() are made.
	*/
/* Sachin 07.06.1996 */

	return (PASS);
}
/****************************************************************************/
static ULONG get_address_mask_for_target (ULONG target)
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	ULONG network_mask;

	network_mask = ip_get_network_mask (target);

	target = target & network_mask;

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	sptr_route_entry = get_first_ip_route_entry ();
#else
	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

	while (sptr_route_entry != NULL)
		{
		network_mask = ip_get_network_mask (sptr_route_entry->target);

		if ((sptr_route_entry->target & network_mask) == target)
			{
			if ((sptr_route_entry->flags.no_subnet_mask == FALSE) &&
				((sptr_route_entry->number_of_subnet_mask_bits != SUBNET_MASK_NOT_KNOWN) ||
				(sptr_route_entry->number_of_subnet_mask_bits != SEND_ADDRESS_MASK_REQUEST) ||
				(sptr_route_entry->number_of_subnet_mask_bits != AWAITING_ADDRESS_MASK_REPLY)))
				{
				return (sptr_route_entry->mask);
				}
			}

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
		sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif
		}

	convert_ip_address_to_dot_format (&ip.print_buffer[0], target);

#ifdef __IP_DEBUG__
	ip_printf (ICMP_PRINTF, "ICMP: mask not known for target %s\n", &ip.print_buffer[0]);
#endif /* __IP__DEBUG__ */

	return (0xffffffffL);
}
/****************************************************************************/
static enum TEST process_icmp_address_mask_reply (ICMP_PACKET *sptr_icmp_packet, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size)
{
	ICMP_HEADER *sptr_icmp_header;

	PARAMETER_NOT_USED (icmp_packet_size);

	sptr_icmp_header = (ICMP_HEADER *) ((ULONG) &sptr_icmp_packet->ip_header + sptr_ip_parameters->header_length);

	++ip.icmp.mib.icmpInAddrMaskReps;

	sptr_icmp_parameters->icmp_options.address_mask	= net_to_host_long (sptr_icmp_header->option.address_mask_message.mask);

	rip_set_icmp_address_mask (sptr_ip_parameters->source_address, sptr_icmp_parameters->icmp_options.address_mask);

	return (PASS);
}
/****************************************************************************/
static void	rip_set_icmp_address_mask (ULONG destination, ULONG target_netmask)
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	ULONG network_mask;
	ULONG destination_network;

	network_mask = ip_get_network_mask (destination);

	destination_network = destination & network_mask;

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	sptr_route_entry = get_first_ip_route_entry ();
#else
	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

	while (sptr_route_entry != NULL)
		{
		if (((sptr_route_entry->number_of_subnet_mask_bits == SEND_ADDRESS_MASK_REQUEST) ||
			(sptr_route_entry->number_of_subnet_mask_bits == AWAITING_ADDRESS_MASK_REPLY)) &&
			(sptr_route_entry->flags.no_subnet_mask == TRUE))
			{
			if ((sptr_route_entry->target == destination) || ((destination & target_netmask) == sptr_route_entry->target))
				{
				sptr_route_entry->number_of_subnet_mask_bits = ip_convert_mask_to_bits (target_netmask);

				sptr_route_entry->mask = target_netmask;
				sptr_route_entry->flags.no_subnet_mask = FALSE;
				sptr_route_entry->flags.route_down = FALSE;

				}
			else
				{
				network_mask = ip_get_network_mask (sptr_route_entry->target);

				if ((sptr_route_entry->target & network_mask) == destination_network)
					{
					sptr_route_entry->number_of_subnet_mask_bits = ip_convert_mask_to_bits (target_netmask);

					sptr_route_entry->mask = target_netmask;
					sptr_route_entry->flags.no_subnet_mask = FALSE;
					sptr_route_entry->flags.route_down = FALSE;
					}
				}
			}

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
		sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif
		}

#ifdef __IP_DEBUG__
	ip_print_routing_table ();
#endif /* __IP__DEBUG__ */
}
/****************************************************************************/
/* sudhir added rx_port_number */
enum TEST process_icmp_echo_request (ICMP_PACKET *sptr_icmp_packet, IP_PARAMETERS *sptr_ip_parameters,
	USHORT icmp_packet_size, USHORT rx_port_number)
{
	ICMP_HEADER *sptr_icmp_header;
	IP_UPPER_LAYER_PARAMETERS ip_upper_layer_parameters;
	ICMP_PACKET *sptr_icmp_tx_packet;
	ICMP_HEADER *sptr_icmp_tx_header;
	USHORT icmp_tx_packet_size;

	sptr_icmp_header = (ICMP_HEADER *) ((ULONG) &sptr_icmp_packet->ip_header + sptr_ip_parameters->header_length);

	++ip.icmp.mib.icmpInEchos;

#ifdef __IP_DEBUG__
	ip_printf (ICMP_PRINTF, "ICMP: rxed echo request packet of length %u\n", icmp_packet_size);
#endif /* __IP__DEBUG__ */

	icmp_tx_packet_size = (USHORT) (icmp_packet_size + sizeof (IP_HEADER) + sizeof (UNION_MAC_HEADER));

/* Sachin 02/05/1997 */
#if 0
	sptr_icmp_tx_packet = (ICMP_PACKET *) get_an_ip_send_packet (sptr_ip_parameters->rx_port_number,
		(USHORT) (icmp_tx_packet_size + MAXIMUM_IP_OPTION_LENGTH));
#endif
	sptr_icmp_tx_packet = (ICMP_PACKET *) get_an_icmp_send_packet ((USHORT) (icmp_tx_packet_size + MAXIMUM_IP_OPTION_LENGTH));

/* Sachin 02/05/1997 */

	if (sptr_icmp_tx_packet == NULL)
		{
		++ip.icmp.mib.icmpOutErrors;

		return (FAIL);
		}

	/* Change type to ECHO_REPLY, recompute checksum, and return datagram. */

	++ip.icmp.mib.icmpOutEchoReps;

	sptr_icmp_tx_header = &sptr_icmp_tx_packet->header;

	memcpy ((void *) sptr_icmp_tx_header, (void *) sptr_icmp_header, icmp_packet_size);

	sptr_icmp_tx_header->type = ICMP_ECHO_REPLY_TYPE;
	sptr_icmp_tx_header->checksum = 0x0000;

	sptr_icmp_tx_header->checksum = calculate_ip_checksum (NULL, (BYTE *) sptr_icmp_tx_header, icmp_packet_size);

	/* set up ip request block */

	memset (&ip_upper_layer_parameters, 0x00, sizeof (IP_UPPER_LAYER_PARAMETERS));

	setup_reflected_ip_header (&ip_upper_layer_parameters, sptr_ip_parameters, ICMP_PROTOCOL,
		(BYTE *) ((ULONG) sptr_icmp_header - sptr_ip_parameters->options_length), NULL, NULL);


	/*
	Sachin took out this line from the #ifdefed out block. 24th May, 1996
	to set right the problem reported yesterday by Hung (look at the bugs
	file)
	*/

/* sudhir removed NO_SUCH_PORT and put rx_port_number */
	if (ip.port[sptr_ip_parameters->rx_port_number].config.point_to_point_link == TRUE)
		ip_upper_layer_parameters.virtual_port_number = rx_port_number;
	else
		ip_upper_layer_parameters.virtual_port_number = NO_SUCH_PORT;
		

#ifdef RTRERROR
	ip_upper_layer_parameters.virtual_port_number = sptr_ip_parameters->rx_port_number;
#endif


#ifdef __IP_DEBUG__
	print_icmp_header (sptr_icmp_tx_header);

	ip_printf (ICMP_PRINTF, "ICMP: txed echo reply packet of size %u\n", icmp_tx_packet_size);
#endif /* __IP__DEBUG__ */

/* Sachin 02/05/1997 */
#if 0
   send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_icmp_tx_packet, icmp_tx_packet_size,
		(void (*) (USHORT port_number, IP_PACKET *sptr_ip_packet)) send_completion_ip_packet);
#endif
	send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_icmp_tx_packet, icmp_tx_packet_size,
		(void (*) (USHORT port_number, IP_PACKET *sptr_ip_packet)) send_completion_icmp_packet);
/* Sachin 02/05/1997 */

	return (PASS);
}

