/*
 * $Log: /IP/IPEXPLIB.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _IPLIB_H_

#ifndef _IPEXPLIB_H_
#define _IPEXPLIB_H_


#include "kroute.h"
#include "viprtstr.h"

#include "kipuser.h"
#include "vipusstr.h"
#include "vipktstr.h"

#include "kudp.h"
#include "vudpuser.h"

#if !defined NUMBER_OF_IP_PORTS
	#define NUMBER_OF_IP_PORTS 								16
#endif

#include "karp.h"

#include "kip.h"


#endif /* _IPEXPLIB_H_ */


/* these are the prototypes of all exported functions */

ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...);

enum TEST register_to_ip_from_upper_layer (enum IP_PROTOCOL_VALUE protocol_type,
	void (*fptr_receive_packet) (IP_PARAMETERS *sptr_ip_parameters, void *vptr_rx_packet, USHORT packet_size),
	enum TEST (*fptr_find_route_and_update_cache) (ULONG type_of_service, ULONG destination_ip_address,
	void **ptr_to_vptr_route_entry));

void send_ip_packet_from_upper_layer (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	enum BOOLEAN forwarded_packet, IP_PACKET *sptr_ip_packet, USHORT number_of_bytes,
	void (*fptr_tx_completion) (USHORT port_number, IP_PACKET *sptr_ip_packet));

USHORT ip_get_mtu_for_outgoing_port (ULONG destination_address);

void *open_udp (IP_SOCKET *sptr_local_socket,
	void (*fptr_call_udp_user) (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket, void *vptr_packet_received,
	USHORT rx_user_data_size, IP_PARAMETERS *sptr_ip_parameters), enum USER_TYPE user_type);

USHORT send_udp (USHORT tx_port_number, IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket,
	SERVICE_TYPE_BIT_STRUCTURE type_of_service,
	BYTE time_to_live, void *vptr_udp_packet, USHORT sequence_identifier, enum BOOLEAN do_not_fragment_flag,
	USHORT number_of_bytes, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet), void *vptr_control_block);

enum TEST send_arp_request_packet (USHORT tx_port_number, ULONG tx_ip_address, enum BOOLEAN proxy_arp,
	MAC_ADDRESS *sptr_mac_address, ULONG sender_ip_address);

void *add_entry_to_arp_table (USHORT port_number, ULONG ip_address, MAC_ADDRESS *sptr_mac_address,
	enum ARP_TABLE_ENTRY_TYPE type, void *vptr_packet);

void send_rarp_request (USHORT port_number);

void *add_rarp_table_entry (USHORT port_number, ULONG ip_address, MAC_ADDRESS *sptr_mac_address);

/* Srikar, Mar 20, 1997. Changed the type and name of the parameter bptr_table_indices to OBJECT_ID * */
/* and sptr_table_indices */
enum TEST get_rfc1213_ip_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the type and name of the parameter bptr_table_indices to OBJECT_ID * */
/* and sptr_table_indices */
enum TEST get_rfc1213_icmp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the type and name of the parameter bptr_table_indices to OBJECT_ID * */
/* and sptr_table_indices */
enum TEST get_rfc1213_udp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the type and name of the parameter bptr_table_indices to OBJECT_ID * */
/* and sptr_table_indices */
enum TEST get_rfc1213_arp_table_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

#endif /* _IPLIB_H_ */
